/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.dom;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.dom.NodeWrapper;
import net2.sf.saxon.om.DocumentInfo;
import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.om.NodeInfo;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DocumentWrapper
extends NodeWrapper
implements DocumentInfo {
    protected Configuration config;
    protected String baseURI;
    protected long documentNumber;
    protected boolean domLevel3;

    public DocumentWrapper(Node doc, String baseURI, Configuration config) {
        super(doc, null, 0);
        if (doc.getNodeType() != 9 && doc.getNodeType() != 11) {
            throw new IllegalArgumentException("Node must be a DOM Document or DocumentFragment");
        }
        this.node = doc;
        this.nodeKind = (short)9;
        this.baseURI = baseURI;
        this.docWrapper = this;
        boolean bl = this.domLevel3 = config.getDOMLevel() == 3;
        if (config.getExternalObjectModel(doc.getClass()) == null) {
            throw new IllegalArgumentException("Node class " + doc.getClass().getName() + " is not recognized in this Saxon configuration");
        }
        this.setConfiguration(config);
    }

    public NodeWrapper wrap(Node node) {
        if (node == this.node) {
            return this;
        }
        Document doc = node.getOwnerDocument();
        if (doc == this.node || this.domLevel3 && doc != null && doc.isSameNode(this.node)) {
            return this.makeWrapper(node, this);
        }
        throw new IllegalArgumentException("DocumentWrapper#wrap: supplied node does not belong to the wrapped DOM document");
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
        this.documentNumber = config.getDocumentNumberAllocator().allocateDocumentNumber();
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    @Override
    public long getDocumentNumber() {
        return this.documentNumber;
    }

    @Override
    public NodeInfo selectID(String id, boolean getParent) {
        if (this.node instanceof Document) {
            Element el = ((Document)this.node).getElementById(id);
            if (el == null) {
                return null;
            }
            return this.wrap(el);
        }
        return null;
    }

    @Override
    public boolean isSameNodeInfo(NodeInfo other) {
        return other instanceof DocumentWrapper && this.node == ((DocumentWrapper)other).node;
    }

    @Override
    public Iterator<String> getUnparsedEntityNames() {
        DocumentType docType = ((Document)this.node).getDoctype();
        if (docType == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        NamedNodeMap map = docType.getEntities();
        if (map == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        ArrayList<String> names = new ArrayList<String>(map.getLength());
        int i = 0;
        while (i < map.getLength()) {
            Entity e = (Entity)map.item(i);
            if (e.getNotationName() != null) {
                names.add(e.getLocalName());
            }
            ++i;
        }
        return names.iterator();
    }

    @Override
    public String[] getUnparsedEntity(String name) {
        DocumentType docType = ((Document)this.node).getDoctype();
        if (docType == null) {
            return null;
        }
        NamedNodeMap map = docType.getEntities();
        if (map == null) {
            return null;
        }
        Entity entity = (Entity)map.getNamedItem(name);
        if (entity == null || entity.getNotationName() == null) {
            return null;
        }
        String systemId = entity.getSystemId();
        try {
            URI systemIdURI = new URI(systemId);
            if (!systemIdURI.isAbsolute()) {
                systemIdURI = new URI(this.getBaseURI()).resolve(systemIdURI);
                systemId = systemIdURI.toString();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return new String[]{systemId, entity.getPublicId()};
    }

    @Override
    public int getTypeAnnotation() {
        return 630;
    }
}

