/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.dom;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.dom.DocumentBuilderImpl;

public class DocumentBuilderFactoryImpl
extends DocumentBuilderFactory {
    Configuration config = null;
    boolean xIncludeAware = false;
    private static String FEATURE_SECURE_PROCESSING = "http://javax.xml.XMLConstants/feature/secure-processing";

    public DocumentBuilderFactoryImpl() {
        this.setCoalescing(true);
        this.setExpandEntityReferences(true);
        this.setIgnoringComments(false);
        this.setIgnoringElementContentWhitespace(false);
        this.setNamespaceAware(true);
        this.setValidating(false);
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (name.equals("http://saxon.sf.net/feature/configuration")) {
            this.config = (Configuration)value;
        } else {
            if (this.config == null) {
                this.config = new Configuration();
            }
            this.config.setConfigurationProperty(name, value);
        }
    }

    @Override
    public Object getAttribute(String name) {
        if (name.equals("http://saxon.sf.net/feature/configuration")) {
            return this.config;
        }
        if (this.config == null) {
            this.config = new Configuration();
        }
        return this.config.getConfigurationProperty(name);
    }

    @Override
    public DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        if (!this.isExpandEntityReferences()) {
            throw new ParserConfigurationException("Saxon parser always expands entity references");
        }
        if (this.isIgnoringComments()) {
            throw new ParserConfigurationException("Saxon parser does not allow comments to be ignored");
        }
        if (this.isIgnoringElementContentWhitespace()) {
            throw new ParserConfigurationException("Saxon parser does not allow whitespace in element content to be ignored");
        }
        if (!this.isNamespaceAware()) {
            throw new ParserConfigurationException("Saxon parser is always namespace aware");
        }
        DocumentBuilderImpl builder = new DocumentBuilderImpl();
        builder.setValidating(this.isValidating());
        builder.setXIncludeAware(this.xIncludeAware);
        if (this.isIgnoringElementContentWhitespace()) {
            builder.setStripSpace(1);
        }
        builder.setConfiguration(this.config);
        return builder;
    }

    @Override
    public void setFeature(String name, boolean value) throws ParserConfigurationException {
        if (!name.equals(FEATURE_SECURE_PROCESSING) || value) {
            throw new ParserConfigurationException("Unsupported feature or value: " + name);
        }
    }

    @Override
    public boolean getFeature(String name) throws ParserConfigurationException {
        if (name.equals(FEATURE_SECURE_PROCESSING)) {
            return false;
        }
        throw new ParserConfigurationException("Unsupported feature: " + name);
    }

    @Override
    public boolean isXIncludeAware() {
        return this.xIncludeAware;
    }

    @Override
    public void setXIncludeAware(boolean state) {
        this.xIncludeAware = state;
    }
}

