/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.charcode;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import net2.sf.saxon.charcode.CharacterSet;
import net2.sf.saxon.charcode.UTF16CharacterSet;

public class JavaCharacterSet
implements CharacterSet {
    public static HashMap<Charset, JavaCharacterSet> map;
    private CharsetEncoder encoder;
    private byte[] charinfo = new byte[65536];
    private StringBuffer supplementary = new StringBuffer(2);
    private static final byte GOOD = 1;
    private static final byte BAD = 2;

    private JavaCharacterSet(Charset charset) {
        this.encoder = charset.newEncoder();
    }

    public static synchronized JavaCharacterSet makeCharSet(Charset charset) {
        JavaCharacterSet c;
        if (map == null) {
            map = new HashMap(10);
        }
        if ((c = map.get(charset)) == null) {
            c = new JavaCharacterSet(charset);
            map.put(charset, c);
        }
        return c;
    }

    @Override
    public final boolean inCharset(int c) {
        if (c <= 127) {
            return true;
        }
        if (c <= 65535) {
            if (this.charinfo[c] == 1) {
                return true;
            }
            if (this.charinfo[c] == 2) {
                return false;
            }
            if (this.encoder.canEncode((char)c)) {
                this.charinfo[c] = 1;
                return true;
            }
            this.charinfo[c] = 2;
            return false;
        }
        this.supplementary.setCharAt(0, UTF16CharacterSet.highSurrogate(c));
        this.supplementary.setCharAt(1, UTF16CharacterSet.lowSurrogate(c));
        return this.encoder.canEncode(this.supplementary);
    }

    @Override
    public String getCanonicalName() {
        return this.encoder.charset().name();
    }
}

