/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.ant;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.Controller;
import net2.sf.saxon.PreparedStylesheet;
import net2.sf.saxon.Version;
import net2.sf.saxon.trace.XSLTTraceListener;
import net2.sf.saxon.trans.CompilerInfo;
import net2.sf.saxon.trans.XPathException;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.XSLTLogger;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.XMLCatalog;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Resources;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;

public class AntTransform
extends MatchingTask
implements XSLTLogger {
    private File destDir = null;
    private File baseDir = null;
    private String xslFile = null;
    private Resource xslResource = null;
    private String targetExtension = ".html";
    private String fileNameParameter = null;
    private String fileDirParameter = null;
    private Vector params = new Vector();
    private File inFile = null;
    private File outFile = null;
    private boolean schemaAware;
    private Path classpath = null;
    private boolean stylesheetLoaded = false;
    private boolean force = false;
    private Vector outputProperties = new Vector();
    private XMLCatalog xmlCatalog = new XMLCatalog();
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private boolean performDirectoryScan = true;
    private Configuration config;
    private boolean reuseLoadedStylesheet = true;
    private AntClassLoader loader = null;
    private Mapper mapperElement = null;
    private Union resources = new Union();
    private boolean useImplicitFileset = true;
    private PreparedStylesheet templates = null;
    private String schemaValidation = "skip";
    private boolean dtdValidation = false;
    private boolean expandAttributeDefaults = true;
    private boolean allowExtensions = true;
    private String initialMode;
    private String initialTemplate;
    private boolean lineNumbering;
    private boolean tracing;
    private String recoveryPolicy;
    private String xmlVersion = "1.0";

    public void setScanIncludedDirectories(boolean b) {
        this.performDirectoryScan = b;
    }

    public void setReloadStylesheet(boolean b) {
        this.reuseLoadedStylesheet = !b;
    }

    public void addMapper(Mapper mapper) {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.getLocation());
        }
        this.mapperElement = mapper;
    }

    public void add(ResourceCollection rc) {
        this.resources.add(rc);
    }

    public void addConfiguredStyle(Resources rc) {
        if (rc.size() != 1) {
            throw new BuildException("The style element must be specified with exactly one nested resource.");
        }
        this.setXslResource((Resource)rc.iterator().next());
    }

    public void setXslResource(Resource xslResource) {
        this.xslResource = xslResource;
    }

    public void add(FileNameMapper fileNameMapper) throws BuildException {
        Mapper mapper = new Mapper(this.getProject());
        mapper.add(fileNameMapper);
        this.addMapper(mapper);
    }

    public void execute() throws BuildException {
        this.log("AntTransform.execute() schema-aware=" + this.schemaAware + " version " + Version.getProductVersion());
        if (this.schemaAware) {
            this.config = Configuration.makeLicensedConfiguration(null, null);
            this.config.displayLicenseMessage();
        } else {
            this.config = new Configuration();
        }
        this.config.setAllowExternalFunctions(this.allowExtensions);
        this.config.setExpandAttributeDefaults(this.expandAttributeDefaults);
        this.config.setLineNumbering(this.lineNumbering);
        this.config.setValidation(this.dtdValidation);
        this.config.setCompileWithTracing(this.tracing);
        this.config.setXMLVersion("1.1".equals(this.xmlVersion) ? 11 : 10);
        if ("skip".equals(this.schemaValidation)) {
            this.config.setSchemaValidationMode(4);
        } else if ("strict".equals(this.schemaValidation)) {
            this.config.setSchemaValidationMode(1);
        } else if ("lax".equals(this.schemaValidation)) {
            this.config.setSchemaValidationMode(2);
        } else {
            throw new BuildException("Validation must be strict or lax or skip");
        }
        File savedBaseDir = this.baseDir;
        if (this.xslResource == null && this.xslFile == null) {
            throw new BuildException("specify the stylesheet either as a filename in style attribute or as a nested resource", this.getLocation());
        }
        if (this.xslResource != null && this.xslFile != null) {
            throw new BuildException("specify the stylesheet either as a filename in style attribute or as a nested resource but not as both", this.getLocation());
        }
        if (this.inFile != null && !this.inFile.exists()) {
            throw new BuildException("input file " + this.inFile.toString() + " does not exist", this.getLocation());
        }
        try {
            if (this.baseDir == null) {
                this.baseDir = this.getProject().resolveFile(".");
            }
            if (this.xslFile != null) {
                File stylesheet = this.getProject().resolveFile(this.xslFile);
                if (!stylesheet.exists() && (stylesheet = FILE_UTILS.resolveFile(this.baseDir, this.xslFile)).exists()) {
                    this.log("DEPRECATED - the 'style' attribute should be relative to the project's");
                    this.log("             basedir, not the tasks's basedir.");
                }
                FileResource fr = new FileResource();
                fr.setProject(this.getProject());
                fr.setFile(stylesheet);
                this.xslResource = fr;
            }
            if (this.inFile != null && this.outFile != null) {
                this.process(this.inFile, this.outFile, this.xslResource);
                return;
            }
            this.checkDest();
            if (this.useImplicitFileset) {
                DirectoryScanner scanner = this.getDirectoryScanner(this.baseDir);
                this.log("Transforming into " + this.destDir, 2);
                String[] list = scanner.getIncludedFiles();
                int i = 0;
                while (i < list.length) {
                    this.process(this.baseDir, list[i], this.destDir, this.xslResource);
                    ++i;
                }
                if (this.performDirectoryScan) {
                    String[] dirs = scanner.getIncludedDirectories();
                    int j = 0;
                    while (j < dirs.length) {
                        list = new File(this.baseDir, dirs[j]).list();
                        int i2 = 0;
                        while (i2 < list.length) {
                            this.process(this.baseDir, String.valueOf(dirs[j]) + File.separator + list[i2], this.destDir, this.xslResource);
                            ++i2;
                        }
                        ++j;
                    }
                }
            } else if (this.resources.size() == 0) {
                throw new BuildException("no resources specified");
            }
            this.processResources(this.xslResource);
        }
        finally {
            if (this.loader != null) {
                this.loader.resetThreadContextLoader();
                this.loader.cleanup();
                this.loader = null;
            }
            this.stylesheetLoaded = false;
            this.baseDir = savedBaseDir;
        }
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setBasedir(File dir) {
        this.baseDir = dir;
    }

    public void setDestdir(File dir) {
        this.destDir = dir;
    }

    public void setExtension(String name) {
        this.targetExtension = name;
    }

    public void setStyle(String xslFile) {
        this.xslFile = xslFile;
    }

    public void setClasspath(Path classpath) {
        this.createClasspath().append(classpath);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setSchemaAware(boolean schemaAware) {
        this.schemaAware = schemaAware;
    }

    public void setSchemaValidation(String validation) {
        this.schemaValidation = validation;
        if (!validation.equals("skip")) {
            this.setSchemaAware(true);
        }
    }

    public void setDTDValidation(boolean validation) {
        this.dtdValidation = validation;
    }

    public void setExpandDefaults(boolean expand) {
        this.expandAttributeDefaults = expand;
    }

    public void setInitialMode(String mode) {
        this.initialMode = mode;
    }

    public void setInitialTemplate(String name) {
        this.initialTemplate = name;
    }

    public void setRecoveryPolicy(String policy) {
        this.recoveryPolicy = policy;
    }

    public void setTracing(boolean tracing) {
        this.tracing = tracing;
    }

    public void setLineNumbering(boolean numbering) {
        this.lineNumbering = numbering;
    }

    public void setXmlVersion(String version) {
        this.xmlVersion = version;
    }

    public void setUseImplicitFileset(boolean useimplicitfileset) {
        this.useImplicitFileset = useimplicitfileset;
    }

    public void addConfiguredXMLCatalog(XMLCatalog xmlCatalog) {
        this.xmlCatalog.addConfiguredXMLCatalog(xmlCatalog);
    }

    public void setFileNameParameter(String fileNameParameter) {
        this.fileNameParameter = fileNameParameter;
    }

    public void setFileDirParameter(String fileDirParameter) {
        this.fileDirParameter = fileDirParameter;
    }

    public void setOut(File outFile) {
        this.outFile = outFile;
    }

    public void setIn(File inFile) {
        this.inFile = inFile;
    }

    private void checkDest() {
        if (this.destDir == null) {
            String msg = "destdir attributes must be set!";
            throw new BuildException(msg);
        }
    }

    private void processResources(Resource stylesheet) {
        for (Resource r : this.resources) {
            FileResource f;
            if (!r.isExists()) continue;
            File base = this.baseDir;
            String name = r.getName();
            if (r instanceof FileResource && (base = (f = (FileResource)r).getBaseDir()) == null) {
                name = f.getFile().getAbsolutePath();
            }
            this.process(base, name, this.destDir, stylesheet);
        }
    }

    private void process(File baseDir, String xmlFile, File destDir, Resource stylesheet) throws BuildException {
        File outF = null;
        if (this.templates == null) {
            this.configureLiaison(stylesheet);
        }
        Controller transformer = (Controller)this.templates.newTransformer();
        if (this.fileNameParameter != null) {
            transformer.setParameter(this.fileNameParameter, xmlFile);
        }
        if (this.fileDirParameter != null) {
            transformer.setParameter(this.fileDirParameter, baseDir.getAbsolutePath());
        }
        try {
            long styleSheetLastModified = stylesheet.getLastModified();
            File inF = new File(baseDir, xmlFile);
            if (inF.isDirectory()) {
                this.log("Skipping " + inF + " it is a directory.", 3);
                return;
            }
            Object mapper = this.mapperElement != null ? this.mapperElement.getImplementation() : new StyleMapper();
            String[] outFileName = mapper.mapFileName(xmlFile);
            if (outFileName == null || outFileName.length == 0) {
                this.log("Skipping " + this.inFile + " it cannot get mapped to output.", 3);
                return;
            }
            if (outFileName == null || outFileName.length > 1) {
                this.log("Skipping " + this.inFile + " its mapping is ambiguous.", 3);
                return;
            }
            outF = new File(destDir, outFileName[0]);
            if (this.force || inF.lastModified() > outF.lastModified() || styleSheetLastModified > outF.lastModified()) {
                this.ensureDirectoryFor(outF);
                this.log("Processing (A) " + inF + " to " + outF);
                this.configureLiaison(stylesheet);
                this.transform(inF, outF);
            }
        }
        catch (Exception ex) {
            this.log("Failed to process " + this.inFile, 2);
            if (outF != null) {
                outF.delete();
            }
            throw new BuildException((Throwable)ex);
        }
    }

    private void process(File inFile, File outFile, Resource stylesheet) throws BuildException {
        try {
            long styleSheetLastModified = stylesheet.getLastModified();
            this.log("In file " + inFile + " time: " + inFile.lastModified(), 4);
            this.log("Out file " + outFile + " time: " + outFile.lastModified(), 4);
            this.log("Style file " + this.xslFile + " time: " + styleSheetLastModified, 4);
            if (this.force || inFile.lastModified() >= outFile.lastModified() || styleSheetLastModified >= outFile.lastModified()) {
                this.ensureDirectoryFor(outFile);
                this.log("Processing (B) " + inFile + " to " + outFile, 2);
                this.configureLiaison(stylesheet);
                this.transform(inFile, outFile);
            } else {
                this.log("Skipping input file " + inFile + " because it is older than output file " + outFile + " and so is the stylesheet " + stylesheet, 4);
            }
        }
        catch (Exception ex) {
            this.log("Failed to process " + inFile, 2);
            if (outFile != null) {
                outFile.delete();
            }
            throw new BuildException((Throwable)ex);
        }
    }

    private void transform(File in, File out) {
        if (this.templates == null) {
            throw new BuildException("No transformer has been created");
        }
        try {
            Controller transformer = this.createTransformer(this.templates);
            StreamSource ss = new StreamSource(in);
            StreamResult sr = new StreamResult(out);
            transformer.transform(ss, sr);
        }
        catch (TransformerException ex) {
            this.log("Failed to transform " + in, 2);
            if (out != null) {
                out.delete();
            }
            throw new BuildException((Throwable)ex);
        }
    }

    private void ensureDirectoryFor(File targetFile) throws BuildException {
        File directory = targetFile.getParentFile();
        if (!directory.exists() && !directory.mkdirs()) {
            throw new BuildException("Unable to create directory: " + directory.getAbsolutePath());
        }
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public XMLCatalog getXMLCatalog() {
        this.xmlCatalog.setProject(this.getProject());
        return this.xmlCatalog;
    }

    public Enumeration getOutputProperties() {
        return this.outputProperties.elements();
    }

    public Param createParam() {
        Param p = new Param();
        this.params.addElement(p);
        return p;
    }

    public OutputProperty createOutputProperty() {
        OutputProperty p = new OutputProperty();
        this.outputProperties.addElement(p);
        return p;
    }

    public void init() throws BuildException {
        super.init();
        this.xmlCatalog.setProject(this.getProject());
    }

    protected void configureLiaison(File stylesheet) throws BuildException {
        FileResource fr = new FileResource();
        fr.setProject(this.getProject());
        fr.setFile(stylesheet);
        this.configureLiaison((Resource)fr);
    }

    protected void configureLiaison(Resource stylesheet) throws BuildException {
        if (this.stylesheetLoaded && this.reuseLoadedStylesheet) {
            return;
        }
        this.stylesheetLoaded = true;
        try {
            this.log("Loading stylesheet " + stylesheet, 2);
            if (!(stylesheet instanceof FileResource)) {
                throw new BuildException("Saxon accepts the stylesheet only as a file", this.getLocation());
            }
            File styleFile = ((FileResource)stylesheet).getFile();
            CompilerInfo info = this.config.getDefaultXsltCompilerInfo();
            this.templates = PreparedStylesheet.compile(new StreamSource(styleFile), this.config, info);
        }
        catch (Exception ex) {
            this.log("Failed to transform using stylesheet " + stylesheet, 2);
            throw new BuildException((Throwable)ex);
        }
    }

    private Controller createTransformer(PreparedStylesheet pss) throws XPathException {
        Controller transformer = (Controller)pss.newTransformer();
        transformer.setInitialMode(this.initialMode);
        transformer.setInitialTemplate(this.initialTemplate);
        if (this.tracing) {
            transformer.addTraceListener(new XSLTTraceListener());
        }
        if (this.recoveryPolicy != null) {
            if (this.recoveryPolicy.equals("silent")) {
                transformer.setRecoveryPolicy(0);
            } else if (this.recoveryPolicy.equals("recover")) {
                transformer.setRecoveryPolicy(1);
            } else {
                transformer.setRecoveryPolicy(2);
            }
        }
        Enumeration e = this.params.elements();
        while (e.hasMoreElements()) {
            Param p = (Param)e.nextElement();
            if (!p.shouldUse()) continue;
            transformer.setParameter(p.getName(), p.getExpression());
        }
        return transformer;
    }

    public static class OutputProperty {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class Param {
        private String name = null;
        private String expression = null;
        private String ifProperty;
        private String unlessProperty;
        private Project project;

        public void setProject(Project project) {
            this.project = project;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }

        public String getName() throws BuildException {
            if (this.name == null) {
                throw new BuildException("Name attribute is missing.");
            }
            return this.name;
        }

        public String getExpression() throws BuildException {
            if (this.expression == null) {
                throw new BuildException("Expression attribute is missing.");
            }
            return this.expression;
        }

        public void setIf(String ifProperty) {
            this.ifProperty = ifProperty;
        }

        public void setUnless(String unlessProperty) {
            this.unlessProperty = unlessProperty;
        }

        public boolean shouldUse() {
            if (this.ifProperty != null && this.project.getProperty(this.ifProperty) == null) {
                return false;
            }
            return this.unlessProperty == null || this.project.getProperty(this.unlessProperty) == null;
        }
    }

    private class StyleMapper
    implements FileNameMapper {
        private StyleMapper() {
        }

        public void setFrom(String from) {
        }

        public void setTo(String to) {
        }

        public String[] mapFileName(String xmlFile) {
            int dotPos = xmlFile.lastIndexOf(46);
            if (dotPos > 0) {
                xmlFile = xmlFile.substring(0, dotPos);
            }
            return new String[]{String.valueOf(xmlFile) + AntTransform.this.targetExtension};
        }
    }
}

