/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon;

import java.io.PrintWriter;
import java.io.Writer;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import net2.sf.saxon.expr.ExpressionLocation;
import net2.sf.saxon.trans.XPathException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class StandardErrorHandler
implements ErrorHandler {
    private ErrorListener errorListener;
    private Writer errorOutput;
    private int warningCount = 0;
    private int errorCount = 0;
    private int fatalErrorCount = 0;

    public StandardErrorHandler(ErrorListener listener) {
        this.errorListener = listener;
    }

    public void setErrorOutput(Writer writer) {
        this.errorOutput = writer;
    }

    @Override
    public void warning(SAXParseException e) {
        if (this.errorListener != null) {
            try {
                ++this.warningCount;
                this.errorListener.warning(new TransformerException(e));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        ++this.errorCount;
        this.reportError(e, false);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        ++this.fatalErrorCount;
        this.reportError(e, true);
        throw e;
    }

    protected void reportError(SAXParseException e, boolean isFatal) {
        block8: {
            if (this.errorListener != null) {
                try {
                    ExpressionLocation loc = new ExpressionLocation(e.getSystemId(), e.getLineNumber(), e.getColumnNumber());
                    XPathException err = new XPathException("Error reported by XML parser", loc, e);
                    err.setErrorCode("SXXP0003");
                    if (isFatal) {
                        this.errorListener.fatalError(err);
                        break block8;
                    }
                    this.errorListener.error(err);
                }
                catch (Exception loc) {}
            } else {
                try {
                    if (this.errorOutput == null) {
                        this.errorOutput = new PrintWriter(System.err);
                    }
                    String errcat = isFatal ? "Fatal error" : "Error";
                    this.errorOutput.write(String.valueOf(errcat) + " reported by XML parser: " + e.getMessage() + '\n');
                    this.errorOutput.write("  URL:    " + e.getSystemId() + '\n');
                    this.errorOutput.write("  Line:   " + e.getLineNumber() + '\n');
                    this.errorOutput.write("  Column: " + e.getColumnNumber() + '\n');
                    this.errorOutput.flush();
                }
                catch (Exception e2) {
                    System.err.println(e);
                    System.err.println(e2);
                    e2.printStackTrace();
                }
            }
        }
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getFatalErrorCount() {
        return this.fatalErrorCount;
    }
}

