/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.Controller;
import net2.sf.saxon.event.NamespaceReducer;
import net2.sf.saxon.event.ParseOptions;
import net2.sf.saxon.event.PipelineConfiguration;
import net2.sf.saxon.event.Receiver;
import net2.sf.saxon.event.Sender;
import net2.sf.saxon.event.SerializerFactory;
import net2.sf.saxon.trans.XPathException;
import org.xml.sax.SAXParseException;

class IdentityTransformer
extends Controller {
    protected IdentityTransformer(Configuration config) {
        super(config);
    }

    @Override
    public void transform(Source source, Result result) throws TransformerException {
        try {
            PipelineConfiguration pipe = this.makePipelineConfiguration();
            SerializerFactory sf = this.getConfiguration().getSerializerFactory();
            Receiver receiver = sf.getReceiver(result, pipe, this.getOutputProperties());
            NamespaceReducer reducer = new NamespaceReducer();
            reducer.setUnderlyingReceiver(receiver);
            ParseOptions options = new ParseOptions();
            options.setContinueAfterValidationErrors(true);
            new Sender(pipe).send(source, reducer, options);
        }
        catch (XPathException err) {
            Throwable cause = err.getException();
            if (cause != null && cause instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)cause;
                if ((cause = spe.getException()) instanceof RuntimeException) {
                    this.reportFatalError(err);
                }
            } else {
                this.reportFatalError(err);
            }
            throw err;
        }
    }
}

