/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net2.sf.saxon.AugmentedSource;
import net2.sf.saxon.CollectionURIResolver;
import net2.sf.saxon.Controller;
import net2.sf.saxon.OutputURIResolver;
import net2.sf.saxon.Platform;
import net2.sf.saxon.SourceResolver;
import net2.sf.saxon.StandardErrorListener;
import net2.sf.saxon.StandardURIResolver;
import net2.sf.saxon.Version;
import net2.sf.saxon.charcode.CharacterSetFactory;
import net2.sf.saxon.event.Builder;
import net2.sf.saxon.event.ContentHandlerProxy;
import net2.sf.saxon.event.ParseOptions;
import net2.sf.saxon.event.PipelineConfiguration;
import net2.sf.saxon.event.ProxyReceiver;
import net2.sf.saxon.event.Receiver;
import net2.sf.saxon.event.Sender;
import net2.sf.saxon.event.SequenceReceiver;
import net2.sf.saxon.event.SerializerFactory;
import net2.sf.saxon.evpull.PullEventSource;
import net2.sf.saxon.expr.CollationMap;
import net2.sf.saxon.expr.EarlyEvaluationContext;
import net2.sf.saxon.expr.ExpressionParser;
import net2.sf.saxon.expr.Optimizer;
import net2.sf.saxon.expr.PJConverter;
import net2.sf.saxon.expr.PathMap;
import net2.sf.saxon.expr.PendingUpdateList;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.functions.ExtensionFunctionDefinition;
import net2.sf.saxon.functions.FunctionLibraryList;
import net2.sf.saxon.functions.IntegratedFunctionLibrary;
import net2.sf.saxon.functions.StandardCollectionURIResolver;
import net2.sf.saxon.functions.VendorFunctionLibrary;
import net2.sf.saxon.instruct.Debugger;
import net2.sf.saxon.instruct.DocumentInstr;
import net2.sf.saxon.instruct.ElementCreator;
import net2.sf.saxon.instruct.SlotManager;
import net2.sf.saxon.instruct.UserFunction;
import net2.sf.saxon.number.Numberer;
import net2.sf.saxon.number.Numberer_en;
import net2.sf.saxon.om.DocumentInfo;
import net2.sf.saxon.om.DocumentNumberAllocator;
import net2.sf.saxon.om.DocumentPool;
import net2.sf.saxon.om.ExternalObjectModel;
import net2.sf.saxon.om.Name10Checker;
import net2.sf.saxon.om.Name11Checker;
import net2.sf.saxon.om.NameChecker;
import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.TreeModel;
import net2.sf.saxon.om.Validation;
import net2.sf.saxon.pull.PullSource;
import net2.sf.saxon.query.ModuleURIResolver;
import net2.sf.saxon.query.StandardModuleURIResolver;
import net2.sf.saxon.query.StaticQueryContext;
import net2.sf.saxon.sort.CollationURIResolver;
import net2.sf.saxon.sort.StandardCollationURIResolver;
import net2.sf.saxon.sort.StringCollator;
import net2.sf.saxon.style.StyleNodeFactory;
import net2.sf.saxon.sxpath.IndependentContext;
import net2.sf.saxon.trace.TraceListener;
import net2.sf.saxon.trans.CompilerInfo;
import net2.sf.saxon.trans.DynamicLoader;
import net2.sf.saxon.trans.IConfigurationReader;
import net2.sf.saxon.trans.LocalizerFactory;
import net2.sf.saxon.trans.Mode;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.BuiltInType;
import net2.sf.saxon.type.ExternalObjectType;
import net2.sf.saxon.type.SchemaDeclaration;
import net2.sf.saxon.type.SchemaException;
import net2.sf.saxon.type.SchemaType;
import net2.sf.saxon.type.SchemaURIResolver;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.type.ValidationException;
import net2.sf.saxon.value.SequenceType;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.LexicalHandler;

public class Configuration
implements Serializable,
SourceResolver {
    private static Platform platform;
    public static Class<Configuration> configurationClass;
    private transient Object apiProcessor = null;
    private transient URIResolver uriResolver;
    private StandardURIResolver systemURIResolver = new StandardURIResolver(this);
    private int xmlVersion = 10;
    protected int xsdVersion = XSD10;
    private boolean tracing = false;
    private boolean traceOptimizations = false;
    private transient TraceListener traceListener = null;
    private String traceListenerClass = null;
    private IntegratedFunctionLibrary integratedFunctionLibrary = new IntegratedFunctionLibrary();
    protected VendorFunctionLibrary vendorFunctionLibrary;
    private CollationURIResolver collationResolver = new StandardCollationURIResolver();
    private String defaultCollection = null;
    private CollationMap collationMap = new CollationMap(this);
    private CollectionURIResolver collectionResolver = new StandardCollectionURIResolver();
    private ModuleURIResolver moduleURIResolver = null;
    private ModuleURIResolver standardModuleURIResolver = StandardModuleURIResolver.getInstance();
    private SchemaURIResolver schemaURIResolver = null;
    private transient SourceResolver sourceResolver = this;
    private String sourceParserClass;
    private String styleParserClass;
    private boolean preferJaxpParser = true;
    private boolean timing = false;
    private boolean allowExternalFunctions = true;
    private boolean traceExternalFunctions = false;
    private boolean useTypedValueCache = true;
    private boolean lazyConstructionMode = false;
    private boolean allowMultiThreading = false;
    private boolean preEvaluateDocFunction = false;
    private boolean useDisableOutputEscaping = false;
    private NamePool namePool = new NamePool();
    private DocumentNumberAllocator documentNumberAllocator = new DocumentNumberAllocator();
    private DocumentPool globalDocumentPool = new DocumentPool();
    private transient XPathContext conversionContext = null;
    private transient TypeHierarchy typeHierarchy;
    private int hostLanguage = 50;
    private boolean validationWarnings = false;
    private boolean retainDTDattributeTypes = false;
    private ParseOptions defaultParseOptions = new ParseOptions();
    private transient Debugger debugger = null;
    protected Optimizer optimizer = null;
    protected int optimizationLevel = 10;
    private transient DynamicLoader dynamicLoader = new DynamicLoader();
    protected transient StyleNodeFactory styleNodeFactory = null;
    private SerializerFactory serializerFactory = new SerializerFactory();
    private Properties defaultSerializationProperties = new Properties();
    private transient CharacterSetFactory characterSetFactory;
    private String defaultLanguage = Locale.getDefault().getLanguage();
    private String defaultCountry = Locale.getDefault().getCountry();
    private transient LocalizerFactory localizerFactory;
    private CompilerInfo defaultXsltCompilerInfo = new CompilerInfo();
    private transient StaticQueryContext defaultStaticQueryContext;
    private transient List<XMLReader> sourceParserPool = new ArrayList<XMLReader>(5);
    private transient List<XMLReader> styleParserPool = new ArrayList<XMLReader>(5);
    private List<ExternalObjectModel> externalObjectModels = new ArrayList<ExternalObjectModel>(4);
    private int domLevel = 3;
    public static final int RECOVER_SILENTLY = 0;
    public static final int RECOVER_WITH_WARNINGS = 1;
    public static final int DO_NOT_RECOVER = 2;
    public static final int XML10 = 10;
    public static final int XML11 = 11;
    public static final int XSLT = 50;
    public static final int XQUERY = 51;
    public static final int XML_SCHEMA = 52;
    public static final int JAVA_APPLICATION = 53;
    public static final int XPATH = 54;
    public static int XSD10;
    public static int XSD11;
    private static LexicalHandler dummyLexicalHandler;

    static {
        XSD10 = 10;
        XSD11 = 11;
        try {
            Class<?> configClass;
            Class<?> platformClass;
            String sConfigFile = "edition.properties2";
            InputStream in = Configuration.class.getClassLoader().getResourceAsStream(sConfigFile);
            if (in == null) {
                throw new RuntimeException("Cannot read edition.properties2 file");
            }
            Properties props = new Properties();
            props.load(in);
            String platformClassName = props.getProperty("platform");
            if (platformClassName == null) {
                platformClassName = "net2.sf.saxon.java.JavaPlatform";
            }
            ClassLoader loader = null;
            try {
                loader = Thread.currentThread().getContextClassLoader();
            }
            catch (Exception err) {
                System.err.println("Failed to getContextClassLoader() - continuing");
            }
            if (loader != null) {
                try {
                    platformClass = loader.loadClass(platformClassName);
                }
                catch (Exception ex) {
                    platformClass = Class.forName(platformClassName);
                }
            } else {
                platformClass = Class.forName(platformClassName);
            }
            platform = (Platform)platformClass.newInstance();
            String configClassName = props.getProperty("config");
            if (configClassName == null) {
                configClassName = "net2.sf.saxon.Configuration";
            }
            if (loader != null) {
                try {
                    configClass = loader.loadClass(configClassName);
                }
                catch (Exception ex) {
                    configClass = Class.forName(configClassName);
                }
            } else {
                configClass = Class.forName(configClassName);
            }
            configurationClass = configClass;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to load configuration defined in edition.properties", e);
        }
        dummyLexicalHandler = new DefaultHandler2();
    }

    public static Configuration readConfiguration(Source source) throws XPathException {
        try {
            Class<?> readerClass = Class.forName("com.saxonica.config.ConfigurationReader");
            IConfigurationReader reader = (IConfigurationReader)readerClass.newInstance();
            return reader.makeConfiguration(source);
        }
        catch (ClassNotFoundException e) {
            throw new XPathException("Could not locate ConfigurationReader: needs Saxon-PE or Saxon-EE");
        }
        catch (InstantiationException e) {
            throw new XPathException(e);
        }
        catch (IllegalAccessException e) {
            throw new XPathException(e);
        }
    }

    public Configuration() {
        this.init();
    }

    public static Configuration newConfiguration() {
        try {
            return configurationClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot instantiate a Configuration", e);
        }
    }

    public static Configuration makeConfiguration(ClassLoader classLoader, String className) {
        if (className == null) {
            className = configurationClass.getClass().getName();
        }
        try {
            Configuration c;
            Class<?> theClass;
            ClassLoader loader = classLoader;
            if (loader == null) {
                try {
                    loader = Thread.currentThread().getContextClassLoader();
                }
                catch (Exception err) {
                    System.err.println("Failed to getContextClassLoader() - continuing");
                }
            }
            if (loader != null) {
                try {
                    theClass = loader.loadClass(className);
                }
                catch (Exception ex) {
                    theClass = Class.forName(className);
                }
            } else {
                theClass = Class.forName(className);
            }
            if ((c = (Configuration)theClass.newInstance()).isLicensed()) {
                return c;
            }
            return new Configuration();
        }
        catch (ClassNotFoundException e) {
            return new Configuration();
        }
        catch (InstantiationException e) {
            return new Configuration();
        }
        catch (IllegalAccessException e) {
            return new Configuration();
        }
    }

    protected void init() {
        platform.initialize(this);
        this.defaultXsltCompilerInfo.setURIResolver(this.getSystemURIResolver());
    }

    public static Configuration makeLicensedConfiguration(ClassLoader classLoader, String className) throws RuntimeException {
        if (className == null) {
            className = "com.saxonica.config.ProfessionalConfiguration";
        }
        try {
            Class<?> theClass;
            ClassLoader loader = classLoader;
            if (loader == null) {
                try {
                    loader = Thread.currentThread().getContextClassLoader();
                }
                catch (Exception err) {
                    System.err.println("Failed to getContextClassLoader() - continuing");
                }
            }
            if (loader != null) {
                try {
                    theClass = loader.loadClass(className);
                }
                catch (Exception ex) {
                    theClass = Class.forName(className);
                }
            } else {
                theClass = Class.forName(className);
            }
            return (Configuration)theClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static Configuration makeSchemaAwareConfiguration(ClassLoader loader, String className) {
        return Configuration.makeLicensedConfiguration(loader, className);
    }

    public String getEditionCode() {
        return "HE";
    }

    public Configuration copy() {
        Configuration c = new Configuration();
        this.copyTo(c);
        return c;
    }

    protected void copyTo(Configuration c) {
        c.uriResolver = this.uriResolver;
        c.systemURIResolver = this.systemURIResolver;
        c.xmlVersion = this.xmlVersion;
        c.tracing = this.tracing;
        c.traceOptimizations = this.traceOptimizations;
        c.traceListener = this.traceListener;
        c.integratedFunctionLibrary = (IntegratedFunctionLibrary)this.integratedFunctionLibrary.copy();
        c.vendorFunctionLibrary = this.vendorFunctionLibrary;
        c.collectionResolver = this.collectionResolver;
        c.defaultCollection = this.defaultCollection;
        c.collationResolver = this.collationResolver;
        c.collationMap = new CollationMap(this.collationMap);
        if (this.localizerFactory != null) {
            c.localizerFactory = this.localizerFactory.copy();
        }
        c.moduleURIResolver = this.moduleURIResolver;
        c.standardModuleURIResolver = this.standardModuleURIResolver;
        c.schemaURIResolver = this.schemaURIResolver;
        c.sourceResolver = this.sourceResolver;
        c.sourceParserClass = this.sourceParserClass;
        c.styleParserClass = this.styleParserClass;
        c.timing = this.timing;
        c.defaultXsltCompilerInfo = new CompilerInfo(this.defaultXsltCompilerInfo);
        c.defaultStaticQueryContext = new StaticQueryContext(this.getDefaultStaticQueryContext());
        c.allowExternalFunctions = this.allowExternalFunctions;
        c.lazyConstructionMode = this.lazyConstructionMode;
        c.allowMultiThreading = this.allowMultiThreading;
        c.preEvaluateDocFunction = this.preEvaluateDocFunction;
        c.namePool = this.namePool;
        c.documentNumberAllocator = this.documentNumberAllocator;
        c.conversionContext = this.conversionContext;
        c.typeHierarchy = this.typeHierarchy;
        c.hostLanguage = this.hostLanguage;
        c.defaultParseOptions = new ParseOptions(this.defaultParseOptions);
        c.validationWarnings = this.validationWarnings;
        c.retainDTDattributeTypes = this.retainDTDattributeTypes;
        c.debugger = this.debugger;
        c.optimizer = this.optimizer;
        c.serializerFactory = this.serializerFactory;
        c.characterSetFactory = this.characterSetFactory;
        c.dynamicLoader = this.dynamicLoader;
        c.sourceParserPool = this.sourceParserPool;
        c.externalObjectModels = this.externalObjectModels;
        c.domLevel = this.domLevel;
    }

    public void setProcessor(Object processor) {
        this.apiProcessor = processor;
    }

    public Object getProcessor() {
        return this.apiProcessor;
    }

    public String getProductTitle() {
        return "Saxon-" + this.getEditionCode() + " " + Version.getProductVersion() + platform.getPlatformSuffix() + " from Saxonica";
    }

    public boolean isLicensed() {
        return true;
    }

    public boolean isLicensedFeature(int feature) {
        return false;
    }

    public boolean isSchemaAware(int language) {
        return false;
    }

    public void displayLicenseMessage() {
    }

    public int getHostLanguage() {
        return this.hostLanguage;
    }

    public void setHostLanguage(int hostLanguage) {
        this.hostLanguage = hostLanguage;
    }

    public static Platform getPlatform() {
        return platform;
    }

    public void setDynamicLoader(DynamicLoader dynamicLoader) {
        this.dynamicLoader = dynamicLoader;
    }

    public DynamicLoader getDynamicLoader() {
        return this.dynamicLoader;
    }

    public Class getClass(String className, boolean tracing, ClassLoader classLoader) throws XPathException {
        return this.dynamicLoader.getClass(className, tracing, classLoader);
    }

    public Object getInstance(String className, ClassLoader classLoader) throws XPathException {
        return this.dynamicLoader.getInstance(className, this.isTiming(), classLoader);
    }

    public URIResolver getURIResolver() {
        if (this.uriResolver == null) {
            return this.systemURIResolver;
        }
        return this.uriResolver;
    }

    public void setURIResolver(URIResolver resolver) {
        this.uriResolver = resolver;
        if (resolver instanceof StandardURIResolver) {
            ((StandardURIResolver)resolver).setConfiguration(this);
        }
        this.defaultXsltCompilerInfo.setURIResolver(resolver);
    }

    public void setParameterizedURIResolver() {
        this.getSystemURIResolver().setRecognizeQueryParameters(true);
    }

    public StandardURIResolver getSystemURIResolver() {
        return this.systemURIResolver;
    }

    public URIResolver makeURIResolver(String className) throws TransformerException {
        Object obj = this.dynamicLoader.getInstance(className, null);
        if (obj instanceof StandardURIResolver) {
            ((StandardURIResolver)obj).setConfiguration(this);
        }
        if (obj instanceof URIResolver) {
            return (URIResolver)obj;
        }
        throw new XPathException("Class " + className + " is not a URIResolver");
    }

    public ErrorListener getErrorListener() {
        ErrorListener listener = this.defaultParseOptions.getErrorListener();
        if (listener == null) {
            listener = new StandardErrorListener();
            ((StandardErrorListener)listener).setRecoveryPolicy(this.defaultXsltCompilerInfo.getRecoveryPolicy());
            this.defaultParseOptions.setErrorListener(listener);
        }
        return listener;
    }

    public void setErrorListener(ErrorListener listener) {
        this.defaultParseOptions.setErrorListener(listener);
    }

    public void reportFatalError(XPathException err) {
        if (!err.hasBeenReported()) {
            try {
                this.getErrorListener().fatalError(err);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            err.setHasBeenReported(true);
        }
    }

    public void setMultiThreading(boolean multithreading) {
        this.allowMultiThreading = multithreading;
    }

    public boolean isMultiThreading() {
        return this.allowMultiThreading;
    }

    public void setXMLVersion(int version) {
        this.xmlVersion = version;
    }

    public int getXMLVersion() {
        return this.xmlVersion;
    }

    public ParseOptions getParseOptions() {
        return this.defaultParseOptions;
    }

    public NameChecker getNameChecker() {
        return this.xmlVersion == 10 ? Name10Checker.getInstance() : Name11Checker.getInstance();
    }

    public int getXsdVersion() {
        return this.xsdVersion;
    }

    public XPathContext getConversionContext() {
        if (this.conversionContext == null) {
            this.conversionContext = new EarlyEvaluationContext(this, new CollationMap(this));
        }
        return this.conversionContext;
    }

    public int getTreeModel() {
        return this.defaultParseOptions.getModel().getSymbolicValue();
    }

    public void setTreeModel(int treeModel) {
        this.defaultParseOptions.setModel(TreeModel.getTreeModel(treeModel));
    }

    public boolean useTypedValueCache() {
        return this.useTypedValueCache;
    }

    public boolean isLineNumbering() {
        return this.defaultParseOptions.isLineNumbering();
    }

    public void setLineNumbering(boolean lineNumbering) {
        this.defaultParseOptions.setLineNumbering(lineNumbering);
    }

    public void setXIncludeAware(boolean state) {
        this.defaultParseOptions.setXIncludeAware(state);
    }

    public boolean isXIncludeAware() {
        return this.defaultParseOptions.isXIncludeAware();
    }

    public TraceListener getTraceListener() {
        return this.traceListener;
    }

    public TraceListener makeTraceListener() throws XPathException {
        if (this.traceListener != null) {
            return this.traceListener;
        }
        if (this.traceListenerClass != null) {
            try {
                return this.makeTraceListener(this.traceListenerClass);
            }
            catch (ClassCastException e) {
                throw new XPathException(e);
            }
        }
        return null;
    }

    public void setTraceListener(TraceListener traceListener) {
        this.traceListener = traceListener;
        this.setCompileWithTracing(true);
        this.setMultiThreading(false);
    }

    public void setTraceListenerClass(String className) {
        try {
            this.makeTraceListener(className);
        }
        catch (XPathException err) {
            throw new IllegalArgumentException(String.valueOf(className) + ": " + err.getMessage());
        }
        this.traceListenerClass = className;
        this.setCompileWithTracing(true);
    }

    public String getTraceListenerClass() {
        return this.traceListenerClass;
    }

    public boolean isCompileWithTracing() {
        return this.tracing;
    }

    public void setCompileWithTracing(boolean trace) {
        this.tracing = trace;
        if (this.defaultXsltCompilerInfo != null) {
            this.defaultXsltCompilerInfo.setCompileWithTracing(trace);
        }
        if (this.defaultStaticQueryContext != null) {
            this.defaultStaticQueryContext.setCompileWithTracing(trace);
        }
    }

    public void setOptimizerTracing(boolean trace) {
        this.traceOptimizations = trace;
    }

    public boolean isOptimizerTracing() {
        return this.traceOptimizations;
    }

    public TraceListener makeTraceListener(String className) throws XPathException {
        Object obj = this.dynamicLoader.getInstance(className, null);
        if (obj instanceof TraceListener) {
            return (TraceListener)obj;
        }
        throw new XPathException("Class " + className + " is not a TraceListener");
    }

    public void registerExtensionFunction(ExtensionFunctionDefinition function) throws XPathException {
        try {
            this.integratedFunctionLibrary.registerFunction(function);
        }
        catch (Exception err) {
            throw new IllegalArgumentException(err);
        }
    }

    public IntegratedFunctionLibrary getIntegratedFunctionLibrary() {
        return this.integratedFunctionLibrary;
    }

    public VendorFunctionLibrary getVendorFunctionLibrary() {
        if (this.vendorFunctionLibrary == null) {
            this.vendorFunctionLibrary = new VendorFunctionLibrary();
        }
        return this.vendorFunctionLibrary;
    }

    public void addExtensionBinders(FunctionLibraryList list) {
    }

    public UserFunction newUserFunction(boolean memoFunction) {
        return new UserFunction();
    }

    public void setCollationURIResolver(CollationURIResolver resolver) {
        this.collationResolver = resolver;
    }

    public CollationURIResolver getCollationURIResolver() {
        return this.collationResolver;
    }

    public CollationMap getCollationMap() {
        return this.collationMap;
    }

    public void setDefaultCollection(String uri) {
        this.defaultCollection = uri;
    }

    public String getDefaultCollection() {
        return this.defaultCollection;
    }

    public void setCollectionURIResolver(CollectionURIResolver resolver) {
        this.collectionResolver = resolver;
    }

    public CollectionURIResolver getCollectionURIResolver() {
        return this.collectionResolver;
    }

    public void setLocalizerFactory(LocalizerFactory factory) {
        this.localizerFactory = factory;
    }

    public LocalizerFactory getLocalizerFactory() {
        return this.localizerFactory;
    }

    public void setDefaultLanguage(String language) {
        this.defaultLanguage = language;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultCountry(String country) {
        this.defaultCountry = country;
    }

    public String getDefaultCountry() {
        return this.defaultCountry;
    }

    public Numberer makeNumberer(String language, String country) {
        if (this.localizerFactory == null) {
            return new Numberer_en();
        }
        Numberer numberer = this.localizerFactory.getNumberer(language, country);
        if (numberer == null) {
            numberer = new Numberer_en();
        }
        return numberer;
    }

    public void setModuleURIResolver(ModuleURIResolver resolver) {
        this.moduleURIResolver = resolver;
    }

    public void setModuleURIResolver(String className) throws TransformerException {
        Object obj = this.dynamicLoader.getInstance(className, null);
        if (!(obj instanceof ModuleURIResolver)) {
            throw new XPathException("Class " + className + " is not a ModuleURIResolver");
        }
        this.setModuleURIResolver((ModuleURIResolver)obj);
    }

    public ModuleURIResolver getModuleURIResolver() {
        return this.moduleURIResolver;
    }

    public ModuleURIResolver getStandardModuleURIResolver() {
        return this.standardModuleURIResolver;
    }

    public void setSchemaURIResolver(SchemaURIResolver resolver) {
        this.schemaURIResolver = resolver;
    }

    public SchemaURIResolver getSchemaURIResolver() {
        return this.schemaURIResolver;
    }

    public CompilerInfo getDefaultXsltCompilerInfo() {
        return this.defaultXsltCompilerInfo;
    }

    public StaticQueryContext getDefaultStaticQueryContext() {
        if (this.defaultStaticQueryContext == null) {
            this.defaultStaticQueryContext = new StaticQueryContext(this, true);
        }
        return this.defaultStaticQueryContext;
    }

    public int getRecoveryPolicy() {
        return this.defaultXsltCompilerInfo.getRecoveryPolicy();
    }

    public void setRecoveryPolicy(int recoveryPolicy) {
        this.defaultXsltCompilerInfo.setRecoveryPolicy(recoveryPolicy);
    }

    public String getMessageEmitterClass() {
        return this.defaultXsltCompilerInfo.getMessageReceiverClassName();
    }

    public void setMessageEmitterClass(String messageReceiverClassName) {
        this.defaultXsltCompilerInfo.setMessageReceiverClassName(messageReceiverClassName);
    }

    public String getSourceParserClass() {
        return this.sourceParserClass;
    }

    public void setSourceParserClass(String sourceParserClass) {
        this.sourceParserClass = sourceParserClass;
    }

    public String getStyleParserClass() {
        return this.styleParserClass;
    }

    public void setStyleParserClass(String parser) {
        this.styleParserClass = parser;
    }

    public OutputURIResolver getOutputURIResolver() {
        return this.defaultXsltCompilerInfo.getOutputURIResolver();
    }

    public void setOutputURIResolver(OutputURIResolver outputURIResolver) {
        this.defaultXsltCompilerInfo.setOutputURIResolver(outputURIResolver);
    }

    public void setSerializerFactory(SerializerFactory factory) {
        this.serializerFactory = factory;
    }

    public SerializerFactory getSerializerFactory() {
        return this.serializerFactory;
    }

    public CharacterSetFactory getCharacterSetFactory() {
        if (this.characterSetFactory == null) {
            this.characterSetFactory = new CharacterSetFactory();
        }
        return this.characterSetFactory;
    }

    public void setDefaultSerializationProperties(Properties props) {
        this.defaultSerializationProperties = props;
    }

    public Properties getDefaultSerializationProperties() {
        return this.defaultSerializationProperties;
    }

    public boolean isTiming() {
        return this.timing;
    }

    public void setTiming(boolean timing) {
        this.timing = timing;
    }

    public boolean isVersionWarning() {
        return this.defaultXsltCompilerInfo.isVersionWarning();
    }

    public void setVersionWarning(boolean warn) {
        this.defaultXsltCompilerInfo.setVersionWarning(warn);
    }

    public boolean isAllowExternalFunctions() {
        return this.allowExternalFunctions;
    }

    public void setAllowExternalFunctions(boolean allowExternalFunctions) {
        this.allowExternalFunctions = allowExternalFunctions;
    }

    public boolean isTraceExternalFunctions() {
        return this.traceExternalFunctions;
    }

    public void setRetainDTDAttributeTypes(boolean useTypes) throws TransformerFactoryConfigurationError {
        if (useTypes && !this.isLicensedFeature(1)) {
            throw new TransformerFactoryConfigurationError("Retaining DTD attribute types requires the schema-aware product");
        }
        this.retainDTDattributeTypes = useTypes;
    }

    public boolean isRetainDTDAttributeTypes() {
        return this.retainDTDattributeTypes;
    }

    public void setTraceExternalFunctions(boolean traceExternalFunctions) {
        this.traceExternalFunctions = traceExternalFunctions;
    }

    public boolean isValidation() {
        return this.defaultParseOptions.getDTDValidationMode() == 1 || this.defaultParseOptions.getDTDValidationMode() == 2;
    }

    public void setValidation(boolean validation) {
        this.defaultParseOptions.setDTDValidationMode(validation ? 1 : 4);
    }

    public ProxyReceiver makeDocumentProjector(PathMap.PathMapRoot map) {
        throw new UnsupportedOperationException("Document projection requires a schema-aware Configuration");
    }

    public int getSchemaValidationMode() {
        return this.defaultParseOptions.getSchemaValidationMode();
    }

    public void setSchemaValidationMode(int validationMode) {
        switch (validationMode) {
            case 3: 
            case 4: {
                break;
            }
            case 1: 
            case 2: {
                if (this.isLicensedFeature(1)) break;
                this.needEnterpriseEdition();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported validation mode " + validationMode);
            }
        }
        this.defaultParseOptions.setSchemaValidationMode(validationMode);
    }

    public void setValidationWarnings(boolean warn) {
        this.validationWarnings = warn;
    }

    public boolean isValidationWarnings() {
        return this.validationWarnings;
    }

    public void setExpandAttributeDefaults(boolean expand) {
        this.defaultParseOptions.setExpandAttributeDefaults(expand);
    }

    public boolean isExpandAttributeDefaults() {
        return this.defaultParseOptions.isExpandAttributeDefaults();
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void setNamePool(NamePool targetNamePool) {
        this.namePool = targetNamePool;
    }

    public final TypeHierarchy getTypeHierarchy() {
        if (this.typeHierarchy == null) {
            this.typeHierarchy = new TypeHierarchy(this);
        }
        return this.typeHierarchy;
    }

    public DocumentNumberAllocator getDocumentNumberAllocator() {
        return this.documentNumberAllocator;
    }

    public void setDocumentNumberAllocator(DocumentNumberAllocator allocator) {
        this.documentNumberAllocator = allocator;
    }

    public boolean isCompatible(Configuration other) {
        return this.namePool == other.namePool && this.documentNumberAllocator == other.documentNumberAllocator;
    }

    public DocumentPool getGlobalDocumentPool() {
        return this.globalDocumentPool;
    }

    public boolean isStripsAllWhiteSpace() {
        return this.defaultParseOptions.getStripSpace() == 2;
    }

    public void setStripsAllWhiteSpace(boolean stripsAllWhiteSpace) {
        if (stripsAllWhiteSpace) {
            this.defaultParseOptions.setStripSpace(2);
        }
    }

    public void setStripsWhiteSpace(int kind) {
        this.defaultParseOptions.setStripSpace(kind);
    }

    public int getStripsWhiteSpace() {
        return this.defaultParseOptions.getStripSpace();
    }

    public synchronized XMLReader getSourceParser() throws TransformerFactoryConfigurationError {
        if (this.sourceParserPool == null) {
            this.sourceParserPool = new ArrayList<XMLReader>(10);
        }
        if (!this.sourceParserPool.isEmpty()) {
            int n = this.sourceParserPool.size() - 1;
            XMLReader parser = this.sourceParserPool.get(n);
            this.sourceParserPool.remove(n);
            return parser;
        }
        XMLReader parser = this.getSourceParserClass() != null ? this.makeParser(this.getSourceParserClass()) : this.loadParser();
        if (this.timing) {
            this.reportParserDetails(parser);
        }
        try {
            Sender.configureParser(parser);
        }
        catch (XPathException err) {
            throw new TransformerFactoryConfigurationError(err);
        }
        if (this.isValidation()) {
            try {
                parser.setFeature("http://xml.org/sax/features/validation", true);
            }
            catch (SAXException err) {
                throw new TransformerFactoryConfigurationError("The XML parser does not support validation");
            }
        }
        return parser;
    }

    private void reportParserDetails(XMLReader reader) {
        String name = reader.getClass().getName();
        System.err.println("Using parser " + name);
    }

    public synchronized void reuseSourceParser(XMLReader parser) {
        if (this.sourceParserPool == null) {
            this.sourceParserPool = new ArrayList<XMLReader>(10);
        }
        try {
            parser.setContentHandler(null);
            parser.setEntityResolver(null);
            parser.setDTDHandler(null);
            parser.setErrorHandler(null);
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", dummyLexicalHandler);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sourceParserPool.add(parser);
    }

    private XMLReader loadParser() {
        return platform.loadParser();
    }

    public synchronized XMLReader getStyleParser() throws TransformerFactoryConfigurationError {
        if (this.styleParserPool == null) {
            this.styleParserPool = new ArrayList<XMLReader>(10);
        }
        if (!this.styleParserPool.isEmpty()) {
            int n = this.styleParserPool.size() - 1;
            XMLReader parser = this.styleParserPool.get(n);
            this.styleParserPool.remove(n);
            return parser;
        }
        XMLReader parser = this.getStyleParserClass() != null ? this.makeParser(this.getStyleParserClass()) : this.loadParser();
        try {
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXNotRecognizedException e) {
            throw new TransformerFactoryConfigurationError(e);
        }
        catch (SAXNotSupportedException e) {
            throw new TransformerFactoryConfigurationError(e);
        }
        return parser;
    }

    public synchronized void reuseStyleParser(XMLReader parser) {
        if (this.styleParserPool == null) {
            this.styleParserPool = new ArrayList<XMLReader>(10);
        }
        try {
            parser.setContentHandler(null);
            parser.setEntityResolver(null);
            parser.setDTDHandler(null);
            parser.setErrorHandler(null);
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", dummyLexicalHandler);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.styleParserPool.add(parser);
    }

    public void loadSchema(String absoluteURI) throws SchemaException {
        this.readSchema(this.makePipelineConfiguration(), "", absoluteURI, null);
    }

    public String readSchema(PipelineConfiguration pipe, String baseURI, String schemaLocation, String expected) throws SchemaException {
        this.needEnterpriseEdition();
        return null;
    }

    public void readMultipleSchemas(PipelineConfiguration pipe, String baseURI, Collection schemaLocations, String expected) throws SchemaException {
        this.needEnterpriseEdition();
    }

    public String readInlineSchema(NodeInfo root, String expected, ErrorListener errorListener) throws SchemaException {
        this.needEnterpriseEdition();
        return null;
    }

    private void needEnterpriseEdition() {
        throw new UnsupportedOperationException("You need the Enterprise Edition of Saxon for this operation");
    }

    public void addSchemaSource(Source schemaSource) throws SchemaException {
        this.addSchemaSource(schemaSource, this.getErrorListener());
    }

    public void addSchemaSource(Source schemaSource, ErrorListener errorListener) throws SchemaException {
        this.needEnterpriseEdition();
    }

    public boolean isSchemaAvailable(String targetNamespace) {
        return false;
    }

    public Set getImportedNamespaces() {
        return Collections.EMPTY_SET;
    }

    public void sealNamespace(String namespace) {
    }

    public Iterator getExtensionsOfType(SchemaType type) {
        return Collections.EMPTY_SET.iterator();
    }

    public void importComponents(Source source) throws XPathException {
        this.needEnterpriseEdition();
    }

    public void exportComponents(Receiver out) throws XPathException {
        this.needEnterpriseEdition();
    }

    public SchemaDeclaration getElementDeclaration(int fingerprint) {
        return null;
    }

    public SchemaDeclaration getAttributeDeclaration(int fingerprint) {
        return null;
    }

    public SchemaType getSchemaType(int fingerprint) {
        if (fingerprint < 1023) {
            return BuiltInType.getSchemaType(fingerprint);
        }
        return this.getExternalObjectType(fingerprint);
    }

    protected ExternalObjectType getExternalObjectType(int fingerprint) {
        if (this.getNamePool().getURI(fingerprint).equals("http://saxon.sf.net/java-type")) {
            Class namedClass;
            block4: {
                try {
                    namedClass = this.dynamicLoader.getClass(this.getNamePool().getLocalName(fingerprint), false, null);
                    if (namedClass != null) break block4;
                    return null;
                }
                catch (XPathException err) {
                    return null;
                }
            }
            return new ExternalObjectType(namedClass, this);
        }
        return null;
    }

    public void checkTypeDerivationIsOK(SchemaType derived, SchemaType base, int block) throws SchemaException, ValidationException {
    }

    public Receiver getDocumentValidator(Receiver receiver, String systemId, int validationMode, int stripSpace, SchemaType schemaType, int topLevelElementName) {
        return receiver;
    }

    public SequenceReceiver getElementValidator(SequenceReceiver receiver, int nameCode, int locationId, SchemaType schemaType, int validation) throws XPathException {
        return receiver;
    }

    public int validateAttribute(int nameCode, CharSequence value, int validation) throws ValidationException {
        return 631;
    }

    public Receiver getAnnotationStripper(Receiver destination) {
        return destination;
    }

    public XMLReader makeParser(String className) throws TransformerFactoryConfigurationError {
        Object obj;
        try {
            obj = this.dynamicLoader.getInstance(className, null);
        }
        catch (XPathException err) {
            throw new TransformerFactoryConfigurationError(err);
        }
        if (obj instanceof XMLReader) {
            return (XMLReader)obj;
        }
        throw new TransformerFactoryConfigurationError("Class " + className + " is not a SAX2 XMLReader");
    }

    public static Locale getLocale(String lang) {
        String country;
        String language;
        int hyphen = lang.indexOf("-");
        if (hyphen < 1) {
            language = lang;
            country = "";
        } else {
            language = lang.substring(1, hyphen);
            country = lang.substring(hyphen + 1);
        }
        return new Locale(language, country);
    }

    public void setDebugger(Debugger debugger) {
        this.debugger = debugger;
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public SlotManager makeSlotManager() {
        if (this.debugger == null) {
            return new SlotManager();
        }
        return this.debugger.makeSlotManager();
    }

    public Receiver makeStreamingTransformer(XPathContext context, Mode mode) {
        return null;
    }

    public Optimizer getOptimizer() {
        if (this.optimizer == null) {
            this.optimizer = new Optimizer(this);
            this.optimizer.setOptimizationLevel(this.optimizationLevel);
        }
        return this.optimizer;
    }

    public StyleNodeFactory getStyleNodeFactory() {
        if (this.styleNodeFactory == null) {
            this.styleNodeFactory = new StyleNodeFactory(this);
        }
        return this.styleNodeFactory;
    }

    public StringCollator makeCollator(String className) throws XPathException {
        Object handler = this.dynamicLoader.getInstance(className, null);
        if (handler instanceof StringCollator) {
            return (StringCollator)handler;
        }
        throw new XPathException("Failed to load collation class " + className + ": it is not an instance of net2.sf.saxon.sort.StringCollator");
    }

    public void setLazyConstructionMode(boolean lazy) {
        this.lazyConstructionMode = lazy;
    }

    public boolean isLazyConstructionMode() {
        return this.lazyConstructionMode;
    }

    public void registerExternalObjectModel(ExternalObjectModel model) {
        if (this.externalObjectModels == null) {
            this.externalObjectModels = new ArrayList<ExternalObjectModel>(4);
        }
        if (!this.externalObjectModels.contains(model)) {
            this.externalObjectModels.add(model);
        }
    }

    public ExternalObjectModel getExternalObjectModel(String uri) {
        int m = 0;
        while (m < this.externalObjectModels.size()) {
            ExternalObjectModel model = this.externalObjectModels.get(m);
            if (model.getIdentifyingURI().equals(uri)) {
                return model;
            }
            ++m;
        }
        return null;
    }

    public ExternalObjectModel getExternalObjectModel(Class nodeClass) {
        int m = 0;
        while (m < this.externalObjectModels.size()) {
            ExternalObjectModel model = this.externalObjectModels.get(m);
            PJConverter converter = model.getPJConverter(nodeClass);
            if (converter != null) {
                return model;
            }
            ++m;
        }
        return null;
    }

    public List<ExternalObjectModel> getExternalObjectModels() {
        return this.externalObjectModels;
    }

    public NodeInfo unravel(Source source) {
        List<ExternalObjectModel> externalObjectModels = this.getExternalObjectModels();
        int m = 0;
        while (m < externalObjectModels.size()) {
            ExternalObjectModel model = externalObjectModels.get(m);
            NodeInfo node = model.unravel(source, this);
            if (node != null) {
                if (node.getConfiguration() != this) {
                    throw new IllegalArgumentException("Externally supplied Node belongs to the wrong Configuration");
                }
                return node;
            }
            ++m;
        }
        if (source instanceof NodeInfo) {
            if (((NodeInfo)source).getConfiguration() != this) {
                throw new IllegalArgumentException("Externally supplied NodeInfo belongs to the wrong Configuration");
            }
            return (NodeInfo)source;
        }
        if (source instanceof DOMSource) {
            throw new IllegalArgumentException("When a DOMSource is used, saxon9-dom.jar must be on the classpath");
        }
        throw new IllegalArgumentException("A source of class " + source.getClass() + " is not recognized by any registered object model");
    }

    public void setDOMLevel(int level) {
        if (level != 2 && level != 3) {
            throw new IllegalArgumentException("DOM Level must be 2 or 3");
        }
        this.domLevel = level;
    }

    public int getDOMLevel() {
        return this.domLevel;
    }

    public StaticQueryContext newStaticQueryContext() {
        return new StaticQueryContext(this, false);
    }

    public PendingUpdateList newPendingUpdateList() {
        throw new UnsupportedOperationException("XQuery update is supported only in Saxon-EE");
    }

    public PipelineConfiguration makePipelineConfiguration() {
        PipelineConfiguration pipe = new PipelineConfiguration();
        pipe.setConfiguration(this);
        pipe.setURIResolver(this.getURIResolver());
        pipe.setSchemaURIResolver(this.getSchemaURIResolver());
        pipe.setHostLanguage(this.getHostLanguage());
        pipe.setParseOptions(new ParseOptions(this.defaultParseOptions));
        return pipe;
    }

    public static Configuration getConfiguration(XPathContext context) {
        return context.getConfiguration();
    }

    public void setSourceResolver(SourceResolver resolver) {
        this.sourceResolver = resolver;
    }

    public SourceResolver getSourceResolver() {
        return this.sourceResolver;
    }

    @Override
    public Source resolveSource(Source source, Configuration config) throws XPathException {
        if (source instanceof AugmentedSource) {
            return source;
        }
        if (source instanceof StreamSource) {
            return source;
        }
        if (source instanceof SAXSource) {
            return source;
        }
        if (source instanceof DOMSource) {
            return source;
        }
        if (source instanceof NodeInfo) {
            return source;
        }
        if (source instanceof PullSource) {
            return source;
        }
        if (source instanceof PullEventSource) {
            return source;
        }
        return null;
    }

    public DocumentInfo buildDocument(Source source) throws XPathException {
        ParseOptions options;
        if (source == null) {
            throw new NullPointerException("source");
        }
        if ((source = this.resolveSource(source, this)) == null) {
            throw new XPathException("Unknown source class");
        }
        Source underlyingSource = source;
        if (source instanceof AugmentedSource) {
            options = ((AugmentedSource)source).getParseOptions();
            underlyingSource = ((AugmentedSource)source).getContainedSource();
        } else {
            options = new ParseOptions();
        }
        source = underlyingSource;
        return this.buildDocument(source, options);
    }

    public DocumentInfo buildDocument(Source source, ParseOptions parseOptions) throws XPathException {
        if (source == null) {
            throw new NullPointerException("source");
        }
        ParseOptions options = new ParseOptions(parseOptions);
        if ((source = this.resolveSource(source, this)) == null) {
            throw new XPathException("Unknown source class");
        }
        PipelineConfiguration pipe = this.makePipelineConfiguration();
        if (source instanceof AugmentedSource) {
            options.merge(((AugmentedSource)source).getParseOptions());
        }
        options.applyDefaults(this);
        TreeModel treeModel = options.getModel();
        boolean lineNumbering = options.isLineNumbering();
        Builder b1 = treeModel.makeBuilder();
        b1.setTiming(this.isTiming());
        b1.setLineNumbering(lineNumbering);
        b1.setPipelineConfiguration(pipe);
        Builder b = b1;
        new Sender(pipe).send(source, b, options);
        NodeInfo newdoc = b.getCurrentRoot();
        if (!(newdoc instanceof DocumentInfo)) {
            throw new XPathException("Source object represents a node other than a document node");
        }
        b.reset();
        if (parseOptions.isPleaseCloseAfterUse()) {
            ParseOptions.close(source);
        }
        return (DocumentInfo)newdoc;
    }

    public Receiver makeEmitter(String clarkName, Controller controller) throws XPathException {
        Object handler;
        int brace = clarkName.indexOf(125);
        String localName = clarkName.substring(brace + 1);
        int colon = localName.indexOf(58);
        String className = localName.substring(colon + 1);
        try {
            handler = this.dynamicLoader.getInstance(className, controller.getClassLoader());
        }
        catch (XPathException e) {
            throw new XPathException("Cannot create user-supplied output method. " + e.getMessage(), "SXCH0004");
        }
        if (handler instanceof Receiver) {
            return (Receiver)handler;
        }
        if (handler instanceof ContentHandler) {
            ContentHandlerProxy emitter = new ContentHandlerProxy();
            emitter.setUnderlyingContentHandler((ContentHandler)handler);
            emitter.setOutputProperties(controller.getOutputProperties());
            return emitter;
        }
        throw new XPathException("Output method " + className + " is neither a Receiver nor a SAX2 ContentHandler");
    }

    public NodeInfo makeUnconstructedElement(ElementCreator instr, XPathContext context) throws XPathException {
        throw new XPathException("Lazy element construction requires Saxon-PE");
    }

    public NodeInfo makeUnconstructedDocument(DocumentInstr instr, XPathContext context) throws XPathException {
        throw new XPathException("Lazy document construction requires Saxon-PE");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setConfigurationProperty(String name, Object value) {
        if (name.equals("http://saxon.sf.net/feature/allow-external-functions")) {
            boolean b = this.requireBoolean(name, value);
            this.setAllowExternalFunctions(b);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/collation-uri-resolver")) {
            if (!(value instanceof CollationURIResolver)) {
                throw new IllegalArgumentException("COLLATION_URI_RESOLVER value must be an instance of net2.sf.saxon.sort.CollationURIResolver");
            }
            this.setCollationURIResolver((CollationURIResolver)value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/collation-uri-resolver-class")) {
            this.setCollationURIResolver((CollationURIResolver)this.instantiateClassName(name, value, CollationURIResolver.class));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/collection-uri-resolver")) {
            if (!(value instanceof CollectionURIResolver)) {
                throw new IllegalArgumentException("COLLECTION_URI_RESOLVER value must be an instance of net2.sf.saxon.CollectionURIResolver");
            }
            this.setCollectionURIResolver((CollectionURIResolver)value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/collection-uri-resolver-class")) {
            this.setCollectionURIResolver((CollectionURIResolver)this.instantiateClassName(name, value, CollectionURIResolver.class));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/compile-with-tracing")) {
            boolean b = this.requireBoolean("COMPILE_WITH_TRACING", value);
            this.setCompileWithTracing(b);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/defaultCollation")) {
            this.getCollationMap().setDefaultCollationName(value.toString());
            return;
        } else if (name.equals("http://saxon.sf.net/feature/defaultCollection")) {
            this.setDefaultCollection(value.toString());
            return;
        } else if (name.equals("http://saxon.sf.net/feature/defaultCountry")) {
            this.setDefaultCountry(value.toString());
            return;
        } else if (name.equals("http://saxon.sf.net/feature/defaultLanguage")) {
            this.setDefaultLanguage(value.toString());
            return;
        } else if (name.equals("http://saxon.sf.net/feature/validation")) {
            boolean b = this.requireBoolean(name, value);
            this.setValidation(b);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/dtd-validation-recoverable")) {
            boolean b = this.requireBoolean(name, value);
            if (b) {
                this.defaultParseOptions.setDTDValidationMode(2);
                return;
            } else {
                this.defaultParseOptions.setDTDValidationMode(this.isValidation() ? 1 : 4);
            }
            return;
        } else if (name.equals("http://saxon.sf.net/feature/errorListenerClass")) {
            this.setErrorListener((ErrorListener)this.instantiateClassName(name, value, ErrorListener.class));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/expandAttributeDefaults")) {
            boolean b = this.requireBoolean(name, value);
            this.setExpandAttributeDefaults(b);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/lazyConstructionMode")) {
            boolean b = this.requireBoolean(name, value);
            this.setLazyConstructionMode(b);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/linenumbering")) {
            boolean b = this.requireBoolean(name, value);
            this.setLineNumbering(b);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/messageEmitterClass")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("MESSAGE_EMITTER_CLASS class must be a String");
            }
            this.setMessageEmitterClass((String)value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/moduleURIResolver")) {
            if (!(value instanceof ModuleURIResolver)) {
                throw new IllegalArgumentException("MODULE_URI_RESOLVER value must be an instance of net2.sf.saxon.query.ModuleURIResolver");
            }
            this.setModuleURIResolver((ModuleURIResolver)value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/moduleURIResolverClass")) {
            this.setModuleURIResolver((ModuleURIResolver)this.instantiateClassName(name, value, ModuleURIResolver.class));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/namePool")) {
            if (!(value instanceof NamePool)) {
                throw new IllegalArgumentException("NAME_POOL value must be an instance of net2.sf.saxon.om.NamePool");
            }
            this.setNamePool((NamePool)value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/optimizationLevel")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("OPTIMIZATION_LEVEL value must be string");
            }
            try {
                this.optimizationLevel = Integer.parseInt((String)value);
                if (this.optimizationLevel < 0 || this.optimizationLevel > 10) {
                    throw new IllegalArgumentException("OPTIMIZATION_LEVEL must be in the range 0 to 10");
                }
                if (this.optimizer == null) return;
                this.optimizer.setOptimizationLevel(this.optimizationLevel);
                return;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("OPTIMIZATION_LEVEL value must be a number represented as a string");
            }
        } else if (name.equals("http://saxon.sf.net/feature/outputURIResolver")) {
            if (!(value instanceof OutputURIResolver)) {
                throw new IllegalArgumentException("OUTPUT_URI_RESOLVER value must be an instance of net2.sf.saxon.OutputURIResolver");
            }
            this.setOutputURIResolver((OutputURIResolver)value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/outputURIResolverClass")) {
            this.setOutputURIResolver((OutputURIResolver)this.instantiateClassName(name, value, OutputURIResolver.class));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/preEvaluateDocFunction")) {
            this.preEvaluateDocFunction = this.requireBoolean("PRE_EVALUATE_DOC_FUNCTION", value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/preferJaxpParser")) {
            this.preferJaxpParser = this.requireBoolean("PREFER_JAXP_PARSER", value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/recognize-uri-query-parameters")) {
            boolean b = this.requireBoolean(name, value);
            this.getSystemURIResolver().setRecognizeQueryParameters(b);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/recoveryPolicy")) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("RECOVERY_POLICY value must be an Integer");
            }
            this.setRecoveryPolicy((Integer)value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/recoveryPolicyName")) {
            int rval;
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("RECOVERY_POLICY_NAME value must be a String");
            }
            if (value.equals("recoverSilently")) {
                rval = 0;
            } else if (value.equals("recoverWithWarnings")) {
                rval = 1;
            } else {
                if (!value.equals("doNotRecover")) throw new IllegalArgumentException("Unrecognized value of RECOVERY_POLICY_NAME = '" + value + "': must be 'recoverSilently', 'recoverWithWarnings', or 'doNotRecover'");
                rval = 2;
            }
            this.setRecoveryPolicy(rval);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/serializerFactoryClass")) {
            this.setSerializerFactory((SerializerFactory)this.instantiateClassName(name, value, OutputURIResolver.class));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/schemaURIResolver")) {
            if (!(value instanceof SchemaURIResolver)) {
                throw new IllegalArgumentException("SCHEMA_URI_RESOLVER value must be an instance of net2.sf.saxon.type.SchemaURIResolver");
            }
            this.setSchemaURIResolver((SchemaURIResolver)value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/schemaURIResolverClass")) {
            this.setSchemaURIResolver((SchemaURIResolver)this.instantiateClassName(name, value, SchemaURIResolver.class));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/schema-validation")) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("SCHEMA_VALIDATION must be an integer");
            }
            this.setSchemaValidationMode((Integer)value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/schema-validation-mode")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("SCHEMA_VALIDATION_MODE must be a string");
            }
            this.setSchemaValidationMode(Validation.getCode((String)value));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/sourceParserClass")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("SOURCE_PARSER_CLASS class must be a String");
            }
            this.setSourceParserClass((String)value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/sourceResolverClass")) {
            this.setSourceResolver((SourceResolver)this.instantiateClassName(name, value, SourceResolver.class));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/strip-whitespace")) {
            int ival;
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("STRIP_WHITESPACE must be a string");
            }
            if (value.equals("all")) {
                ival = 2;
            } else if (value.equals("none")) {
                ival = 0;
            } else {
                if (!value.equals("ignorable")) throw new IllegalArgumentException("Unrecognized value STRIP_WHITESPACE = '" + value + "': must be 'all', 'none', or 'ignorable'");
                ival = 1;
            }
            this.setStripsWhiteSpace(ival);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/styleParserClass")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("STYLE_PARSER_CLASS class must be a String");
            }
            this.setStyleParserClass((String)value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/timing")) {
            this.setTiming(this.requireBoolean(name, value));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/trace-external-functions")) {
            this.setTraceExternalFunctions(this.requireBoolean(name, value));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/trace-optimizer-decisions")) {
            this.setOptimizerTracing(this.requireBoolean(name, value));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/traceListener")) {
            if (!(value instanceof TraceListener)) {
                throw new IllegalArgumentException("TRACE_LISTENER is of wrong class");
            }
            this.setTraceListener((TraceListener)value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/traceListenerClass")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("TRACE_LISTENER_CLASS must be a string");
            }
            this.setTraceListenerClass((String)value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/treeModel")) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("Tree model must be an Integer");
            }
            this.setTreeModel((Integer)value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/treeModelName")) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("TREE_MODEL_NAME must be a string");
            }
            if (value.equals("tinyTree")) {
                this.setTreeModel(1);
                return;
            } else if (value.equals("tinyTreeCondensed")) {
                this.setTreeModel(2);
                return;
            } else {
                if (!value.equals("linkedTree")) throw new IllegalArgumentException("Unrecognized value TREE_MODEL_NAME = '" + value + "': must be linkedTree|tinyTree|tinyTreeCondensed");
                this.setTreeModel(0);
            }
            return;
        } else if (name.equals("http://saxon.sf.net/feature/uriResolverClass")) {
            this.setURIResolver((URIResolver)this.instantiateClassName(name, value, URIResolver.class));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/use-pi-disable-output-escaping")) {
            this.useDisableOutputEscaping = this.requireBoolean(name, value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/use-typed-value-cache")) {
            this.useTypedValueCache = this.requireBoolean(name, value);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/useXsiSchemaLocation")) {
            this.defaultParseOptions.setUseXsiSchemaLocation(this.requireBoolean(name, value));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/validation-warnings")) {
            this.setValidationWarnings(this.requireBoolean(name, value));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/version-warning")) {
            this.setVersionWarning(this.requireBoolean(name, value));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/xinclude-aware")) {
            this.setXIncludeAware(this.requireBoolean(name, value));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/xqueryAllowUpdate")) {
            this.getDefaultStaticQueryContext().setUpdatingEnabled(this.requireBoolean(name, value));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/xqueryConstructionMode")) {
            this.getDefaultStaticQueryContext().setConstructionMode(Validation.getCode(value.toString()));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/xqueryDefaultElementNamespace")) {
            this.getDefaultStaticQueryContext().setDefaultElementNamespace(value.toString());
            return;
        } else if (name.equals("http://saxon.sf.net/feature/xqueryDefaultFunctionNamespace")) {
            this.getDefaultStaticQueryContext().setDefaultFunctionNamespace(value.toString());
            return;
        } else if (name.equals("http://saxon.sf.net/feature/xqueryEmptyLeast")) {
            this.getDefaultStaticQueryContext().setEmptyLeast(this.requireBoolean(name, value));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/xqueryInheritNamespaces")) {
            this.getDefaultStaticQueryContext().setInheritNamespaces(this.requireBoolean(name, value));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/xqueryPreserveBoundarySpace")) {
            this.getDefaultStaticQueryContext().setPreserveBoundarySpace(this.requireBoolean(name, value));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/xqueryPreserveNamespaces")) {
            this.getDefaultStaticQueryContext().setPreserveNamespaces(this.requireBoolean(name, value));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/xqueryRequiredContextItemType")) {
            ExpressionParser parser = new ExpressionParser();
            try {
                SequenceType type = parser.parseSequenceType(value.toString(), new IndependentContext(this));
                this.getDefaultStaticQueryContext().setRequiredContextItemType(type.getPrimaryType());
                return;
            }
            catch (XPathException err) {
                throw new IllegalArgumentException(err);
            }
        } else if (name.equals("http://saxon.sf.net/feature/xquerySchemaAware")) {
            this.getDefaultStaticQueryContext().getExecutable().setSchemaAware(this.requireBoolean(name, value));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/xqueryStaticErrorListenerClass")) {
            this.getDefaultStaticQueryContext().setErrorListener((ErrorListener)this.instantiateClassName(name, value, ErrorListener.class));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/xqueryVersion")) {
            this.getDefaultStaticQueryContext().setLanguageVersion(value.toString());
            return;
        } else if (name.equals("http://saxon.sf.net/feature/xml-version") || name.equals("http://saxon.sf.bet/feature/xml-version")) {
            if (!(value instanceof String) || !value.equals("1.0") && !value.equals("1.1")) {
                throw new IllegalArgumentException("XML_VERSION value must be \"1.0\" or \"1.1\" as a String");
            }
            this.setXMLVersion(value.equals("1.0") ? 10 : 11);
            return;
        } else if (name.equals("http://saxon.sf.net/feature/xsd-version")) {
            if (!(value instanceof String) || !value.equals("1.0") && !value.equals("1.1")) {
                throw new IllegalArgumentException("XSD_VERSION value must be \"1.0\" or \"1.1\" as a String");
            }
            this.xsdVersion = value.equals("1.0") ? XSD10 : XSD11;
            return;
        } else if (name.equals("http://saxon.sf.net/feature/xsltSchemaAware")) {
            this.defaultXsltCompilerInfo.setSchemaAware(this.requireBoolean(name, value));
            return;
        } else if (name.equals("http://saxon.sf.net/feature/stylesheetErrorListener")) {
            this.getDefaultXsltCompilerInfo().setErrorListener((ErrorListener)this.instantiateClassName(name, value, ErrorListener.class));
            return;
        } else {
            if (!name.equals("http://saxon.sf.net/feature/stylesheetURIResolver")) throw new IllegalArgumentException("Unknown configuration option " + name);
            this.getDefaultXsltCompilerInfo().setURIResolver((URIResolver)this.instantiateClassName(name, value, URIResolver.class));
        }
    }

    private boolean requireBoolean(String propertyName, Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            if ("true".equals(value) || "on".equals(value)) {
                return true;
            }
            if ("false".equals(value) || "off".equals(value)) {
                return false;
            }
            throw new IllegalArgumentException(String.valueOf(propertyName) + " must be 'true' or 'false'");
        }
        throw new IllegalArgumentException(String.valueOf(propertyName) + " must be a boolean");
    }

    protected Object instantiateClassName(String propertyName, Object value, Class requiredClass) {
        if (!(value instanceof String)) {
            throw new IllegalArgumentException(String.valueOf(propertyName) + " must be a String");
        }
        try {
            Object obj = this.getInstance((String)value, null);
            if (!requiredClass.isAssignableFrom(obj.getClass())) {
                throw new IllegalArgumentException("Error in " + propertyName + ": Class " + value + " does not implement " + requiredClass.getName());
            }
            return obj;
        }
        catch (XPathException err) {
            throw new IllegalArgumentException("Cannot instantiate COLLECTION_URI_RESOLVER_CLASS. " + err.getMessage());
        }
    }

    public Object getConfigurationProperty(String name) {
        if (name.equals("http://saxon.sf.net/feature/allow-external-functions")) {
            return this.isAllowExternalFunctions();
        }
        if (name.equals("http://saxon.sf.net/feature/collation-uri-resolver")) {
            return this.getCollationURIResolver();
        }
        if (name.equals("http://saxon.sf.net/feature/collation-uri-resolver-class")) {
            return this.getCollationURIResolver().getClass().getName();
        }
        if (name.equals("http://saxon.sf.net/feature/collection-uri-resolver")) {
            return this.getCollectionURIResolver();
        }
        if (name.equals("http://saxon.sf.net/feature/collection-uri-resolver-class")) {
            return this.getCollectionURIResolver().getClass().getName();
        }
        if (name.equals("http://saxon.sf.net/feature/compile-with-tracing")) {
            return this.isCompileWithTracing();
        }
        if (name.equals("http://saxon.sf.net/feature/defaultCollation")) {
            return this.getCollationMap().getDefaultCollationName();
        }
        if (name.equals("http://saxon.sf.net/feature/defaultCollection")) {
            return this.getDefaultCollection();
        }
        if (name.equals("http://saxon.sf.net/feature/defaultCountry")) {
            return this.getDefaultCountry();
        }
        if (name.equals("http://saxon.sf.net/feature/defaultLanguage")) {
            return this.getDefaultLanguage();
        }
        if (name.equals("http://saxon.sf.net/feature/validation")) {
            return this.isValidation();
        }
        if (name.equals("http://saxon.sf.net/feature/dtd-validation-recoverable")) {
            return this.defaultParseOptions.getDTDValidationMode() == 2;
        }
        if (name.equals("http://saxon.sf.net/feature/errorListenerClass")) {
            return this.getErrorListener().getClass().getName();
        }
        if (name.equals("http://saxon.sf.net/feature/expandAttributeDefaults")) {
            return this.isExpandAttributeDefaults();
        }
        if (name.equals("http://saxon.sf.net/feature/linenumbering")) {
            return this.isLineNumbering();
        }
        if (name.equals("http://saxon.sf.net/feature/messageEmitterClass")) {
            return this.getMessageEmitterClass();
        }
        if (name.equals("http://saxon.sf.net/feature/moduleURIResolver")) {
            return this.getModuleURIResolver();
        }
        if (name.equals("http://saxon.sf.net/feature/moduleURIResolverClass")) {
            return this.getModuleURIResolver().getClass().getName();
        }
        if (name.equals("http://saxon.sf.net/feature/namePool")) {
            return this.getNamePool();
        }
        if (name.equals("http://saxon.sf.net/feature/optimizationLevel")) {
            return "" + this.optimizationLevel;
        }
        if (name.equals("http://saxon.sf.net/feature/outputURIResolver")) {
            return this.getOutputURIResolver();
        }
        if (name.equals("http://saxon.sf.net/feature/outputURIResolverClass")) {
            return this.getOutputURIResolver().getClass().getName();
        }
        if (name.equals("http://saxon.sf.net/feature/preEvaluateDocFunction")) {
            return this.preEvaluateDocFunction;
        }
        if (name.equals("http://saxon.sf.net/feature/preferJaxpParser")) {
            return this.preferJaxpParser;
        }
        if (name.equals("http://saxon.sf.net/feature/recognize-uri-query-parameters")) {
            return this.getSystemURIResolver().queryParametersAreRecognized();
        }
        if (name.equals("http://saxon.sf.net/feature/recoveryPolicy")) {
            return new Integer(this.getRecoveryPolicy());
        }
        if (name.equals("http://saxon.sf.net/feature/recoveryPolicyName")) {
            switch (this.getRecoveryPolicy()) {
                case 0: {
                    return "recoverSilently";
                }
                case 1: {
                    return "recoverWithWarnings";
                }
                case 2: {
                    return "doNotRecover";
                }
            }
            return null;
        }
        if (name.equals("http://saxon.sf.net/feature/schemaURIResolver")) {
            return this.getSchemaURIResolver();
        }
        if (name.equals("http://saxon.sf.net/feature/schemaURIResolverClass")) {
            return this.getSchemaURIResolver().getClass().getName();
        }
        if (name.equals("http://saxon.sf.net/feature/schema-validation")) {
            return new Integer(this.getSchemaValidationMode());
        }
        if (name.equals("http://saxon.sf.net/feature/schema-validation-mode")) {
            return Validation.toString(this.getSchemaValidationMode());
        }
        if (name.equals("http://saxon.sf.net/feature/serializerFactoryClass")) {
            return this.getSerializerFactory().getClass().getName();
        }
        if (name.equals("http://saxon.sf.net/feature/sourceParserClass")) {
            return this.getSourceParserClass();
        }
        if (name.equals("http://saxon.sf.net/feature/sourceResolverClass")) {
            return this.getSourceResolver().getClass().getName();
        }
        if (name.equals("http://saxon.sf.net/feature/strip-whitespace")) {
            int s = this.getStripsWhiteSpace();
            if (s == 2) {
                return "all";
            }
            if (s == 1) {
                return "ignorable";
            }
            return "none";
        }
        if (name.equals("http://saxon.sf.net/feature/styleParserClass")) {
            return this.getStyleParserClass();
        }
        if (name.equals("http://saxon.sf.net/feature/timing")) {
            return this.isTiming();
        }
        if (name.equals("http://saxon.sf.net/feature/traceListener")) {
            return this.traceListener;
        }
        if (name.equals("http://saxon.sf.net/feature/traceListenerClass")) {
            return this.traceListenerClass;
        }
        if (name.equals("http://saxon.sf.net/feature/trace-external-functions")) {
            return this.isTraceExternalFunctions();
        }
        if (name.equals("http://saxon.sf.net/feature/trace-optimizer-decisions")) {
            return this.isOptimizerTracing();
        }
        if (name.equals("http://saxon.sf.net/feature/treeModel")) {
            return new Integer(this.getTreeModel());
        }
        if (name.equals("http://saxon.sf.net/feature/treeModelName")) {
            switch (this.getTreeModel()) {
                default: {
                    return "tinyTree";
                }
                case 2: {
                    return "tinyTreeCondensed";
                }
                case 0: 
            }
            return "linkedTree";
        }
        if (name.equals("http://saxon.sf.net/feature/uriResolverClass")) {
            return this.getURIResolver().getClass().getName();
        }
        if (name.equals("http://saxon.sf.net/feature/use-pi-disable-output-escaping")) {
            return this.useDisableOutputEscaping;
        }
        if (name.equals("http://saxon.sf.net/feature/use-typed-value-cache")) {
            return this.useTypedValueCache;
        }
        if (name.equals("http://saxon.sf.net/feature/useXsiSchemaLocation")) {
            return this.defaultParseOptions.isUseXsiSchemaLocation();
        }
        if (name.equals("http://saxon.sf.net/feature/validation-warnings")) {
            return this.isValidationWarnings();
        }
        if (name.equals("http://saxon.sf.net/feature/version-warning")) {
            return this.isVersionWarning();
        }
        if (name.equals("http://saxon.sf.net/feature/xinclude-aware")) {
            return this.isXIncludeAware();
        }
        if (name.equals("http://saxon.sf.net/feature/xml-version")) {
            return this.getXMLVersion() == 10 ? "1.0" : "1.1";
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryAllowUpdate")) {
            return this.getDefaultStaticQueryContext().isUpdatingEnabled();
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryConstructionMode")) {
            return this.getDefaultStaticQueryContext().getConstructionMode();
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryDefaultElementNamespace")) {
            return this.getDefaultStaticQueryContext().getDefaultElementNamespace();
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryDefaultFunctionNamespace")) {
            return this.getDefaultStaticQueryContext().getDefaultFunctionNamespace();
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryEmptyLeast")) {
            return this.getDefaultStaticQueryContext().isEmptyLeast();
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryInheritNamespaces")) {
            return this.getDefaultStaticQueryContext().isInheritNamespaces();
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryPreserveBoundarySpace")) {
            return this.getDefaultStaticQueryContext().isPreserveBoundarySpace();
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryPreserveNamespaces")) {
            return this.getDefaultStaticQueryContext().isPreserveNamespaces();
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryRequiredContextItemType")) {
            return this.getDefaultStaticQueryContext().getRequiredContextItemType();
        }
        if (name.equals("http://saxon.sf.net/feature/xquerySchemaAware")) {
            return this.getDefaultStaticQueryContext().getExecutable().isSchemaAware();
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryStaticErrorListenerClass")) {
            return this.getDefaultStaticQueryContext().getErrorListener().getClass().getName();
        }
        if (name.equals("http://saxon.sf.net/feature/xqueryVersion")) {
            return this.getDefaultStaticQueryContext().getLanguageVersion();
        }
        if (name.equals("http://saxon.sf.net/feature/xsd-version")) {
            return this.xsdVersion == XSD10 ? "1.0" : "1.1";
        }
        if (name.equals("http://saxon.sf.net/feature/xsltSchemaAware")) {
            return this.defaultXsltCompilerInfo.isSchemaAware();
        }
        if (name.equals("http://saxon.sf.net/feature/stylesheetErrorListener")) {
            return this.getDefaultXsltCompilerInfo().getErrorListener().getClass().getName();
        }
        if (name.equals("http://saxon.sf.net/feature/stylesheetURIResolver")) {
            return this.getDefaultXsltCompilerInfo().getURIResolver().getClass().getName();
        }
        throw new IllegalArgumentException("Unknown attribute " + name);
    }

    public static class LicenseFeature {
        public static final int SCHEMA_VALIDATION = 1;
        public static final int SCHEMA_AWARE_XSLT = 2;
        public static final int SCHEMA_AWARE_XQUERY = 3;
        public static final int XOM_MODEL = 4;
        public static final int JDOM_MODEL = 5;
        public static final int DOM4J_MODEL = 6;
        public static final int SAXON_EXTENSION_FUNCTIONS = 7;
        public static final int SAXON_EXTENSION_INSTRUCTIONS = 8;
        public static final int COLLATIONS = 9;
    }
}

