<?xml version='1.0' encoding="UTF-8" ?>
<!DOCTYPE xsl:stylesheet SYSTEM "mmlents/windob.dtd">
<!--
 * NAT - An universal Translator
 * Copyright (C) 2005 Bruno Mascret
 * Contact: bmascret@free.fr
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
-->

<!-- version 1.5 -->


<xsl:stylesheet version="1.0" 
xmlns:xsl='http://www.w3.org/1999/XSL/Transform' 
xmlns:xhtml="http://www.w3.org/1999/xhtml" 
xmlns:m='http://www.w3.org/1998/Math/MathML'
xmlns:doc='espaceDoc'> 

<xsl:output method="xml" encoding="UTF-8" indent="yes" omit-xml-declaration="no"/>

<xsl:strip-space elements = "xhtml:head xhtml:meta xhtml:title xhtml:link xhtml:style xhtml:ul xhtml:li m:* m:math m:semantics m:mrow xhtml:table xhtml:tbody xhtml:tr" />

<xsl:variable name="l_ponct">¡¿”&quot;’,.:;!?»…)]}\}«“‘([{}&lsquo;&rsquo;&acute;&prime;&mldr;&vellip;&hellip;&dtdot;&ldots;&ctdot;&utdot;</xsl:variable>
<xsl:template match="/">
	<xsl:text disable-output-escaping="yes">
		&lt;!DOCTYPE doc:doc SYSTEM "./xsl/mmlents/windob.dtd"&gt;
	</xsl:text>
	<doc:doc xmlns:doc="espaceDoc">
	<xsl:apply-templates select="*|text()|processing-instruction()" />
	</doc:doc>
</xsl:template>
<!--
<xsl:template match="xhtml:table|xhtml:tr|xhtml:div|xhtml:html|xhtml:body">
	<xsl:apply-templates/>
</xsl:template>-->
<xsl:template match="*[@class='echap']">
	<xsl:text disable-output-escaping="yes">&lt;/lit&gt;</xsl:text>
	<xsl:value-of select='.'/>
	<xsl:text disable-output-escaping="yes">&lt;lit&gt;</xsl:text>
</xsl:template>

<xsl:template match="xhtml:head/xhtml:title">
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match="xhtml:head|xhtml:td|xhtml:tr">
</xsl:template>

<xsl:template match="xhtml:table|xhtml:div|xhtml:html|xhtml:body|xhtml:ul">
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match="xhtml:tbody">
	<tableau>
	<xsl:variable name="col">
		<xsl:value-of select="count(xhtml:tr[1]/child::xhtml:td)"/>
	</xsl:variable>
	<xsl:variable name="lignes">
		<xsl:value-of select="count(child::xhtml:tr)"/>
	</xsl:variable>
	<xsl:call-template name="retourneTableau">
		<xsl:with-param name="nbCol" select="$col"/>
		<xsl:with-param name="colonne" select="1"/>
	</xsl:call-template>
	</tableau>
</xsl:template>

<xsl:template name="retourneTableau">
	<xsl:param name="nbCol"/>
	<xsl:param name="colonne"/>
	
	<xsl:if test="not($colonne &gt; $nbCol)">
		<col>
		<xsl:for-each select="child::xhtml:tr">
			<xsl:for-each select="child::xhtml:td[position()=$colonne]">
				<ligne>
				<xsl:if test="(not(substring-before(substring-after(@style, 'border-right:'),';')='none' or substring-before(substring-after(@style, 'border-right:'),';')='') or not(substring-before(substring-after(following-sibling::xhtml:td[1]/@style, 'border-left:'),';')='none' or substring-before(substring-after(following-sibling::xhtml:td[1]/@style, 'border-left:'),';')='')) or not(substring-before(substring-after(@style, 'border:'),';')='none' or substring-before(substring-after(@style, 'border:'),';')='') or not(substring-before(substring-after(following-sibling::xhtml:td[1]/@style, 'border:'),';')='none' or substring-before(substring-after(following-sibling::xhtml:td[1]/@style, 'border:'),';')='')">
					<xsl:attribute name="b-vert">1</xsl:attribute>
				</xsl:if>
				<xsl:if test="not(substring-before(substring-after(@style, 'border-bottom:'),';')='none')">
					<xsl:attribute name="b-hor">1</xsl:attribute>
				</xsl:if>
				<xsl:apply-templates/>
				</ligne>
			</xsl:for-each>
		</xsl:for-each>
		</col>
		<xsl:call-template name="retourneTableau">
			<xsl:with-param name="nbCol" select="$nbCol"/>
			<xsl:with-param name="colonne" select="$colonne + 1"/>
		</xsl:call-template>
	</xsl:if>
</xsl:template>


<xsl:variable name="empty_string"/>

<xsl:template match="xhtml:pre|xhtml:li|xhtml:p|xhtml:h1|xhtml:h2|xhtml:h3|xhtml:h4|xhtml:h5|xhtml:h6|xhtml:h7|xhtml:h8|xhtml:h9|xhtml:title">
	<!-- je vire le test du champ vide car c'est important dans certain cas (cellules de tableaux vides) en fait... -->
	<!--<xsl:if test="(not(string(.)=' ') and not(string(.)=''))">-->
	<xsl:if test="not(string(.)='')">
	<!-- Attention au caractère d'espace précédent, il faut le mettre dans le bon jeu de caractère sinon le test ne marche pas!!!! -->
		<phrase>
			<!-- le contenu n'est pas vide; pour simplifier, on crée forcement un tag lit suivi d'un tag mot, s'ils sont vides, on les supprimera dans la feuille de style de transcription -->
			<xsl:if test="@xml:lang='es-ES'">
				<xsl:attribute name="lang">
					<xsl:value-of select="string('es')"/>
				</xsl:attribute>
			</xsl:if>
			<lit>
				<xsl:if test="local-name(.)='li'">
					<xsl:choose>
						<xsl:when test="local-name(parent::*[1])='ul'">
							<ponctuation type="puce">-</ponctuation>
						</xsl:when>
						<xsl:when test="local-name(parent::*[1])='ol'">
							<ponctuation>
								<xsl:attribute name="type">ordre</xsl:attribute>
								<xsl:attribute name="num">
									<xsl:value-of select="count(preceding-sibling::*[name()='li'])+1"/>
								</xsl:attribute>
								<xsl:text>-</xsl:text>
							</ponctuation>
						</xsl:when>
					</xsl:choose>
				</xsl:if>
				<xsl:for-each select="*|text()">
					<!--<xsl:sort select="position()"/>-->
					<!--<xsl:value-of select="."/>-->
					<xsl:choose>
						<xsl:when test="node()">
							<xsl:apply-templates select="." mode="phrase"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="remplaceEspace">
								<xsl:with-param name="chaine">
									<xsl:value-of disable-output-escaping="yes" select="." />
								</xsl:with-param>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			</lit>
		</phrase>
	</xsl:if>
</xsl:template>

<xsl:template match="xhtml:pre|xhtml:li|xhtml:p|xhtml:h1|xhtml:h2|xhtml:h3|xhtml:h4|xhtml:h5|xhtml:h6|xhtml:h7|xhtml:h8|xhtml:h9|xhtml:title" mode="phrase">
	<!-- je vire le test du champ vide car c'est important dans certain cas (cellules de tableaux vides) en fait... -->
	<!--<xsl:if test="(not(string(.)=' ') and not(string(.)=''))">-->
	<xsl:if test="not(string(.)='')">
		<xsl:if test="local-name(.)='li'">
			<xsl:choose>
				<xsl:when test="local-name(parent::*[1])='ul'">
					<ponctuation type="puce">-</ponctuation>
				</xsl:when>
				<xsl:when test="local-name(parent::*[1])='ol'">
					<ponctuation>
						<xsl:attribute name="type">ordre</xsl:attribute>
						<xsl:attribute name="num">
							<xsl:value-of select="count(preceding-sibling::*[name()='li'])+1"/>
						</xsl:attribute>
						<xsl:text>-</xsl:text>
					</ponctuation>
				</xsl:when>
			</xsl:choose>
		</xsl:if>
		<xsl:for-each select="*|text()">
			<!--<xsl:sort select="position()"/>-->
			<!--<xsl:value-of select="."/>-->
			<xsl:choose>
				<xsl:when test="node()">
					<xsl:apply-templates select="."/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="remplaceEspace">
						<xsl:with-param name="chaine">
							<xsl:value-of disable-output-escaping="yes" select="." />
						</xsl:with-param>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:if>
</xsl:template>

<xsl:template match="xhtml:tt|xhtml:span|xhtml:cite|xhtml:dfn|xhtml:samp|xhtml:code|xhtml:var" mode="phrase">
	<xsl:if test="not(string(.)=' ') and not(string(.)='')">
	<!-- Attention au caractère d'espace précédent, il faut le mettre dans le bon jeu de caractère sinon le test ne marche pas!!!! -->
		<xsl:for-each select="*|text()">
			<xsl:choose>
				<xsl:when test="node()">
					<xsl:apply-templates select="." mode="phrase"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="remplaceEspace">
						<xsl:with-param name="chaine" select="translate(.,'&nbsp;',' ')" />
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:if>
</xsl:template>

<xsl:template match="xhtml:a" mode="phrase">
	<!--<xsl:if test="text()">-->
	<xsl:call-template name="remplaceEspace">
		<xsl:with-param name="chaine">
				<xsl:value-of select="concat(.,'(',@href,')')" />
		</xsl:with-param>
	</xsl:call-template>
</xsl:template>

<xsl:template match="xhtml:img" mode="phrase">
	<xsl:if test="not(@alt=' ' or @alt='')">
		<xsl:call-template name="remplaceEspace">
			<xsl:with-param name="chaine"><!-- espace après le [ pour que le [ soit bien considéré comme une ponctuation-->
					<xsl:value-of select="concat(.,'[ ',@alt,']')" />
			</xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>

<xsl:template match="xhtml:sup" mode="phrase">
	<xsl:if test="not(string(.)=' ') and not(string(.)='')">
	<!-- Attention au caractère d'espace précédent, il faut le mettre dans le bon jeu de caractère sinon le test ne marche pas!!!! -->
		<xsl:for-each select="*|text()">
			<xsl:choose>
				<xsl:when test="node()">
					<xsl:apply-templates select="." mode="phrase"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="remplaceEspace">
						<xsl:with-param name="chaine" select="translate(.,'&nbsp;',' ')" />
						<xsl:with-param name="attrvalue" select="'exp'"/>
						<xsl:with-param name="attrname" select="'attr'"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:if>
</xsl:template>

<xsl:template match="xhtml:sub" mode="phrase">
	<xsl:if test="not(string(.)=' ') and not(string(.)='')">
		<xsl:for-each select="*|text()">
			<xsl:choose>
				<xsl:when test="node()">
					<xsl:apply-templates select="." mode="phrase"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="remplaceEspace">
						<xsl:with-param name="chaine" select="translate(.,'&nbsp;',' ')" />
						<xsl:with-param name="attrvalue" select="'ind'"/>
						<xsl:with-param name="attrname" select="'attr'"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:if>
</xsl:template>

<xsl:template match="xhtml:i" mode="phrase">
	<!-- on suppose qu'on est forcement dans une phrase -->
	<xsl:if test="not(string(.)=' ') and not(string(.)='')">
	<!-- Attention au caractère d'espace précédent, il faut le mettre dans le bon jeu de caractère sinon le test ne marche pas!!!! -->
		<xsl:for-each select="*|text()">
			<xsl:choose>
				<xsl:when test="node()">
					<xsl:apply-templates select="." mode="phrase"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="remplaceEspace">
						<xsl:with-param name="chaine" select="translate(.,'&nbsp;',' ')" />
						<xsl:with-param name="attrvalue" select="'italique'"/>
						<xsl:with-param name="attrname" select="'attr'"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:if>
</xsl:template>

<xsl:template match="xhtml:em" mode="phrase">
	<!-- on suppose qu'on est forcement dans une phrase -->
	<xsl:if test="not(string(.)=' ') and not(string(.)='')">
	<!-- Attention au caractère d'espace précédent, il faut le mettre dans le bon jeu de caractère sinon le test ne marche pas!!!! -->
		<xsl:for-each select="*|text()">
			<xsl:choose>
				<xsl:when test="node()">
					<xsl:apply-templates select="." mode="phrase"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="remplaceEspace">
						<xsl:with-param name="chaine" select="translate(.,'&nbsp;',' ')" />
						<xsl:with-param name="attrvalue" select="'emph'"/>
						<xsl:with-param name="attrname" select="'attr'"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:if>
</xsl:template>

<xsl:template match="xhtml:strong" mode="phrase">
	<!-- on suppose qu'on est forcement dans une phrase -->
	<xsl:if test="not(string(.)=' ') and not(string(.)='')">
	<!-- Attention au caractère d'espace précédent, il faut le mettre dans le bon jeu de caractère sinon le test ne marche pas!!!! -->
		<xsl:for-each select="*|text()">
			<xsl:choose>
				<xsl:when test="node()">
					<xsl:apply-templates select="." mode="phrase"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="remplaceEspace">
						<xsl:with-param name="chaine" select="translate(.,'&nbsp;',' ')" />
						<xsl:with-param name="attrvalue" select="'emph2'"/>
						<xsl:with-param name="attrname" select="'attr'"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:if>
</xsl:template>

<xsl:template match="xhtml:b" mode="phrase">
	<xsl:if test="not(string(.)=' ') and not(string(.)='')">
	<!-- Attention au caractère d'espace précédent, il faut le mettre dans le bon jeu de caractère sinon le test ne marche pas!!!! -->
		<xsl:for-each select="*|text()">
			<xsl:choose>
				<xsl:when test="node()">
					<xsl:apply-templates select="." mode="phrase"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="remplaceEspace">
						<xsl:with-param name="chaine" select="translate(.,'&nbsp;',' ')" />
						<xsl:with-param name ="attrvalue" select="'gras'"/>
						<xsl:with-param name ="attrname" select="'attr'"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:if>
</xsl:template>
<!-- musique recopé tel quel -->
<xsl:template match="score-partwise">
		<xsl:copy-of select="."/>
</xsl:template>

<!--math recopiés tels quel-->
<xsl:template match="m:math" mode="phrase">
	<xsl:text disable-output-escaping="yes">&lt;/lit&gt;</xsl:text>
<!--	<xsl:copy-of select="."/>-->
		<xsl:copy><!-- disable-output-escaping="yes">-->
			<xsl:apply-templates select="*|text()|processing-instruction()"/>
		</xsl:copy>
	<xsl:text disable-output-escaping="yes">&lt;lit&gt;</xsl:text>
</xsl:template>

<xsl:template match="m:*">
		<xsl:copy>
			<!-- Les entités arrivent TOUTES sous la forme &amp;NOM; (cf mathconverter)
			on demande donc d'interpréter les &amp; pour obtenir en fin: &NOM; sur chaque contenu textuel de noeud -->
			<!-- problème: les entités dans les attributs ne sont pas interprétés....-->
			<xsl:copy-of select="@*"/>
			<xsl:value-of disable-output-escaping="yes" select="text()" />
			<xsl:apply-templates select="*|processing-instruction()"/>
		</xsl:copy>
</xsl:template>

<xsl:template name="remplaceEspace">
	<xsl:param name="chaine" />
	<xsl:param name="attrname" />
	<xsl:param name="attrvalue" />
	<xsl:variable name="chaine2">
		<!-- on remplace insécables, tabulation, et saut de ligne par des espaces -->
		<xsl:value-of select="translate($chaine,'&nbsp;	','  ')"/>
	</xsl:variable>
	<xsl:choose>
		<!--<xsl:when test="$chaine2=' '">
			<mot/>
		</xsl:when>-->
		<!-- le mot commence par un espace -->
		<xsl:when test="starts-with($chaine2, ' ')">
			<xsl:call-template name="remplaceEspace">
				<xsl:with-param name="chaine" select="substring-after($chaine2,' ')"/>
				<xsl:with-param name ="attrvalue" select="$attrvalue"/>
				<xsl:with-param name ="attrname" select="$attrname"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="string-length($chaine2)>0">
			<xsl:if test="contains($chaine2, ' ')">
				<xsl:choose>
					<!-- ponctuation seule -->
					<xsl:when test="string-length(substring-before($chaine2, ' '))=1 and (contains(concat($l_ponct, '-'),substring(substring-before($chaine2, ' '),1,1)))">
						<ponctuation>
							<xsl:value-of select="substring-before($chaine2, ' ')" />
						</ponctuation>
					</xsl:when>
					<xsl:when test='string-length(substring-before($chaine2, " "))=1 and substring(substring-before($chaine2, " "),1,1)="&apos;"'>
						<ponctuation>&apos;</ponctuation>
					</xsl:when>
					<xsl:when test="string-length(substring-before($chaine2, ' '))=3 and substring(substring-before($chaine2, ' '),1,3)='...'">
						<ponctuation>...</ponctuation>
					</xsl:when>
					<!-- ponctuation au début du mot sans espace -->
					<xsl:when test="contains($l_ponct,substring(substring-before($chaine2, ' '),1,1))">
						<ponctuation>
						<xsl:value-of select="substring(substring-before($chaine2, ' '), 1, 1)" />
						</ponctuation>
						<xsl:call-template name="remplaceEspace">
							<xsl:with-param name="chaine">
								<xsl:value-of select="substring(substring-before($chaine2, ' '),2,string-length(substring-before($chaine2, ' ')))" />
							</xsl:with-param>
							<xsl:with-param name ="attrvalue" select="$attrvalue"/>
							<xsl:with-param name ="attrname" select="$attrname"/>
						</xsl:call-template>
					</xsl:when>
					<!-- ponctuation à la fin du mot sans espace -->
					<xsl:when test="substring(substring-before($chaine2, ' '), string-length(substring-before($chaine2, ' '))-2, string-length(substring-before($chaine2, ' ')))='...'">
						<xsl:call-template name="remplaceEspace">
							<xsl:with-param name="chaine">
								<xsl:value-of select="substring(substring-before($chaine2, ' '),1,string-length(substring-before($chaine2, ' '))-3)" />
							</xsl:with-param>
							<xsl:with-param name ="attrvalue" select="$attrvalue"/>
							<xsl:with-param name ="attrname" select="$attrname"/>
						</xsl:call-template>
						<ponctuation>
						<xsl:text>...</xsl:text>
						</ponctuation>
					</xsl:when>
					<xsl:when test="contains($l_ponct,substring(substring-before($chaine2, ' '), string-length(substring-before($chaine2, ' ')), string-length(substring-before($chaine2, ' '))))">
						<xsl:call-template name="remplaceEspace">
							<xsl:with-param name="chaine">
								<xsl:value-of select="substring(substring-before($chaine2, ' '),1,string-length(substring-before($chaine2, ' '))-1)" />
							</xsl:with-param>
							<xsl:with-param name ="attrvalue" select="$attrvalue"/>
							<xsl:with-param name ="attrname" select="$attrname"/>
						</xsl:call-template>
						<ponctuation>
						<xsl:value-of select="substring(substring-before($chaine2, ' '), string-length(substring-before($chaine2, ' ')), string-length(substring-before($chaine2, ' ')))" />
						</ponctuation>
					</xsl:when>
					<xsl:otherwise>
						<mot>
							<!--<xsl:value-of select="concat('aa',$attrname,'aa',$attrvalue,'aa')"/>-->
							<xsl:if test="not(string($attrname)='')">
								<xsl:attribute name="{string($attrname)}">
									<xsl:value-of select="string($attrvalue)"/>
								</xsl:attribute>
							</xsl:if>
							<xsl:value-of select="substring-before($chaine2, ' ')"/><!--disable-output-escaping="yes"-->
						<!--<xsl:value-of select="$chaine2" />-->
						</mot>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:if test="string-length(substring-after($chaine2, ' '))>0">
					<xsl:call-template name="remplaceEspace">
						<xsl:with-param name="chaine" select="substring-after($chaine2, ' ')" />
						<xsl:with-param name ="attrvalue" select="$attrvalue"/>
						<xsl:with-param name ="attrname" select="$attrname"/>
					</xsl:call-template>
				</xsl:if>
			</xsl:if>
			<xsl:if test="not(contains($chaine2, ' '))">
				<xsl:choose>
					<!-- ponctuation seule -->
					<xsl:when test="string-length($chaine2)=1 and (contains(concat($l_ponct, '-'),string($chaine2)))">
						<ponctuation>
						<xsl:value-of select="string($chaine2)" />
						</ponctuation>
					</xsl:when>
					<xsl:when test='string($chaine2)="&apos;"'>
						<ponctuation>&apos;</ponctuation>
					</xsl:when>
					<xsl:when test="string($chaine2)='...'">
						<ponctuation>...</ponctuation>
					</xsl:when>
					<!-- ponctuation à la fin du mot sans espace -->
					<xsl:when test="substring($chaine2, string-length($chaine2)-2, string-length($chaine2))='...'">
						<xsl:call-template name="remplaceEspace">
							<xsl:with-param name="chaine">
								<xsl:value-of select="substring($chaine2,1,string-length($chaine2)-3)" />
							</xsl:with-param>
							<xsl:with-param name ="attrvalue" select="$attrvalue"/>
							<xsl:with-param name ="attrname" select="$attrname"/>
						</xsl:call-template>
						<ponctuation>...</ponctuation>
					</xsl:when>
					<xsl:when test="contains(concat($l_ponct, '-'),substring($chaine2,string-length($chaine2),string-length($chaine2)))">
						<xsl:call-template name="remplaceEspace">
							<xsl:with-param name="chaine">
								<xsl:value-of select="substring($chaine2,1,string-length($chaine2)-1)" />
							</xsl:with-param>
							<xsl:with-param name ="attrvalue" select="$attrvalue"/>
							<xsl:with-param name ="attrname" select="$attrname"/>
						</xsl:call-template>
						<ponctuation>
							<xsl:value-of select="substring($chaine2, string-length($chaine2), string-length($chaine2))" />
						</ponctuation>
					</xsl:when>
					<xsl:otherwise>
						<mot>
							<xsl:if test="not(string($attrname)='')">
								<!--<xsl:value-of select="concat('aa',$attrname,'aa',$attrvalue,'aa')"/>-->
								<xsl:attribute name="{string($attrname)}">
									<xsl:value-of select="string($attrvalue)"/>
								</xsl:attribute>
							</xsl:if>
							<!--<xsl:copy-of select="$chaine2"/><!-disable-output-escaping="yes"-->
							<xsl:value-of select="$chaine2" />
						</mot>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		</xsl:when>
		<!--<xsl:otherwise>
			<xsl:text disable-output-escaping="yes">&lt;/mot&gt;</xsl:text>
		</xsl:otherwise>-->
	</xsl:choose>
</xsl:template>

</xsl:stylesheet>