<?xml version='1.0' encoding="UTF-8" ?>
<!--
 * NAT - An universal Translator
 * Copyright (C) 2005 Bruno Mascret
 * Contact: bmascret@free.fr
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
-->

<!-- version: 1.3-b3 -->

<!DOCTYPE xsl:stylesheet
  SYSTEM "mmlents/windob.dtd"
[
  <!ENTITY % table_braille PUBLIC "table braille" "./tablesBraille/Brltab.ent">
  %table_braille;
  <!ENTITY quad    "&ThickSpace;"> <!-- espace -->
  <!ENTITY neq     "&ne;"> <!-- different de -->
  <!ENTITY epsilon "&epsiv;"> <!-- epsilon -->
  <!ENTITY empty "&emptyv;"> <!-- endemble vide -->
  <!ENTITY ldots   "&mldr;"> <!-- points de suspension -->
  <!ENTITY hat     "&Hat;"> <!-- signe d'angle -->
  <!ENTITY espace  "&#254;"><!-- espace à generer-->
  <!ENTITY coupe   "&#255;"><!-- endroit ou on peut couper un equation-->
]>


<xsl:stylesheet version="1.0"
xmlns:xsl='http://www.w3.org/1999/XSL/Transform' 
xmlns:saxon='http://icl.com/saxon'
xmlns:m='http://www.w3.org/1998/Math/MathML'
xmlns:lit='espacelit'
xmlns:doc='espaceDoc'>

<xsl:output method="text" encoding="UTF-8" indent="no"/>

<xsl:variable name="chaine_vide"/>
<xsl:variable name="points">
	<xsl:text>&pt1;&pt12;&pt14;&pt145;&pt15;&pt124;&pt1245;&pt125;&pt24;&pt245;&pt13;&pt123;&pt134;&pt1345;&pt135;&pt1234;&pt12345;&pt1235;&pt234;&pt2345;&pt136;&pt1236;&pt2456;&pt1346;&pt13456;&pt1356;&pt12356;&pt16;&pt123456;&pt2346;&pt126;&pt1246;&pt146;&pt12456;&pt1456;&pt23456;&pt156;&pt1256;&pt12346;&pt345;&pt246;&pt1;&pt12;&pt14;&pt145;&pt15;&pt124;&pt1245;&pt125;&pt24;&pt245;&pt13;&pt123;&pt134;&pt1345;&pt135;&pt1234;&pt12345;&pt1235;&pt234;&pt2345;&pt136;&pt1236;&pt2456;&pt1346;&pt13456;&pt1356;&pt3456;&pt16;&pt126;&pt146;&pt1456;&pt156;&pt1246;&pt12456;&pt1256;&pt246;&pt12356;&pt16;&pt123456;&pt2346;&pt126;&pt1246;&pt146;&pt12456;&pt1456;&pt23456;&pt156;&pt1256;&pt12346;&pt345;&pt246;&pt345;&pt235;&pt36;&pt35;&pt25;&pt2356;&pt256;&pt2;&pt;&pt34;</xsl:text>
</xsl:variable>

<xsl:include href="outilsTan.xsl"/>

<xsl:template match="lit">
	<!--<xsl:text>debLit</xsl:text>-->
	<xsl:apply-templates select="@*|*|text()|processing-instruction()" />
	<!--<xsl:text>FinLit</xsl:text>-->
</xsl:template>

<xsl:template match="phrase">
	<xsl:apply-templates />
	<xsl:text>&NewLine;</xsl:text><!--&#13;&#10;</xsl:text>-->
</xsl:template>

<xsl:template match="ponctuation">
	<xsl:text>P</xsl:text>
</xsl:template>

<xsl:template match="mot" mode="silence"/>

<xsl:template match="mot">
	<xsl:choose>
		<xsl:when test="starts-with(.,'&pt6;')">
			<xsl:call-template name="maths">
				<xsl:with-param name="noeud" select="."/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="starts-with(.,'&pt25;&pt46;')">
			<xsl:call-template name="passageM">
				<xsl:with-param name="noeud" select="."/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="starts-with(.,'&pt46;&pt46;')">
			<xsl:call-template name="motM">
				<xsl:with-param name="noeud" select="."/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="starts-with(.,'&pt46;')">
			<xsl:call-template name="maj">
				<xsl:with-param name="noeud" select="."/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="starts-with(.,'&pt25;&pt456;')">
			<xsl:call-template name="passageE">
				<xsl:with-param name="noeud" select="."/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="starts-with(.,'&pt46;&pt456;')">
			<xsl:call-template name="motE">
				<xsl:with-param name="noeud" select="."/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="starts-with(.,'&pt456;')">
			<xsl:call-template name="evd">
				<xsl:with-param name="noeud" select="."/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains(translate(.,'0123456789-+×÷=&sup2;&sup3;','11111111111111111'),'1')">
			<xsl:text>M</xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="text()"/>
			<xsl:call-template name="espace"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="maths">
	<xsl:text>maths</xsl:text>
</xsl:template>

<xsl:template name="passageM">
	<xsl:param name="noeud"/>
	<xsl:param name="pos" select="1"/>
	<xsl:choose>
		<xsl:when test="$pos = 1">
			<xsl:value-of select="translate(substring-after(.,'&pt46;'),string($points),'ABCDEFGHIJKLMNOPQRSTUVWXYZÀÂÉÈÊËÎÏÔÙÛÜ&Ccedil;&AElig;&OElig;ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789ÀÂÉÈÊËÎÏÔÙÛÜ&Ccedil;&AElig;&OElig;@+-×÷=.,&nbsp;/')" />
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="translate(following::*[$pos -1],string($points),'ABCDEFGHIJKLMNOPQRSTUVWXYZÀÂÉÈÊËÎÏÔÙÛÜ&Ccedil;&AElig;&OElig;ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789ÀÂÉÈÊËÎÏÔÙÛÜ&Ccedil;&AElig;&OElig;@+-×÷=.,&nbsp;/')" />
		</xsl:otherwise>
	</xsl:choose>
	<xsl:call-template name="espace"/>
	<xsl:apply-templates select="following::*[$pos]" mode="silence"/>
	<xsl:choose>
		<xsl:when test="not(position() + $pos &gt; last()) and not(starts-with(following::*[$pos],'&pt46;'))">
			<xsl:call-template name="passageM">
				<xsl:with-param name="noeud" select="following::*[$pos]"/>
				<xsl:with-param name="pos" select="$pos + 1"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name="motM">
				<xsl:with-param name="noeud" select="following::*[$pos]"/>
				<xsl:with-param name="pos" select="$pos"/>
			</xsl:call-template>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="motM">
	<xsl:param name="noeud"/>
	<xsl:param name="pos" select="0"/>
	<xsl:value-of select="translate(substring-after(following::*[$pos],'&pt46;'),string($points),'ABCDEFGHIJKLMNOPQRSTUVWXYZÀÂÉÈÊËÎÏÔÙÛÜ&Ccedil;&AElig;&OElig;ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789ÀÂÉÈÊËÎÏÔÙÛÜ&Ccedil;&AElig;&OElig;@+-×÷=.,&nbsp;/')" />
	<xsl:call-template name="espace"/>
	<xsl:apply-templates select="following::*[$pos + 1]"/>
</xsl:template>

<xsl:template name="maj">
	<!-- à améliorer dans le cas de lettres isolées dans un mot -->
	<xsl:param name="noeud"/>
	<!-- denier mot d'un passage?-->
	<xsl:variable name="dernier">
		<xsl:call-template name="dernierMotPassageM">
			<xsl:with-param name= "noeud" select="."/>
		</xsl:call-template>
	</xsl:variable>
	<xsl:choose>
		<xsl:when test="$dernier = 1">
			<xsl:call-template name="motM">
				<xsl:with-param name="noeud" select="."/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="concat(translate(substring(.,2,1),string($points),'ABCDEFGHIJKLMNOPQRSTUVWXYZÀÂÉÈÊËÎÏÔÙÛÜ&Ccedil;&AElig;&OElig;ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789ÀÂÉÈÊËÎÏÔÙÛÜ&Ccedil;&AElig;&OElig;@+-×÷=.,&nbsp;/'),translate(substring(.,3,string-length(.)),string($points),'abcdefghijklmnopqrstuvwxyzàâéèêëîïôùûüçæœabcdefghijklmnopqrstuvwxyz0123456789àâéèêëîïôùûüçæœ@+-×÷=.,&nbsp;/'))" />
			<xsl:call-template name="espace"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="passageE">
	<xsl:param name="noeud"/>
</xsl:template>

<xsl:template name="motE">
	<xsl:param name="noeud"/>
</xsl:template>

<xsl:template name="evd">
	<xsl:param name="noeud"/>
</xsl:template>

<xsl:template name="espace">
	<xsl:param name="position" select="1"/>
	<xsl:choose>
		<!--<xsl:when test="not(following::*[1]=text() or following::*[1]=node())">
		</xsl:when>-->
		<xsl:when test="following::*[$position] =''">
			<xsl:call-template name="espace">
				<xsl:with-param name="position" select="$position + 1"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="local-name(following::*[$position])='mot'">
			<xsl:if test="not(following::*[$position]/@attr='exp')">
				<xsl:text> </xsl:text>
			</xsl:if>
		</xsl:when>
		<!-- espaces avec les ponctuations -->
		<xsl:when test="local-name(following::*[$position])='ponctuation'">
			<xsl:if test="contains('([{«“‘&lsquo;',following::*[$position])" >
				<xsl:text> </xsl:text>
			</xsl:if>
		</xsl:when>
	</xsl:choose>
</xsl:template>

</xsl:stylesheet>