﻿<?xml version='1.0' encoding="UTF-8" ?>
<!--
 * NAT - An universal Translator
 * Copyright (C) 2007  Didier Erin
 * Contact: natbraille@free.fr
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
-->

<!-- Didier ERIN : Travail réalisé
 * transcription du mouvement et du tempo
 * transcription de la clé
 * transcription de la tonalité
 * transcription de la mesure
 * transcription d'une note et de sa durée avec ou sans altération
 * l'atération prend en compte la tonalité de la mesure mais ne gère pas encore le fait qu'une note
déjà altéré réaparait dans la mesure auquel cas le signe d'altération de doit pas apparaître
-->

<!-- Didier ERIN : TO DO List
 * corriger le beug concernant les altérations :
il y a lieu d'altérer une note que si cette altération n'est pas indiquée
par la tonalité, de même pour le bécare
 * transcription de l'octave (plus important que la transcription de la clé en braille musicale)
 * trancription de notes groupées
 * transcription des triolets, sextolets et groupes irréguliers
 * transcription de notes liées
 * trancription des interprétations
 * transcription du doigté
 * prise en compte de l'instrument
-->

<!-- version: 0.1 -->

<!DOCTYPE xsl:stylesheet SYSTEM "mmlents/windob.dtd">

<xsl:stylesheet version="1.0"
xmlns:xsl='http://www.w3.org/1999/XSL/Transform' 
xmlns:saxon='http://icl.com/saxon'
xmlns:m='http://www.w3.org/1998/Math/MathML'
xmlns:lit='espacelit'
xmlns:score-partwise='http://www.musicxml.org/'
xmlns:doc='espaceDoc'>

	<xsl:output method="text" encoding="UTF-8" indent="no"/>

	<xsl:include href="outilsMusique.xsl" />

	<xsl:strip-space elements = "*" />

	<xsl:template match="score-partwise">
		<!--
		<xsl:text disable-output-escaping="yes">
			&lt;!DOCTYPE doc:doc SYSTEM "./xsl/mmlents/windob.dtd"&gt;
			&lt;doc:doc xmlns:doc="espaceDoc"&gt;
		</xsl:text>-->
		<xsl:apply-templates/><!--
		<xsl:text disable-output-escaping="yes">
			&lt;/doc:doc&gt;
		</xsl:text>
		<xsl:text>&pt134;&pt136;&pt234;&pt24;&pt12345;&pt136;&pt15;&#xa;</xsl:text>-->
	</xsl:template>

	<xsl:template match="part">
		<!--<xsl:text>Partie&#xa;</xsl:text>-->
		<xsl:apply-templates/>
	</xsl:template>

	<!--nom de l'instrument-->
	<!--
	<xsl:template match="part-list/score-part/part-name">
		<xsl:text>Nom de l'instrument: </xsl:text>
		<xsl:value-of select="text()"/>
		<xsl:text>&#xa;</xsl:text>
	</xsl:template>
	-->

	<!--Didier ERIN : Traitement des attributs de la mesure-->
	<xsl:template match="measure">

		<!-- Didier ERIN : Mouvement et tempo -->
		<xsl:if test="current() = ../measure[1]">
			
			<xsl:if test="direction/direction-type/words/@font-weight = 'bold'">
				<xsl:text>&pt6;</xsl:text>
				<xsl:value-of select="direction/direction-type/words" />
				<xsl:text>&pt256;&pt;</xsl:text>
			</xsl:if>
			
			<xsl:if test="direction//metronome">
				<xsl:call-template name="transcrireNote">
					<xsl:with-param name="step" select="'C'" />
					<xsl:with-param name="duration" select="//metronome/beat-unit" />
				</xsl:call-template>
				
				<xsl:for-each select="//metronome/beat-unit-dot" >
					<xsl:text>&pt3;</xsl:text>
				</xsl:for-each>
				
				<xsl:text>&pt2356;&pt3456;</xsl:text>
				<xsl:value-of select="//metronome/per-minute" />
				<xsl:text>&pt;</xsl:text>
			</xsl:if>
		</xsl:if>
		
		<!-- Didier ERIN : Détermination de la clé -->
		<xsl:if test="attributes/clef">
			<xsl:call-template name="transcrireClef">
				<xsl:with-param name="sign" select="attributes/clef/sign" />
				<xsl:with-param name="line" select="attributes/clef/line" />
				<xsl:with-param name="tone" select="attributes/key/fifths" />
			</xsl:call-template>
		</xsl:if>

		<!-- Didier ERIN : Détermination de la mesure -->
		<xsl:if test="attributes/time">
			<xsl:call-template name="transcrireTempsMesure">
				<xsl:with-param name="beats" select="attributes/time/beats" />
				<xsl:with-param name="beat-type" select="attributes/time/beat-type" />
			</xsl:call-template>
			<xsl:text>&pt;</xsl:text>
		</xsl:if>

		<!-- Didier ERIN : Retour à la ligne  après les indications sur l'interprétation et le tempo données à la première mesure-->
		<xsl:if test="current() = ../measure[1]">
			<xsl:text>&NewLine;</xsl:text>
		</xsl:if>

		<!-- Didier ERIN : je récupère le nombre de divisions par noire qui permettra de calculer la durée de la note -->
		<xsl:variable name="division">
			<xsl:call-template name="retrouverDivision">
				<xsl:with-param name="measure" select="current()" />
			</xsl:call-template>
		</xsl:variable>
		
		<!-- Didier ERIN : je la récupère tonalité : peut servir pour corriger le beug des altérations -->
		<xsl:variable name="tone">
			<xsl:call-template name="retrouverTonalite">
				<xsl:with-param name="measure" select="current()" />
			</xsl:call-template>
		</xsl:variable>

		<!-- Didier ERIN : variable armure stockant l'armure à la clef, utile pour la détermination du symbole d'altération à appliquer -->
		<xsl:variable name="armure">
			<xsl:call-template name="trouverArmure">
				<xsl:with-param name="tone" select="$tone" />
			</xsl:call-template>
		</xsl:variable>
	
		<!-- Didier ERIN : transcription de la note -->
		<xsl:for-each select="*">
			
			<xsl:if test="name(current()) = 'note'">
				<!-- Didier ERIN : Je récupère dans la variable step le nom de la note ou la pause -->
				<xsl:variable name="step">
					<xsl:choose>
						<xsl:when test="pitch">
							<xsl:value-of select="pitch/step" />
						</xsl:when>
						<xsl:when test="rest">
							<xsl:text>rest</xsl:text>
						</xsl:when> 
					</xsl:choose>
				</xsl:variable>
				
				<!-- Didier ERIN : Récupération de l'octave de la note -->
				<xsl:variable name="octave">
					<xsl:if test="$step != 'rest'">
						<xsl:value-of select="pitch/step" />
					</xsl:if>
				</xsl:variable>
				
				<!-- Didier ERIN : Je récupère ou je calcule selon les cas qui se présentent la durée de la note ou de la pause
					que je stocke dans la variable duration --> 
				<xsl:variable name="duration">
					<xsl:choose>
						<xsl:when test="type">
							<xsl:value-of select="type" />
						</xsl:when>
						<xsl:when test="duration and not(dot) and not(type)">
							<xsl:value-of select="$division * 4 div duration" />
						</xsl:when>
						<xsl:when test="duration and dot and not(type)">
							<xsl:variable name="nbDot" select="count(dot)" />
							<xsl:if test="$nbDot = '1'">
								<xsl:value-of select="$division * 4 div (duration * 2 div 3)" />
							</xsl:if>
							<xsl:if test="$nbDot = '2'">
								<xsl:value-of select="$division * 4 div (duration* 4 div 7)" />
							</xsl:if>
						</xsl:when>
					</xsl:choose>
				</xsl:variable>
				
				<!-- Didier ERIN : Je récupère la valeur de la note précendente si il y en a une -->
				<xsl:variable name="notePrecedante">
					<xsl:if test="preceding::note[1]/pitch/step">
						<xsl:value-of select="preceding::note[1]/pitch/step" />
					</xsl:if>
				</xsl:variable>
				
				<!-- Didier ERIN : Je récupère la valeur de l'octave de la note précendente si il y en a une -->
				<xsl:variable name="octavePrecedant">
					<xsl:if test="$notePrecedante">
						<xsl:value-of select="preceding::note[1]/pitch/octave" />
					</xsl:if>
				</xsl:variable>
				
				<!-- Didier ERIN : Compte le nombre de note impliquée dans la phrasé,
					si celle en cours de traitement commence un phrasé -->
				<!--<xsl:variable name="nbNotes">
					<xsl:if test="current()//slur[@type='start']">
						<xsl:call-template name="nbNoteSuivPhrase" >
								<xsl:with-param name="note" select="current()"/>
							</xsl:call-template>
					</xsl:if>
				</xsl:variable>-->
	
				<!-- Didier ERIN : détermination du symbole d'altération à appliquer -->
				<xsl:call-template name="determinerSymboleAlteration" >
					<xsl:with-param name="step" select="$step" />
					<xsl:with-param name="alter" select="pitch/alter" />
					<xsl:with-param name="armure" select="$armure" />
				</xsl:call-template>
				
				<!-- Didier ERIN : indication de l'octave -->
				<xsl:if test="pitch/step and $notePrecedante">
					<xsl:call-template name="indiquerOctave" >
						<xsl:with-param name="noteCourante" select="pitch" />
						<xsl:with-param name="notePrecedante" select="$notePrecedante" />
						<xsl:with-param name="octavePrecedant" select="$octavePrecedant" />
					</xsl:call-template>
				</xsl:if>
				
				<!-- Didier ERIN : transcription de la note  ou du silence et de sa durée -->
				<xsl:call-template name="transcrireNote">
					<xsl:with-param name="step" select="$step" />
					<xsl:with-param name="duration" select="$duration" />
				</xsl:call-template>
	
				<!--- Didier ERIN : Transcription des points -->
				<xsl:for-each select="dot">
					<xsl:text>&pt3;</xsl:text>
				</xsl:for-each>
				
				<!--<xsl:variable name="dansPhrase">
					<xsl:call-template name="dansPhrase">
						<xsl:with-param name="note" select="current()" />
					</xsl:call-template>
				</xsl:variable>
				<xsl:text>*</xsl:text>
				<xsl:value-of select="$dansPhrase"/>
				<xsl:if test="$dansPhrase = 'true'">
					<xsl:text>$$</xsl:text>
				</xsl:if>		
				<xsl:text>*</xsl:text>-->
				
				<!-- Didier ERIN : Transcription de la liaison de prolongation -->
				<xsl:call-template name="transcrireLiaisonDeProlongation">
					<xsl:with-param name="tie" select="tie" />
				</xsl:call-template>
			</xsl:if>
		</xsl:for-each>
		
		<xsl:call-template name="transcrireBarreDeMesure">
			<xsl:with-param name="barline" select="./barline"/>
		</xsl:call-template>
		
		<xsl:text>&NewLine;</xsl:text>

	</xsl:template>

	<!-- tag échappés -->
	<!-- ATTENTION: A VERIFIER -->
	<xsl:template match="work|identification|stem|score-instrument|midi-instrument|movement-title|part-list">
	</xsl:template>

	<xsl:template match="score-part|part-name">
		<xsl:apply-templates/>
	</xsl:template>

</xsl:stylesheet>