<?xml version='1.0' encoding="UTF-8" ?>
<!--
 * NAT - An universal Translator
 * Copyright (C) 2005 Bruno Blanchard, Bruno Mascret
 * Contact: bmascret@free.fr
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
-->

<!-- version 1.1 -->

<!DOCTYPE xsl:stylesheet SYSTEM "mmlents/windob.dtd">

<xsl:stylesheet version="2.0"
xmlns:xsl='http://www.w3.org/1999/XSL/Transform' 
xmlns:saxon='http://icl.com/saxon'
xmlns:m='http://www.w3.org/1998/Math/MathML'
xmlns:lit='espacelit'
xmlns:doc='espaceDoc'>

<xsl:output method="text" encoding="UTF-8" indent="no"/>

<xsl:template match="lit">
	<!--<xsl:text>debLit</xsl:text>-->
	<xsl:apply-templates select="@*|*|text()|processing-instruction()" />
	<!--<xsl:text>FinLit</xsl:text>-->
</xsl:template>

<!--
<xsl:template match="espace">
	<xsl:choose>
		<xsl:when test="local-name(preceding::*[1])='mot' and local-name(following::*[1])='mot'">
			<xsl:param name="motPrec" select="translate(string(preceding::*[1]),'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz')"/>
			<xsl:param name="motSuiv" select="translate(string(following::*[1]),'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz')"/>
			<xsl:choose>
				<xsl:when test="string($motSuiv)='suite' and string($motPrec)='de'"/>
				<xsl:when test="string($motSuiv)='caetera' and string($motPrec)='et'"/>
				<xsl:when test="string($motSuiv)='plupart' and string($motPrec)='la'"/>
				<xsl:when test="string($motSuiv)='seulement' and string($motPrec)='non'"/>
				<xsl:when test="string($motSuiv)='que' and string($motPrec)='parce'"/>
				<xsl:when test="string($motSuiv)='consÃ©quent' and string($motPrec)='par'"/>
				<xsl:when test="string($motSuiv)='exemple' and string($motPrec)='par'"/>
				<xsl:when test="string($motSuiv)='suite' and string($motPrec)='par'"/>
				<xsl:when test="string($motSuiv)='tard' and string($motPrec)='plus'"/>
				<xsl:when test="string($motSuiv)='tÃ´t' and string($motPrec)='plus'"/>
				<xsl:when test="string($motSuiv)='chose' and string($motPrec)='quelque'"/>
				<xsl:when test="string($motSuiv)='part' and string($motPrec)='quelque'"/>
				<xsl:when test="string($motSuiv)='temps' and string($motPrec)='quelque'"/>
				<xsl:when test="string($motSuiv)='cesse' and string($motPrec)='sans'"/>
				<xsl:when test="string($motSuiv)='doute' and string($motPrec)='sans'"/>
				<xsl:when test="string($motSuiv)='que' and string($motPrec)='tandis'"/>
				<xsl:when test="string($motSuiv)='bien' and string($motPrec)='trÃ¨s'"/>
				<xsl:when test="(string($motSuiv)='cause' or string($motSuiv)='mesure' or string($motSuiv)='peine' or string($motSuiv)='prÃ©sent' or string($motSuiv)='travers') and (string($motPrec)='Ã ' or substring($motPrec,string-length($motPrec)-3,string-length($motPrec))=concat('qu',$apos,'Ã ') or substring($motPrec,string-length($motPrec)-2,string-length($motPrec))=concat('d',$apos,'Ã '))" />
				<xsl:when test="string($motSuiv)='contraire' and (string($motPrec)='au' or substring($motPrec,string-length($motPrec)-4,string-length($motPrec))=concat('qu',$apos,'au') or substring($motPrec,string-length($motPrec)-3,string-length($motPrec))=concat('d',$apos,'au'))" />
				<xsl:when test="string($motSuiv)='que' and (string($motPrec)='autant' or substring($motPrec,string-length($motPrec)-8,string-length($motPrec))=concat('qu',$apos,'autant') or substring($motPrec,string-length($motPrec)-7,string-length($motPrec))=concat('d',$apos,'autant'))" />
				<xsl:when test="(string($motSuiv)='chose' or string($motSuiv)='part') and (string($motPrec)='autre' or substring($motPrec,string-length($motPrec)-7,string-length($motPrec))=concat('qu',$apos,'autre') or substring($motPrec,string-length($motPrec)-6,string-length($motPrec))=concat('d',$apos,'autre'))" />
				<xsl:when test="(string($motSuiv)='mesure' or string($motSuiv)='rÃ©alitÃ©') and (string($motPrec)='en' or substring($motPrec,string-length($motPrec)-4,string-length($motPrec))=concat('qu',$apos,'en') or substring($motPrec,string-length($motPrec)-3,string-length($motPrec))=concat('d',$apos,'en'))" />
				
				<xsl:when test="(string($motSuiv)='peu' and (string($motPrec)='Ã ' or substring($motPrec,string-length($motPrec)-3,string-length($motPrec))=concat('qu',$apos,'Ã ') or substring($motPrec,string-length($motPrec)-2,string-length($motPrec))=concat('d',$apos,'Ã ')) and string(translate(following::*[3],'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))='prÃ¨s' and local-name(following::*[2])='espace')"/>
				<xsl:when test="(string($motSuiv)='prÃ¨s' and (string(preceding::*[3])='Ã ' or substring(preceding::*[3],string-length(preceding::*[3])-3,string-length(preceding::*[3]))=concat('qu',$apos,'Ã ') or substring(preceding::*[3],string-length(preceding::*[3])-2,string-length(preceding::*[3]))=concat('d',$apos,'Ã ')) and string($motPrec)='peu' and local-name(preceding::*[2])='espace')"/>
				<xsl:when test="(string($motSuiv)='Ã ' and string($motPrec)='peu' and string(translate(following::*[3],'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))='peu' and local-name(following::*[2])='espace')"/>
				<xsl:when test="(string($motSuiv)='peu' and string($motPrec)='Ã ' and string(translate(preceding::*[3],'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))='peu' and local-name(preceding::*[2])='espace')"/>
				<xsl:when test="(string($motSuiv)='ainsi' and string($motPrec)='pour' and string(translate(following::*[3],'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))='dire' and local-name(following::*[2])='espace')"/>
				<xsl:when test="(string($motSuiv)='dire' and string($motPrec)='ainsi' and string(translate(preceding::*[3],'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))='pour' and local-name(preceding::*[2])='espace')"/>
				<xsl:when test="(string($motSuiv)='Ã ' and string($motPrec)='tour' and string(translate(following::*[3],'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))='tour' and local-name(following::*[2])='espace')"/>
				<xsl:when test="(string($motSuiv)='tour' and string($motPrec)='Ã ' and string(translate(preceding::*[3],'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))='tour' and local-name(preceding::*[2])='espace')"/>
				<xsl:when test="(string($motSuiv)='Ã ' and string($motPrec)='tout' and string(translate(following::*[3],'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))='coup' and local-name(following::*[2])='espace')"/>
				<xsl:when test="(string($motSuiv)='coup' and string($motPrec)='Ã ' and string(translate(preceding::*[3],'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))='tout' and local-name(preceding::*[2])='espace')"/>
				<xsl:when test="(string($motSuiv)='Ã ' and string($motPrec)='tout' and string(translate(following::*[3],'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))='fait' and local-name(following::*[2])='espace')"/>
				<xsl:when test="(string($motSuiv)='fait' and string($motPrec)='Ã ' and string(translate(preceding::*[3],'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))='tout' and local-name(preceding::*[2])='espace')"/>
				<xsl:otherwise>
					<xsl:text> </xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text> </xsl:text>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>
-->
<xsl:template match="ponctuation">
	<xsl:value-of select="concat(string(.),' ')"/>
</xsl:template>

<xsl:template match="mot">
	<xsl:choose>
		<xsl:when test="string-length(.)=0">
			
		</xsl:when>
		<xsl:otherwise>
			<xsl:if test="contains('0123456789',substring(string(.),1,1))">
				<xsl:text>&pt6;</xsl:text>
				<!--<xsl:value-of select="translate(.,'0123456789,','&pt3456;&pt16;&pt126;&pt146;&pt1456;&pt156;&pt1246;&pt12456;&pt1256;&pt246;&pt3;')" />-->
			</xsl:if>
			<xsl:choose>
				<xsl:when test="contains('ABCDEFGHIJKLMNOPQRSTUVWXYZ',substring(string(.),1,1))">
					<xsl:text>&pt46;</xsl:text>
					<xsl:choose>
						<xsl:when test="string-length(.)>1 and contains('ABCDEFGHIJKLMNOPQRSTUVWXYZ',substring(string(.),2,1))">
							<xsl:text>&pt46;</xsl:text>
						</xsl:when>
					</xsl:choose>
					<xsl:variable name="motEnMin">
						<xsl:value-of select="translate(.,'ABCDEFGHIJKLMNOPQRSTUVWXYZ','&pt1;&pt12;&pt14;&pt145;&pt15;&pt124;&pt1245;&pt125;&pt24;&pt245;&pt13;&pt123;&pt134;&pt1345;&pt135;&pt1234;&pt12345;&pt1235;&pt234;&pt2345;&pt136;&pt1236;&pt2456;&pt1346;&pt13456;&pt1356;')" />
					</xsl:variable>
					<xsl:call-template name="apostrophe">
						<xsl:with-param name="motMin" select="string($motEnMin)"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="apostrophe">
						<xsl:with-param name="motMin" select="string(.)"/>
					</xsl:call-template>	
				</xsl:otherwise>
			</xsl:choose>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- template fonctions pour abrÃ©ger -->
<xsl:template name="apostrophe">
	<xsl:param name="motMin"/>
	<xsl:choose>
		<xsl:when test="contains(string($motMin),string($apos))"><!-- RAF: variable -->
			<xsl:param name="ajdh">aujourd'hui</xsl:param>
			<xsl:param name="cad">c'est-Ã -dire</xsl:param>
			<xsl:param name="dbrd">d'abord</xsl:param>
			<xsl:param name="quApos">qu'</xsl:param>
			<xsl:choose>
				<xsl:when test="contains(string($motMin),string($ajdh))">
					<xsl:if test="string($motMin)!=string($ajdh)">
						<xsl:call-template name="apostrophe">
							<xsl:with-param name="motMin" select="substring-before(string($motMin),string($ajdh))"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:text>&pt13;&pt3;&pt125;</xsl:text>
					<xsl:if test="local-name(following-sibling::*[1])='mot'">
						<xsl:text> </xsl:text>
					</xsl:if>
				</xsl:when>
				<xsl:when test="string($motMin)=string($cad)">
					<xsl:text>&pt14;&pt3;&pt15;&pt36;&pt12356;&pt36;&pt145;</xsl:text>
					<xsl:if test="local-name(following-sibling::*[1])='mot'">
						<xsl:text> </xsl:text>
					</xsl:if>
				</xsl:when>
				<xsl:when test="string($motMin)=string($dbrd)">
					<xsl:text>&pt145;&pt3;&pt1;</xsl:text>
					<xsl:if test="local-name(following-sibling::*[1])='mot'">
						<xsl:text> </xsl:text>
					</xsl:if>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="string-length($motMin)=string-length(substring-before(string($motMin),string($apos)))+1">
							<xsl:choose>
								<xsl:when test="contains(string($motMin),string($quApos))">
									<xsl:call-template name="locution">
										<xsl:with-param name="motMin" select="concat(substring-before(string($motMin),string($apos)),'e')"/>
									</xsl:call-template>
									<xsl:value-of select="$apos"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="locution">
										<xsl:with-param name="motMin" select="string($motMin)"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="apostrophe">
								<xsl:with-param name="motMin" select="concat(substring-before(string($motMin),string($apos)),string($apos))"/>
							</xsl:call-template>
							<xsl:call-template name="apostrophe">
								<xsl:with-param name="motMin" select="substring-after(string($motMin),string($apos))"/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name="locution">
				<xsl:with-param name="motMin" select="string($motMin)"/>
			</xsl:call-template>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="locution">
	<xsl:param name="motMin"/>
	<xsl:param name="motPrec" select="translate(preceding::*[1],'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz')"/>
	<xsl:choose>
		<xsl:when test="string($motMin)='au-dessous'">
			<xsl:text>&pt13;&pt36;&pt1256;</xsl:text>
			<xsl:if test="local-name(following-sibling::*[1])='mot'">
				<xsl:text> </xsl:text>
			</xsl:if>
		</xsl:when>
		<xsl:when test="string($motMin)='au-dessus'">
			<xsl:text>&pt13;&pt36;&pt145;</xsl:text>
			<xsl:if test="local-name(following-sibling::*[1])='mot'">
				<xsl:text> </xsl:text>
			</xsl:if>
		</xsl:when>
		<xsl:when test="string($motMin)='par-dessous'">
			<xsl:text>&pt1234;&pt36;&pt1256;</xsl:text>
			<xsl:if test="local-name(following-sibling::*[1])='mot'">
				<xsl:text> </xsl:text>
			</xsl:if>
		</xsl:when>
		<xsl:when test="string($motMin)='par-dessus'">
			<xsl:text>&pt1234;&pt36;&pt145;</xsl:text>
			<xsl:if test="local-name(following-sibling::*[1])='mot'">
				<xsl:text> </xsl:text>
			</xsl:if>
		</xsl:when>
		<xsl:when test="string($motMin)='peut-Ãªtre'">
			<xsl:text>&pt1234;&pt36;&pt126;</xsl:text>
			<xsl:if test="local-name(following-sibling::*[1])='mot'">
				<xsl:text> </xsl:text>
			</xsl:if>
		</xsl:when>
		<xsl:when test="string($motMin)='vis-Ã -vis'">
			<xsl:text>&pt1236;&pt36;&pt12356;&pt36;&pt1236;</xsl:text>
			<xsl:if test="local-name(following-sibling::*[1])='mot'">
				<xsl:text> </xsl:text>
			</xsl:if>
		</xsl:when>
		<!-- Pb de preformance, faire un seul mot pour les locutions????-->
		<xsl:when test="local-name(following::*[1])='mot'">
			<xsl:param name="motSuiv" select="translate(string(following::*[1]),'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz')"/>
			<xsl:choose>
				<xsl:when test="string($motMin)='de' and string($motSuiv)='suite'">
					<xsl:text>&pt145;&pt456;&pt234;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='et' and string($motSuiv)='caetera'">
					<xsl:text>&pt15;&pt456;&pt14;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='et cÃ¦tera'"><!-- ajout BB prÃ©voir le Ã¦-->
					<xsl:text>&pt15;&pt456;&pt14;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='la' and string($motSuiv)='plupart'">
					<xsl:text>&pt123;&pt456;&pt1246;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='non' and string($motSuiv)='seulement'">
					<xsl:text>&pt1345;&pt456;&pt234;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='parce' and string($motSuiv)='que'">
					<xsl:text>&pt1234;&pt456;&pt12345;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='par' and string($motSuiv)='consÃ©quent'">
					<xsl:text>&pt1234;&pt456;&pt14;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='par' and string($motSuiv)='exemple'">
					<xsl:text>&pt1234;&pt456;&pt15;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='par' and string($motSuiv)='suite'">
					<xsl:text>&pt1234;&pt456;&pt234;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='plus' and string($motSuiv)='tard'">
					<xsl:text>&pt1246;&pt456;&pt2345;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='plus' and string($motSuiv)='tÃ´t'">
					<xsl:text>&pt1246;&pt456;&pt1456;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='quelque' and string($motSuiv)='chose'">
					<xsl:text>&pt12345;&pt456;&pt12356;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='quelque' and string($motSuiv)='part'">
					<xsl:text>&pt12345;&pt456;&pt1234;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='quelque' and string($motSuiv)='temps'">
					<xsl:text>&pt12345;&pt456;&pt2345;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='sans' and string($motSuiv)='cesse'">
					<xsl:text>&pt234;&pt456;&pt14;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='sans' and string($motSuiv)='doute'">
					<xsl:text>&pt234;&pt456;&pt145;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='tandis' and string($motSuiv)='que'">
					<xsl:text>&pt2345;&pt456;&pt12345;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='trÃ¨s' and string($motSuiv)='bien'">
					<xsl:text>&pt356;&pt456;&pt12;</xsl:text>
				</xsl:when>
				<!-- apostrophe possible -->
				<xsl:when test="string($motMin)='Ã ' and string($motSuiv)='cause'">
					<xsl:text>&pt12356;&pt456;&pt14;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='Ã ' and string($motSuiv)='mesure'">
					<xsl:text>&pt12356;&pt456;&pt134;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='Ã ' and string($motSuiv)='peine'">
					<xsl:text>&pt12356;&pt456;&pt1234;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='Ã ' and string($motSuiv)='prÃ©sent'">
					<xsl:text>&pt12356;&pt456;&pt235;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='Ã ' and string($motSuiv)='travers'">
					<xsl:text>&pt12356;&pt456;&pt356;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='au' and string($motSuiv)='contraire'">
					<xsl:text>&pt13;&pt456;&pt14;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='autant' and string($motSuiv)='que'">
					<xsl:text>&pt13;&pt456;&pt12345;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='autre' and string($motSuiv)='chose'">
					<xsl:text>&pt13;&pt456;&pt12356;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='autre' and string($motSuiv)='part'">
					<xsl:text>&pt13;&pt456;&pt1234;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='en' and string($motSuiv)='mesure'">
					<xsl:text>&pt26;&pt456;&pt134;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='en' and string($motSuiv)='rÃ©alitÃ©'">
					<xsl:text>&pt26;&pt456;&pt1235;</xsl:text>
				</xsl:when>
				<!-- 3 composantes -->
				<xsl:when test="local-name(following::*[2])='mot'">
					<xsl:param name="motSuivSuiv" select="translate(string(following::*[2]),'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz')"/>
					<xsl:choose>
						<xsl:when test="string($motMin)='Ã ' and string($motSuiv)='peu' and string($motSuivSuiv)='prÃ¨s'">
							<xsl:text>&pt12356;&pt456;&pt1234;&pt456;&pt235;</xsl:text>
						</xsl:when>
						<xsl:when test="string($motMin)='peu' and string($motSuiv)='Ã ' and string($motSuivSuiv)='peu'">
							<xsl:text>&pt1234;&pt456;&pt12356;&pt456;&pt1234;</xsl:text>
						</xsl:when>
						<xsl:when test="string($motMin)='pour' and string($motSuiv)='ainsi' and string($motSuivSuiv)='dire'">
							<xsl:text>&pt1234;&pt456;&pt1;&pt456;&pt145;</xsl:text>
						</xsl:when>
						<xsl:when test="string($motMin)='tour' and string($motSuiv)='Ã ' and string($motSuivSuiv)='tour'">
							<xsl:text>&pt2345;&pt456;&pt12356;&pt456;&pt2345;</xsl:text>
						</xsl:when>
						<xsl:when test="string($motMin)='tout' and string($motSuiv)='Ã ' and string($motSuivSuiv)='coup'">
							<xsl:text>&pt16;&pt456;&pt12356;&pt456;&pt14;</xsl:text>
						</xsl:when>
						<xsl:when test="string($motMin)='tout' and string($motSuiv)='Ã ' and string($motSuivSuiv)='fait'">
							<xsl:text>&pt16;&pt456;&pt12356;&pt456;&pt124;</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:choose><!-- ce truc lÃ  est Ã  mettre au moment des majuscules, pas ici-->
								<xsl:when test="local-name(preceding::*[1])='mot'">
									<xsl:call-template name="finLocution">
										<xsl:with-param name="motMin" select="string($motMin)"/>
										<xsl:with-param name="motPrec" select="string($motPrec)"/>
									</xsl:call-template>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="unSeulSigne">
										<xsl:with-param name="motMin" select="$motMin"/>
									</xsl:call-template>
									<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose><!-- ce truc lÃ  est Ã  mettre au moment des majuscules, pas ici-->
						<xsl:when test="local-name(preceding-sibling::*[1])='mot'">
							<xsl:call-template name="finLocution">
								<xsl:with-param name="motMin" select="string($motMin)"/>
								<xsl:with-param name="motPrec" select="string($motPrec)"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="unSeulSigne">
								<xsl:with-param name="motMin" select="$motMin"/>
							</xsl:call-template>
							<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:when test="local-name(preceding-sibling::*[1])='mot'">
			<xsl:call-template name="finLocution">
				<xsl:with-param name="motMin" select="string($motMin)"/>
				<xsl:with-param name="motPrec" select="string($motPrec)"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name="unSeulSigne">
				<xsl:with-param name="motMin" select="$motMin"/>
			</xsl:call-template>
			<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="finLocution">
	<xsl:param name="motMin"/>
	<xsl:param name="motPrec"/>
	<xsl:choose>
		<!-- milieu de locution (si 3 composantes) -->
		<xsl:when test="string($motMin)='Ã ' and string($motPrec)='tout' and string(translate(following::*[1],'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))='fait' "/>
		<xsl:when test="string($motMin)='Ã ' and string($motPrec)='tout' and string(translate(following::*[1],'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))='coup' "/>
		<xsl:when test="string($motMin)='Ã ' and string($motPrec)='tour' and string(translate(following::*[1],'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))='tour' "/>
		<xsl:when test="string($motMin)='ainsi' and string($motPrec)='pour' and string(translate(following::*[1],'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))='dire'"/>
		<xsl:when test="string($motMin)='Ã ' and string($motPrec)='peu' and string(translate(following::*[1],'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))='peu'"/>
		<xsl:when test="string($motMin)='peu' and (string($motPrec)='Ã ' or substring($motPrec,string-length($motPrec)-3,string-length($motPrec))=concat('qu',$apos,'Ã ') or substring($motPrec,string-length($motPrec)-2,string-length($motPrec))=concat('d',$apos,'Ã ')) and string(translate(following::*[1],'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))='prÃ¨s'"/>
		<!-- fin de locution -->
		<xsl:when test="string($motMin)='suite' and string($motPrec)='de'">
			<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
		</xsl:when>
		<xsl:when test="string($motMin)='caetera' and string($motPrec)='et'">
			<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
		</xsl:when>
		<xsl:when test="string($motMin)='plupart' and string($motPrec)='la'">
			<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
		</xsl:when>
		<xsl:when test="string($motMin)='seulement' and string($motPrec)='non'">
			<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
		</xsl:when>
		<xsl:when test="string($motMin)='que' and string($motPrec)='parce'">
			<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
		</xsl:when>
		<xsl:when test="string($motMin)='consÃ©quent' and string($motPrec)='par'">
			<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
		</xsl:when>
		<xsl:when test="string($motMin)='exemple' and string($motPrec)='par'">
			<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
		</xsl:when>
		<xsl:when test="string($motMin)='suite' and string($motPrec)='par'">
			<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
		</xsl:when>
		<xsl:when test="string($motMin)='tard' and string($motPrec)='plus'">
			<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
		</xsl:when>
		<xsl:when test="string($motMin)='tÃ´t' and string($motPrec)='plus'">
			<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
		</xsl:when>
		<xsl:when test="string($motMin)='chose' and string($motPrec)='quelque'">
			<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
		</xsl:when>
		<xsl:when test="string($motMin)='part' and string($motPrec)='quelque'">
			<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
		</xsl:when>
		<xsl:when test="string($motMin)='temps' and string($motPrec)='quelque'">
			<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
		</xsl:when>
		<xsl:when test="string($motMin)='cesse' and string($motPrec)='sans'">
			<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
		</xsl:when>
		<xsl:when test="string($motMin)='doute' and string($motPrec)='sans'">
			<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
		</xsl:when>
		<xsl:when test="string($motMin)='que' and string($motPrec)='tandis'">
			<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
		</xsl:when>
		<xsl:when test="string($motMin)='bien' and string($motPrec)='trÃ¨s'">
			<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
		</xsl:when>
		<xsl:when test="(string($motMin)='cause' or string($motMin)='mesure' or string($motMin)='peine' or string($motMin)='prÃ©sent' or string($motMin)='travers') and (string($motPrec)='Ã ' or substring($motPrec,string-length($motPrec)-3,string-length($motPrec))=concat('qu',$apos,'Ã ') or substring($motPrec,string-length($motPrec)-2,string-length($motPrec))=concat('d',$apos,'Ã '))" >
			<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
		</xsl:when>
		<xsl:when test="string($motMin)='contraire' and (string($motPrec)='au' or substring($motPrec,string-length($motPrec)-4,string-length($motPrec))=concat('qu',$apos,'au') or substring($motPrec,string-length($motPrec)-3,string-length($motPrec))=concat('d',$apos,'au'))" >
			<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
		</xsl:when>
		<xsl:when test="string($motMin)='que' and (string($motPrec)='autant' or substring($motPrec,string-length($motPrec)-8,string-length($motPrec))=concat('qu',$apos,'autant') or substring($motPrec,string-length($motPrec)-7,string-length($motPrec))=concat('d',$apos,'autant'))" >
			<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
		</xsl:when>
		<xsl:when test="(string($motMin)='chose' or string($motMin)='part') and (string($motPrec)='autre' or substring($motPrec,string-length($motPrec)-7,string-length($motPrec))=concat('qu',$apos,'autre') or substring($motPrec,string-length($motPrec)-6,string-length($motPrec))=concat('d',$apos,'autre'))" >
			<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
		</xsl:when>
		<xsl:when test="(string($motMin)='mesure' or string($motMin)='rÃ©alitÃ©') and (string($motPrec)='en' or substring($motPrec,string-length($motPrec)-4,string-length($motPrec))=concat('qu',$apos,'en') or substring($motPrec,string-length($motPrec)-3,string-length($motPrec))=concat('d',$apos,'en'))" >
			<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
		</xsl:when>
		<xsl:when test="string($motMin)='prÃ¨s' and (string(preceding::*[2])='Ã ' or substring(preceding::*[2],string-length(preceding::*[2])-3,string-length(preceding::*[2]))=concat('qu',$apos,'Ã ') or substring(preceding::*[2],string-length(preceding::*[2])-2,string-length(preceding::*[2]))=concat('d',$apos,'Ã ')) and string($motPrec)='peu'">
			<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
		</xsl:when>
		<xsl:when test="string($motMin)='peu' and string($motPrec)='Ã ' and string(translate(preceding::*[2],'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))='peu'">
			<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
		</xsl:when>
		<xsl:when test="string($motMin)='dire' and string($motPrec)='ainsi' and string(translate(preceding::*[2],'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))='pour' ">
			<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
		</xsl:when>
		<xsl:when test="string($motMin)='tour' and string($motPrec)='Ã ' and string(translate(preceding::*[2],'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))='tour' ">
			<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
		</xsl:when>
		<xsl:when test="string($motMin)='coup' and string($motPrec)='Ã ' and string(translate(preceding::*[2],'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))='tout' ">
			<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
		</xsl:when>
		<xsl:when test="string($motMin)='fait' and string($motPrec)='Ã ' and string(translate(preceding::*[2],'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 'abcdefghijklmnopqrstuvwxyz'))='tout' ">
			<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name="unSeulSigne">
				<xsl:with-param name="motMin" select="$motMin"/>
			</xsl:call-template>
			<xsl:if test="local-name(following-sibling::*[1])='mot'"><xsl:text> </xsl:text></xsl:if>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="unSeulSigne">
	<xsl:param name="motMin"/>
	<xsl:choose><!--
		<xsl:when test="string($motMin)='ai'">
			<xsl:text>&pt34;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='elle'">
			<xsl:text>&pt1356;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='elles'">
			<xsl:text>&pt1356;&pt234;</xsl:text>
		</xsl:when>-->
		<xsl:when test="substring($motMin, string-length($motMin), string-length($motMin))='s'">
			<xsl:choose>
			<!-- les unSeulSignes avec un s mais pas pluriel-->
				<xsl:when test="string($motMin)='dans'">
					<xsl:text>&pt1456;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='dÃ¨s'">
					<xsl:text>&pt256;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='es'"><!-- plus bas??? cas gen ?-->
					<xsl:text>&pt156;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='les'">
					<xsl:text>&pt345;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='mais'">
					<xsl:text>&pt1346;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='nous'">
					<xsl:text>&pt135;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='plus'">
					<xsl:text>&pt1246;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='puis'">
					<xsl:text>&pt235;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='sans'">
					<xsl:text>&pt2346;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='sous'">
					<xsl:text>&pt356;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='tous'">
					<xsl:text>&pt2456;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='vous'">
					<xsl:text>&pt1236;</xsl:text>
				</xsl:when>
			<!-- les unSeulSignes avec un s si pluriel -->
				<xsl:when test="string($motMin)='ais'">
					<xsl:text>&pt34;&pt234;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='biens'">
					<xsl:text>&pt12;&pt234;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='ces'">
					<xsl:text>&pt14;&pt234;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='des'">
					<xsl:text>&pt145;&pt234;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='dus'">
					<xsl:text>&pt236;&pt234;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='elles'">
					<xsl:text>&pt1356;&pt234;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='Ã©tÃ©s'">
					<xsl:text>&pt2356;&pt234;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='grands'">
					<xsl:text>&pt12456;&pt234;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='ils'">
					<xsl:text>&pt24;&pt234;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='las'">
					<xsl:text>&pt3;&pt234;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='mÃªmes'">
					<xsl:text>&pt126;&pt234;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='mes'">
					<xsl:text>&pt134;&pt234;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='pars'"><!-- tu pars ???-->
					<xsl:text>&pt1234;&pt234;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='pours'"><!-- les pours et les contres....-->
					<xsl:text>&pt12346;&pt234;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='riens'">
					<xsl:text>&pt1235;&pt234;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='ses'">
					<xsl:text>&pt234;&pt234;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='sis'">
					<xsl:text>&pt35;&pt234;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='sons'">
					<xsl:text>&pt246;&pt234;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='tes'">
					<xsl:text>&pt2345;&pt234;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='uns'">
					<xsl:text>&pt136;&pt234;</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="symboleFond">
						<xsl:with-param name="motMin" select="$motMin"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise>
			<!-- les un seuls signes - 1ss avec s-->
			<xsl:choose>
				<xsl:when test="string($motMin)='ai'">
					<xsl:text>&pt34;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='au'">
					<xsl:text>&pt13;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='bien'">
					<xsl:text>&pt12;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='celui'">
					<xsl:text>&pt36;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='cet'">
					<xsl:text>&pt146;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='ce'">
					<xsl:text>&pt14;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='de'">
					<xsl:text>&pt145;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='du'">
					<xsl:text>&pt236;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='elle'">
					<xsl:text>&pt1356;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='est'">
					<xsl:text>&pt156;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='et'">
					<xsl:text>&pt23456;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='en'">
					<xsl:text>&pt26;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='Ã©tÃ©'">
					<xsl:text>&pt2356;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='faire'">
					<xsl:text>&pt124;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='grand'">
					<xsl:text>&pt12456;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='il'">
					<xsl:text>&pt24;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='je'">
					<xsl:text>&pt245;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='la'">
					<xsl:text>&pt3;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='le'">
					<xsl:text>&pt123;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='lui'">
					<xsl:text>&pt3456;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='mÃªme'">
					<xsl:text>&pt126;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='me'">
					<xsl:text>&pt134;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='ne'">
					<xsl:text>&pt1345;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='on'">
					<xsl:text>&pt346;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='ou'">
					<xsl:text>&pt1256;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='par'">
					<xsl:text>&pt1234;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='pour'">
					<xsl:text>&pt12346;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='que'">
					<xsl:text>&pt12345;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='qui'">
					<xsl:text>&pt1245;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='quoi'">
					<xsl:text>&pt123456;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='rien'">
					<xsl:text>&pt1235;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='se'">
					<xsl:text>&pt234;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='si'">
					<xsl:text>&pt35;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='son'">
					<xsl:text>&pt246;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='sur'">
					<xsl:text>&pt125;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='te'">
					<xsl:text>&pt2345;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='tout'">
					<xsl:text>&pt16;</xsl:text>
				</xsl:when>
				<xsl:when test="string($motMin)='un'">
					<xsl:text>&pt136;</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="symboleFond">
						<xsl:with-param name="motMin" select="$motMin"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="symboleFond">
	<xsl:param name="motMin"/>
	<xsl:choose>
		<xsl:when test="contains(string($motMin),'action')">
				<xsl:choose>
					<xsl:when test="string-length($motMin)=6">
						<xsl:text>&pt1;&pt3456;</xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>+action+</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
		</xsl:when>
		<xsl:when test="string($motMin)='absolument'">
			<xsl:text>&pt1;&pt12;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='absolu'">
			<xsl:text>&pt1;&pt12;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='actionnaire'">
			<xsl:text>&pt1;&pt3456;&pt1235;</xsl:text>
		</xsl:when>
		<!--<xsl:when test="string($motMin)='action'">
			<xsl:text>&pt1;&pt3456;</xsl:text>
		</xsl:when>-->
		<xsl:when test="string($motMin)='affaire'">
			<xsl:text>&pt1;&pt124;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='afin'">
			<xsl:text>&pt1;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='ailleurs'">
			<xsl:text>&pt34;&pt136;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='ainsi'">
			<xsl:text>&pt1;&pt24;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='alors'">
			<xsl:text>&pt1;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='amoureux'">
			<xsl:text>&pt1;&pt134;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='amoureusement'">
			<xsl:text>&pt1;&pt134;&pt234;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='amoureuse'">
			<xsl:text>&pt1;&pt134;&pt234;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='amour'">
			<xsl:text>&pt1;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='apparemment'">
			<xsl:text>&pt1;&pt1234;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='apparence'">
			<xsl:text>&pt1;&pt1234;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='apparent'">
			<xsl:text>&pt1;&pt1234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='aprÃ¨s'">
			<xsl:text>&pt1;&pt235;&pt2346;&pt234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='assez'">
			<xsl:text>&pt1;&pt1356;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='attentivement'">
			<xsl:text>&pt1;&pt2345;&pt1236;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='attentive'">
			<xsl:text>&pt1;&pt2345;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='attention'">
			<xsl:text>&pt1;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='attentif'">
			<xsl:text>&pt1;&pt2345;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='aucunement'">
			<xsl:text>&pt13;&pt1345;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='aucune'">
			<xsl:text>&pt13;&pt1345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='aucun'">
			<xsl:text>&pt13;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='auparavant'">
			<xsl:text>&pt13;&pt1234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='auprÃ¨s'">
			<xsl:text>&pt13;&pt235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='auquel'">
			<xsl:text>&pt13;&pt12345;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='aussitÃ´t'">
			<xsl:text>&pt13;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='aussi'">
			<xsl:text>&pt13;&pt234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='autour'">
			<xsl:text>&pt13;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='autrefois'">
			<xsl:text>&pt13;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='autrement'">
			<xsl:text>&pt13;&pt356;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='autre'">
			<xsl:text>&pt13;&pt356;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='auxquelles'">
			<xsl:text>&pt13;&pt1346;&pt12345;&pt123;&pt123;&pt234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='auxquels'">
			<xsl:text>&pt13;&pt1346;&pt12345;&pt123;&pt234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='avancement'">
			<xsl:text>&pt1;&pt1236;&pt14;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='avance'">
			<xsl:text>&pt1;&pt1236;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='avantageux'">
			<xsl:text>&pt1;&pt1236;&pt1245;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='avantageusement'">
			<xsl:text>&pt1;&pt1236;&pt1245;&pt234;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='avantageuse'">
			<xsl:text>&pt1;&pt1236;&pt1245;&pt234;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='avantage'">
			<xsl:text>&pt1;&pt1236;&pt1245;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='avant'">
			<xsl:text>&pt1;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='avec'">
			<xsl:text>&pt1;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='avoir'">
			<xsl:text>&pt1;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='ayant'">
			<xsl:text>&pt1;&pt13456;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='beaucoup'">
			<xsl:text>&pt12;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='besogneux'">
			<xsl:text>&pt12;&pt2356;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='besogneuse'">
			<xsl:text>&pt12;&pt2356;&pt234;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='besogne'">
			<xsl:text>&pt12;&pt2356;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='besoin'">
			<xsl:text>&pt12;&pt35;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='bÃªtement'">
			<xsl:text>&pt12;&pt126;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='bÃªte'">
			<xsl:text>&pt12;&pt126;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='bienveillance'">
			<xsl:text>&pt12;&pt1236;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='bienveillant'">
			<xsl:text>&pt12;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='bientÃ´t'">
			<xsl:text>&pt12;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='bienfaisance'">
			<xsl:text>&pt12;&pt124;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='bienfaiteur'">
			<xsl:text>&pt12;&pt124;&pt46;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='bienfait'">
			<xsl:text>&pt12;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='bizarrement'">
			<xsl:text>&pt12;&pt1356;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='bizarre'">
			<xsl:text>&pt12;&pt1356;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='bonheur'">
			<xsl:text>&pt12;&pt125;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='bonjour'">
			<xsl:text>&pt12;&pt245;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='bonnement'">
			<xsl:text>&pt12;&pt1345;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='bontÃ©'">
			<xsl:text>&pt12;&pt135;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='bonne'">
			<xsl:text>&pt12;&pt1345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='boulevard'">
			<xsl:text>&pt12;&pt145;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='braille'">
			<xsl:text>&pt23;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='branchement'">
			<xsl:text>&pt23;&pt12356;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='branche'">
			<xsl:text>&pt23;&pt12356;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='bravement'">
			<xsl:text>&pt23;&pt1236;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='brave'">
			<xsl:text>&pt23;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='bruit'">
			<xsl:text>&pt23;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='brusquement'">
			<xsl:text>&pt23;&pt12345;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='brusque'">
			<xsl:text>&pt23;&pt12345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='budgÃ©taire'">
			<xsl:text>&pt12;&pt1245;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='budget'">
			<xsl:text>&pt12;&pt1245;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='caractÃ©ristique'">
			<xsl:text>&pt14;&pt123456;&pt12345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='caractÃ¨re'">
			<xsl:text>&pt14;&pt2346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='ceci'">
			<xsl:text>&pt14;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='celle'">
			<xsl:text>&pt14;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='cela'">
			<xsl:text>&pt14;&pt1;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='cependant'">
			<xsl:text>&pt14;&pt1234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='certainement'">
			<xsl:text>&pt14;&pt1345;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='certaine'">
			<xsl:text>&pt14;&pt1345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='certain'">
			<xsl:text>&pt14;&pt35;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='certes'">
			<xsl:text>&pt14;&pt236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='certitude'">
			<xsl:text>&pt14;&pt236;&pt145;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='ces'">
			<xsl:text>&pt14;&pt234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='cette'">
			<xsl:text>&pt14;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='ceux'">
			<xsl:text>&pt14;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='chacune'">
			<xsl:text>&pt12356;&pt1345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='chacun'">
			<xsl:text>&pt12356;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='chagrin'">
			<xsl:text>&pt12356;&pt12456;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='chaleureux'">
			<xsl:text>&pt12356;&pt123;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='chaleureusement'">
			<xsl:text>&pt12356;&pt123;&pt234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='chaleureuse'">
			<xsl:text>&pt12356;&pt123;&pt234;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='chaleur'">
			<xsl:text>&pt12356;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='champ'">
			<xsl:text>&pt12356;&pt1234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='changement'">
			<xsl:text>&pt12356;&pt1245;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='change'">
			<xsl:text>&pt12356;&pt1245;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='chaque'">
			<xsl:text>&pt12356;&pt12345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='charitablement'">
			<xsl:text>&pt12356;&pt2345;&pt45;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='charitable'">
			<xsl:text>&pt12356;&pt2345;&pt45;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='charitÃ©'">
			<xsl:text>&pt12356;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='chaudement'">
			<xsl:text>&pt12356;&pt145;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='chaud'">
			<xsl:text>&pt12356;&pt145;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='chemin'">
			<xsl:text>&pt12356;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='chÃ¨rement'">
			<xsl:text>&pt12356;&pt2346;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='chÃ¨re'">
			<xsl:text>&pt12356;&pt2346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='chez'">
			<xsl:text>&pt12356;&pt1356;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='chiffrage'">
			<xsl:text>&pt12356;&pt124;&pt1245;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='chiffre'">
			<xsl:text>&pt12356;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='choeur'">
			<xsl:text>&pt12356;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='choix'">
			<xsl:text>&pt12356;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='chÂœur'">
			<xsl:text>&pt12356;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='choeur'"><!-- ajout BM -->
			<xsl:text>&pt12356;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='chose'">
			<xsl:text>&pt12356;&pt234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='circonstanciel'">
			<xsl:text>&pt14;&pt25;&pt14;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='circonstance'">
			<xsl:text>&pt14;&pt25;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='civilisation'">
			<xsl:text>&pt14;&pt1236;&pt16;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='civilement'">
			<xsl:text>&pt14;&pt1236;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='civilitÃ©'">
			<xsl:text>&pt14;&pt1236;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='civil'">
			<xsl:text>&pt14;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='coeur'">
			<xsl:text>&pt14;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='combien'">
			<xsl:text>&pt14;&pt12;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='commencement'">
			<xsl:text>&pt36;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='commentaire'">
			<xsl:text>&pt14;&pt26;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='comment'">
			<xsl:text>&pt14;&pt26;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='comme'">
			<xsl:text>&pt14;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='communion'">
			<xsl:text>&pt36;&pt1345;&pt3456;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='communÃ©ment'">
			<xsl:text>&pt36;&pt1345;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='communaux'">
			<xsl:text>&pt36;&pt1345;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='communautÃ©'">
			<xsl:text>&pt36;&pt1345;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='communautaire'">
			<xsl:text>&pt36;&pt1345;&pt2345;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='communal'">
			<xsl:text>&pt36;&pt1345;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='commun'">
			<xsl:text>&pt36;&pt1345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='complÃ©mentaire'">
			<xsl:text>&pt36;&pt1246;&pt134;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='complÃ©ment'">
			<xsl:text>&pt36;&pt1246;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='complÃ¨tement'">
			<xsl:text>&pt36;&pt2345;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='complÃ¨te'">
			<xsl:text>&pt36;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='complet'">
			<xsl:text>&pt36;&pt1246;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='conclusion'">
			<xsl:text>&pt25;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='conditionnellement'">
			<xsl:text>&pt25;&pt145;&pt123;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='conditionnel'">
			<xsl:text>&pt25;&pt145;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='condition'">
			<xsl:text>&pt25;&pt145;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='confiance'">
			<xsl:text>&pt25;&pt124;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='confiant'">
			<xsl:text>&pt25;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='congrÃ¨s'">
			<xsl:text>&pt25;&pt12456;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='connaissance'">
			<xsl:text>&pt25;&pt1345;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='connaÃ®tre'">
			<xsl:text>&pt25;&pt1345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='consciemment'">
			<xsl:text>&pt25;&pt234;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='consciencieux'">
			<xsl:text>&pt25;&pt234;&pt14;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='consciencieusement'">
			<xsl:text>&pt25;&pt234;&pt14;&pt234;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='consciencieuse'">
			<xsl:text>&pt25;&pt234;&pt14;&pt234;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='conscience'">
			<xsl:text>&pt25;&pt234;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='conscient'">
			<xsl:text>&pt25;&pt234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='consÃ©quemment'">
			<xsl:text>&pt14;&pt12345;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='consÃ©quence'">
			<xsl:text>&pt14;&pt12345;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='consÃ©quent'">
			<xsl:text>&pt14;&pt12345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='considÃ©rablement'">
			<xsl:text>&pt14;&pt145;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='considÃ©rable'">
			<xsl:text>&pt14;&pt145;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='considÃ©ration'">
			<xsl:text>&pt14;&pt145;&pt16;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='contrairement'">
			<xsl:text>&pt14;&pt356;&pt1235;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='contraire'">
			<xsl:text>&pt14;&pt356;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='contre'">
			<xsl:text>&pt14;&pt356;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='conversation'">
			<xsl:text>&pt25;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='cÃ´tÃ©'">
			<xsl:text>&pt14;&pt1456;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='cÂœur'">
			<xsl:text>&pt14;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='coeur'"><!-- ajout BM -->
			<xsl:text>&pt14;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='couple'">
			<xsl:text>&pt14;&pt1246;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='courageux'">
			<xsl:text>&pt14;&pt1245;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='courageusement'">
			<xsl:text>&pt14;&pt1245;&pt234;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='courageuse'">
			<xsl:text>&pt14;&pt1245;&pt234;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='courage'">
			<xsl:text>&pt14;&pt1245;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='dangereusement'">
			<xsl:text>&pt145;&pt1245;&pt234;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='dangereuse'">
			<xsl:text>&pt145;&pt1245;&pt234;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='dangereux'">
			<xsl:text>&pt145;&pt1245;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='danger'">
			<xsl:text>&pt145;&pt1245;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='davantage'">
			<xsl:text>&pt145;&pt1;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='debout'">
			<xsl:text>&pt145;&pt12;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='dedans'">
			<xsl:text>&pt145;&pt145;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='degrÃ©'">
			<xsl:text>&pt145;&pt12456;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='dehors'">
			<xsl:text>&pt145;&pt125;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='dÃ©jÃ '">
			<xsl:text>&pt145;&pt245;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='demain'">
			<xsl:text>&pt145;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='depuis'">
			<xsl:text>&pt145;&pt1234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='derniÃ¨rement'">
			<xsl:text>&pt145;&pt1235;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='derniÃ¨re'">
			<xsl:text>&pt145;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='dernier'">
			<xsl:text>&pt145;&pt1345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='derriÃ¨re'">
			<xsl:text>&pt145;&pt236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='dÃ©sormais'">
			<xsl:text>&pt145;&pt34;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='desquelles'">
			<xsl:text>&pt145;&pt234;&pt12345;&pt123;&pt123;&pt234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='desquels'">
			<xsl:text>&pt145;&pt234;&pt12345;&pt123;&pt234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='destination'">
			<xsl:text>&pt145;&pt35;&pt16;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='destinataire'">
			<xsl:text>&pt145;&pt35;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='destin'">
			<xsl:text>&pt145;&pt35;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='devant'">
			<xsl:text>&pt145;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='des'">
			<xsl:text>&pt145;&pt234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='diffÃ©remment'">
			<xsl:text>&pt145;&pt345;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='diffÃ©rence'">
			<xsl:text>&pt145;&pt26;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='diffÃ©rent'">
			<xsl:text>&pt145;&pt26;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='difficilement'">
			<xsl:text>&pt145;&pt124;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='difficultÃ©'">
			<xsl:text>&pt145;&pt124;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='difficile'">
			<xsl:text>&pt145;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='dignitaire'">
			<xsl:text>&pt145;&pt2356;&pt2345;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='dignement'">
			<xsl:text>&pt145;&pt2356;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='dignitÃ©'">
			<xsl:text>&pt145;&pt2356;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='digne'">
			<xsl:text>&pt145;&pt2356;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='discours'">
			<xsl:text>&pt256;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='disposition'">
			<xsl:text>&pt256;&pt1234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='dispositif'">
			<xsl:text>&pt256;&pt1234;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='distance'">
			<xsl:text>&pt256;&pt2345;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='distant'">
			<xsl:text>&pt256;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='donc'">
			<xsl:text>&pt145;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='dont'">
			<xsl:text>&pt145;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='douloureux'">
			<xsl:text>&pt145;&pt123;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='douloureusement'">
			<xsl:text>&pt145;&pt123;&pt234;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='douloureuse'">
			<xsl:text>&pt145;&pt123;&pt234;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='douleur'">
			<xsl:text>&pt145;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='doute'">
			<xsl:text>&pt145;&pt1256;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='duquel'">
			<xsl:text>&pt145;&pt136;&pt12345;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='effectivement'">
			<xsl:text>&pt15;&pt124;&pt1236;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='effective'">
			<xsl:text>&pt15;&pt124;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='effectif'">
			<xsl:text>&pt15;&pt124;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='Ã©gal'">
			<xsl:text>&pt123456;&pt1245;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='Ã©galement'">
			<xsl:text>&pt123456;&pt1245;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='Ã©galitaire'">
			<xsl:text>&pt123456;&pt1245;&pt2345;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='Ã©galitÃ©'">
			<xsl:text>&pt123456;&pt1245;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='Ã©gaux'">
			<xsl:text>&pt123456;&pt1245;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='Ã©lÃ©ment'">
			<xsl:text>&pt123456;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='Ã©lÃ©mentaire'">
			<xsl:text>&pt123456;&pt123;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='effet'">
			<xsl:text>&pt15;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='encore'">
			<xsl:text>&pt26;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='endroit'">
			<xsl:text>&pt26;&pt145;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='Ã©nergie'">
			<xsl:text>&pt123456;&pt1345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='Ã©nergique'">
			<xsl:text>&pt123456;&pt1345;&pt12345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='Ã©nergiquement'">
			<xsl:text>&pt123456;&pt1345;&pt12345;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='enfin'">
			<xsl:text>&pt26;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='ennui'">
			<xsl:text>&pt26;&pt1345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='ennuyeux'">
			<xsl:text>&pt26;&pt1345;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='ennuyeuse'">
			<xsl:text>&pt26;&pt1345;&pt234;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='enquÃªteuse'">
			<xsl:text>&pt26;&pt12345;&pt234;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='enquÃªteur'">
			<xsl:text>&pt26;&pt12345;&pt46;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='enquÃªte'">
			<xsl:text>&pt26;&pt12345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='ensemble'">
			<xsl:text>&pt26;&pt345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='ensuite'">
			<xsl:text>&pt26;&pt234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='entiÃ¨rement'">
			<xsl:text>&pt26;&pt1235;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='entiÃ¨re'">
			<xsl:text>&pt26;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='entier'">
			<xsl:text>&pt26;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='environ'">
			<xsl:text>&pt26;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='espÃ©rance'">
			<xsl:text>&pt156;&pt1235;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='espÃ¨ce'">
			<xsl:text>&pt156;&pt1234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='espoir'">
			<xsl:text>&pt156;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='esprit'">
			<xsl:text>&pt15;&pt235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='essentiellement'">
			<xsl:text>&pt156;&pt123;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='essentielle'">
			<xsl:text>&pt156;&pt123;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='essentiel'">
			<xsl:text>&pt156;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='Ã©tant'">
			<xsl:text>&pt123456;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='Ã©vÃ©nement'">
			<xsl:text>&pt123456;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='Ã©ventualitÃ©'">
			<xsl:text>&pt123456;&pt1236;&pt123;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='Ã©ventuel'">
			<xsl:text>&pt123456;&pt1236;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='Ã©ventuellement'">
			<xsl:text>&pt123456;&pt1236;&pt123;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='excellence'">
			<xsl:text>&pt1346;&pt123;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='excellent'">
			<xsl:text>&pt1346;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='excessivement'">
			<xsl:text>&pt1346;&pt14;&pt1236;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='excessive'">
			<xsl:text>&pt1346;&pt14;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='excessif'">
			<xsl:text>&pt1346;&pt14;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='excÃ¨s'">
			<xsl:text>&pt1346;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='exercice'">
			<xsl:text>&pt1346;&pt236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='expÃ©rience'">
			<xsl:text>&pt1346;&pt1234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='expÃ©rimentalement'">
			<xsl:text>&pt1346;&pt1234;&pt123;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='expÃ©rimentateur'">
			<xsl:text>&pt1346;&pt1234;&pt46;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='expÃ©rimentaux'">
			<xsl:text>&pt1346;&pt1234;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='expÃ©rimentation'">
			<xsl:text>&pt1346;&pt1234;&pt16;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='expÃ©rimental'">
			<xsl:text>&pt1346;&pt1234;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='explicative'">
			<xsl:text>&pt1346;&pt1246;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='explicatif'">
			<xsl:text>&pt1346;&pt1246;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='explication'">
			<xsl:text>&pt1346;&pt1246;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='expressivement'">
			<xsl:text>&pt1346;&pt235;&pt1236;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='expressif'">
			<xsl:text>&pt1346;&pt235;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='expressive'">
			<xsl:text>&pt1346;&pt235;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='expression'">
			<xsl:text>&pt1346;&pt235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='extÃ©rieurement'">
			<xsl:text>&pt1346;&pt2345;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='extÃ©rieur'">
			<xsl:text>&pt1346;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='extrÃªmement'">
			<xsl:text>&pt1346;&pt356;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='extrÃ©mitÃ©'">
			<xsl:text>&pt1346;&pt356;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='extrÃªme'">
			<xsl:text>&pt1346;&pt356;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='facilement'">
			<xsl:text>&pt124;&pt14;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='facilitÃ©'">
			<xsl:text>&pt124;&pt14;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='facile'">
			<xsl:text>&pt124;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='faute'">
			<xsl:text>&pt124;&pt2345;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='faut'">
			<xsl:text>&pt124;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='faveur'">
			<xsl:text>&pt124;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='favorablement'">
			<xsl:text>&pt124;&pt1236;&pt45;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='favorable'">
			<xsl:text>&pt124;&pt1236;&pt45;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='fÃ©minine'">
			<xsl:text>&pt124;&pt134;&pt1345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='fÃ©minin'">
			<xsl:text>&pt124;&pt134;&pt35;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='femme'">
			<xsl:text>&pt124;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='fÃªte'">
			<xsl:text>&pt124;&pt126;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='fidÃ¨lement'">
			<xsl:text>&pt124;&pt145;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='fidÃ©litÃ©'">
			<xsl:text>&pt124;&pt145;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='fidÃ¨le'">
			<xsl:text>&pt124;&pt145;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='figuration'">
			<xsl:text>&pt124;&pt1245;&pt16;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='figure'">
			<xsl:text>&pt124;&pt1245;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='fille'">
			<xsl:text>&pt124;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='fils'">
			<xsl:text>&pt124;&pt234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='fonctionnement'">
			<xsl:text>&pt124;&pt346;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='fonctionnelle'">
			<xsl:text>&pt124;&pt346;&pt123;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='fonctionnel'">
			<xsl:text>&pt124;&pt346;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='fonctionnaire'">
			<xsl:text>&pt124;&pt346;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='fonction'">
			<xsl:text>&pt124;&pt346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='forcÃ©ment'">
			<xsl:text>&pt124;&pt135;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='force'">
			<xsl:text>&pt124;&pt135;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='fortune'">
			<xsl:text>&pt124;&pt1345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='fraternellement'">
			<xsl:text>&pt124;&pt1235;&pt123;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='fraternitÃ©'">
			<xsl:text>&pt124;&pt1235;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='fraternel'">
			<xsl:text>&pt124;&pt1235;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='frÃ©quentation'">
			<xsl:text>&pt124;&pt12345;&pt16;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='frÃ©quence'">
			<xsl:text>&pt124;&pt12345;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='frÃ©quemment'">
			<xsl:text>&pt124;&pt12345;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='frÃ©quent'">
			<xsl:text>&pt124;&pt12345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='frÃ¨re'">
			<xsl:text>&pt124;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='garde'">
			<xsl:text>&pt1245;&pt145;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='gÃ©nÃ©ralement'">
			<xsl:text>&pt1245;&pt1345;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='gÃ©nÃ©ralisation'">
			<xsl:text>&pt1245;&pt1345;&pt16;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='gÃ©nÃ©ralitÃ©'">
			<xsl:text>&pt1245;&pt1345;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='gÃ©nÃ©raux'">
			<xsl:text>&pt1245;&pt1345;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='gÃ©nÃ©ral'">
			<xsl:text>&pt1245;&pt1345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='gÃ©nÃ©reusement'">
			<xsl:text>&pt1245;&pt234;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='gÃ©nÃ©reux'">
			<xsl:text>&pt1245;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='gÃ©nÃ©rositÃ©'">
			<xsl:text>&pt1245;&pt234;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='gÃ©nÃ©reuse'">
			<xsl:text>&pt1245;&pt234;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='glorieusement'">
			<xsl:text>&pt1245;&pt1235;&pt234;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='glorieux'">
			<xsl:text>&pt1245;&pt1235;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='glorieuse'">
			<xsl:text>&pt1245;&pt1235;&pt234;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='gloire'">
			<xsl:text>&pt1245;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='gouvernementaux'">
			<xsl:text>&pt1245;&pt1236;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='gouvernemental'">
			<xsl:text>&pt1245;&pt1236;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='gouvernement'">
			<xsl:text>&pt1245;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='gouverneur'">
			<xsl:text>&pt1245;&pt1236;&pt46;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='gracieusement'">
			<xsl:text>&pt12456;&pt14;&pt234;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='gracieux'">
			<xsl:text>&pt12456;&pt14;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='gracieuse'">
			<xsl:text>&pt12456;&pt14;&pt234;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='grÃ¢ce'">
			<xsl:text>&pt12456;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='grandement'">
			<xsl:text>&pt12456;&pt145;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='grandeur'">
			<xsl:text>&pt12456;&pt46;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='grande'">
			<xsl:text>&pt12456;&pt145;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='gravement'">
			<xsl:text>&pt12456;&pt1236;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='gravitÃ©'">
			<xsl:text>&pt12456;&pt1236;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='grave'">
			<xsl:text>&pt12456;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='groupement'">
			<xsl:text>&pt12456;&pt1234;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='groupe'">
			<xsl:text>&pt12456;&pt1234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='guerre'">
			<xsl:text>&pt1245;&pt236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='guÃ¨re'">
			<xsl:text>&pt1245;&pt2346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='habituellement'">
			<xsl:text>&pt125;&pt12;&pt123;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='habituelle'">
			<xsl:text>&pt125;&pt12;&pt123;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='habituel'">
			<xsl:text>&pt125;&pt12;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='habitude'">
			<xsl:text>&pt125;&pt12;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='hasardeuse'">
			<xsl:text>&pt125;&pt145;&pt234;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='hasardeux'">
			<xsl:text>&pt125;&pt145;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='hasard'">
			<xsl:text>&pt125;&pt145;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='hÃ©las'">
			<xsl:text>&pt125;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='heureusement'">
			<xsl:text>&pt125;&pt234;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='heureuse'">
			<xsl:text>&pt125;&pt234;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='heureux'">
			<xsl:text>&pt125;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='heure'">
			<xsl:text>&pt125;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='hier'">
			<xsl:text>&pt125;&pt236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='historiquement'">
			<xsl:text>&pt125;&pt2345;&pt12345;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='historique'">
			<xsl:text>&pt125;&pt2345;&pt12345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='histoire'">
			<xsl:text>&pt125;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='hiver'">
			<xsl:text>&pt125;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='hommage'">
			<xsl:text>&pt125;&pt1245;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='homme'">
			<xsl:text>&pt125;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='honnÃªtement'">
			<xsl:text>&pt125;&pt126;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='honnÃªtetÃ©'">
			<xsl:text>&pt125;&pt126;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='honnÃªte'">
			<xsl:text>&pt125;&pt126;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='honneur'">
			<xsl:text>&pt125;&pt1345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='honorablement'">
			<xsl:text>&pt125;&pt1345;&pt45;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='honorable'">
			<xsl:text>&pt125;&pt1345;&pt45;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='honoraire'">
			<xsl:text>&pt125;&pt1345;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='horaire'">
			<xsl:text>&pt125;&pt1235;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='horizontalement'">
			<xsl:text>&pt125;&pt1356;&pt123;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='horizontalitÃ©'">
			<xsl:text>&pt125;&pt1356;&pt123;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='horizontaux'">
			<xsl:text>&pt125;&pt1356;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='horizontal'">
			<xsl:text>&pt125;&pt1356;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='horizon'">
			<xsl:text>&pt125;&pt1356;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='humainement'">
			<xsl:text>&pt125;&pt134;&pt1345;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='humanitaire'">
			<xsl:text>&pt125;&pt134;&pt1345;&pt2345;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='humanitÃ©'">
			<xsl:text>&pt125;&pt134;&pt1345;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='humaine'">
			<xsl:text>&pt125;&pt134;&pt1345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='humain'">
			<xsl:text>&pt125;&pt134;&pt35;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='hypothÃ©tiquement'">
			<xsl:text>&pt125;&pt1234;&pt12345;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='hypothÃ©tique'">
			<xsl:text>&pt125;&pt1234;&pt12345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='hypothÃ¨se'">
			<xsl:text>&pt125;&pt1234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='idÃ©alement'">
			<xsl:text>&pt24;&pt145;&pt123;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='idÃ©al'">
			<xsl:text>&pt24;&pt145;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='idÃ©e'">
			<xsl:text>&pt24;&pt145;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='idÃ©aux'">
			<xsl:text>&pt24;&pt145;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='imagination'">
			<xsl:text>&pt24;&pt1245;&pt16;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='imaginaire'">
			<xsl:text>&pt24;&pt1245;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='imaginable'">
			<xsl:text>&pt24;&pt1245;&pt45;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='image'">
			<xsl:text>&pt24;&pt1245;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='immÃ©diatement'">
			<xsl:text>&pt24;&pt134;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='immÃ©diat'">
			<xsl:text>&pt24;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='impressionnable'">
			<xsl:text>&pt246;&pt235;&pt45;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='impression'">
			<xsl:text>&pt246;&pt235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='infÃ©rieurement'">
			<xsl:text>&pt35;&pt124;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='infÃ©rioritÃ©'">
			<xsl:text>&pt35;&pt124;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='infÃ©rieur'">
			<xsl:text>&pt35;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='inquiÃ©tude'">
			<xsl:text>&pt35;&pt12345;&pt145;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='inquiÃ¨te'">
			<xsl:text>&pt35;&pt2346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='inquiet'">
			<xsl:text>&pt35;&pt12345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='intelligemment'">
			<xsl:text>&pt35;&pt1245;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='intelligence'">
			<xsl:text>&pt35;&pt1245;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='intelligent'">
			<xsl:text>&pt35;&pt1245;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='intÃ©rieurement'">
			<xsl:text>&pt35;&pt2345;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='intÃ©rieur'">
			<xsl:text>&pt35;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='jadis'">
			<xsl:text>&pt245;&pt145;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='jamais'">
			<xsl:text>&pt245;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='jeune'">
			<xsl:text>&pt245;&pt1345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='jour'">
			<xsl:text>&pt245;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='joyeusement'">
			<xsl:text>&pt245;&pt234;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='joyeux'">
			<xsl:text>&pt245;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='joyeuse'">
			<xsl:text>&pt245;&pt234;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='jugement'">
			<xsl:text>&pt245;&pt1245;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='juge'">
			<xsl:text>&pt245;&pt1245;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='jusque'">
			<xsl:text>&pt245;&pt12345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='jusqu'">
			<xsl:text>&pt245;&pt12345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='justement'">
			<xsl:text>&pt245;&pt2345;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='juste'">
			<xsl:text>&pt245;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='justice'">
			<xsl:text>&pt245;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='laquelle'">
			<xsl:text>&pt123;&pt123;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='lecture'">
			<xsl:text>&pt123;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='lequel'">
			<xsl:text>&pt123;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='lesquelles'">
			<xsl:text>&pt123;&pt123;&pt123;&pt234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='lesquels'">
			<xsl:text>&pt123;&pt123;&pt234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='lettre'">
			<xsl:text>&pt123;&pt356;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='libÃ©ration'">
			<xsl:text>&pt123;&pt12;&pt16;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='libÃ©ralitÃ©'">
			<xsl:text>&pt123;&pt12;&pt123;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='libÃ©raux'">
			<xsl:text>&pt123;&pt12;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='libertÃ©'">
			<xsl:text>&pt123;&pt12;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='libÃ©ral'">
			<xsl:text>&pt123;&pt12;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='librement'">
			<xsl:text>&pt123;&pt12;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='libre'">
			<xsl:text>&pt123;&pt12;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='ligne'">
			<xsl:text>&pt123;&pt2356;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='livre'">
			<xsl:text>&pt123;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='lointaine'">
			<xsl:text>&pt123;&pt1345;&pt1345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='lointain'">
			<xsl:text>&pt123;&pt1345;&pt35;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='loin'">
			<xsl:text>&pt123;&pt1345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='longtemps'">
			<xsl:text>&pt123;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='lorsque'">
			<xsl:text>&pt123;&pt12345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='lourdement'">
			<xsl:text>&pt123;&pt145;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='lourdeur'">
			<xsl:text>&pt123;&pt145;&pt46;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='lourd'">
			<xsl:text>&pt123;&pt145;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='lumiÃ¨re'">
			<xsl:text>&pt123;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='lumineusement'">
			<xsl:text>&pt123;&pt134;&pt234;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='lumineux'">
			<xsl:text>&pt123;&pt134;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='luminositÃ©'">
			<xsl:text>&pt123;&pt134;&pt234;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='lumineuse'">
			<xsl:text>&pt123;&pt134;&pt234;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='logiquement'">
			<xsl:text>&pt123;&pt1245;&pt12345;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='logique'">
			<xsl:text>&pt123;&pt1245;&pt12345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='madame'">
			<xsl:text>&pt134;&pt145;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='mademoiselle'">
			<xsl:text>&pt134;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='magnifiquement'">
			<xsl:text>&pt134;&pt2356;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='magnificence'">
			<xsl:text>&pt134;&pt2356;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='magnifique'">
			<xsl:text>&pt134;&pt2356;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='maintenant'">
			<xsl:text>&pt134;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='malgrÃ©'">
			<xsl:text>&pt134;&pt12456;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='malheureusement'">
			<xsl:text>&pt134;&pt125;&pt234;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='malheureuse'">
			<xsl:text>&pt134;&pt125;&pt234;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='malheureux'">
			<xsl:text>&pt134;&pt125;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='malheur'">
			<xsl:text>&pt134;&pt125;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='maniÃ¨re'">
			<xsl:text>&pt134;&pt1345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='mauvais'">
			<xsl:text>&pt134;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='meilleur'">
			<xsl:text>&pt134;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='merci'">
			<xsl:text>&pt134;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='mÃ¨re'">
			<xsl:text>&pt134;&pt2346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='mesdames'">
			<xsl:text>&pt134;&pt145;&pt234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='mesdemoiselles'">
			<xsl:text>&pt134;&pt134;&pt234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='messieurs'">
			<xsl:text>&pt134;&pt1235;&pt234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='mes'">
			<xsl:text>&pt134;&pt234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='mettre'">
			<xsl:text>&pt134;&pt356;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='mieux'">
			<xsl:text>&pt134;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='missionnaire'">
			<xsl:text>&pt134;&pt3456;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='mission'">
			<xsl:text>&pt134;&pt3456;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='mobilisation'">
			<xsl:text>&pt134;&pt12;&pt16;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='mobilitÃ©'">
			<xsl:text>&pt134;&pt12;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='mobile'">
			<xsl:text>&pt134;&pt12;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='moins'">
			<xsl:text>&pt134;&pt35;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='momentanÃ©ment'">
			<xsl:text>&pt134;&pt26;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='moment'">
			<xsl:text>&pt134;&pt26;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='monsieur'">
			<xsl:text>&pt134;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='multiplicitÃ©'">
			<xsl:text>&pt134;&pt1246;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='multiplication'">
			<xsl:text>&pt134;&pt1246;&pt16;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='multiplicateur'">
			<xsl:text>&pt134;&pt1246;&pt46;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='multiple'">
			<xsl:text>&pt134;&pt1246;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='musique'">
			<xsl:text>&pt134;&pt12345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='mystÃ©rieusement'">
			<xsl:text>&pt134;&pt13456;&pt234;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='mystÃ©rieux'">
			<xsl:text>&pt134;&pt13456;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='mystÃ©rieuse'">
			<xsl:text>&pt134;&pt13456;&pt234;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='mystÃ¨re'">
			<xsl:text>&pt134;&pt13456;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='naguÃ¨re'">
			<xsl:text>&pt1345;&pt1245;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='nationalitÃ©'">
			<xsl:text>&pt1345;&pt16;&pt123;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='nationaux'">
			<xsl:text>&pt1345;&pt16;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='national'">
			<xsl:text>&pt1345;&pt16;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='nation'">
			<xsl:text>&pt1345;&pt16;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='naturellement'">
			<xsl:text>&pt1345;&pt2345;&pt123;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='naturel'">
			<xsl:text>&pt1345;&pt2345;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='nature'">
			<xsl:text>&pt1345;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='nÃ©anmoins'">
			<xsl:text>&pt1345;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='nÃ©cessairement'">
			<xsl:text>&pt1345;&pt14;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='nÃ©cessitÃ©'">
			<xsl:text>&pt1345;&pt14;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='nÃ©cessiteuse'">
			<xsl:text>&pt1345;&pt14;&pt2345;&pt234;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='nÃ©cessiteux'">
			<xsl:text>&pt1345;&pt14;&pt2345;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='nÃ©cessaire'">
			<xsl:text>&pt1345;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='nombreux'">
			<xsl:text>&pt1345;&pt12;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='nombreuse'">
			<xsl:text>&pt1345;&pt12;&pt234;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='nombre'">
			<xsl:text>&pt1345;&pt12;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='nos'">
			<xsl:text>&pt1345;&pt234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='nÃ´tre'">
			<xsl:text>&pt1345;&pt1456;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='notre'">
			<xsl:text>&pt1345;&pt356;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='nouvellement'">
			<xsl:text>&pt1345;&pt123;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='nouvel'">
			<xsl:text>&pt1345;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='nouveautÃ©'">
			<xsl:text>&pt1345;&pt1236;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='nouveau'">
			<xsl:text>&pt1345;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='objectivement'">
			<xsl:text>&pt135;&pt245;&pt1236;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='objectivitÃ©'">
			<xsl:text>&pt135;&pt245;&pt1236;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='objective'">
			<xsl:text>&pt135;&pt245;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='objectif'">
			<xsl:text>&pt135;&pt245;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='objection'">
			<xsl:text>&pt135;&pt245;&pt3456;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='objet'">
			<xsl:text>&pt135;&pt245;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='observation'">
			<xsl:text>&pt135;&pt12;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='observateur'">
			<xsl:text>&pt135;&pt12;&pt46;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='occasionnellement'">
			<xsl:text>&pt135;&pt14;&pt123;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='occasionnel'">
			<xsl:text>&pt135;&pt14;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='occasion'">
			<xsl:text>&pt135;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='oeuvre'">
			<xsl:text>&pt246;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='officiellement'">
			<xsl:text>&pt135;&pt124;&pt123;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='officiel'">
			<xsl:text>&pt135;&pt124;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='officieusement'">
			<xsl:text>&pt135;&pt124;&pt234;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='officieux'">
			<xsl:text>&pt135;&pt124;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='officieuse'">
			<xsl:text>&pt135;&pt124;&pt234;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='office'">
			<xsl:text>&pt135;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='opinion'">
			<xsl:text>&pt135;&pt1234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='ordinairement'">
			<xsl:text>&pt56;&pt145;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='ordinaire'">
			<xsl:text>&pt56;&pt145;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='originairement'">
			<xsl:text>&pt135;&pt1245;&pt1235;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='originaire'">
			<xsl:text>&pt135;&pt1245;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='originalement'">
			<xsl:text>&pt135;&pt1245;&pt123;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='originalitÃ©'">
			<xsl:text>&pt135;&pt1245;&pt123;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='originaux'">
			<xsl:text>&pt135;&pt1245;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='original'">
			<xsl:text>&pt135;&pt1245;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='origine'">
			<xsl:text>&pt135;&pt1245;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='outrageusement'">
			<xsl:text>&pt1256;&pt356;&pt1245;&pt234;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='outrageux'">
			<xsl:text>&pt1256;&pt356;&pt1245;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='outrageuse'">
			<xsl:text>&pt1256;&pt356;&pt1245;&pt234;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='outrage'">
			<xsl:text>&pt1256;&pt356;&pt1245;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='outre'">
			<xsl:text>&pt1256;&pt356;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='ouvriÃ¨re'">
			<xsl:text>&pt1256;&pt2346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='ouvrier'">
			<xsl:text>&pt1256;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='ouvrage'">
			<xsl:text>&pt1256;&pt1245;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='parfois'">
			<xsl:text>&pt1234;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='parmi'">
			<xsl:text>&pt1234;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='parole'">
			<xsl:text>&pt1234;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='particuliÃ¨rement'">
			<xsl:text>&pt1234;&pt123;&pt1235;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='particularitÃ©'">
			<xsl:text>&pt1234;&pt123;&pt1235;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='particuliÃ¨re'">
			<xsl:text>&pt1234;&pt123;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='particulier'">
			<xsl:text>&pt1234;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='partout'">
			<xsl:text>&pt1234;&pt1;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='pas'">
			<xsl:text>&pt1234;&pt234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='patient'">
			<xsl:text>&pt1234;&pt1;&pt2345;&pt256;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='pauvrement'">
			<xsl:text>&pt1234;&pt1236;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='pauvretÃ©'">
			<xsl:text>&pt1234;&pt1236;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='pauvre'">
			<xsl:text>&pt1234;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='pendant'">
			<xsl:text>&pt1234;&pt145;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='pensivement'">
			<xsl:text>&pt1234;&pt26;&pt1236;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='pensive'">
			<xsl:text>&pt1234;&pt26;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='pensif'">
			<xsl:text>&pt1234;&pt26;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='pensÃ©e'">
			<xsl:text>&pt1234;&pt26;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='pÃ¨re'">
			<xsl:text>&pt1234;&pt2346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='personnalitÃ©'">
			<xsl:text>&pt1234;&pt1345;&pt123;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='personnage'">
			<xsl:text>&pt1234;&pt1345;&pt1245;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='personnellement'">
			<xsl:text>&pt1234;&pt1345;&pt123;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='personnel'">
			<xsl:text>&pt1234;&pt1345;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='personne'">
			<xsl:text>&pt1234;&pt1345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='petit'">
			<xsl:text>&pt1234;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='peuplement'">
			<xsl:text>&pt1234;&pt1246;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='peuple'">
			<xsl:text>&pt1234;&pt1246;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='placement'">
			<xsl:text>&pt1246;&pt14;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='place'">
			<xsl:text>&pt1246;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='plaisir'">
			<xsl:text>&pt1246;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='plusieurs'">
			<xsl:text>&pt1246;&pt234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='plutÃ´t'">
			<xsl:text>&pt1246;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='pointe'">
			<xsl:text>&pt1234;&pt2345;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='point'">
			<xsl:text>&pt1234;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='populairement'">
			<xsl:text>&pt1234;&pt1234;&pt1235;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='popularitÃ©'">
			<xsl:text>&pt1234;&pt1234;&pt1235;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='populaire'">
			<xsl:text>&pt1234;&pt1234;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='populeux'">
			<xsl:text>&pt1234;&pt1234;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='populeuse'">
			<xsl:text>&pt1234;&pt1234;&pt234;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='population'">
			<xsl:text>&pt1234;&pt1234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='possibilitÃ©'">
			<xsl:text>&pt1234;&pt12;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='possible'">
			<xsl:text>&pt1234;&pt12;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='pourquoi'">
			<xsl:text>&pt1234;&pt23456;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='pourtant'">
			<xsl:text>&pt1234;&pt135;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='pratiquement'">
			<xsl:text>&pt235;&pt2345;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='pratique'">
			<xsl:text>&pt235;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='praticable'">
			<xsl:text>&pt235;&pt2345;&pt45;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='premiÃ¨rement'">
			<xsl:text>&pt235;&pt1235;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='premiÃ¨re'">
			<xsl:text>&pt235;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='premier'">
			<xsl:text>&pt235;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='presque'">
			<xsl:text>&pt235;&pt12345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='prÃ¨s'">
			<xsl:text>&pt235;&pt234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='preuve'">
			<xsl:text>&pt235;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='primitivement'">
			<xsl:text>&pt235;&pt134;&pt1236;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='primitif'">
			<xsl:text>&pt235;&pt134;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='primitive'">
			<xsl:text>&pt235;&pt134;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='principalement'">
			<xsl:text>&pt235;&pt14;&pt123;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='principaux'">
			<xsl:text>&pt235;&pt14;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='principal'">
			<xsl:text>&pt235;&pt14;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='principe'">
			<xsl:text>&pt235;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='prix'">
			<xsl:text>&pt235;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='probablement'">
			<xsl:text>&pt235;&pt12;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='probabilitÃ©'">
			<xsl:text>&pt235;&pt12;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='probable'">
			<xsl:text>&pt235;&pt12;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='prochainement'">
			<xsl:text>&pt235;&pt1345;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='prochaine'">
			<xsl:text>&pt235;&pt1345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='prochain'">
			<xsl:text>&pt235;&pt12356;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='producteur'">
			<xsl:text>&pt235;&pt145;&pt46;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='productivement'">
			<xsl:text>&pt235;&pt145;&pt1236;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='productivitÃ©'">
			<xsl:text>&pt235;&pt145;&pt1236;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='productif'">
			<xsl:text>&pt235;&pt145;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='productive'">
			<xsl:text>&pt235;&pt145;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='production'">
			<xsl:text>&pt235;&pt145;&pt3456;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='produit'">
			<xsl:text>&pt235;&pt145;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='profiteuse'">
			<xsl:text>&pt235;&pt124;&pt234;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='profiteur'">
			<xsl:text>&pt235;&pt124;&pt46;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='profitable'">
			<xsl:text>&pt235;&pt124;&pt45;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='profit'">
			<xsl:text>&pt235;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='progressivement'">
			<xsl:text>&pt235;&pt12456;&pt1236;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='progressive'">
			<xsl:text>&pt235;&pt12456;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='progression'">
			<xsl:text>&pt235;&pt12456;&pt3456;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='progressif'">
			<xsl:text>&pt235;&pt12456;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='progrÃ¨s'">
			<xsl:text>&pt235;&pt12456;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='projecteur'">
			<xsl:text>&pt235;&pt245;&pt46;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='projection'">
			<xsl:text>&pt235;&pt245;&pt3456;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='projet'">
			<xsl:text>&pt235;&pt245;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='proportionnellement'">
			<xsl:text>&pt235;&pt1234;&pt123;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='proportionnalitÃ©'">
			<xsl:text>&pt235;&pt1234;&pt123;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='proportionnel'">
			<xsl:text>&pt235;&pt1234;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='proportion'">
			<xsl:text>&pt235;&pt1234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='proposition'">
			<xsl:text>&pt235;&pt246;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='puissance'">
			<xsl:text>&pt1234;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='puisque'">
			<xsl:text>&pt1234;&pt12345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='qualitÃ©'">
			<xsl:text>&pt12345;&pt123;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='quand'">
			<xsl:text>&pt12345;&pt145;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='quantitÃ©'">
			<xsl:text>&pt12345;&pt2345;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='quant'">
			<xsl:text>&pt12345;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='quelconque'">
			<xsl:text>&pt12345;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='quelquefois'">
			<xsl:text>&pt12345;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='quelque'">
			<xsl:text>&pt12345;&pt12345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='quel'">
			<xsl:text>&pt12345;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='questionnaire'">
			<xsl:text>&pt12345;&pt3456;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='question'">
			<xsl:text>&pt12345;&pt3456;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='quiconque'">
			<xsl:text>&pt12345;&pt346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='quoique'">
			<xsl:text>&pt12345;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='raisonnablement'">
			<xsl:text>&pt1235;&pt346;&pt45;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='raisonnement'">
			<xsl:text>&pt1235;&pt346;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='raisonnable'">
			<xsl:text>&pt1235;&pt346;&pt45;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='raison'">
			<xsl:text>&pt1235;&pt346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='rapporteur'">
			<xsl:text>&pt1235;&pt1234;&pt46;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='rapport'">
			<xsl:text>&pt1235;&pt1234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='rarement'">
			<xsl:text>&pt1235;&pt1235;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='raretÃ©'">
			<xsl:text>&pt1235;&pt1235;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='rare'">
			<xsl:text>&pt1235;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='rÃ©alisateur'">
			<xsl:text>&pt1235;&pt123;&pt46;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='rÃ©alisation'">
			<xsl:text>&pt1235;&pt123;&pt16;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='rÃ©alisable'">
			<xsl:text>&pt1235;&pt123;&pt45;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='rÃ©alitÃ©'">
			<xsl:text>&pt1235;&pt123;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='rÃ©ellement'">
			<xsl:text>&pt1235;&pt123;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='rÃ©el'">
			<xsl:text>&pt1235;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='rÃ©flexion'">
			<xsl:text>&pt1235;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='regard'">
			<xsl:text>&pt1235;&pt1245;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='regrettable'">
			<xsl:text>&pt1235;&pt12456;&pt45;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='regret'">
			<xsl:text>&pt1235;&pt12456;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='relativement'">
			<xsl:text>&pt1235;&pt2345;&pt1236;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='relativitÃ©'">
			<xsl:text>&pt1235;&pt2345;&pt1236;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='relatif'">
			<xsl:text>&pt1235;&pt2345;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='relation'">
			<xsl:text>&pt1235;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='relative'">
			<xsl:text>&pt1235;&pt2345;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='remarquablement'">
			<xsl:text>&pt1235;&pt12345;&pt45;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='remarquable'">
			<xsl:text>&pt1235;&pt12345;&pt45;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='remarque'">
			<xsl:text>&pt1235;&pt12345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='remerciement'">
			<xsl:text>&pt1235;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='renseignement'">
			<xsl:text>&pt1235;&pt26;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='rÃªveuse'">
			<xsl:text>&pt1235;&pt126;&pt234;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='rÃªveur'">
			<xsl:text>&pt1235;&pt126;&pt46;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='rÃªve'">
			<xsl:text>&pt1235;&pt126;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='rÃ´le'">
			<xsl:text>&pt1235;&pt1456;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='route'">
			<xsl:text>&pt1235;&pt1256;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='rythmique'">
			<xsl:text>&pt1235;&pt13456;&pt12345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='rythme'">
			<xsl:text>&pt1235;&pt13456;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='sÃ©culairement'">
			<xsl:text>&pt234;&pt14;&pt1235;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='sÃ©culaire'">
			<xsl:text>&pt234;&pt14;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='seigneur'">
			<xsl:text>&pt234;&pt2356;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='semblablement'">
			<xsl:text>&pt234;&pt12;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='semblable'">
			<xsl:text>&pt234;&pt12;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='sentimentalitÃ©'">
			<xsl:text>&pt234;&pt2345;&pt134;&pt123;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='sentimentaux'">
			<xsl:text>&pt234;&pt2345;&pt134;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='sentimental'">
			<xsl:text>&pt234;&pt2345;&pt134;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='sentiment'">
			<xsl:text>&pt234;&pt2345;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='ses'">
			<xsl:text>&pt234;&pt234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='seulement'">
			<xsl:text>&pt234;&pt123;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='seul'">
			<xsl:text>&pt234;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='siÃ¨cle'">
			<xsl:text>&pt234;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='simplification'">
			<xsl:text>&pt234;&pt1246;&pt16;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='simplicitÃ©'">
			<xsl:text>&pt234;&pt1246;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='simplement'">
			<xsl:text>&pt234;&pt1246;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='simple'">
			<xsl:text>&pt234;&pt1246;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='soeur'">
			<xsl:text>&pt234;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='soin'">
			<xsl:text>&pt234;&pt35;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='solitairement'">
			<xsl:text>&pt234;&pt123;&pt1235;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='solitaire'">
			<xsl:text>&pt234;&pt123;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='solitude'">
			<xsl:text>&pt234;&pt123;&pt145;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='sommairement'">
			<xsl:text>&pt234;&pt2456;&pt1235;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='sommaire'">
			<xsl:text>&pt234;&pt2456;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='somme'">
			<xsl:text>&pt234;&pt2456;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='sont'">
			<xsl:text>&pt246;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='sorte'">
			<xsl:text>&pt234;&pt135;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='sÂœur'">
			<xsl:text>&pt234;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='soeur'"><!-- ajout BM -->
			<xsl:text>&pt234;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='soudainement'">
			<xsl:text>&pt234;&pt1345;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='soudainetÃ©'">
			<xsl:text>&pt234;&pt1345;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='soudaine'">
			<xsl:text>&pt234;&pt1345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='soudain'">
			<xsl:text>&pt234;&pt145;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='souffrance'">
			<xsl:text>&pt234;&pt124;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='souffrant'">
			<xsl:text>&pt234;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='souvent'">
			<xsl:text>&pt234;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='subjectivement'">
			<xsl:text>&pt234;&pt245;&pt1236;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='subjectivitÃ©'">
			<xsl:text>&pt234;&pt245;&pt1236;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='subjectif'">
			<xsl:text>&pt234;&pt245;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='subjective'">
			<xsl:text>&pt234;&pt245;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='sujÃ©tion'">
			<xsl:text>&pt234;&pt245;&pt3456;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='sujet'">
			<xsl:text>&pt234;&pt245;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='supÃ©rieurement'">
			<xsl:text>&pt234;&pt1234;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='supÃ©rioritÃ©'">
			<xsl:text>&pt234;&pt1234;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='supÃ©rieur'">
			<xsl:text>&pt234;&pt1234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='surtout'">
			<xsl:text>&pt234;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='systÃ©matiquement'">
			<xsl:text>&pt234;&pt13456;&pt12345;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='systÃ©matique'">
			<xsl:text>&pt234;&pt13456;&pt12345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='systÃ¨me'">
			<xsl:text>&pt234;&pt13456;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='tellement'">
			<xsl:text>&pt2345;&pt123;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='tel'">
			<xsl:text>&pt2345;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='temporairement'">
			<xsl:text>&pt2345;&pt1234;&pt1235;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='temporaire'">
			<xsl:text>&pt2345;&pt1234;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='temporel'">
			<xsl:text>&pt2345;&pt1234;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='temps'">
			<xsl:text>&pt2345;&pt1234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='tenir'">
			<xsl:text>&pt2345;&pt1345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='terre'">
			<xsl:text>&pt2345;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='tes'">
			<xsl:text>&pt2345;&pt234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='tÃªte'">
			<xsl:text>&pt2345;&pt126;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='thÃ©oriquement'">
			<xsl:text>&pt2345;&pt125;&pt12345;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='thÃ©orique'">
			<xsl:text>&pt2345;&pt125;&pt12345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='thÃ©orie'">
			<xsl:text>&pt2345;&pt125;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='titre'">
			<xsl:text>&pt2345;&pt356;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='toujours'">
			<xsl:text>&pt2345;&pt245;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='toutefois'">
			<xsl:text>&pt2345;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='toute'">
			<xsl:text>&pt2345;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='tragiquement'">
			<xsl:text>&pt356;&pt1245;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='tragique'">
			<xsl:text>&pt356;&pt1245;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='trajet'">
			<xsl:text>&pt356;&pt245;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='tranquillement'">
			<xsl:text>&pt356;&pt12345;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='tranquillitÃ©'">
			<xsl:text>&pt356;&pt12345;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='tranquille'">
			<xsl:text>&pt356;&pt12345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='travailleuse'">
			<xsl:text>&pt356;&pt123;&pt234;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='travaux'">
			<xsl:text>&pt356;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='travailleur'">
			<xsl:text>&pt356;&pt123;&pt46;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='travail'">
			<xsl:text>&pt356;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='travers'">
			<xsl:text>&pt356;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='trÃ¨s'">
			<xsl:text>&pt356;&pt234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='trop'">
			<xsl:text>&pt356;&pt1234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='typiquement'">
			<xsl:text>&pt2345;&pt13456;&pt12345;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='typique'">
			<xsl:text>&pt2345;&pt13456;&pt12345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='type'">
			<xsl:text>&pt2345;&pt13456;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='une'">
			<xsl:text>&pt136;&pt1345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='uniquement'">
			<xsl:text>&pt136;&pt12345;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='unique'">
			<xsl:text>&pt136;&pt12345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='unitÃ©'">
			<xsl:text>&pt136;&pt1345;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='universalitÃ©'">
			<xsl:text>&pt136;&pt1236;&pt123;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='universellement'">
			<xsl:text>&pt136;&pt1236;&pt123;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='universel'">
			<xsl:text>&pt136;&pt1236;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='universitÃ©'">
			<xsl:text>&pt136;&pt1236;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='universitaire'">
			<xsl:text>&pt136;&pt1236;&pt2345;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='univers'">
			<xsl:text>&pt136;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='usage'">
			<xsl:text>&pt136;&pt1245;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='utilement'">
			<xsl:text>&pt136;&pt123;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='utile'">
			<xsl:text>&pt136;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='utilisation'">
			<xsl:text>&pt136;&pt123;&pt16;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='utilisateur'">
			<xsl:text>&pt136;&pt123;&pt46;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='utilisable'">
			<xsl:text>&pt136;&pt123;&pt45;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='utilitaire'">
			<xsl:text>&pt136;&pt123;&pt2345;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='inutilitÃ©'">
			<xsl:text>&pt136;&pt123;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='utilitÃ©'">
			<xsl:text>&pt136;&pt123;&pt2345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='valeur'">
			<xsl:text>&pt1236;&pt46;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='venir'">
			<xsl:text>&pt1236;&pt1345;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='vÃ©ritablement'">
			<xsl:text>&pt1236;&pt1235;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='vÃ©ritable'">
			<xsl:text>&pt1236;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='vÃ©ritÃ©'">
			<xsl:text>&pt1236;&pt123456;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='vieux'">
			<xsl:text>&pt1236;&pt1346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='vif'">
			<xsl:text>&pt1236;&pt124;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='vivement'">
			<xsl:text>&pt1236;&pt1236;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='vive'">
			<xsl:text>&pt1236;&pt1236;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='voici'">
			<xsl:text>&pt1236;&pt14;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='voilÃ '">
			<xsl:text>&pt1236;&pt123;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='volontairement'">
			<xsl:text>&pt1236;&pt135;&pt1235;&pt134;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='volontaire'">
			<xsl:text>&pt1236;&pt135;&pt1235;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='volontÃ©'">
			<xsl:text>&pt1236;&pt135;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='volontiers'">
			<xsl:text>&pt1236;&pt346;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='vos'">
			<xsl:text>&pt1236;&pt234;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='vÃ´tre'">
			<xsl:text>&pt1236;&pt1456;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='votre'">
			<xsl:text>&pt1236;&pt356;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='voyageuse'">
			<xsl:text>&pt1236;&pt1245;&pt234;&pt15;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='voyageur'">
			<xsl:text>&pt1236;&pt1245;&pt46;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='voyage'">
			<xsl:text>&pt1236;&pt1245;</xsl:text>
		</xsl:when>
		<xsl:when test="string($motMin)='vraiment'">
			<xsl:text>&pt1236;&pt134;</xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name="casGeneral">
				<xsl:with-param name="motMin" select="$motMin"/>
			</xsl:call-template>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="casGeneral">
	<xsl:param name="motMin"/>
	<xsl:call-template name="casGenTerminaison">
		<xsl:with-param name="motMin" select="$motMin"/>
	</xsl:call-template>
</xsl:template>

<xsl:template name="casGenTerminaison">
	<xsl:param name="motMin"/>
	<xsl:choose>
		<!--********** terminaisons ************* -->
		<xsl:when test="substring($motMin, string-length($motMin)-3, string-length($motMin))='ment'">
			<xsl:choose>
				<xsl:when test="substring($motMin, string-length($motMin)-7, string-length($motMin))='ablement'">
					<xsl:text>+ablement]</xsl:text>
				</xsl:when>
				<xsl:when test="substring($motMin, string-length($motMin)-7, string-length($motMin))='ellement'">
					<xsl:text>+ellement]</xsl:text>
				</xsl:when>
				<xsl:when test="substring($motMin, string-length($motMin)-10, string-length($motMin))='logiquement'">
					<xsl:text>+logiquement]</xsl:text>
				</xsl:when>
				<xsl:when test="substring($motMin, string-length($motMin)-6, string-length($motMin))='quement'">
					<xsl:text>+quement]</xsl:text>
				</xsl:when>
				<xsl:when test="substring($motMin, string-length($motMin)-5, string-length($motMin))='tement'">
					<xsl:text>+tement]</xsl:text>
				</xsl:when>
				<xsl:when test="substring($motMin, string-length($motMin)-5, string-length($motMin))='vement'">
					<xsl:text>+vement]</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>+ment]</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-2, string-length($motMin))='ait'">
			<xsl:text>+ait]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-2, string-length($motMin))='ant'">
			<xsl:text>+ant]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-4, string-length($motMin))='ation'">
			<xsl:text>+ation]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-5, string-length($motMin))='bilitÃ©'">
			<xsl:text>+bilitÃ©]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-3, string-length($motMin))='elle'">
			<xsl:text>+elle]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-2, string-length($motMin))='ent'">
			<xsl:text>+ent]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-1, string-length($motMin))='es'">
			<xsl:text>+es]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-1, string-length($motMin))='ez'">
			<xsl:text>+ez]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-4, string-length($motMin))='ition'">
			<xsl:text>+ition]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-4, string-length($motMin))='logie'">
			<xsl:text>+logie]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-6, string-length($motMin))='logique'">
			<xsl:text>+logique]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-2, string-length($motMin))='our'">
			<xsl:text>+our]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-2, string-length($motMin))='que'">
			<xsl:text>+que]</xsl:text>
		</xsl:when>
		<!-- toujours -->
		<xsl:when test="substring($motMin, string-length($motMin)-1, string-length($motMin))='ai'">
			<xsl:text>+ai]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-1, string-length($motMin))='an'">
			<xsl:text>+an]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-1, string-length($motMin))='ar'">
			<xsl:text>+ar]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-1, string-length($motMin))='au'">
			<xsl:text>+au]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-1, string-length($motMin))='ch'">
			<xsl:text>+ch]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-2, string-length($motMin))='ien'">
			<xsl:text>+ien]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-1, string-length($motMin))='en'">
			<xsl:text>+en]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-1, string-length($motMin))='er'">
			<xsl:text>+er]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-2, string-length($motMin))='eur'">
			<xsl:text>+eur]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-2, string-length($motMin))='ieu'">
			<xsl:text>+ieu]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-1, string-length($motMin))='eu'">
			<xsl:text>+eu]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-1, string-length($motMin))='gn'">
			<xsl:text>+gn]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-1, string-length($motMin))='in'">
			<xsl:text>+in]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-2, string-length($motMin))='ion'">
			<xsl:text>+ion]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-1, string-length($motMin))='oi'">
			<xsl:text>+oi]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-1, string-length($motMin))='on'">
			<xsl:text>+on]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-1, string-length($motMin))='or'">
			<xsl:text>+or]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-2, string-length($motMin))='our'">
			<xsl:text>+our]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-1, string-length($motMin))='ou'">
			<xsl:text>+ou]</xsl:text>
		</xsl:when>
		<xsl:when test="substring($motMin, string-length($motMin)-1, string-length($motMin))='qu' or substring($motMin, string-length($motMin)-2, string-length($motMin))='que'">
			<xsl:text>+qu]</xsl:text>
		</xsl:when>
		<xsl:otherwise><!-- prévoir les autres caractères --><!-- ne pas traiter les nombres, c'est déjà  fait-->
			<xsl:variable name="chaineTranslate">
				<xsl:text>&pt1;&pt12;&pt14;&pt145;&pt15;&pt124;&pt1245;&pt125;&pt24;&pt245;&pt13;&pt123;&pt134;&pt1345;&pt135;&pt1234;&pt12345;&pt1235;&pt234;&pt2345;&pt136;&pt1236;&pt2456;&pt1346;&pt13456;&pt1356;&pt3456;&pt16;&pt126;&pt146;&pt1456;&pt156;&pt1246;&pt12456;&pt1256;&pt246;&pt3;</xsl:text>
			</xsl:variable>
			<xsl:value-of select="translate(string($motMin),'abcdefghijklmnopqrstuvwxyz0123456789,',$chaineTranslate)" />
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="remplaceChaine">
   <xsl:param name="chaineAChercher"/>
   <xsl:param name="chaineOuChercher"/>
   <xsl:param name="chaineRemplacement"/>
   <xsl:choose>
     <xsl:when test="contains($chaineOuChercher,$chaineAChercher)">
        <xsl:value-of select="concat(substring-before($chaineOuChercher,$chaineAChercher),$chaineRemplacement)"/>
	<xsl:call-template name="remplaceChaine">
		<xsl:with-param name="chaineOuChercher" select="substring-after($chaineOuChercher,$chaineAChercher)"/>
		<xsl:with-param name="chaineAChercher" select="$chaineAChercher"/>
		<xsl:with-param name="chaineRemplacement" select="$chaineRemplacement"/>
	</xsl:call-template>
     </xsl:when>
     <xsl:otherwise>
       <xsl:value-of select="$chaineOuChercher"/>
     </xsl:otherwise>
   </xsl:choose>
</xsl:template>

<xsl:template name="detecteException">
	<xsl:param name="mot"/>
	<xsl:choose>
		<xsl:when test="contains(.,'merci')">
			<xsl:call-template name="remplaceChaine">
				<xsl:with-param name="chaineOuChercher" select="."/>
				<xsl:with-param name="chaineAChercher" select="'merci'"/>
				<xsl:with-param name="chaineRemplacement" select="'&pt134;&pt14;'"/>
            		</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains(.,'vous')">
			<xsl:call-template name="remplaceChaine">
				<xsl:with-param name="chaineOuChercher" select="."/>
				<xsl:with-param name="chaineAChercher" select="'vous'"/>
				<xsl:with-param name="chaineRemplacement" select="'&pt1236;'"/>
            		</xsl:call-template>
		</xsl:when>
	</xsl:choose>
</xsl:template>

</xsl:stylesheet>