<?xml version='1.0' encoding="UTF-8" ?>
<!--
 * NAT - An universal Translator
 * Copyright (C) 2005 Bruno Mascret
 * Contact: bmascret@free.fr
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
-->

<!DOCTYPE xsl:stylesheet SYSTEM "mmlents/windob.dtd">

<xsl:stylesheet version="2.0"
xmlns:xsl='http://www.w3.org/1999/XSL/Transform' 
xmlns:saxon='http://icl.com/saxon'
xmlns:m='http://www.w3.org/1998/Math/MathML'
xmlns:fn='http://www.w3.org/2005/xpath-functions'
xmlns:xs='http://www.w3.org/2001/XMLSchema'
xmlns:lit='espacelit'
xmlns:doc='espaceDoc'>

	<xsl:output method="text" encoding="UTF-8" indent="no"/>
	
	<xsl:variable name="chaine_vide" as="xs:string" select="''"/>
	<xsl:variable name="l_maj" as="xs:string">ABCDEFGHIJKLMNOPQRSTUVWXYZÀÂÉÈÊËÎÏÔÙÛÜÁÍÓÚÑÌÒÄÖ&Ccedil;&AElig;&OElig;</xsl:variable>
	<xsl:variable name="l_maj_A" as="xs:string">AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA</xsl:variable>
	<xsl:variable name="l_min" as="xs:string">abcdefghijklmnopqrstuvwxyzàâéèêëîïôùûüáíóúñìòäö&cedil;&aelig;&oelig;</xsl:variable>
	<xsl:variable name="l_min_a" as="xs:string">aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa</xsl:variable>
	<xsl:variable name="l_num" as="xs:string">0123456789+-×÷=,.&sup2;&sup3;</xsl:variable>
	<xsl:variable name="l_amb" as="xs:string">ÂÊÎÔÛËÏÜŒWâêîôûëïüœ</xsl:variable>
	<xsl:variable name="l_amb_ahat" as="xs:string">âââââââââââââââââââ</xsl:variable>
	<xsl:variable name="l_alphabet" as="xs:string">abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ</xsl:variable>
	<xsl:variable name="l_chiffres" as="xs:string">1234567890,</xsl:variable>
	<xsl:variable name="l_grec_min" as="xs:string">&alpha;&beta;&gamma;&delta;&epsi;&epsiv;&zeta;&eta;&theta;&thetav;&iota;&kappa;&lambda;&mu;&nu;&xi;&omicron;&pi;&piv;&rho;&rhov;&sigma;&sigmav;&tau;&upsilon;&phi;&phiv;&chi;&psi;&omega;</xsl:variable>
	<xsl:variable name="l_grec_maj" as="xs:string">&Agr;&Bgr;&Gamma;&Delta;&Egr;&Zgr;&EEgr;&Theta;&Igr;&Kgr;&Lambda;&Mgr;&Ngr;&Xi;&Ogr;&Pi;&Rgr;&Sigma;&Tgr;&Upsilon;&Phi;&KHgr;&Chi;&Psi;&Omega;</xsl:variable>
	<!--<xsl:variable name="l_alphanumgrec" select="fn:concat($l_alphabet,$l_chiffres,$l_grec_min,$l_grec_maj)" />-->
	<xsl:variable name="l_alphanumgrec" as="xs:string" select="concat($l_alphabet,$l_chiffres,$l_grec_min,$l_grec_maj)" />
	
	<xsl:include href="outils.xsl"/>
	
	<xsl:strip-space elements = "tableau col ligne lit phrase math" />
	
	<xsl:template match="doc:doc">
		<xsl:apply-templates select="@*|*|text()|processing-instruction()" />
	</xsl:template>
	
	<xsl:template match="tableau">
		<xsl:variable name="colMef" >
			<xsl:apply-templates/>
		</xsl:variable>
		<!-- affichage final -->
		<xsl:variable name="longLigne" as="xs:integer">
			<xsl:value-of select="string-length($colMef) div (count(col[1]/child::ligne) + 1) - count(child::col)"/>
		</xsl:variable>
		<xsl:text>&NewLine;</xsl:text>
		<xsl:choose>
			<xsl:when test="$coupons = 1 and $longLigne &gt; $longueur">
				<!-- va falloir scinder le tableau -->
				<!-- recherche de la première coupe possible -->
				<xsl:call-template name="scinderTab">
					<xsl:with-param name="tableau" select="string($colMef)"/>
					<xsl:with-param name="nbCol" select="count(child::col)"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="mefTab">
					<xsl:with-param name="tableau" select="string($colMef)"/>
					<xsl:with-param name="nbLigne" select="count(col[1]/child::ligne) + 1"/><!-- +1 pour ligne séparateur -->
					<xsl:with-param name="nbCol" select="count(child::col)"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:text>&NewLine;</xsl:text>
	</xsl:template>
	
	<xsl:template name="scinderTab">
		<xsl:param name="tableau" as="xs:string"/>
		<xsl:param name="nbCol" as="xs:integer" select="-10" />
		<!-- <xsl:param name="compte" as="xs:string" select="'CTRL '" /> -->
		<xsl:choose>
			<!-- <xsl:when test="string-length($compte) &gt; 80"><xsl:value-of select="$compte" /></xsl:when> -->
			<xsl:when test="string-length($tableau) div (count(col[1]/child::ligne) + 1) - $nbCol &gt; $longueur">
				<!--c'est pas fini; sauvegarde des entetes -->
				<xsl:variable name="entete" as="xs:string">
					<xsl:value-of select="concat(substring($tableau,1,string-length(substring-before($tableau,$coupe)) * (count(col[1]/child::ligne) + 1) + count(col[1]/child::ligne)),$coupe)"/>
				</xsl:variable>
				<xsl:variable name="pcoup" as="xs:integer">
					<xsl:call-template name="donnePositionCoupure">
						<xsl:with-param name="tableau" select="$tableau"/>
					</xsl:call-template>
				</xsl:variable>
				<!--<xsl:value-of select="$pcoup"/>-->
				<!-- affichage du début-->
				<!--<xsl:value-of select="$nbCol - string-length(translate(substring-before(substring-after($tableau,$coupe),$coupe),'&pt25;', ''))"/>-->
				<xsl:variable name="colFait" as="xs:integer">
					<xsl:value-of select="(string-length(substring($tableau,1,$pcoup * (count(col[1]/child::ligne) + 1) + count(col[1]/child::ligne))) - string-length(translate(substring($tableau,1,$pcoup * (count(col[1]/child::ligne) + 1) + count(col[1]/child::ligne)),$coupe,''))) div (count(col[1]/child::ligne) + 1)"/>
				</xsl:variable>
				<xsl:call-template name="mefTab">
					<xsl:with-param name="tableau" select="substring($tableau,1,$pcoup * (count(col[1]/child::ligne) + 1) + count(col[1]/child::ligne))"/>
					<xsl:with-param name="nbLigne" select="count(col[1]/child::ligne) + 1"/><!-- +1 pour ligne séparateur -->
					<xsl:with-param name="nbCol" select="$colFait"/>
				</xsl:call-template>
				<!-- affichage reste -->
				<xsl:text>&NewLine;</xsl:text>
				<xsl:call-template name="scinderTab">
					<xsl:with-param name="tableau" select="concat($entete,substring($tableau,$pcoup * (count(col[1]/child::ligne) + 1) + 1))"/>
					<xsl:with-param name="nbCol" select="$nbCol - $colFait + 1"/>  <!-- +1 pour entetes  -->
					<!-- <xsl:with-param name="compte" select="concat($compte,' NC', string($nbCol), ' CF', string($colFait), ' PC', string($pcoup))" /> -->
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="mefTab">
					<xsl:with-param name="tableau" select="$tableau"/>
					<xsl:with-param name="nbLigne" select="count(col[1]/child::ligne) + 1"/><!-- +1 pour ligne séparateur -->
					<xsl:with-param name="nbCol" select="$nbCol"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="donnePositionCoupure">
		<xsl:param name="tableau" as="xs:string"/>
		<!-- <xsl:param name="nbCol" as="xs:integer" select="-10" /> -->
		<xsl:param name="used" select="0" as="xs:integer"/>
		<xsl:variable name="lg"  select="string-length(substring-before($tableau,$coupe)) * (count(col[1]/child::ligne) + 1) + count(col[1]/child::ligne) +1" as="xs:integer"/>
		<xsl:choose>
			<xsl:when test="string-length(substring-before($tableau,$coupe)) + $used  + $lg &gt; $longueur">
				<xsl:value-of select="$used"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="donnePositionCoupure">
						<xsl:with-param name="tableau" select="substring($tableau,$lg + 1)"/>
						<xsl:with-param name="used" select="$used + $lg"/>
					</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	
	<xsl:template name="mefTab">
		<xsl:param name="tableau" as="xs:string"/>
		<xsl:param name="nbLigne" as="xs:integer" select="-10" />
		<xsl:param name="nbCol" as="xs:integer" select="-10"/>
		<xsl:param name="ligne" as="xs:integer" select="0"/>
		<xsl:param name="col" as="xs:integer" select="0" />
		<xsl:param name="used" as="xs:integer" select="0"/>
		<xsl:if test="$nbLigne &gt; $ligne">
			<xsl:choose>
				<xsl:when test="$nbCol &gt; $col">
					<xsl:variable name="res" as="xs:string">
						<xsl:call-template name="donneCellule">
							<xsl:with-param name="tableau" select="$tableau"/>
							<xsl:with-param name="nombre" select="$ligne + ($nbLigne * $col)"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:value-of select="$res"/>
					<xsl:call-template name="mefTab">
						<xsl:with-param name="tableau" select="$tableau"/>
						<xsl:with-param name="nbLigne" select="$nbLigne"/>
						<xsl:with-param name="nbCol" select="$nbCol"/>
						<xsl:with-param name="ligne" select="$ligne"/>
						<xsl:with-param name="col" select="$col + 1"/>
						<xsl:with-param name="used" select="string-length($res)"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<!-- on a traité toutes les colonnes de cette ligne -->
					<xsl:text>&NewLine;</xsl:text>
					<xsl:call-template name="mefTab">
						<xsl:with-param name="tableau" select="$tableau"/>
						<xsl:with-param name="nbLigne" select="$nbLigne"/>
						<xsl:with-param name="nbCol" select="$nbCol"/>
						<xsl:with-param name="ligne" select="$ligne + 1"/>
						<xsl:with-param name="col" select="0"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="donneCellule">
		<xsl:param name="nombre" as="xs:integer" select="-10"/>
		<xsl:param name="fait" as="xs:integer" select="0"/>
		<xsl:param name="tableau" as="xs:string"/>
		<xsl:choose>
			<xsl:when test="$fait &lt; $nombre">
				<xsl:call-template name="donneCellule">
					<xsl:with-param name="nombre" select="$nombre"/>
					<xsl:with-param name="fait" select="$fait + 1"/>
					<xsl:with-param name="tableau" select="substring-after($tableau,$coupe)"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise><!-- on y est!-->
				<xsl:value-of select="translate(substring-before($tableau, $coupe),'&espace;','&pt;')"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="col">
		<xsl:variable name="colonne">
			<xsl:for-each select="child::ligne">
				<xsl:apply-templates/>
				<xsl:choose>
					<xsl:when test="@b-vert=1">
						<xsl:text>&pt456;</xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>&espace;</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:value-of select="$coupe"/>
			</xsl:for-each>
		</xsl:variable>
		<!--<xsl:value-of select="translate(string($colonne),'&NewLine;&#13;&#10;', '')"/>-->
		<xsl:call-template name="largeurMax">
			<xsl:with-param name="colonne" select="translate($colonne,'&#13;&#10;&NewLine;', '')"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="largeurMax">
		<xsl:param name="colonne" as="xs:string"/>
		<xsl:param name="position" as="xs:integer" select="1"/>
		<xsl:param name="max" as="xs:integer" select="0"/>
		<!-- détection de la largeur maximale des colonnes -->
		<xsl:choose>
			<xsl:when test="$position &gt; string-length($colonne)">
				<xsl:call-template name="prepareColonne">
					<xsl:with-param name="max" select="$max"/>
					<xsl:with-param name="colonne" select="$colonne"/>
					<xsl:with-param name="hSeparateur" select="1"/>
				</xsl:call-template>
				<!--<xsl:value-of select="concat('fini:',$max)"/>-->
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="long" as="xs:integer">
					<xsl:value-of select="string-length(substring-before(substring($colonne, $position),$coupe))"/>
				</xsl:variable>
				<xsl:choose>
					<xsl:when test="$long &gt; $max">
						<xsl:call-template name="largeurMax">
							<xsl:with-param name="colonne" select="$colonne"/>
							<xsl:with-param name="position" select="$position + $long + 1"/>
							<xsl:with-param name="max" select="$long"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="largeurMax">
							<xsl:with-param name="colonne" select="$colonne"/>
							<xsl:with-param name="position" select="$position + $long + 1"/>
							<xsl:with-param name="max" select="$max"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="prepareColonne">
		<xsl:param name="max" as="xs:integer" select="-10" />
		<xsl:param name="colonne" as="xs:string" />
		<xsl:param name="hSeparateur" as="xs:integer" select="-10" /><!-- = 1 ligne à ajouter -->
		<!-- largeur max pour chaque élément de la colonne -->
		<xsl:if test="not(string-length($colonne) = 0)">
			<xsl:variable name="col" as="xs:string">
				<xsl:value-of select="substring-before($colonne, $coupe)"/>
			</xsl:variable>
			<xsl:value-of select="substring($col,1,string-length($col)-1)"/>
			<xsl:call-template name="rempli">
				<xsl:with-param name="nb" select="$max - string-length($col)" />
				<xsl:with-param name="motif" select="'&pt;'"/>
			</xsl:call-template>
			<xsl:value-of select="substring($col,string-length($col))"/>
			<!--<xsl:value-of select="concat('&pt456;',$coupe)"/>-->
			<xsl:value-of select="$coupe"/>
			<xsl:if test="$hSeparateur = 1">
				<xsl:call-template name="rempli">
					<xsl:with-param name="nb" select="$max -1"/>
					<xsl:with-param name="motif" select="'&pt25;'"/>
				</xsl:call-template>
				<xsl:value-of select="concat('&pt2456;',$coupe)"/>
			</xsl:if>
			<xsl:call-template name="prepareColonne">
				<xsl:with-param name="max" select="$max"/>
				<xsl:with-param name="colonne" select="substring-after($colonne, $coupe)"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="rempli">
		<xsl:param name="nb" select="-10" as="xs:integer"/>
		<xsl:param name="motif" as="xs:string"/>
		<xsl:if test="$nb &gt; 0">
			<xsl:value-of select="$motif"/>
			<xsl:call-template name="rempli">
				<xsl:with-param name="nb" select="$nb - 1"/>
				<xsl:with-param name="motif" select="$motif"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="phrase">
		<xsl:variable name="expr">
			<xsl:apply-templates />
		</xsl:variable>
		<!--<xsl:text>&NewLine;Mon expr:</xsl:text>
		<xsl:value-of select="$expr"/>-->
		<xsl:variable name="phraseSansEspaceMath">
			<xsl:choose>
				<xsl:when test="$coupons = 1">
					<!-- il faut couper; on sauve le résultat de la transcription dans une variable -->
					<xsl:call-template name="coupure">
						<!-- ajout d'un espace en fin de phrase (il sera supprimé) pour ne pas avoir à tester partout dans coupure si le mot est le dernier de la phrase -->
						<!-- remplacement des $coupeEsth par $coupe en attendant de les traiter -->
						<!--<xsl:with-param name="phrase" select="concat(translate($expr,$coupeEsth,$coupe),' ')"/>-->
						<xsl:with-param name="phrase" select="concat(string($expr),' ')"/>
						<xsl:with-param name="premier" select="1"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<!-- on applique directement les templates -->
					<xsl:value-of select="translate(string($expr), concat($coupeEsth,$coupe,$debMath,$finMath), '')"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:value-of select="translate(string($phraseSansEspaceMath),$espace,' ')"/>
		<xsl:text>&NewLine;</xsl:text><!--&#13;&#10;</xsl:text>-->
	</xsl:template>
	
	<!-- ****** FONCTION de COUPURE *********** -->
	<!-- ne pas oublier dans les calculs de longueur que si on coupe, il faudra ajouter un caractère de coupure braille (pt5) -->
	<xsl:template name="coupure">
		<xsl:param name="phrase" as="xs:string"/>
		<xsl:param name="used" select="0" as="xs:integer"/>
		<xsl:param name="premier" select="0" as="xs:integer"/>
		<xsl:param name="debPhrase" select="0" as="xs:integer"/>
		<xsl:variable name="carcoup" as="xs:string" select="concat($coupeEsth,$coupe,$debMath,$finMath)"/>
		<xsl:variable name="carcoupmath" select="concat($debMath,$finMath)" as="xs:string"/>
		<!--<xsl:param name="pareil" select='O'/>-->
		<xsl:variable name="longMot" as="xs:integer">
			<xsl:value-of select="string-length(substring-before($phrase, ' '))"/>
		</xsl:variable>
		<xsl:variable name="longMotSansCoup" as="xs:integer">
			<xsl:value-of select="string-length(translate(substring-before($phrase, ' '),$carcoup,''))"/>
		</xsl:variable>
		<!-- pour les tests -->
		<!--<xsl:value-of select='$phrase'/>-->
		<!--<xsl:value-of select="concat('lgMot:',$longMot,' longMotSansCoup:',$longMotSansCoup, ' utilisé:',$used)"/>
		<xsl:text>&NewLine;</xsl:text>
		
		
		<xsl:text>yo:</xsl:text>
		<xsl:value-of select="translate(substring-before($phrase, ' '),$coupe,'')"/>
		<xsl:text>:yo</xsl:text>
		<xsl:text>coupure:</xsl:text>-->
		<xsl:choose>
			<xsl:when test="$longMotSansCoup = 0"/><!-- c'est fini! -->
			<xsl:when test="$used = $longueur">
				<!-- il n'y a plus de place -->
				<xsl:text>&NewLine;</xsl:text>
				<xsl:call-template name="coupure">
					<xsl:with-param name="phrase" select="$phrase"/>
					<xsl:with-param name="premier" select="1"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$longMotSansCoup = $longueur - $used">
				<xsl:value-of select="translate(substring-before($phrase, ' '),$carcoup,'')"/>
				<xsl:if test="string-length(substring-after($phrase,' '))&gt;0">
					<xsl:text>&NewLine;</xsl:text>
					<xsl:call-template name="coupure">
						<xsl:with-param name="phrase" select="substring-after($phrase,' ')"/>
						<xsl:with-param name="premier" select="1"/>
					</xsl:call-template>
				</xsl:if>
				<!--<xsl:text>&NewLine;</xsl:text>
				<xsl:call-template name="coupure">
					<xsl:with-param name="phrase" select="substring-after($phrase, ' ')"/>
					<!-<xsl:with-param name="used" select="$longueur"/>->
				</xsl:call-template>-->
			</xsl:when>
			<xsl:when test="$longMotSansCoup &lt; $longueur - $used + 1">
				<xsl:value-of select="translate(substring-before($phrase, ' '),$carcoup,'')"/>
				<xsl:text>&pt;</xsl:text>
				<xsl:call-template name="coupure">
					<xsl:with-param name="phrase" select="substring-after($phrase, ' ')"/>
					<xsl:with-param name="used" select="$used+$longMotSansCoup+1"/>
					<xsl:with-param name="premier" select="1"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<!-- il va falloir couper 
				<xsl:text>&NewLine;Phrase:</xsl:text>
				<xsl:value-of select="$phrase"/>
				<xsl:text>&NewLine;Début:</xsl:text>
				<xsl:value-of select="substring($phrase,1,1)"/>-->
				<xsl:choose>
					<!-- cas particulier d'une expression mathématique qui tient sur une ligne sans coupure-->
					<xsl:when test="$premier=1 and substring($phrase,1,1)=$debMath and $longueur - $longMotSansCoup &gt; -1">
						<xsl:text>&NewLine;</xsl:text>
						<xsl:variable name="mathligne" as="xs:string" select="translate(substring-before($phrase, ' '),$carcoup,'')"/>
						<xsl:value-of select="$mathligne"/>
						<xsl:choose>
							<xsl:when test="not($longueur - string-length($mathligne)= 0)">
								<xsl:text>&pt;</xsl:text>
								<xsl:call-template name="coupure">
									<xsl:with-param name="phrase" select="substring-after($phrase,' ')"/>
									<xsl:with-param name="used" select="string-length($mathligne)+1"/>
									<xsl:with-param name="premier" select="1"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<!--<xsl:text>&NewLine;</xsl:text>
								<xsl:value-of select="concat($longueur, ' ', $mathligne)"/>-->
								<xsl:if test="string-length(substring-after($phrase,' '))&gt;0">
									<xsl:text>&NewLine;</xsl:text>
									<xsl:call-template name="coupure">
										<xsl:with-param name="phrase" select="substring-after($phrase,' ')"/>
										<xsl:with-param name="premier" select="1"/>
									</xsl:call-template>
								</xsl:if>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<!-- cas particulier d'une expression mathématique qui ne tient pas sur une ligne sans coupure et qui contient des caractères de coupure esthétique-->
					<xsl:when test="substring($phrase,1,1)=$debMath and contains(substring-before($phrase, $finMath),$coupeEsth)">
						<!--<xsl:text>&NewLine;YO</xsl:text>
						<xsl:value-of select="$phrase"/>
						<xsl:text>&NewLine;</xsl:text>-->
						
						<xsl:variable name="mathligne" as="xs:string" select="translate(substring-before($phrase, $finMath),$carcoupmath,'')"/>
						<xsl:variable name="teteExpr" as="xs:string" select="translate(substring-before($mathligne, $coupeEsth),$coupe,'')"/>
						<xsl:variable name="finExpr" as="xs:string" select="translate(substring-after($mathligne, $coupeEsth),$coupe,'')"/>
						<!--<xsl:value-of select="$mathligne"/>-->
						<xsl:choose>
							<!-- il y a une coupure esthétique possible avant la fin de la ligne -->
							<xsl:when test="$longueur - $used - string-length($teteExpr) &gt; 0">
								<xsl:choose>
									<!-- il y a une coupure esthétique possible après celle-ci-->
									<xsl:when test="contains($finExpr,$coupeEsth) and $longueur - $used - string-length($teteExpr) - string-length(substring-before($finExpr,$coupeEsth)) &gt; 0">
										<!--<xsl:text>&NewLine;OUIOUIOUIOUIOUI&NewLine;</xsl:text>
										<xsl:value-of select="concat($phrase,' ',$mathligne,' ',translate(substring-before($mathligne, $coupeEsth),$coupe,''),' ',translate(substring-before(substring-after($mathligne, $coupeEsth),$coupeEsth),$coupe,''))"/>
										<xsl:text>&NewLine;OUIOUIOUIOUIOUI&NewLine;</xsl:text>-->
										<xsl:value-of select="$teteExpr"/>
										<xsl:call-template name="coupure">
											<xsl:with-param name="phrase" select="concat($debMath,substring-after($phrase,$coupeEsth))"/>
											<xsl:with-param name="used" select="$used + string-length(translate(substring-before($mathligne, $coupeEsth),$coupe,''))"/>
										</xsl:call-template>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$teteExpr"/>
										<!-- on est sur la seule coupure esthetique possible, mais est-ce qu'on l'applique?
										oui si l'expression ne tient pas sur plus de lignes avec cette coupure et qu'on pourra couper proprement
										OU qu'il n'y a pas de possibilité de couper autrement que par sagouin sur une ligne-->
										<xsl:choose>
											<xsl:when test="not(string-length($finExpr) &gt; $longueur and ( contains(substring(translate(substring-after($phrase,$coupeEsth),$coupe,$coupeEsth),1,$longueur - $used - string-length($teteExpr)),$coupeEsth) or string-length(substring($finExpr,1,$longueur)) = string-length(substring(substring-after($phrase,$coupeEsth), 1, $longueur))))">
												<xsl:text>&pt5;&NewLine;</xsl:text>
												<xsl:call-template name="coupure">
													<xsl:with-param name="phrase" select="concat($debMath,substring-after($phrase,$coupeEsth))"/>
												</xsl:call-template>
											</xsl:when>
											<xsl:otherwise>
												<xsl:call-template name="coupure">
													<xsl:with-param name="phrase" select="concat($debMath,substring-after($phrase,$coupeEsth))"/>
													<xsl:with-param name="used" select="$used+string-length($teteExpr)"/>
												</xsl:call-template>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:when test="contains(substring($phrase,1,$longueur - $used + 1),$coupe)">
								<!-- remplacement des car de coupe par des coupes esthétiques sur la longueur qui reste-->
								<xsl:call-template name="coupure">
									<xsl:with-param name="phrase" select="concat(translate(substring($phrase,1,$longueur - $used + 1),$coupe,$coupeEsth),substring($phrase,$longueur - $used + 2))"/>
									<xsl:with-param name="used" select="$used"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:when test="not(contains(substring($mathligne, 1, $longueur - 1),$coupeEsth) or contains(substring($phrase, 2, $longueur),$coupe))">
								<!-- il n'y a pas possibilité de couper l'expression proporement même en passant à la ligne car elle est trop longue -->
								<!-- sagouin! -->
								<xsl:value-of select="substring($mathligne,1,$longueur - $used - 1)"/>
								<xsl:text>&pt5;&NewLine;</xsl:text><!--
								<xsl:call-template name="coupure">
									<xsl:with-param name="phrase" select="substring($phrase,string-length(substring($mathligne,1,$longueur - $used - 1))+1,string-length"/>
								</xsl:call-template>-->
							</xsl:when>
							<xsl:otherwise><!--on passe à la ligne en espérant pouvoir couper-->
								<xsl:if test="not($premier = 1)">
									<xsl:text>&pt5;</xsl:text>
								</xsl:if>
								<xsl:text>&NewLine;</xsl:text>
								<xsl:call-template name="coupure">
									<xsl:with-param name="phrase" select="$phrase"/>
									<xsl:with-param name="premier" select="1"/>
								</xsl:call-template>
							</xsl:otherwise>
							<!--
							<xsl:when test="not($longueur - string-length($mathligne)= 0)">
								<xsl:text>&pt;</xsl:text>
								<xsl:call-template name="coupure">
									<xsl:with-param name="phrase" select="substring-after($phrase,' ')"/>
									<xsl:with-param name="used" select="string-length($mathligne)+1"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>&NewLine;</xsl:text>
								<xsl:value-of select="concat($longueur, ' ', $mathligne)"/>
								<xsl:if test="string-length(substring-after($phrase,' '))&gt;0">
									<xsl:text>&NewLine;</xsl:text>
									<xsl:call-template name="coupure">
										<xsl:with-param name="phrase" select="substring-after($phrase,' ')"/>
									</xsl:call-template>
								</xsl:if>
							</xsl:otherwise>-->
						</xsl:choose>
					</xsl:when>
					<!-- il n'y a pas de caractere de coupe -->
					<xsl:when test="not(contains(substring-before($phrase, ' '),$coupe))">
						<xsl:choose>
							<xsl:when test="$sagouin = 1 and $longueur - $used &gt; 1">
								<xsl:value-of select="substring(translate($phrase,$carcoup,''), 0,$longueur - $used)"/>
								<xsl:text>&pt5;&NewLine;</xsl:text>
								<xsl:call-template name="coupure">
									<xsl:with-param name="phrase" select="substring($phrase, $longueur - $used)"/>
								</xsl:call-template>
							</xsl:when>
							<!-- ça ne tient pas de toute façon -->
							<xsl:when test="$longueur &lt; string-length(substring-before(translate($phrase,$carcoup,''), ' '))">
								<xsl:value-of select="substring(translate($phrase,$carcoup,''), 0,$longueur - $used)"/>
								<xsl:text>&pt5;&NewLine;</xsl:text>
								<xsl:call-template name="coupure">
									<xsl:with-param name="phrase" select="substring($phrase, $longueur - $used)"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>&NewLine;</xsl:text>
								<xsl:call-template name="coupure">
									<xsl:with-param name="phrase" select="$phrase"/>
									<xsl:with-param name="premier" select="1"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<!-- on peut couper le mot avant la fin de la ligne -->
					<xsl:when test="string-length(substring-before(translate($phrase,$carcoupmath,''),$coupe)) + $used &lt; $longueur ">
						<!-- si le premier caractère de coupure est le bon, on coupe, sinon on écrit ce qu'on peut et on appelle de nouveau le template -->
						<xsl:value-of select="substring-before(translate($phrase,$carcoupmath,''),$coupe)"/>
						<xsl:choose>
							<!-- on peut couper plus loin -->
							<xsl:when test="string-length(substring-before(substring-after(translate($phrase,$carcoupmath,''),$coupe),$coupe)) + $used + string-length(substring-before(translate($phrase,$carcoupmath,''),$coupe)) &lt; $longueur and string-length(substring-before(substring-after(translate($phrase,$carcoupmath,''),$coupe),$coupe)) &gt; 0">
								<xsl:call-template name="coupure">
									<xsl:with-param name="phrase" select="substring-after($phrase,$coupe)"/>
									<xsl:with-param name="used" select="$used + string-length(substring-before(translate($phrase,$carcoupmath,''),$coupe))"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<!-- la coupure détectée est la meilleure -->
								<xsl:text>&pt5;&NewLine;</xsl:text>
								<xsl:call-template name="coupure">
									<xsl:with-param name="phrase" select="substring-after($phrase,$coupe)"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<!-- on ne peut pas couper le mot avant la fin de la ligne -->
					<xsl:otherwise>
						<!-- la première coupure du mot tiendrait-il sur une ligne? -->
						<xsl:choose>
							<!--oui: on saute une ligne-->
							<xsl:when test="string-length(substring-before(translate($phrase,$carcoupmath,''),$coupe)) &lt; $longueur">
								<xsl:text>&NewLine;</xsl:text>
								<xsl:call-template name="coupure">
									<xsl:with-param name="phrase" select="$phrase"/>
								</xsl:call-template>
							</xsl:when>
							<!-- non: sagouin!-->
							<xsl:otherwise>
								<xsl:value-of select="substring(translate($phrase,$carcoupmath,''), 0,$longueur - $used)"/>
								<xsl:text>&pt5;&NewLine;</xsl:text>
								<xsl:call-template name="coupure">
									<xsl:with-param name="phrase" select="substring($phrase, $longueur - $used)"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
		<!--<xsl:value-of select="concat('zob', $phrase)"/>-->
	</xsl:template>

	<xsl:template name="espace">
		<xsl:param name="position" select="1" as="xs:integer" />
		<xsl:choose>
			<!--<xsl:when test="not(following::*[1]=text() or following::*[1]=node())">
			</xsl:when>-->
			<!--<xsl:when test="string(following::*[$position]) ='' or local-name(following::*[$position])='lit'">-->
			<xsl:when test="local-name(following::*[$position])='lit' or following::*[$position][not(string(.))]">
				<xsl:call-template name="espace">
					<xsl:with-param name="position" select="$position + 1"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="following::*[$position]='-' and local-name(following::*[$position+1])='ponctuation'"/>
			<xsl:when test="local-name(following::*[$position])='mot' or local-name(following::*[$position])='math' or following::*[$position]='-'">
				<xsl:if test="not(following::*[$position]/@attr='exp' or following::*[$position]/@attr='ind' or 
					(.='&quot;' and (count(preceding-sibling::ponctuation[.='&quot;']) mod 2)=0))">
					<xsl:text>&pt;</xsl:text>
				</xsl:if>
			</xsl:when>
			<!-- espaces avec les pponctuations -->
			<xsl:when test="local-name(following::*[$position])='ponctuation'">
				<xsl:if test="contains('¡¿([{«“‘&lsquo;',following::*[$position])" >
					<xsl:text>&pt;</xsl:text>
				</xsl:if>
				<!--  cas particulier des guillements non orientés -->
				<xsl:if test="following::*[$position]='&quot;'">
					<xsl:variable name="ouvrant" as="xs:integer">
						<xsl:value-of select="count(preceding-sibling::ponctuation[.='&quot;']) mod 2"/>
					</xsl:variable>
					<!-- Espace si le nombre de guillements précédents est pair (ouverture) -->
					<xsl:if test="$ouvrant = 0">
						<xsl:text>&pt;</xsl:text>
					</xsl:if>
				</xsl:if>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
