/************************************************************************
 *
 *  GraphicConverter.java
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *  Copyright: 2002-2007 by Henrik Just
 *
 *  All Rights Reserved.
 * 
 *  Version 0.4.1e (2007-02-23) 
 *
 */
 
package writer2latex.api;

//import java.io.InputStream;
//import java.io.OutputStream;

/** A simple interface for a graphic converter which converts between various
 *  graphics formats
 */
public interface GraphicConverter {
    
    /** Check whether a certain graphics format is supported by the converter
     *  @param sMime a string containing the Mime type
     *  @return true if the format is supported 
     */
    public boolean supportsFormat(String sMime);
	
    /** Convert a graphics file from one format to another
     *  @param source a byte array containing the source graphic
     *  @param sSourceMime a string containing the Mime type of the source
     *  @param sTargetMime a string containing the desired Mime type of the target
     *  @return a byte array containing the converted graphic. Returns null
     *  if the conversion failed. 
     */
    public byte[] convert(byte[] source, String sSourceMime, String sTargetMime);

}



