/*
 * NAT - An universal Translator
 * Copyright (C) 2005 Bruno Mascret
 * Contact: bmascret@free.fr
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

package ui;
/* 
 * d'après http://brassens.upmf-grenoble.fr/IMSS/dciss/Enseignements/PSR/Prog/Java/dialogueFichier.htm
 */

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class FiltreFichier extends FileFilter 
{
    String []lesSuffixes;
    String  laDescription;

   public FiltreFichier(String []lesSuffixes, String laDescription)
   {
        this.lesSuffixes = lesSuffixes;
        this.laDescription = laDescription;
   }
   
   //Méthodes d'accès
   // la description du filtre
   public String getDescription() 
   {
       return laDescription;
   }

   boolean Appartient( String suffixe )
   {
	   boolean retour = false;
      for( int i = 0; i<lesSuffixes.length; ++i)
      {
          if(suffixe.equals(lesSuffixes[i])) retour = true;
      }
      return retour;
   }
// implémentation des méthodes abstraites héritéés
 public boolean accept(File f) 
 {
	 boolean retour = false;
     if (f.isDirectory()) 
     {
         retour = true;
     }
     else
     {
    	 String suffixe = null;
    	 String s = f.getName();
    	 int i = s.lastIndexOf('.');
    	 if (i > 0 &&  i < s.length() - 1) 
    	 {
    		 suffixe = s.substring(i+1).toLowerCase();
    	 }
    	 retour = suffixe != null && Appartient(suffixe);
     }
     return retour;
 }
}