/*
 * NAT - An universal Translator
 * Copyright (C) 2005 Bruno Mascret
 * Contact: bmascret@free.fr
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

package ui;

import gestionnaires.GestionnaireMajTabBraille;

import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.JPanel;
import javax.swing.JButton;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
//import javax.swing.ImageIcon;

import nat.ConfigNat;

public class Configuration extends JFrame implements ActionListener, WindowListener
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private JTabbedPane onglets = new JTabbedPane();
	private ConfGeneral panGen;
	private ArrayList<OngletConf> listOnglets = new ArrayList<OngletConf>();
	private JLabel lTitreConfig = new JLabel ("<html><h3>Edition de la configuration : "+ConfigNat.getCurrentConfig().getShortFichierConf() + "</h3></html>");
	private JPanel lesBoutons = new JPanel();
	private JButton btAnnuler = new JButton("Annuler",new ImageIcon("ui/icon/edit-undo.png"));
	private JButton btEnregistrer = new JButton("Enregistrer",new ImageIcon("ui/icon/document-save.png"));
	private JButton btEnregistrerSous = new JButton("Enregistrer sous...",new ImageIcon("ui/icon/document-save-as.png"));
	//private JTextField jtfConfig;
	//private ConfigNat confNat;
	private FenetrePrinc fPrinc;
	private GestionnaireMajTabBraille gmtb;
	
	public Configuration(FenetrePrinc fp)
	{
		super("Configuration de NAT");//+ConfigNat.getCurrentConfig().getShortFichierConf());
		fPrinc = fp;
		addWindowListener(this);
		//this.confNat = confNat;
		ConfEmbossage panConfEmbossage = new ConfEmbossage();
		panGen = new ConfGeneral(this);
		
		listOnglets.add(panConfEmbossage);
		listOnglets.add(new ConfConversion());
		listOnglets.add(new ConfTranscription());
		listOnglets.add(new ConfPostTraitement());//,this);
		listOnglets.add(new ConfInterface(this));
		listOnglets.add(new ConfAvance());
		listOnglets.add(panGen);

		//ImageIcon icon = createImageIcon("images/middle.gif");
		
		gmtb = new GestionnaireMajTabBraille (panGen.getComboTables(), panConfEmbossage.getComboTables());
		onglets.addTab("Général",new ImageIcon("ui/icon/document-properties.png"),panGen,"Regroupe les options de configuration les plus génériques");
		onglets.addTab("Transcription",new ImageIcon("ui/icon/stock_script.png"),listOnglets.get(2),"Regroupe les options pour un paramétrage fin de la transcription");
		onglets.addTab("Embossage",new ImageIcon("ui/icon/stock_print-setup.png"),panConfEmbossage,"Regroupe les options pour l'embossage");
		onglets.addTab("Interface",new ImageIcon("ui/icon/gnome-settings-ui-behavior.png"),listOnglets.get(4),"Regroupe les options de configuration de l'interface graphique");
		onglets.addTab("Avancé",new ImageIcon("ui/icon/stock_form-properties.png"),listOnglets.get(5),"Regroupe les réglages techniques avancés de NAT");
		
		onglets.setEnabledAt(1, true);
		onglets.setEnabledAt(2, true);
		onglets.setEnabledAt(3, true);
		onglets.setEnabledAt(4, true);
//		onglets.addTab("Conversion",new ImageIcon("ui/icon/stock_filter-data-by-criteria.png"),listOnglets.get(1),"Regroupe les options des convertisseurs");
		
		btAnnuler.addActionListener(this);
		btAnnuler.getAccessibleContext().setAccessibleName("Bouton annuler");
		btAnnuler.getAccessibleContext().setAccessibleDescription("Valider pour annuler les modifications et fermer la fenêtre");
		btAnnuler.setToolTipText("Annuler et fermer la fenêtre");
		btAnnuler.setMnemonic('z');
		
		btEnregistrer.addActionListener(this);
		btEnregistrer.getAccessibleContext().setAccessibleName("Bouton enregistrer");
		btEnregistrer.getAccessibleContext().setAccessibleDescription("Valider pour enregister les modifications et fermer la fenêtre");
		btEnregistrer.setToolTipText("Enregister et fermer la fenêtre");
		btEnregistrer.setMnemonic('s');
		
		btEnregistrerSous.addActionListener(this);
		btEnregistrerSous.getAccessibleContext().setAccessibleName("Bouton enregistrer sous");
		btEnregistrerSous.getAccessibleContext().setAccessibleDescription("Valider pour enregistrer la configuration sous un nouveau nom");
		btEnregistrerSous.setToolTipText("Enregistrer la configuration sous un nouveau nom");
		btEnregistrerSous.setMnemonic('n');
		
		//jtfConfig = new JTextField(nomConf, 10);
		//jtfConfig.getAccessibleContext().setAccessibleName("Champ de saisie nom configuration");
		//jtfConfig.getAccessibleContext().setAccessibleDescription("Entrer le nom de la nouvelle configuration puis activer le bouton enregistrer sous");
		//jtfConfig.setToolTipText("Entrer le nom de la nouvelle configuration");
		
		lesBoutons.add(btEnregistrer);
		lesBoutons.add(btEnregistrerSous);
		//lesBoutons.add(jtfConfig);
		lesBoutons.add(btAnnuler);
		add("North", lTitreConfig);
		add("Center",onglets);
		add("South",lesBoutons);
		//setSize(new Dimension(470,600));
		pack();
		if(ConfigNat.getCurrentConfig().getCentrerFenetre())
		{
			Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
			Dimension size = this.getPreferredSize();
			screenSize.height = screenSize.height/2;
			screenSize.width = screenSize.width/2;
			size.height = size.height/2;
			size.width = size.width/2;
			int y = screenSize.height - size.height;
			int x = screenSize.width - size.width;
			setLocation(x, y);
		}

	}
	
	public GestionnaireMajTabBraille getGmtb ()
	{
		return gmtb ;
	}
	
	public void dispose()
	{
		super.dispose();
		fPrinc.setOptionsOuvertes(false);
	}
	public void actionPerformed(ActionEvent evt)
	{
		if (evt.getSource() == btAnnuler)
		{
			this.dispose();
			try
			{
				this.finalize();
			}
			catch (Throwable e){e.printStackTrace();}
		}
		else if (evt.getSource() == btEnregistrer)
		{
			//System.out.println("Editeur de configuration en développement");
			if (saveAll())
			{
				//ajout de la nouvelle conf
				//ConfigNat.getCurrentConfig().setFichierConf("configurations/" + jtfConfig.getText() + ".cfg");
				ConfigNat.getCurrentConfig().sauvegarder();
				fPrinc.chargeConfigurations();
				this.dispose();
				try
				{
					this.finalize();
				}
				catch (Throwable e){e.printStackTrace();}
			}
		}
		else if(evt.getSource()==btEnregistrerSous)
		{			
			String nomConf = ConfigNat.getCurrentConfig().getShortFichierConf();
			//on demande le nom de la nouvelle config
			String nomNewConf = (String)JOptionPane.showInputDialog(
                    this,
                    "Nom de la nouvelle configuration :",
                    "Conf. actuelle : "+nomConf,
                    JOptionPane.PLAIN_MESSAGE,null,null,
                    nomConf);
			
		    //on vérifie qu'elle n'existe pas déjà
			int reponse = JOptionPane.YES_OPTION ;
			if ((new File("./configurations/"+nomNewConf+".cfg").exists()) && (nomNewConf != null))
			{
			reponse = JOptionPane.showConfirmDialog(
				    this,
				    "La configuration\n"+nomNewConf+"\nexiste déjà,\nvoulez-vous l'écraser ?",
				    "Confirmation",
				    JOptionPane.YES_NO_OPTION);
			}

		    if ((nomNewConf != null) && (nomNewConf.length() > 0) && (reponse == JOptionPane.YES_OPTION))
		    {    
			    ConfigNat.getCurrentConfig().setFichierConf("configurations/" + nomNewConf + ".cfg");
				
				if (saveAll())
				{
					ConfigNat.getCurrentConfig().sauvegarder();
					fPrinc.chargeConfigurations();//ajout de la nouvelle conf
					this.dispose();
					try
					{
						this.finalize();
					}
					catch (Throwable e){e.printStackTrace();}
				}
		    }
		}
	}

	public void windowActivated(WindowEvent arg0) {}
	public void windowClosed(WindowEvent arg0) {}
	public void windowClosing(WindowEvent arg0) {fPrinc.setOptionsOuvertes(false);}
	public void windowDeactivated(WindowEvent arg0) {}
	public void windowDeiconified(WindowEvent arg0) {}
	public void windowIconified(WindowEvent arg0) {}
	public void windowOpened(WindowEvent arg0) {}
	
	private boolean saveAll()
	{
		boolean retour = true;
		int i= 0;
		while(i<listOnglets.size()&&retour)
		{
			retour = listOnglets.get(i).enregistrer();
			i++;
		}
		return retour;
	}

}
