/*
 * NAT - An universal Translator
 * Copyright (C) 2005 Bruno Mascret
 * Contact: bmascret@free.fr
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

package ui;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

import nat.ConfigNat;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;



public class ConfTranscription extends OngletConf implements ItemListener, ActionListener
{

	/**
	 * Inutilisé pour l'instant; contiendra les options détaillées de configuration de la transcription
	 */
	private static final long serialVersionUID = 1L;
	private JButton jbtTout = new JButton("Tout activer");
	private JButton jbtRien = new JButton("Ne rien activer");
	private JCheckBox jchbMajDouble = new JCheckBox("Utiliser le double préfixe pour les mots entièrement en majuscule");
	private JCheckBox jchbMajPassage = new JCheckBox("Prendre en compte les passages en majuscules");
	private JCheckBox jchbMajMots = new JCheckBox("Prendre en compte les mélanges de minuscules et majuscules dans un mot");
	
	private JCheckBox jchbEviMot = new JCheckBox("Signaler la mise en évidence d'un mot");
	private JCheckBox jchbEviPassage = new JCheckBox("Prendre en compte les passages mis en évidence");
	private JCheckBox jchbEviDansMot = new JCheckBox("Prendre en compte les mises en évidence à l'interieur d'un mot");
	private JCheckBox jchbMathsTrigoSpec = new JCheckBox("Utiliser la notation trigonométrique spécifique");
	
	
	public ConfTranscription()
	{
		super();
		
		/**********
		 * Préparation des composants
		 */
	    
		jbtTout.getAccessibleContext().setAccessibleName("Bouton utiliser toutes les règles complémentaires du litéraire");
		jbtTout.getAccessibleContext().setAccessibleDescription("Validez si vous souhaitez activer toutes les règles complémentaires en litéraire");
		jbtTout.setToolTipText("Validez si vous souhaitez activer toutes les règles complémentaires en litéraire");
		jbtTout.setMnemonic('t');
		jbtTout.addActionListener(this);
		
		jbtRien.getAccessibleContext().setAccessibleName("Bouton n'utiliser aucune des règles complémentaires du litéraire");
		jbtRien.getAccessibleContext().setAccessibleDescription("Validez si vous souhaitez désactiver toutes les règles complémentaires en litéraire");
		jbtRien.setToolTipText("Validez si vous souhaitez désactiver toutes les règles complémentaires en litéraire");
		jbtRien.setMnemonic('r');
		jbtRien.addActionListener(this);
		
		jchbMajDouble.getAccessibleContext().setAccessibleName("Case à cocher utiliser le double préfixe majuscule pour les mots entièrement en majuscule");
		jchbMajDouble.getAccessibleContext().setAccessibleDescription("Cochez cette case si vous souhaitez activer le double préfixe majuscule pour les mots entièrement en majuscule");
		jchbMajDouble.setToolTipText("Cochez cette case si vous souhaitez activer le double préfixe majuscule pour les mots entièrement en majuscule");
		jchbMajDouble.setMnemonic('d');
		jchbMajDouble.setSelected(ConfigNat.getCurrentConfig().getLitMajDouble());  
		jchbMajDouble.addItemListener(this);
	  
		jchbMajPassage.getAccessibleContext().setAccessibleName("Case à cocher préfixer les passages en majuscule");
		jchbMajPassage.getAccessibleContext().setAccessibleDescription("Cochez cette case si vous souhaitez activer le préfixage des passages en majuscule");
		jchbMajPassage.setToolTipText("Cochez cette case si vous souhaitez activer le préfixage des passages en majuscule");
		jchbMajPassage.setMnemonic('p');
		jchbMajPassage.setSelected(ConfigNat.getCurrentConfig().getLitMajPassage());    
		jchbMajPassage.addItemListener(this);
		
		jchbMajMots.getAccessibleContext().setAccessibleName("Case à cocher prendre en compte les mélanges de minuscules et majuscules dans un mot");
		jchbMajMots.getAccessibleContext().setAccessibleDescription("Cochez cette case si vous souhaitez prendre en compte les mélanges de minuscules et majuscules dans un mot");
		jchbMajMots.setToolTipText("Cochez cette case si vous souhaitez prendre en compte les mélanges de minuscules et majuscules dans un mot");
		jchbMajMots.setMnemonic('m');
		jchbMajMots.setSelected(ConfigNat.getCurrentConfig().getLitMajMelange());	    
		jchbMajMots.addItemListener(this);
		
		jchbEviMot.getAccessibleContext().setAccessibleName("Case à cocher prendre en compte les mots mis en évidence");
		jchbEviMot.getAccessibleContext().setAccessibleDescription("Cochez cette case si vous souhaitez prendre en compte les mots mis en évidence");
		jchbEviMot.setToolTipText("Cochez cette case si vous souhaitez prendre en compte les mots mis en évidence");
		jchbEviMot.setMnemonic('v');
		jchbEviMot.setSelected(ConfigNat.getCurrentConfig().getLitEvidenceMot());	    
		jchbEviMot.addItemListener(this);
		
		jchbEviPassage.getAccessibleContext().setAccessibleName("Case à cocher prendre en compte les passages en évidence");
		jchbEviPassage.getAccessibleContext().setAccessibleDescription("Cochez cette case si vous souhaitez prendre en compte les passages en évidence");
		jchbEviPassage.setToolTipText("Cochez cette case si vous souhaitez prendre en compte les passages en évidence");
		jchbEviPassage.setMnemonic('e');
		jchbEviPassage.setSelected(ConfigNat.getCurrentConfig().getLitEvidencePassage());	    
		jchbEviPassage.addItemListener(this);
		
		jchbEviDansMot.getAccessibleContext().setAccessibleName("Case à cocher prendre en compte les mises en évidence à l'interieur d'un mot");
		jchbEviDansMot.getAccessibleContext().setAccessibleDescription("Cochez cette case si vous souhaitez prendre en compte les mises en évidence à l'interieur d'un mot");
		jchbEviDansMot.setToolTipText("Cochez cette case si vous souhaitez prendre en compte les mises en évidence à l'interieur d'un mot");
		jchbEviDansMot.setMnemonic('i');
		jchbEviDansMot.setSelected(ConfigNat.getCurrentConfig().getLitEvidenceDansMot());	    
		jchbEviDansMot.addItemListener(this);
		
		jchbMathsTrigoSpec.setSelected(ConfigNat.getCurrentConfig().getMathTrigoSpec());
		jchbMathsTrigoSpec.getAccessibleContext().setAccessibleName("Case à cocher notation spécifique trigo");
		jchbMathsTrigoSpec.getAccessibleContext().setAccessibleDescription("Cocher cette case pour activer la notation spécifique trigo");
		jchbMathsTrigoSpec.setToolTipText("Activer la notation spécifique trigo");
		jchbMathsTrigoSpec.setMnemonic('n');
		jchbMathsTrigoSpec.addItemListener(this);
		
		
		/*********
		 * Mise en page
		 */
		
		
		GridBagConstraints gbc = new GridBagConstraints();
		GridBagLayout gbl = new GridBagLayout();
		
		
		JLabel titre = new JLabel("<html><h3>Paramétrage de la transcription</h3></html>");
		JLabel titre2 = new JLabel("<html><h4>Paramétrage détaillé : braille littéraire intégral</h4></html>");
		JLabel titre3 = new JLabel("<html><h4>Paramétrage détaillé : braille mathématique</h4></html>");
		
		
		JPanel panTr = new JPanel();
		panTr.setLayout(gbl);
		gbc.anchor = GridBagConstraints.WEST;
		
		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.gridwidth=2;
		gbl.setConstraints(titre, gbc);
		panTr.add(titre);
		
		gbc.gridy++;
		gbc.gridwidth=1;
		gbl.setConstraints(jbtTout, gbc);
		panTr.add(jbtTout);
		
		gbc.gridx++;
		gbl.setConstraints(jbtRien, gbc);
		panTr.add(jbtRien);
		
		gbc.gridx=0;
		gbc.gridwidth=2;
		gbc.gridy++;
		gbl.setConstraints(titre2, gbc);
		panTr.add(titre2);
		
		gbc.gridy++;
		gbl.setConstraints(jchbMajDouble, gbc);
		panTr.add(jchbMajDouble);
		
		gbc.gridy++;
		gbl.setConstraints(jchbMajPassage, gbc);
		panTr.add(jchbMajPassage);
		
		gbc.gridy++;
		gbl.setConstraints(jchbMajMots, gbc);
		panTr.add(jchbMajMots);
		
		gbc.gridy++;
		gbl.setConstraints(jchbEviMot, gbc);
		panTr.add(jchbEviMot);
		
		gbc.gridy++;
		gbl.setConstraints(jchbEviDansMot, gbc);
		panTr.add(jchbEviDansMot);
		
		gbc.gridy++;
		gbl.setConstraints(jchbEviPassage, gbc);
		panTr.add(jchbEviPassage);
		
		gbc.gridy++;
		gbl.setConstraints(titre3, gbc);
		panTr.add(titre3);
		
		gbc.gridy++;
		gbl.setConstraints(jchbMathsTrigoSpec, gbc);
		panTr.add(jchbMathsTrigoSpec);

		add(panTr);
	}	

	public void itemStateChanged(ItemEvent ie) 
	{
		jbtTout.setEnabled(true);
		jbtRien.setEnabled(true);
		if(((JCheckBox)(ie.getSource())).isSelected())
		{
			if(jchbMajDouble.isSelected()&&jchbMajPassage.isSelected()&&jchbMajMots.isSelected()&&
					jchbEviMot.isSelected()&&jchbEviPassage.isSelected()&&jchbEviDansMot.isSelected()
					&&jchbMathsTrigoSpec.isSelected())
			{
				jbtTout.setEnabled(false);
			}
		}
		else if(!(jchbMajDouble.isSelected()||jchbMajPassage.isSelected()||jchbMajMots.isSelected()||
					jchbEviMot.isSelected()||jchbEviPassage.isSelected()||jchbEviDansMot.isSelected()
					||jchbMathsTrigoSpec.isSelected()))
		{
			jbtRien.setEnabled(false);
		}		
	}
	
	public void actionPerformed(ActionEvent ae) 
	{
		if(ae.getSource()==jbtTout)
		{
			jchbMajDouble.setSelected(true);
			jchbMajPassage.setSelected(true);
			jchbMajMots.setSelected(true);
			jchbEviMot.setSelected(true);
			jchbEviPassage.setSelected(true);
			jchbEviDansMot.setSelected(true);
			jchbMathsTrigoSpec.setSelected(true);
			jbtTout.setEnabled(false);
			jbtRien.setEnabled(true);
		}
		else if(ae.getSource()==jbtRien)
		{
			jchbMajDouble.setSelected(false);
			jchbMajPassage.setSelected(false);
			jchbMajMots.setSelected(false);
			jchbEviMot.setSelected(false);
			jchbEviPassage.setSelected(false);
			jchbEviDansMot.setSelected(false);
			jchbMathsTrigoSpec.setSelected(false);
			jbtRien.setEnabled(false);
			jbtTout.setEnabled(true);
		}
	}
	
	public boolean enregistrer(String f)
	{
		ConfigNat.getCurrentConfig().setFichierConf(f);
		return enregistrer();
	}
	public boolean enregistrer()
	{
		boolean retour = true;
		ConfigNat.getCurrentConfig().setLitEvidenceMot(jchbEviMot.isSelected());
		ConfigNat.getCurrentConfig().setLitEvidencePassage(jchbEviPassage.isSelected());
		ConfigNat.getCurrentConfig().setLitEvidenceDansMot(jchbEviDansMot.isSelected());
		ConfigNat.getCurrentConfig().setLitMajDouble(jchbMajDouble.isSelected());
		ConfigNat.getCurrentConfig().setLitMajMelange(jchbMajMots.isSelected());
		ConfigNat.getCurrentConfig().setLitMajPassage(jchbMajPassage.isSelected());
		ConfigNat.getCurrentConfig().setMathTrigoSpec(jchbMathsTrigoSpec.isSelected());
		ConfigNat.getCurrentConfig().sauvegarder();
		return retour;
	}
}
