/*
 * NAT - An universal Translator
 * Copyright (C) 2005 Bruno Mascret
 * Contact: bmascret@free.fr
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

package ui;

import gestionnaires.GestionnaireMajTabBraille;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
//import javax.swing.JTable;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JButton;
import javax.swing.JTextField;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerListener;
import java.awt.event.ContainerEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

//import nat.ConfigNat;
import nat.ConfigNat;
import nat.Nat;

public class ConfTableBraille extends JFrame implements ActionListener, ContainerListener, FocusListener 
{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private JTableNonEditCol1 table;
	private JLabel nomTable;
	private JLabel message = new JLabel("<html><br></html>");
	private JScrollPane scrollTable;
	private JButton btEnregistrer = new JButton("Enregistrer",new ImageIcon("ui/icon/document-save.png"));
	private JButton btEnregistrerSous = new JButton("Enregistrer sous...",new ImageIcon("ui/icon/document-save-as.png"));
	//private JTextField texteEnregistrerSous;
	private JButton btQuitter = new JButton("Fermer",new ImageIcon("ui/icon/exit.png"));
	private String fichierTable;
	private String fichierTableConv;
	private String[] lesColonnes = new String[]{"Braille", "Caractère", "Code"};
	private String[][] donnees;
	//private ConfigNat confNat;
	private String nomFichierTable;
	private GestionnaireMajTabBraille gmtb ;
	private boolean modif = false;
	
	public ConfTableBraille(String fichierTable, GestionnaireMajTabBraille gmtb)//, ConfigNat confNat)
	{
		super("Edition de la table braille");
		
		//this.confNat = confNat;
		this.fichierTable = "./xsl/tablesBraille/" + fichierTable + ".ent";
		fichierTableConv = "./xsl/tablesEmbosseuse/" + fichierTable + ".ent";
		nomFichierTable = fichierTable;
		this.gmtb = gmtb ;
		addWindowListener(this.gmtb) ;
		/*texteEnregistrerSous = new JTextField("nouvelle table", 10);
		texteEnregistrerSous.getAccessibleContext().setAccessibleName("Champ de saisie nom table");
		texteEnregistrerSous.getAccessibleContext().setAccessibleDescription("Entrer le nom de la nouvelle table puis activer le bouton enregistrer sous");
		texteEnregistrerSous.setToolTipText("Entrer le nom de la nouvelle table");*/
		
		nomTable = new JLabel("<html><center><h2>Table " + fichierTable + "</h2></center></html>");
		//on ouvre le fichier et on remplit la table
		afficheTable();
		table = new JTableNonEditCol1(donnees,lesColonnes);
		scrollTable = new JScrollPane (table);
		scrollTable.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		scrollTable.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		scrollTable.setPreferredSize(new Dimension(300,350));
		
		table.addContainerListener(this);
		table.addFocusListener(this);
		
		JPanel pTable = new JPanel();
		pTable.add(scrollTable);
		pTable.setPreferredSize(new Dimension(350,400));
		//pTable.addContainerListener(this);
		
		JPanel lesBoutons = new JPanel();
		btEnregistrer.addActionListener(this);
		btEnregistrer.getAccessibleContext().setAccessibleName("Bouton Enregistrer la table");
		btEnregistrer.getAccessibleContext().setAccessibleDescription("Valider pour enregistrer les modifications apportées à la table");
		btEnregistrer.setToolTipText("Enregistrer les modifications");
		btEnregistrer.setMnemonic('s');
		
		btQuitter.addActionListener(this);
		btQuitter.getAccessibleContext().setAccessibleName("Bouton fermer la fenêtre");
		btQuitter.getAccessibleContext().setAccessibleDescription("Valider pour fermer la fenêtre");
		btQuitter.setToolTipText("Fermer la fenêtre");
		btQuitter.setMnemonic('f');
		
		btEnregistrerSous.addActionListener(this);
		btEnregistrerSous.getAccessibleContext().setAccessibleName("Bouton enregistrer sous");
		btEnregistrerSous.getAccessibleContext().setAccessibleDescription("Valider pour enregistrer la table  sous un nouveau nom");
		btEnregistrerSous.setToolTipText("Enregistrer la table  sous un nouveau nom");
		btEnregistrerSous.setMnemonic('n');
		
		
		lesBoutons.add(btEnregistrer);
		lesBoutons.add(btEnregistrerSous);
		// lesBoutons.add(texteEnregistrerSous);
		lesBoutons.add(btQuitter);
		JPanel entete = new JPanel();
		entete.add(nomTable);
		entete.add(message);
		
		//setLayout(new BorderLayout(5,5));
		add(BorderLayout.NORTH, entete);
		add(BorderLayout.CENTER,pTable);
		add(BorderLayout.SOUTH,lesBoutons);
		setSize(500,500);
	}
	
	public void actionPerformed(ActionEvent evt)
	{
		if (evt.getSource()==btEnregistrer)
		{
			//JOptionPane jopErreur = new JOptionPane();
			if(JOptionPane.showConfirmDialog( this,"Voulez-vous écraser la table " + nomFichierTable,"Enregistrement", JOptionPane.YES_NO_OPTION)==JOptionPane.OK_OPTION)
			{
				enregistrer();
			}
		}
		else if (evt.getSource()==btQuitter)
		{
			if(modif)
			{
				//JOptionPane jopErreur = new JOptionPane();
				if(JOptionPane.showConfirmDialog( this,"Enregistrer les modifications?","Enregistrement", JOptionPane.YES_NO_OPTION)==JOptionPane.OK_OPTION)
				{
					enregistrer();
				}
			}
			this.dispose();
		}
		else if(evt.getSource()==btEnregistrerSous)
		{
			enregistrerSous();
		}
	}
	
	public void componentAdded(ContainerEvent e)
	{
		//declenché dès qu'onmodifie une valeur
	}
	
	public void componentRemoved(ContainerEvent e)
	{
		//déclenché quand on a rentré une nouvelle valeur
		message.setText("");
		modif = true;
		//On cherche quel composant a été modifié:
		int x = table.getEditingRow();
		int y = table.getEditingColumn();

		String valeur = ((JTextField) table.getEditorComponent()).getText();
		majTable(valeur,x,y);
	}
	
	private boolean majTable(String valeur, int x, int y)
	{
		boolean retour=  false;
		
		switch (y)
		{
			case 1:
				//colonne 2
				if (valeur.length()==1)
				{
					//c'est un caractère
					donnees[x][1] = valeur;
					char c = valeur.charAt(0);
					donnees[x][2] = Short.toString((short) c);
					retour = true;
				}
				else
				{
					//JOptionPane jopErreur = new JOptionPane();
					JOptionPane.showMessageDialog( this,"Vous devez saisir un seul caractère","Erreur de saisie", JOptionPane.ERROR_MESSAGE);
				}
				break;
				
			case 2:
				//colonne 3
				donnees[x][1]=Character.toString( ((char) Integer.parseInt(valeur)));
				donnees[x][2]=valeur;
				retour = true;
				break;
		}
		table.repaint();
		return retour;
	}
	
	private void enregistrer()
	{
		try
		{
			int i;
			FileWriter raf = new FileWriter(fichierTable);
			FileWriter rac = new FileWriter(fichierTableConv);
			raf.write(Nat.getLicence("<!--\n","-->\n"));
			rac.write(Nat.getLicence("<!--\n","-->\n"));
			for (i=0; i<donnees.length; i++)//length - 1 car il y a une ligne en plus je sais pas pq
			{
				if (donnees[i][1].equals("\""))
				{
					raf.write("<!ENTITY " + donnees[i][0] + " \"&quot;\">\n");
					rac.write("<!ENTITY " + donnees[i][0].replaceFirst("pt", "pte") + " \"&quot;\">\n");
				}
				else if(donnees[i][1].equals("'"))
				{
					raf.write("<!ENTITY " + donnees[i][0] + " \"&apos;\">\n");
					rac.write("<!ENTITY " + donnees[i][0].replaceFirst("pt", "pte") + " \"&apos;\">\n");
				}
				else if(donnees[i][1].equals("<"))
				{
					raf.write("<!ENTITY " + donnees[i][0] + " \"&lt;\">\n");
					rac.write("<!ENTITY " + donnees[i][0].replaceFirst("pt", "pte") + " \"&lt;\">\n");
				}
				else if(donnees[i][1].equals(">"))
				{
					raf.write("<!ENTITY " + donnees[i][0] + " \"&gt;\">\n");
					rac.write("<!ENTITY " + donnees[i][0].replaceFirst("pt", "pte") + " \"&gt;\">\n");
				}
				else if(donnees[i][1].equals("&"))
				{
					raf.write("<!ENTITY " + donnees[i][0] + " \"&amp;\">\n");
					rac.write("<!ENTITY " + donnees[i][0].replaceFirst("pt", "pte") + " \"&amp;\">\n");
				}
				else
				{
					raf.write("<!ENTITY " + donnees[i][0] + " \"&#" + donnees[i][2] + ";\">\n");
					rac.write("<!ENTITY " + donnees[i][0].replaceFirst("pt", "pte") + " \"&#" + donnees[i][2] + ";\">\n");
				}
			}
			raf.close();
			rac.close();
			message.setText("<html><br><p>Table enregistrée</p></html>");
			nomTable.setText("<html><h2>Table " + nomFichierTable + "</h2></html>");
			modif=false;
		}
		catch (IOException e)
		{
			System.out.println("erreur dans: " + e);
			message.setText("<html><br><p color=\"red\">Erreur lors de l'enregistrement</p></html>");
		}
	}
	
	private void enregistrerSous()
	{
		String nomTable = ConfigNat.getCurrentConfig().getTableBraille();
		
		//on demande le nom de la nouvelle config
		String nomNewTable = (String)JOptionPane.showInputDialog(
                this,
                "Nom de la nouvelle table braille :",
                "Table actuelle : "+nomTable,
                JOptionPane.PLAIN_MESSAGE,null,null,
                nomTable);
		
	    //on vérifie qu'elle n'existe pas déjà
		int reponse = JOptionPane.YES_OPTION ;
		if ((new File("./xsl/tablesBraille/"+nomNewTable+".ent").exists()) && (nomNewTable != null))
		{
		reponse = JOptionPane.showConfirmDialog(
			    this,
			    "La table braille\n"+nomNewTable+"\nexiste déjà,\nvoulez-vous l'écraser ?",
			    "Confirmation",
			    JOptionPane.YES_NO_OPTION);
		}

		
	    if ((nomNewTable != null) && (nomNewTable.length() > 0) && (reponse == JOptionPane.YES_OPTION))
	    {
			nomFichierTable = nomNewTable;
			this.fichierTable = "./xsl/tablesBraille/" + nomNewTable + ".ent";
			this.fichierTableConv = "./xsl/tablesEmbosseuse/" + nomNewTable + ".ent";
			enregistrer();
	    }
	}
	
	private boolean afficheTable()
	{
	    boolean retour = true;
		try
	      {
		      RandomAccessFile raf = new RandomAccessFile(fichierTable, "r");
		      String ligne;
		      String[] enregistrement;
		      int i=1;
		      
		      ligne = raf.readLine();
		      //on cherche le début des entitées
		      while(!ligne.startsWith("<!ENTITY") && ligne!=null)
		      {
		    	  ligne = raf.readLine();
		      }
		      if (ligne==null)
		      {
		    	  System.out.println("Le fichier" + fichierTable + "n'est pas un fichier valide");
		    	  message.setText("<html><br><p color=\"red\">Le fichier" + fichierTable + "n'est pas un fichier valide</p></html>");
		    	  retour =false;
		      }
		      else
		      {
		    	  donnees = new String[64][3];
		    	  enregistrement = ligne.split(" ");
		    	  donnees[0][0] = enregistrement[1];

		    	  if(!enregistrement[2].startsWith("\"&#"))
		    	  {
		    		  if (enregistrement[2].startsWith("\"&apos;"))
		    		  {
		    			  donnees[0][1] = "'";
		    			  donnees[0][2] = "39";
		    		  }
		    		  else if (enregistrement[2].startsWith("\"&quot;"))
		    		  {
		    			  donnees[0][1] = "\"";
		    			  donnees[0][2] = "34";
		    		  }
		    		  else if (enregistrement[2].startsWith("\"&lt;"))
		    		  {
		    			  donnees[0][1] = "<";
		    			  donnees[0][2] = "60";
		    		  }
		    		  else if (enregistrement[2].startsWith("\"&gt;"))
		    		  {
		    			  donnees[0][1] = ">";
		    			  donnees[0][2] = "62";
		    		  }
		    		  else
		    		  {
		    			  donnees[0][1] = "&";
		    			  donnees[0][2] = "38";
		    		  }
		    	  }
		    	  else
		    	  {
			    	  donnees[0][1] = Character.toString((char)(Integer.parseInt(enregistrement[2].substring(3, enregistrement[2].length()-3))));
			    	  donnees[0][2] = enregistrement[2].substring(3, enregistrement[2].length()-3);
		    	  }

			      while ( (ligne = raf.readLine()) != null && i<donnees.length)
				  	{
			    	  enregistrement = ligne.split(" ");
			    	  donnees[i][0] = enregistrement[1];
			    	  if(!enregistrement[2].startsWith("\"&#"))
			    	  {
			    		  if (enregistrement[2].startsWith("\"&apos;"))
			    		  {
			    			  donnees[i][1] = "'";
			    			  donnees[i][2] = "39";
			    		  }
			    		  else if (enregistrement[2].startsWith("\"&quot;"))
			    		  {
			    			  donnees[i][1] = "\"";
			    			  donnees[i][2] = "34";
			    		  }
			    		  else if (enregistrement[2].startsWith("\"&lt;"))
			    		  {
			    			  donnees[i][1] = "<";
			    			  donnees[i][2] = "60";
			    		  }
			    		  else if (enregistrement[2].startsWith("\"&gt;"))
			    		  {
			    			  donnees[i][1] = ">";
			    			  donnees[i][2] = "62";
			    		  }
			    		  else
			    		  {
			    			  donnees[i][1] = "&";
			    			  donnees[i][2] = "38";
			    		  }
			    	  }
			    	  else
			    	  {
				    	  donnees[i][1] = Character.toString((char)(Integer.parseInt(enregistrement[2].substring(3, enregistrement[2].length()-3))));
				    	  donnees[i][2] = enregistrement[2].substring(3, enregistrement[2].length()-3);
			    	  }
			    	  i++;
			  	    }
		      }
		      raf.close();
	       }
		   catch (IOException e)
		   {
			   System.out.println("erreur dans: " + e);
			   message.setText(":Erreur d'entrée/sortie lors du chargement");
		   }
		   catch (NumberFormatException e)
		   {
			   System.out.println("La table Braille n'est pas valide: " + e);
			   message.setText("<html><br> <p color=\"red\">La table Braille n'est pas valide</p></html>");
		   }
		   return retour;
	}

	public void focusGained(FocusEvent arg0) {}

	public void focusLost(FocusEvent fe) 
	{
		//table.revalidate();
	}

}
