package ui;

import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import nat.ConfigNat;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ConfInterface extends OngletConf implements ItemListener
{
	private static final long serialVersionUID = 1L;
	private JCheckBox editeurBraille = new JCheckBox("Affichage automatique");
	//private JCheckBox editeurEnBraille = new JCheckBox("Editeur en Braille");
	private JLabel lCbPolice = new JLabel("Police de l'éditeur:");
	private JComboBox cbPolice;
	private JLabel lTaillePolice = new JLabel("Taille de la police");
	private JTextField jtfTaillePolice = new JTextField(3);
	
	private JCheckBox afficheLigne = new JCheckBox("Affiche la ligne secondaire");
	private JLabel lCbPolice2 = new JLabel("Police de la ligne secondaire:");
	private JComboBox cbPolice2;
	private JLabel lTaillePolice2 = new JLabel("Taille de la police secondaire");
	private JTextField jtfTaillePolice2 = new JTextField(3);
	
	private Configuration jfParent;
	private JCheckBox jcbTailleFenetre = new JCheckBox("Mémoriser les dimensions des fenêtres de taille variable");
	private JCheckBox jcbCentrerFenetre = new JCheckBox("Centrer les fenêtres à l'écran");
	
	public ConfInterface(Configuration jfp)
	{
		super();
		this.jfParent = jfp;

		editeurBraille.setSelected(ConfigNat.getCurrentConfig().getOuvrirEditeur());
		editeurBraille.getAccessibleContext().setAccessibleName("Case à cocher ouvrir l'éditeur");
		editeurBraille.getAccessibleContext().setAccessibleDescription("Cocher la case pour ouvrir automatiquement l'éditeur après une transcription");
		editeurBraille.setToolTipText("Ouvrir l'éditeur après la transcription");
		editeurBraille.setMnemonic('e');		
		
		GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
		/** Liste de toutes les polices : */
		//Font[ ] polices = environment.getAllFonts();
		/** Liste des noms de toutes les polices : */
		String[ ] nomPolices = environment.getAvailableFontFamilyNames();
		cbPolice = new JComboBox(nomPolices);
		cbPolice.getAccessibleContext().setAccessibleName("Liste à choix multiples police de l'éditeur ");
		cbPolice.getAccessibleContext().setAccessibleDescription("Sélectionner la police de l'éditeur intégré");
		cbPolice.setToolTipText("Sélectionner la police à utiliser avec l'éditeur intégré");
		
		lCbPolice.setLabelFor(cbPolice);
		lCbPolice.setDisplayedMnemonic('f');

		cbPolice.setSelectedItem(ConfigNat.getCurrentConfig().getPoliceEditeur());
		
		jtfTaillePolice.getAccessibleContext().setAccessibleName("Champ texte taille de la police");
		jtfTaillePolice.getAccessibleContext().setAccessibleDescription("Sélectionner la taille de la police de l'éditeur");
		jtfTaillePolice.setToolTipText("Sélectionner la taille de police à utiliser avec l'éditeur");
		
		lTaillePolice.setLabelFor(jtfTaillePolice);
		lTaillePolice.setDisplayedMnemonic('x');
		jtfTaillePolice.setText(ConfigNat.getCurrentConfig().getTaillePolice() + "");
		
		afficheLigne.setSelected(ConfigNat.getCurrentConfig().getAfficheLigneSecondaire());
		afficheLigne.getAccessibleContext().setAccessibleName("Case à cocher afficher la ligne secondaire de l'éditeur");
		afficheLigne.getAccessibleContext().setAccessibleDescription("Cocher la case pour afficher la ligne secondaire dans l'éditeur");
		afficheLigne.setToolTipText("Afficher la ligne secondaire de l'éditeur");
		afficheLigne.setMnemonic('d');
		afficheLigne.addItemListener(this);
		
		cbPolice2 = new JComboBox(nomPolices);
		cbPolice2.getAccessibleContext().setAccessibleName("Liste à choix multiples police secondaire ");
		cbPolice2.getAccessibleContext().setAccessibleDescription("Sélectionner la police secondaire de l'éditeur intégré");
		cbPolice2.setToolTipText("Sélectionner la police secondaire à utiliser avec l'éditeur intégré");
		
		lCbPolice2.setLabelFor(cbPolice2);
		lCbPolice2.setDisplayedMnemonic('g');
		cbPolice2.setSelectedItem(ConfigNat.getCurrentConfig().getPolice2Editeur());
		
		jtfTaillePolice2.getAccessibleContext().setAccessibleName("Champ texte taille de la police secondaire");
		jtfTaillePolice2.getAccessibleContext().setAccessibleDescription("Sélectionner la taille de la police secondaire de l'éditeur");
		jtfTaillePolice2.setToolTipText("Sélectionner la taille de police secondaire à utiliser");
		
		lTaillePolice2.setLabelFor(jtfTaillePolice2);
		lTaillePolice2.setDisplayedMnemonic('y');
		jtfTaillePolice2.setText(ConfigNat.getCurrentConfig().getTaillePolice2() + "");
		
		if (!afficheLigne.isSelected())
		{
			lCbPolice2.setEnabled(false);
			cbPolice2.setEnabled(false);
			jtfTaillePolice2.setEnabled(false);
			lTaillePolice2.setEnabled(false);
		}
		
		
		/* options valables pour toute l'interface quelle que soit la conf */
		jcbTailleFenetre.setSelected(ConfigNat.getCurrentConfig().getMemoriserFenetre());
		jcbTailleFenetre.getAccessibleContext().setAccessibleName("Case à cocher mémoriser les tailles des fenêtres");
		jcbTailleFenetre.getAccessibleContext().setAccessibleDescription("Cocher la case pour mémoriser les tailles de fenêtre");
		jcbTailleFenetre.setToolTipText("Mémoriser la taille des fenêtres lors de redimensionnement");
		jcbTailleFenetre.setMnemonic('m');
		
		jcbCentrerFenetre.setSelected(ConfigNat.getCurrentConfig().getCentrerFenetre());
		jcbCentrerFenetre.getAccessibleContext().setAccessibleName("Case à cocher centrer les fenêtres");
		jcbCentrerFenetre.getAccessibleContext().setAccessibleDescription("Cocher la case pour centrer les fenêtres à l'écran");
		jcbCentrerFenetre.setToolTipText("Centrer les fenêtres à l'écran");
		jcbCentrerFenetre.setMnemonic('c');
		
		/*********
		 * Mise en page
		 */
		
		GridBagConstraints gbc = new GridBagConstraints();
		GridBagLayout gbl = new GridBagLayout();
		//setLayout(gbl);
		
		JPanel p = new JPanel();
		p.setLayout(gbl);
		
		gbc.anchor = GridBagConstraints.WEST;
		gbc.gridwidth = 3;
		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		JLabel titreEditeur = new JLabel("<html><h3>Editeur intégré</h3></html>");
		gbl.setConstraints(titreEditeur, gbc);
		p.add(titreEditeur);
		
		gbc.gridwidth = 2;
		gbc.gridx = 0;
		gbc.gridy++;
		gbl.setConstraints(editeurBraille, gbc);
		p.add(editeurBraille);
		
		gbc.gridx = 0;
		gbc.gridy++;
		gbl.setConstraints(lCbPolice, gbc);
		p.add(lCbPolice);
		gbc.gridx=1;
		gbl.setConstraints(cbPolice, gbc);
		p.add(cbPolice);
		
		gbc.gridx = 0;
		gbc.gridy++;
		gbl.setConstraints(lTaillePolice, gbc);
		p.add(lTaillePolice);
		gbc.gridx=1;
		gbl.setConstraints(jtfTaillePolice, gbc);
		p.add(jtfTaillePolice);
		
		gbc.gridwidth = 2;
		gbc.gridy++;
		gbc.gridx = 0;
		gbl.setConstraints(afficheLigne, gbc);
		p.add(afficheLigne);
		
		gbc.gridwidth = 1;
		gbc.gridy++;
		gbl.setConstraints(lCbPolice2, gbc);
		p.add(lCbPolice2);
		gbc.gridx=1;
		gbl.setConstraints(cbPolice2, gbc);
		p.add(cbPolice2);
		
		gbc.gridx = 0;
		gbc.gridy++;
		gbl.setConstraints(lTaillePolice2, gbc);
		p.add(lTaillePolice2);
		gbc.gridx=1;
		gbl.setConstraints(jtfTaillePolice2, gbc);
		p.add(jtfTaillePolice2);
		
		JLabel lTitreGeneral = new JLabel("<html><h3>Options générales</h3></html>");
		gbc.gridx = 0;
		gbc.gridwidth = 3;
		gbc.gridy++;
		gbl.setConstraints(lTitreGeneral, gbc);
		p.add(lTitreGeneral);
		
		JLabel lInfo = new JLabel("Les options suivantes s'appliquent à l'interface quelle que soit la configuration en cours");
		gbc.gridwidth = 4;
		gbc.gridy++;
		gbl.setConstraints(lInfo, gbc);
		p.add(lInfo);
		
		gbc.gridwidth = 2;
		gbc.gridy++;
		gbl.setConstraints(jcbTailleFenetre, gbc);
		p.add(jcbTailleFenetre);
		
		gbc.gridwidth = 2;
		gbc.gridy++;
		gbl.setConstraints(jcbCentrerFenetre, gbc);
		p.add(jcbCentrerFenetre);
		
		add(p);
	}

	public boolean enregistrer(String f)
	{
		ConfigNat.getCurrentConfig().setFichierConf(f);
		return enregistrer();
	}
	public boolean enregistrer()
	{
	    //System.out.println("/viremoi/ confgeneral.enregister"+ConfigNat.getCurrentConfig().getFichierConf());
		boolean retour = true;
		try
		{
			ConfigNat.getCurrentConfig().setPoliceEditeur((String)cbPolice.getSelectedItem());
			ConfigNat.getCurrentConfig().setOuvreEditeurApresTranscription(editeurBraille.isSelected());
			ConfigNat.getCurrentConfig().setTaillePolice(Integer.parseInt(jtfTaillePolice.getText()));
			ConfigNat.getCurrentConfig().setAfficheLigneSecondaire(afficheLigne.isSelected());
			ConfigNat.getCurrentConfig().setTaillePolice2(Integer.parseInt(jtfTaillePolice2.getText()));
			ConfigNat.getCurrentConfig().setPolice2Editeur((String)cbPolice2.getSelectedItem());
			ConfigNat.getCurrentConfig().setCentrerFenetre(jcbCentrerFenetre.isSelected());
			ConfigNat.getCurrentConfig().setMemoriserFenetre(jcbTailleFenetre.isSelected());
		}
		catch (NumberFormatException nbe)
		{
			/*JOptionPane jopErreur = new JOptionPane();
			jopErreur.showMessageDialog( jfParent,"Vous devez entrer un entier pour la longueur de la ligne et la taille de police","Erreur de saisie", jopErreur.ERROR_MESSAGE);*/
			JOptionPane.showMessageDialog(jfParent,"Vous devez entrer un entier pour la longueur de la ligne et la taille de police","Erreur de saisie", JOptionPane.ERROR_MESSAGE);
			retour = false;
		}
		return retour;
	}

	public void itemStateChanged(ItemEvent ie) 
	{
		if(ie.getSource()==afficheLigne)
	    {
			if(!afficheLigne.isSelected())
		    {
		    	lCbPolice2.setEnabled(false);
				cbPolice2.setEnabled(false);
				jtfTaillePolice2.setEnabled(false);
				lTaillePolice2.setEnabled(false);
		    }
		    else
		    {
		    	lCbPolice2.setEnabled(true);
				cbPolice2.setEnabled(true);
				jtfTaillePolice2.setEnabled(true);
				lTaillePolice2.setEnabled(true);
		    }
	    }
		
	}
}