/*
 * NAT - An universal Translator
 * Copyright (C) 2005 Bruno Mascret
 * Contact: bmascret@free.fr
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
package ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.SortedMap;
import java.util.Vector;

import nat.ConfigNat;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class ConfGeneral extends OngletConf implements ActionListener, ItemListener
{
	private static final long serialVersionUID = 1L;
	//private ConfigNat confNat;

	private JCheckBox abreger = new JCheckBox("<html>Braille abrégé. <b color=\"red\">Ne pas utiliser: fonctionalité en développement</b></html>");
	
	private JCheckBox bLit = new JCheckBox("Traiter les écritures littéraires");
	private JCheckBox bMaths = new JCheckBox("Traiter les écritures mathématiques");
	private JCheckBox bMusique = new JCheckBox("<html>Traiter les écritures musicales. <b color=\"red\">Ne pas utiliser: en développement</b></html>");
	
	private JComboBox comboTables;
	private JLabel lComboTables = new JLabel("Table Braille");
	private JButton btEditTable =new JButton("Editer",new ImageIcon("ui/icon/gtk-edit.png"));
	
	private JComboBox jcbCharsetSource = new JComboBox();
	private JLabel ljcbCharsetSource = new JLabel("Encodage fichier source");
	
	private JComboBox jcbCharsetSortie = new JComboBox();
	private JLabel ljcbCharsetSortie = new JLabel("Encodage fichier sortie");
	
	private JCheckBox jcbCoupure = new JCheckBox("Activer la coupure");
	private JCheckBox jcbSagouin = new JCheckBox("Activer le mode sagouin");
	private JLabel lLongLigne = new JLabel("Longueur de la ligne:");
	private JTextField jtfLongLigne = new JTextField();
	
	private JComboBox cbLog;
	private JLabel lLog = new JLabel("Niveau de verbosité");
	
	private Configuration jfParent;
	
	public ConfGeneral(Configuration jfp)
	{
		super();
		//this.confNat = confNat;
		this.jfParent = jfp;
		
		/**********
		 * Préparation des composants
		 */
		
		bLit.setSelected(ConfigNat.getCurrentConfig().getTraiterLiteraire());
		bLit.getAccessibleContext().setAccessibleName("Case à cocher braille littéraire");
		bLit.getAccessibleContext().setAccessibleDescription("Cocher cette case pour activer le traitement des contenus littéraires");
		bLit.setToolTipText("Activer le traitement des contenus littéraires (textes)");
		bLit.setMnemonic('l');
		bMaths.setSelected(ConfigNat.getCurrentConfig().getTraiterMaths());
		bMaths.getAccessibleContext().setAccessibleName("Case à cocher braille mathématique");
		bMaths.getAccessibleContext().setAccessibleDescription("Cocher cette case pour activer le traitement des contenus mathématiques");
		bMaths.setToolTipText("Activer le traitement des contenus mathématiques (formules, mathml)");
		bMaths.setMnemonic('m');
		bMusique.setSelected(ConfigNat.getCurrentConfig().getTraiterMusique());
		bMusique.getAccessibleContext().setAccessibleName("Case à cocher braille musical");
		bMusique.getAccessibleContext().setAccessibleDescription("Cocher cette case pour activer le traitement des contenus musicaux");
		bMusique.setToolTipText("Activer le traitement des contenus musicaux");
		bMusique.setMnemonic('u');

		
		abreger.setSelected(ConfigNat.getCurrentConfig().getAbreger());
		abreger.getAccessibleContext().setAccessibleName("Case à cocher braille abrégé");
		abreger.getAccessibleContext().setAccessibleDescription("Cocher cette case pour activer l'abrégé");
		abreger.setToolTipText("Activer le braille abrégé");
		abreger.setMnemonic('a');

		/* Liste Tables braille */
		File repertoire =new File("xsl/tablesBraille");
	   //System.out.println ( repertoire.getAbsolutePath());
		File[] listTables = repertoire.listFiles();
	    //String table = "";
	    
		int taille = listTables.length;
		Vector<String> namesList = new Vector<String>(taille);
		
		for(int i=0;i<taille;i++)
	    {
	    	String nomTable = listTables[i].getName() ;
	    	if (nomTable.endsWith(".ent") && !nomTable.equals("Brltab.ent"))
	    	{
	    		namesList.add(nomTable.substring(0,nomTable.length()-4));
	    	}
	    }
		
		Collections.sort(namesList);
		
		comboTables  = new JComboBox(namesList);
		comboTables.setSelectedItem(ConfigNat.getCurrentConfig().getTableBraille());
	    comboTables.setEditable(false);
	    comboTables.getAccessibleContext().setAccessibleName("Liste à choix multiples table braille");
	    comboTables.getAccessibleContext().setAccessibleDescription("Sélectionner à l'aide des flèches la table braille à utiliser");
	    comboTables.setToolTipText("Sélectionner la table braille");

	    

		/*
		comboTables.addItem("CBFr1252");
		comboTables.addItem("DuxFr");
		comboTables.addItem("CodeUs");
		comboTables.addItem("TableBraille");*/
	    
	    /* Encodage */
	    //ajout de la détection automatique
		jcbCharsetSource.addItem("automatique");
		jcbCharsetSortie.addItem("automatique");
		//récupération des charsets disponibles
		SortedMap<String,Charset> charsets = Charset.availableCharsets();
		for(String nom : charsets.keySet())
		{
			jcbCharsetSource.addItem(nom);
			jcbCharsetSortie.addItem(nom);
			/*System.out.println("Charset "+nom);
			Charset charset = charsets.get(nom);
			for(String alias : charset.aliases())
			{
				System.out.print(" "+alias+",");
			}*/
    		if(nom.equals(ConfigNat.getCurrentConfig().getSourceEncoding()))
    		{
    			jcbCharsetSource.setSelectedIndex(jcbCharsetSource.getItemCount()-1);
    		}
    		if(nom.equals(ConfigNat.getCurrentConfig().getSortieEncoding()))
    		{
    			jcbCharsetSortie.setSelectedIndex(jcbCharsetSortie.getItemCount()-1);
    		}
		}
		jcbCharsetSource.getAccessibleContext().setAccessibleName("Liste à choix multiples encodage source ");
		jcbCharsetSource.getAccessibleContext().setAccessibleDescription("Sélectionner l'encodage du fichier source, ou laisser la détection automatique");
		jcbCharsetSource.setToolTipText("Sélectionner l'encodage du fichier source, ou laisser la détection automatique");
		jcbCharsetSortie.getAccessibleContext().setAccessibleName("Liste à choix multiples encodage sortie ");
		jcbCharsetSortie.getAccessibleContext().setAccessibleDescription("Sélectionner l'encodage du fichier sortie, ou laisser la détection automatique");
		jcbCharsetSortie.setToolTipText("Sélectionner l'encodage du fichier sortie, ou laisser la détection automatique");

		lComboTables.setLabelFor(comboTables);
		lComboTables.setDisplayedMnemonic('b');
		btEditTable.addActionListener(this);
		btEditTable.getAccessibleContext().setAccessibleName("Bouton éditer la table braille");
		btEditTable.getAccessibleContext().setAccessibleDescription("valider pour éditer la table braille");
		btEditTable.setToolTipText("Editer la table braille sélectionnée");
		btEditTable.setMnemonic('t');
		
		ljcbCharsetSource.setLabelFor(jcbCharsetSource);
		ljcbCharsetSource.setDisplayedMnemonic('i');
		comboTables.getAccessibleContext().setAccessibleName("Liste à choix multiples table braille");
		comboTables.getAccessibleContext().setAccessibleDescription("Sélectionner à l'aide des flèches la table braille à utiliser");
		comboTables.setToolTipText("Sélectionner la table braille");
		ljcbCharsetSortie.setLabelFor(jcbCharsetSortie);
		ljcbCharsetSortie.setDisplayedMnemonic('o');
		
		jcbCoupure.setSelected(ConfigNat.getCurrentConfig().getCoupure());
		jcbCoupure.getAccessibleContext().setAccessibleName("Case à cocher coupure");
		jcbCoupure.getAccessibleContext().setAccessibleDescription("Cocher cette case pour activer la coupure");
		jcbCoupure.setToolTipText("Activer la coupure");
		jcbCoupure.setMnemonic('c');	
		jcbCoupure.addItemListener(this);
		
		jcbSagouin.setSelected(ConfigNat.getCurrentConfig().getModeCoupureSagouin());
		jcbSagouin.getAccessibleContext().setAccessibleName("Case à cocher mode sagouin coupure");
		jcbSagouin.getAccessibleContext().setAccessibleDescription("Cocher cette case pour activer la coupure en mode sagouin");
		jcbSagouin.setToolTipText("Activer la coupure en mode sagouin");
		jcbSagouin.setMnemonic('g');
		
		if (!jcbCoupure.isSelected()){jcbSagouin.setEnabled(false);}
		
		jtfLongLigne.setText(String.valueOf(ConfigNat.getCurrentConfig().getLongueurLigne()));
		jtfLongLigne.getAccessibleContext().setAccessibleName("Zone de saisie de la longueur de la ligne de l'éditeur");
		jtfLongLigne.getAccessibleContext().setAccessibleDescription("Entrer la longueur de la ligne");
		jtfLongLigne.setToolTipText("Entrer la longueur de la ligne souhaitée en nombre de caractères");
		lLongLigne.setLabelFor(jtfLongLigne);
		lLongLigne.setDisplayedMnemonic('w');
		
		// verbosité des logs:
		String [] listeModeVerbeux = {"faible","moyen","élevé","debugage"};
		cbLog = new JComboBox(listeModeVerbeux);
		cbLog.getAccessibleContext().setAccessibleName("Liste à choix multiples niveau de verbosité des messages");
		cbLog.getAccessibleContext().setAccessibleDescription("Sélectionner le niveau de verbosité des messages");
		cbLog.setToolTipText("Sélectionner le niveau de verbosité des messages, présentés du plus faible au plus élevé (débugage)");
		cbLog.setSelectedIndex(ConfigNat.getCurrentConfig().getNiveauLog()-1);

		lLog.setLabelFor(cbLog);
		lLog.setDisplayedMnemonic('v');
		
		
		/*********
		 * Mise en page
		 */
		
		GridBagConstraints gbc = new GridBagConstraints();
		GridBagLayout gbl = new GridBagLayout();
		setLayout(gbl);
		
		JLabel titreEcritures = new JLabel("<html><h3>Ecritures brailles</h3></html>");
		gbc.anchor = GridBagConstraints.LINE_START;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.gridwidth = 3;
		gbl.setConstraints(titreEcritures, gbc);
		add(titreEcritures);
		
		gbc.gridy++;
		gbl.setConstraints(bLit, gbc);
		add(bLit);
		
		gbc.gridy++;
		gbl.setConstraints(bMaths, gbc);
		add(bMaths);
		
		gbc.gridy++;
		gbl.setConstraints(bMusique, gbc);
		add(bMusique);
		
		gbc.gridy++;
		gbl.setConstraints(abreger, gbc);
		add(abreger);
		
		JLabel titreEncodage = new JLabel("<html><h3>Encodage des fichiers et table braille</h3></html>");
		gbc.gridy++;
		gbl.setConstraints(titreEncodage, gbc);
		add(titreEncodage);
		
		gbc.gridy++;
		gbc.gridwidth = 1;
		gbl.setConstraints(lComboTables, gbc);
		add(lComboTables);
		gbc.gridx=1;
		gbl.setConstraints(comboTables, gbc);
		add(comboTables);
		gbc.gridx=2;
		gbl.setConstraints(btEditTable, gbc);
		add(btEditTable);

		gbc.gridy++;
		gbc.gridx = 0;
		gbl.setConstraints(ljcbCharsetSource, gbc);
		add(ljcbCharsetSource);
		gbc.gridx=1;
		gbl.setConstraints(jcbCharsetSource, gbc);
		add(jcbCharsetSource);
		
		gbc.gridy++;
		gbc.gridx = 0;
		gbl.setConstraints(ljcbCharsetSortie, gbc);
		add(ljcbCharsetSortie);
		gbc.gridx=1;
		gbl.setConstraints(jcbCharsetSortie, gbc);
		add(jcbCharsetSortie);
	
		gbc.gridx = 0;
		gbc.gridy++;
		gbc.gridwidth = 1;
		JLabel titreCoupure = new JLabel("<html><h3>Coupure</h3></html>");
		gbl.setConstraints(titreCoupure, gbc);
		add(titreCoupure);
		
		gbc.gridwidth = 1;
		gbc.gridy++;
		gbl.setConstraints(jcbCoupure, gbc);
		add(jcbCoupure);
		
		gbc.gridx = 0;
		gbc.gridy++;
		gbl.setConstraints(jcbSagouin, gbc);
		add(jcbSagouin);
		
		gbc.gridy++;
		gbl.setConstraints(lLongLigne, gbc);
		add(lLongLigne);
		
		gbc.gridx=1;
		gbl.setConstraints(jtfLongLigne, gbc);
		add(jtfLongLigne);
		
		gbc.gridx = 0;
		gbc.gridy++;
		gbc.gridwidth = 3;
		JLabel titreLog = new JLabel("<html><h3>Messages</h3></html>");
		gbl.setConstraints(titreLog, gbc);
		add(titreLog);
		
		gbc.gridwidth = 1;
		gbc.gridy++;
		gbl.setConstraints(lLog, gbc);
		add(lLog);
		gbc.gridx = 1;
		gbl.setConstraints(cbLog, gbc);
		add(cbLog);
	}
	
	public void actionPerformed(ActionEvent evt)
	{
		if (evt.getSource()==btEditTable)
		{
			ConfTableBraille ctb = new ConfTableBraille(comboTables.getSelectedItem().toString(), jfParent.getGmtb());
			ctb.setVisible(true);
		}
	}
	
	public void itemStateChanged(ItemEvent e)
	{
		if(e.getSource()==jcbCoupure)
		{
			if(!jcbCoupure.isSelected()){jcbSagouin.setEnabled(false);}
			else{jcbSagouin.setEnabled(true);};
		}
	}
	
	public boolean enregistrer(String f)
	{
		ConfigNat.getCurrentConfig().setFichierConf(f);
		return enregistrer();
	}
	public boolean enregistrer()
	{
	    //System.out.println("/viremoi/ confgeneral.enregister"+ConfigNat.getCurrentConfig().getFichierConf());
		boolean retour = true;
		try
		{
			ConfigNat.getCurrentConfig().setLongueurLigne(Integer.parseInt(jtfLongLigne.getText()));
			ConfigNat.getCurrentConfig().setTableBraille((String)comboTables.getSelectedItem());
			ConfigNat.getCurrentConfig().setAbreger(abreger.isSelected());
			ConfigNat.getCurrentConfig().setTraiterLiteraire(bLit.isSelected());
			ConfigNat.getCurrentConfig().setTraiterMaths(bMaths.isSelected());
			ConfigNat.getCurrentConfig().setTraiterMusique(bMusique.isSelected());
			ConfigNat.getCurrentConfig().setSourceEncoding((String)jcbCharsetSource.getSelectedItem());
			ConfigNat.getCurrentConfig().setSortieEncoding((String)jcbCharsetSortie.getSelectedItem());
			ConfigNat.getCurrentConfig().setNiveauLog(cbLog.getSelectedIndex()+1);
			ConfigNat.getCurrentConfig().setCoupure(jcbCoupure.isSelected());
			ConfigNat.getCurrentConfig().setModeCoupureSagouin(jcbSagouin.isSelected());
			//ConfigNat.getCurrentConfig().Sauvegarder();
		}
		catch (NumberFormatException nbe)
		{
			/*JOptionPane jopErreur = new JOptionPane();
			jopErreur.showMessageDialog( jfParent,"Vous devez entrer un entier pour la longueur de la ligne et la taille de police","Erreur de saisie", jopErreur.ERROR_MESSAGE);*/
			JOptionPane.showMessageDialog( jfParent,"Vous devez entrer un entier pour la longueur de la ligne et la taille de police","Erreur de saisie", JOptionPane.ERROR_MESSAGE);
			retour = false;
		}
		return retour;
	}
	
	public JComboBox getComboTables()
	{
		return comboTables;
	}
}
