/*
 * NAT - An universal Translator
 * Copyright (C) 2005 Bruno Mascret
 * Contact: bmascret@free.fr
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

package ui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Collections;
import java.util.Vector;

import nat.ConfigNat;

import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
//import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ConfEmbossage extends OngletConf implements ItemListener
{
	private static final long serialVersionUID = 1L;
	//private ConfigNat confNat;
	//private JFrame jfParent;
	private JLabel lCommande = new JLabel("Commande impression:");
	private JTextField tfCommande = new JTextField(20);
	/* plus besoin: détection automatique
	private JComboBox jcbOs = new JComboBox();
	private JLabel lOs = new JLabel("Système d'exploitation:");*/
	private JLabel ljcbTable = new JLabel("Table Braille pour l'embossage:");
	private JComboBox jcbTablesEmb = new JComboBox();
	private JCheckBox jchbCommande = new JCheckBox("Utiliser une commande système pour l'embossage");
	private JCheckBox jchbEmbosseuse = new JCheckBox("Utiliser directement un périphérique d'embossage");
	private JLabel lEmbosseuse = new JLabel("Choix du périphérique:");
	private JComboBox jcbEmbosseuse = new JComboBox();
	
	public ConfEmbossage()//, JFrame jfp)
	{
		super();
		//this.confNat = confNat;
		//this.jfParent = jfp;
		/*GridLayout grille=new GridLayout(7,3);
		setLayout(grille);*/
		
		/**********
		 * Préparation des composants
		 */
		

		/* Table embossage braille */
		File repertoire =new File("xsl/tablesEmbosseuse");
		File[] listTables = repertoire.listFiles();
		int taille = listTables.length;
		Vector<String> namesList = new Vector<String>(taille);
		
		for(int i=0;i<taille;i++)
	    {
	    	String nomTable = listTables[i].getName() ;
	    	if (nomTable.endsWith(".ent") && !nomTable.equals("Embtab.ent"))
	    	{
	    		namesList.add(nomTable.substring(0,nomTable.length()-4));
	    	}
	    }
		
		Collections.sort(namesList);
		
		jcbTablesEmb  = new JComboBox(namesList);
		jcbTablesEmb.setSelectedItem(ConfigNat.getCurrentConfig().getTableEmbossage());
		jcbTablesEmb.setEditable(false);
	    jcbTablesEmb.getAccessibleContext().setAccessibleName("Liste à choix multiples table braille");
	    jcbTablesEmb.getAccessibleContext().setAccessibleDescription("Sélectionner à l'aide des flèches la table braille à utiliser pour l'embossage");
	    jcbTablesEmb.setToolTipText("Sélectionner la table braille d'embossage");

	    ljcbTable.setLabelFor(jcbTablesEmb);
	    
	    /*
	    jcbOs.addItem("Linux");
	    jcbOs.addItem("Windows");
	    jcbOs.addItem("MacOS");

	    String os = confNat.getOs();
	    if (os.compareTo("Linux")==0) {jcbOs.setSelectedIndex(0);}
	    else if (os.compareTo("Windows")==0){jcbOs.setSelectedIndex(1);}
	    else if (os.compareTo("MacOS")==0){jcbOs.setSelectedIndex(2);}

	    jcbOs.setEditable(false);
	    jcbOs.getAccessibleContext().setAccessibleName("Liste à choix multiples système d'exploitation");
	    jcbOs.getAccessibleContext().setAccessibleDescription("Sélectionner à l'aide des flèches votre système d'exploitation");
	    jcbOs.setToolTipText("Sélectionner votre système d'exploitation");

	    lOs.setLabelFor(jcbOs);*/
	    
	    jchbCommande.getAccessibleContext().setAccessibleName("Case à cocher utilisation d'une commande système pour l'embossage");
	    jchbCommande.getAccessibleContext().setAccessibleDescription("Cochez cette case si vous souhaitez embosser à l'aide d'une commande");
	    jchbCommande.setToolTipText("Cochez cette case si vous souhaitez embosser à l'aide d'une commande");
	    jchbCommande.setSelected(ConfigNat.getCurrentConfig().getUtiliserCommandeEmbossage());
	    jchbCommande.setMnemonic('c');
	    
	    jchbCommande.addItemListener(this);
	  
	    lCommande.setLabelFor(tfCommande);
	    tfCommande.getAccessibleContext().setAccessibleName("Zone de texte commande pour l'embossage");
	    tfCommande.getAccessibleContext().setAccessibleDescription("Entrez la commande à exécuter pour lancer l'embossage");
	    tfCommande.setToolTipText("Entrez la commande à exécuter pour lancer l'embossage");
	    tfCommande.setText(ConfigNat.getCurrentConfig().getCommande());
	    
	    if(!jchbCommande.isSelected())
	    {
	    	lCommande.setEnabled(false);
	    	tfCommande.setEnabled(false);
	    }
	    else
	    {
	    	jchbEmbosseuse.setSelected(false);
	    }
	    
	    jchbEmbosseuse.getAccessibleContext().setAccessibleName("Case à cocher utilisation directe d'une embosseuse");
	    jchbEmbosseuse.getAccessibleContext().setAccessibleDescription("Cochez cette case si vous souhaitez embosser directement à l'aide d'une embosseuse installée");
	    jchbEmbosseuse.setToolTipText("Cochez cette case si vous souhaitez embosser à l'aide d'une embosseuse installée");
	    jchbEmbosseuse.setMnemonic('e');
	    jchbEmbosseuse.addItemListener(this);
	    jchbEmbosseuse.setSelected(ConfigNat.getCurrentConfig().getUtiliserEmbosseuse());
	  
	    lEmbosseuse.setLabelFor(jcbEmbosseuse);
	    jcbEmbosseuse.getAccessibleContext().setAccessibleName("Zone de texte commande pour l'embossage");
	    jcbEmbosseuse.getAccessibleContext().setAccessibleDescription("Entrez la commande à exécuter pour lancer l'embossage");
	    jcbEmbosseuse.setToolTipText("Entrez la commande à exécuter pour lancer l'embossage");
	    //jcbEmbosseuse.setText(confNat.getembosseuse());
	    setListePrinters(jcbEmbosseuse);
	    
	    if(!jchbEmbosseuse.isSelected())
	    {
	    	jcbEmbosseuse.setEnabled(false);
	    	lEmbosseuse.setEnabled(false);
	    }
	    else
	    {
	    	jchbCommande.setSelected(false);
	    }
		/*********
		 * Mise en page
		 */
		
		JPanel pEmbo = new JPanel();
		GridBagConstraints gbc = new GridBagConstraints();
		GridBagLayout gbl = new GridBagLayout();
		pEmbo.setLayout(gbl);
		
		JLabel titre = new JLabel("<html><h3>Configuration de l'embossage</h3></html>");
		
		gbc.anchor = GridBagConstraints.WEST;
		gbc.gridx = 0;
		gbc.gridy = 0;
		gbl.setConstraints(titre, gbc);
		pEmbo.add(titre);
		
		gbc.anchor = GridBagConstraints.WEST;
		gbc.gridx = 0;
		gbc.gridy = 1;
		gbl.setConstraints(ljcbTable, gbc);
		pEmbo.add(ljcbTable);
		
		gbc.gridx = 1;
		gbc.gridy = 1;
		gbl.setConstraints(jcbTablesEmb, gbc);
		pEmbo.add(jcbTablesEmb);
		
		gbc.gridx = 0;
		gbc.gridy = 2;
		gbc.gridwidth = 2;
		gbl.setConstraints(jchbCommande, gbc);
		pEmbo.add(jchbCommande);
		
		gbc.gridx = 0;
		gbc.gridy = 3;
		gbc.gridwidth = 1;
		gbc.anchor = GridBagConstraints.EAST;
		gbl.setConstraints(lCommande, gbc);
		pEmbo.add(lCommande);
		
		gbc.gridx = 1;
		gbc.gridy = 3;
		gbc.anchor = GridBagConstraints.WEST;
		gbl.setConstraints(tfCommande, gbc);
		pEmbo.add(tfCommande);
		
		gbc.gridx = 0;
		gbc.gridy = 4;
		gbc.gridwidth = 2;
		gbl.setConstraints(jchbEmbosseuse, gbc);
		pEmbo.add(jchbEmbosseuse);
		
		gbc.gridx = 0;
		gbc.gridy = 5;
		gbc.gridwidth = 1;
		gbc.anchor = GridBagConstraints.EAST;
		gbl.setConstraints(lEmbosseuse, gbc);
		pEmbo.add(lEmbosseuse);
		
		gbc.gridx = 1;
		gbc.gridy = 5;
		gbc.anchor = GridBagConstraints.WEST;
		gbl.setConstraints(jcbEmbosseuse, gbc);
		pEmbo.add(jcbEmbosseuse);
		/*pEmbo.add(lOs);
		pEmbo.add(jcbOs);*/
		add(pEmbo);
	}
	
	private void setListePrinters(JComboBox jcb) 
	{
		//on récupère les imprimantes et leur docFlavors
		PrintService[] pservices = PrintServiceLookup.lookupPrintServices(null, null);
		//if (pservices.length > 0)
		//{
			//il y a des imprimantes?
			jcb.setEnabled(false);
			for (int i = 0; i < pservices.length; i++)
			{
				//System.out.println(pservices[i]);
				if(pservices[i]!= null)
				{
					jcb.addItem(pservices[i].getName());
					if (ConfigNat.getCurrentConfig().getPrintservice()!= null && pservices[i].getName().compareTo(ConfigNat.getCurrentConfig().getPrintservice())==0)
					{
						jcb.setSelectedIndex(i);
					}
					jcb.setEnabled(true);
				}
			}
		/*}
		else
		{
			jcb.setEnabled(false);
		}*/
	}
	
	public boolean enregistrer(String f)
	{
		ConfigNat.getCurrentConfig().setFichierConf(f);
		return enregistrer();
	}

	public boolean enregistrer()
	{
	    //System.out.println("/viremoi/ confemboss.enregister"+ConfigNat.getCurrentConfig().getFichierConf());
		boolean retour = true;
		ConfigNat.getCurrentConfig().setTableEmbossage((String)jcbTablesEmb.getSelectedItem());
		//confNat.setOs((String)jcbOs.getSelectedItem());
		ConfigNat.getCurrentConfig().setCommande(tfCommande.getText());
		ConfigNat.getCurrentConfig().setUtiliserCommandeEmbossage(jchbCommande.isSelected());
		ConfigNat.getCurrentConfig().setUtiliserEmbosseuse(jchbEmbosseuse.isSelected());
		ConfigNat.getCurrentConfig().setPrintService((String)jcbEmbosseuse.getSelectedItem());
		//ConfigNat.getCurrentConfig().Sauvegarder();
		return retour;
	}

	public void itemStateChanged(ItemEvent e)
	{
		if (e.getSource()==jchbCommande)
		{
		    if(!jchbCommande.isSelected())
		    {
		    	lCommande.setEnabled(false);
		    	tfCommande.setEnabled(false);
		    }
		    else
		    {
		    	lCommande.setEnabled(true);
		    	tfCommande.setEnabled(true);
		    	jchbEmbosseuse.setSelected(false);
		    }
		}
		else if (e.getSource()==jchbEmbosseuse)
		{
		    if(!jchbEmbosseuse.isSelected())
		    {
		    	lEmbosseuse.setEnabled(false);
		    	jcbEmbosseuse.setEnabled(false);
		    }
		    else
		    {
		    	lEmbosseuse.setEnabled(true);
		    	jcbEmbosseuse.setEnabled(true);
		    	jchbCommande.setSelected(false);
		    	//dispatchEvent(new ItemEvent(jchbCommande, ItemEvent.DESELECTED, jchbCommande, ItemEvent.DESELECTED));
		    }
		}
		
	}
	
	public JComboBox getComboTables()
	{
		return jcbTablesEmb;
	}
}
