package ui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import javax.swing.JCheckBox;
import javax.swing.JPanel;

import nat.ConfigNat;

public class ConfAvance extends OngletConf
{
	private static final long serialVersionUID = 1L;
	private JCheckBox jcbXsltProc = new JCheckBox("Saxon au lieu de Xalan (devrait rester coché dans le cas d'une utilisation normale de NAT)");

	
	public ConfAvance()
	{
		super();	
		
		jcbXsltProc.setSelected(ConfigNat.getCurrentConfig().getSaxonAsXsltProcessor());
		jcbXsltProc.getAccessibleContext().setAccessibleName("Case à cocher utiliser Saxon");
		jcbXsltProc.getAccessibleContext().setAccessibleDescription("Cocher la case pour utiliser saxon");
		jcbXsltProc.setToolTipText("Utiliser le processeur xslt Saxon et pas Xalan (usage normal de NAT)");
		jcbXsltProc.setMnemonic('x');
		
		/*********
		 * Mise en page
		 */
		
		GridBagConstraints gbc = new GridBagConstraints();
		GridBagLayout gbl = new GridBagLayout();
		//setLayout(gbl);
		
		JPanel p = new JPanel();
		p.setLayout(gbl);
		
		gbc.gridx=0;
		gbc.gridy = 0;
		gbc.gridwidth = 1;
		p.add(jcbXsltProc,gbc);
		
		add(p);
	}

	public boolean enregistrer(String f)
	{
		ConfigNat.getCurrentConfig().setFichierConf(f);
		return enregistrer();
	}
	public boolean enregistrer()
	{
	    //System.out.println("/viremoi/ confgeneral.enregister"+ConfigNat.getCurrentConfig().getFichierConf());
		boolean retour = true;
		ConfigNat.getCurrentConfig().setSaxonAsXsltProcessor(jcbXsltProc.isSelected());
		return retour;
	}
}
