

/**
* A class for conversion of text file from
* UNIX to Windows.
*/

package outils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;


public class TextConverter
{
	private File file;
	
	public TextConverter (String s) 
	{
		file= new File (s);
	}
	
	public void convert() throws Exception
	{
		if (file.exists())
		{
			FileInputStream reader= new FileInputStream (file);
			File result= new File(file.getPath()+".txt");
			if(result.exists()){result.delete();}
			result.createNewFile();
			FileOutputStream writer= new FileOutputStream (result);
			int red= reader.read();
			while (red != -1)
			{
				// inserts a byte 13 before 10
				if (red==10) {writer.write(13);}
				// writes the current byte
				writer.write(red);
				// next byte is red.
				red= reader.read();
			}
			
			reader.close();
			writer.close();
			
			// deletes the old file
			file.delete();
			// renames the new one
			result.renameTo(file);
		}
	}
}

