/*
 * NAT - An universal Translator
 * Copyright (C) 2005 Bruno Mascret
 * Contact: bmascret@free.fr
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
package outils;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import gestionnaires.GestionnaireErreur;
import nat.ConfigNat;
import nat.Nat;
import outils.TextConverter;

public class EmbosseurLDC extends Embosseur
{
	private String ldc = "";
	//private String port;
	public static final int OS_LINUX = 1;
	public static final int OS_WINDOWS = 2;
	public static final int OS_MAC = 3;

	public EmbosseurLDC(String f, GestionnaireErreur g) 
	{
		super(f, g);
	}
	
	public void setLdc(String s, String fic)
	{	
		System.out.println(s);
		ldc = s.replace("$f", fic);
		System.out.println(ldc);
	}
	
	public void fabriqueExec(int os)
	{
		File fff = new File(fichier);
		if(os == OS_LINUX)
		{
			gest.AfficheMessage("\n***Système d'exploitation: Linux", Nat.LOG_VERBEUX);
			gest.AfficheMessage("\n***Création du script", Nat.LOG_VERBEUX);
			setLdc(ConfigNat.getCurrentConfig().getCommande(), fff.getPath()); //ldc est assignée
			try
			{
				BufferedWriter fichier = new BufferedWriter(new OutputStreamWriter(new FileOutputStream("outils/emboss.bat"),"UTF-8"));
				//FileWriter fichierXSL = new FileWriter(filtre);
				fichier.write("#!/bin/sh\n#Generated file/fichier genere par NAT\n");
				fichier.write("exec=exec\n");
				fichier.write("exec " + ldc + ";");
				fichier.close();
			}
			catch (IOException e)
			{
				gest.AfficheMessage("\nErreur lors de la création du script d'embossage" + e,Nat.LOG_NORMAL);
			}
		}
		else if(os == OS_WINDOWS)
		{
			gest.AfficheMessage("\n***Système d'exploitation: Windows", Nat.LOG_VERBEUX);
			gest.AfficheMessage("\n***Création du script", Nat.LOG_VERBEUX);
			/* TextConverter f = new TextConverter (fichier);
			try {
					f.convert(); //conversion des lf en crlf pour impression
				} catch(Exception e) {System.err.println("Erreur");} */
			setLdc(ConfigNat.getCurrentConfig().getCommande(), fff.getPath()); //ldc est assignée			
			try
			{
				BufferedWriter fichier = new BufferedWriter(new OutputStreamWriter(new FileOutputStream("emboss.bat"),"UTF-8"));
				//FileWriter fichierXSL = new FileWriter(filtre);
				fichier.write(ldc);
				fichier.close();
			}
			catch (IOException e)
			{
				gest.AfficheMessage("\nErreur lors de la création du script d'embossage" + e,Nat.LOG_NORMAL);
			}
		}
		else
		{
			
		}
	}

	public void Embosser() 
	{
		gest.AfficheMessage("\nEmbossage", Nat.LOG_NORMAL);
		// setLdc(ConfigNat.getCurrentConfig().getCommande()); maintenant dans FabriqueExec
		if(!ConfigNat.getCurrentConfig().getCommande().equals(""))
		{
			System.out.println("système:" + System.getProperty("os.name"));
			if(System.getProperty("os.name").startsWith("Linux"))
			{
				gest.AfficheMessage("\n**Ecriture du script", Nat.LOG_VERBEUX);
				fabriqueExec(OS_LINUX);
				gest.AfficheMessage("\n**Lancement de l'embossage", Nat.LOG_VERBEUX);
				Runtime runTime = Runtime.getRuntime();
				int res = 0;
				try
				{
					Process p = runTime.exec("outils/emboss " + fichier);
					res = p.waitFor();
				}
				catch (IOException e) {gest.AfficheMessage("\nErreur d'entrée/sortie", Nat.LOG_NORMAL);}
				catch (InterruptedException e) {gest.AfficheMessage("\nErreur de communication avec l'embosseuse", Nat.LOG_NORMAL);}
				if (res != 0)
				{//le processus p ne s'est pas terminé normalement
					gest.AfficheMessage("\nLe script d'embossage a renvoyé une erreur", Nat.LOG_NORMAL);
				}
				/*CommandRunner c = new CommandRunner("outils/emboss " + fichier);
				c.waitForCompletion();*/
			}
			else if(System.getProperty("os.name").startsWith("Windows"))
			{
				Runtime runTime = Runtime.getRuntime();
				int res = 0;
				gest.AfficheMessage("\n**Ecriture du script", Nat.LOG_VERBEUX);
				fabriqueExec(OS_WINDOWS);
				gest.AfficheMessage("\n**Lancement de l'embossage", Nat.LOG_VERBEUX);
				TextConverter f = new TextConverter (fichier);
				try 
				{
					f.convert(); //conversion des lf en crlf pour impression
				}
				catch (Exception e) {gest.AfficheMessage("\nErreur de TextConverter", Nat.LOG_NORMAL);}
				try
				{
					Process p = runTime.exec("emboss.bat");
					res = p.waitFor();
				}
				catch (IOException e) {gest.AfficheMessage("\nErreur d'entrée/sortie", Nat.LOG_NORMAL);}
				catch (InterruptedException e) {gest.AfficheMessage("\nErreur de communication avec l'embosseuse", Nat.LOG_NORMAL);}
				if (res != 0)
				{//le processus p ne s'est pas terminé normalement
					gest.AfficheMessage("\nLe processus d'embossage a renvoyé une erreur", Nat.LOG_NORMAL);
				}
			}
			else{gest.AfficheMessage("\nSystème d'exploitation inconnu", Nat.LOG_NORMAL);}

		}
		else
		{
			gest.AfficheMessage("\nErreur: Pas de ligne de commande entrée", Nat.LOG_NORMAL);
		}
		gest.AfficheMessage("\n--Embossage terminé", Nat.LOG_NORMAL);
	}
	
	public void Embosser(String f)
	{
		fichier = f;
		Embosser();		
	}
	
	/*
	public static void main(String[] arg)
	{
		EmbosseurLDC e = new EmbosseurLDC("/home/developpement/trans/test.txt", null,null);
		e.setLdc("cat $f > /dev/lp0");
		e.Embosser();
	}*/


}
