/*
 * NAT - An universal Translator
 * Copyright (C) 2005 Bruno Mascret
 * Contact: bmascret@free.fr
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/
package outils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.Sides;


import nat.ConfigNat;
import nat.Nat;
import gestionnaires.GestionnaireErreur;

public class EmbosseurInstalle extends Embosseur
{

	public EmbosseurInstalle(String f, GestionnaireErreur g)
	{
		super(f, g);
	}

	public void Embosser()
	{
		gest.AfficheMessage("\nEmbossage", Nat.LOG_NORMAL);
		gest.AfficheMessage("\n**Recherche des imprimantes", Nat.LOG_VERBEUX);
		// recherche de l'embosseuse sélectionnée
		boolean trouve = false;
		
		PrintService[] pservices = PrintServiceLookup.lookupPrintServices(null, null);
		if (pservices.length > 0)
		{
			//il y a des imprimantes
			int i =0;
			while (!trouve && i < pservices.length)
			{			
				//System.out.println(pservices[i]);
				if (pservices[i].getName().compareTo(ConfigNat.getCurrentConfig().getPrintservice())==0)
				{
					gest.AfficheMessage("\n**Sélection de l'imprimante " + pservices[i].getName(), Nat.LOG_VERBEUX);
					
					FileInputStream fis = null;
					try {
					   fis = new FileInputStream(fichier);
					}
					catch (FileNotFoundException ffne)
					{
						ffne.printStackTrace();
					}
					if (!(fis==null))
					{
						gest.AfficheMessage("\n**Création du document", Nat.LOG_VERBEUX);
						DocFlavor [] sdf = pservices[i].getSupportedDocFlavors();
						
						gest.AfficheMessage("\n*** Liste des DocFlavor supportés:",Nat.LOG_DEBUG);
						for (int j=0; j< sdf.length; j++)
						{
							gest.AfficheMessage("\n - " + sdf[j],Nat.LOG_VERBEUX);
						}
						
						DocFlavor fisFormat = DocFlavor.INPUT_STREAM.TEXT_PLAIN_HOST;						
						if(!pservices[i].isDocFlavorSupported(fisFormat))
						{
							gest.AfficheMessage("\n**Avertissement: impossible d'utiliser le DocFlavor spécifié, remplacement par un DocFlavor plus générique... ", Nat.LOG_VERBEUX);
							fisFormat = DocFlavor.INPUT_STREAM.AUTOSENSE;
						}
						if(pservices[i].isDocFlavorSupported(fisFormat))
						{
							Doc document = new SimpleDoc(fis, fisFormat, null); 
							PrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
							aset.add(new Copies(1));
							aset.add(MediaSizeName.ISO_A4);
							aset.add(Sides.DUPLEX);
							try
							{
								gest.AfficheMessage("\n**Impression", Nat.LOG_VERBEUX);
								DocPrintJob job = pservices[i].createPrintJob();
								job.print(document, aset);
								
							}
							catch (PrintException e)
							{
								gest.AfficheMessage("\n** Erreur lors de l'impression", Nat.LOG_NORMAL);
								e.printStackTrace();
							}
							catch (Exception e)
							{
								gest.AfficheMessage("\n** Erreur d'impression", Nat.LOG_NORMAL);
								e.printStackTrace();
							}
						}
						else
						{
							gest.AfficheMessage("\n** Erreur: l'imprimante séléctionnée ne peut imprimer en mode texte via java", Nat.LOG_NORMAL);
						}
					}
					else
					{
						gest.AfficheMessage("\nErreur lors de la création du fichier d'impression", Nat.LOG_NORMAL);
					}
					trouve = true;
				}
				i++;
			}
			gest.AfficheMessage("\n--Impression terminée", Nat.LOG_NORMAL);
		}
	}

	public void Embosser(String f)
	{
		fichier = f;
		Embosser();
	}	
}
