package nat.presentateur;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;

import nat.Nat;
import gestionnaires.GestionnaireErreur;

public class PresentateurSans extends Presentateur
{
	private String charset;
	private GestionnaireErreur gest;

	public PresentateurSans(GestionnaireErreur gest, String charset, String source,String sortie)
	{
		super(source,sortie);
		this.gest = gest;
		this.charset = charset;
		
	}
	public boolean presenter()
	{
		tempsExecution = System.currentTimeMillis();
		gest.AfficheMessage("\nDébut de la mise en forme du document ... ok\n",Nat.LOG_SILENCIEUX);
		//encodage dans le charset désiré
		if(!charset.equals("UTF-8"))
		{
			gest.AfficheMessage("\n** encodage du fichier de sortie en " + charset + "...", Nat.LOG_NORMAL);
			encode("UTF-8", charset);
		}
		else
		{
			File fsource = new File(source);
			File fsortie = new File(sortie);
			fsource.renameTo(fsortie);
		}
		gest.AfficheMessage("ok\n** mise en forme ...",Nat.LOG_NORMAL);
		tempsExecution = System.currentTimeMillis() - tempsExecution;
		return true;
	}

	/**	
	* Transfert le contenu texte d’un fichier dans un autre fichier en assurant
	* la conversion de l’encodage du texte
	* 
	* @param in
	*            Fichier d’origine. Ne sera pas modifié sauf si passé en 2ème
	*            paramètre également
	* @param out
	*            Fichier à créer
	* @param encodingIn
	*            Encodage du fichier d’origine (tel que ISO-8859-15, UTF-8 ou
	*            UTF-16)
	* @param encodingOut
	*            Encodage du fichier de destination
	* @throws FileNotFoundException Quand le fichier d’origine n’existe pas
	* @throws IllegalCharsetNameException Quand un des encodages est invalide ou introuvable
	* @throws UnsupportedCharsetException Quand un des encodages n’est pas supporté
	* @throws IOException Erreur d’entrées/sorties
	*/

	public  void convert(File in, File out, String encodingIn, String encodingOut) throws FileNotFoundException, IllegalCharsetNameException, UnsupportedCharsetException,	
	IOException 
	{
		CharsetDecoder decoder = Charset.forName(encodingIn).newDecoder();
		CharsetEncoder encoder = Charset.forName(encodingOut).newEncoder();
		FileInputStream fis = new FileInputStream(in);
		FileChannel channelIn = fis.getChannel();
		MappedByteBuffer buffer = channelIn.map(FileChannel.MapMode.READ_ONLY,
		0, channelIn.size()); // Mappe tout le fichier dans buffer
		channelIn.close();
		fis.close();
		FileOutputStream fos = new FileOutputStream(out);
		FileChannel channelOut = fos.getChannel();
		channelOut.write(encoder.encode(decoder.decode(buffer)));
		channelOut.close();
		fos.close();
	}


}