package nat.presentateur;

import java.io.BufferedReader;
import java.io.BufferedWriter;
//import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
//import java.nio.charset.Charset;

//import nat.Nat;

public abstract class Presentateur
{
	protected String sortie;
	protected String source;
	protected long tempsExecution;

	public Presentateur(String src, String sor)
	{
		source= src;
		sortie = sor;
	}
	public long donneTempsExecution(){return tempsExecution;}
	
	protected void encode(String charsetSource, String charsetCible)
	{
		try 
		{
			BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(source),charsetSource));
			BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(sortie),charsetCible));
			String ligne;
			while ((ligne = br.readLine()) != null)
			{
				bw.write(ligne+"\n");
				//System.out.println(ligne);
			}
			br.close();
			bw.close();
		}
		catch (FileNotFoundException fnfe)
		{
			System.out.println("Erreur fnfe");
			fnfe.printStackTrace();
		}
		catch(IOException ioe)
		{
			System.out.println("Erreur ioe");
			ioe.printStackTrace();
		}
	finally
		{
			//voir le truc pour fermer proprement dans tous les cas
		}
	}
	public abstract boolean presenter();
}