package nat.convertisseur;

import nat.Nat;
import nat.Transcription;
//***  java.io ***
import java.io.File;
//import java.io.FileReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
// *** gestionnaires ***
import gestionnaires.GestionnaireErreur;

public class ConvertisseurXML extends Convertisseur
{
	public ConvertisseurXML(String source, String cible)
	{
		super(source, cible);
	}

	public boolean convertir(GestionnaireErreur gest)
	{
		tempsExecution = System.currentTimeMillis();
		boolean retour = false;
		gest.AfficheMessage("ok\n** Conversion au format interne...",Nat.LOG_VERBEUX);
		retour = XHTML2FormatInterne(source, gest, "xsl/xhtml2interne.xsl"); 
		tempsExecution = System.currentTimeMillis() - tempsExecution;
		//gest.AfficheMessage("ok\n----Conversion terminée en " + tempsExecution + " msec.\n",Nat.LOG_SILENCIEUX);
		return retour;
	}

	public boolean XHTML2FormatInterne(String source, GestionnaireErreur gestErreur, String filtre)
	{
		gestErreur.AfficheMessage("ok\n*** Création de la fabrique (DocumentBuilderFactory) ...",Nat.LOG_VERBEUX);
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		//configuration de la fabrique
		factory.setNamespaceAware(true);/*
		try{
			factory.setAttribute("indent-number", new Integer(6));
		}
		catch(IllegalArgumentException iae){}*/
		factory.setValidating(true);//je mets a false: pas besoin de réseau: non, voir xhtmlDocument
		//factory.setIgnoringElementContentWhitespace(true);
		factory.setIgnoringComments(true);
		factory.setIgnoringElementContentWhitespace(false);
		try 
		{
			DocumentBuilder builder = factory.newDocumentBuilder();
			gestErreur.AfficheMessage("ok\n*** Parsage du document d'entrée XHTML avec SAX ...",Nat.LOG_VERBEUX);
			builder.setErrorHandler(gestErreur);
			Document doc = builder.parse(new File(source));
			doc.setStrictErrorChecking(true);
			gestErreur.AfficheMessage("ok\n*** Initialisation et lecture de la feuille de style de conversion...",Nat.LOG_VERBEUX);
			TransformerFactory transformFactory = TransformerFactory.newInstance();
			StreamSource styleSource = new StreamSource(new File(filtre));
			// lire le style
			
			Transformer transform = transformFactory.newTransformer(styleSource);
			// conformer le transformeur au style
			DOMSource in = new DOMSource(doc);
			gestErreur.AfficheMessage("ok\n*** Création du fichier au format interne ...",Nat.LOG_VERBEUX);
			// Création du fichier de sortie
			//File file = new File("tmpEntites.xhtml");
			File file = new File(Transcription.fTempXML);
			///Result resultat = new StreamResult(fichier);
			StreamResult out = new StreamResult(file);
			gestErreur.AfficheMessage("ok\n*** Transformation du document interne...",Nat.LOG_VERBEUX);
			transform.transform(in, out);
			return true;
		}
		catch (Exception e)  
		{
			gestErreur.setException(e);
			gestErreur.GestionErreur();
			return false;
		}
	}
}