package nat.convertisseur;

import gestionnaires.GestionnaireErreur;
import nat.Nat;
import nat.Transcription;
// *** writer2latex ***
/*import writer2latex.Writer2XHTML;
import writer2latex.office.MIMETypes;*/
//import java.io.BufferedWriter;
import java.io.FileInputStream;
//import java.io.FileNotFoundException;
import java.io.FileOutputStream;
//import java.io.File;
//import java.io.IOException;
//import java.io.OutputStreamWriter;
//import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
//import java.util.Enumeration;
import writer2latex.api.*;
import writer2latex.office.MIMETypes;
import writer2latex.util.Config;


public class ConvertisseurOpenOffice extends ConvertisseurXML
{

	public ConvertisseurOpenOffice(String source, String cible)
	{
		super(source, cible);
	}

	public boolean convertir(GestionnaireErreur gest)
	{
		tempsExecution = System.currentTimeMillis();
		boolean retour;
		/*
		//conversion en XHTML avec writer2xhtml
		Writer2XHTML w2x = new Writer2XHTML();
		w2x.setsOutputFormat("xhtml");
		w2x.setTargetMime(MIMETypes.XHTML_MATHML);
		//w2x.setsFileName(source);
		w2x.setsSource(source);
		w2x.setsOutFileName("tmp.xhtml");
		w2x.setsOutPathName("");
		gest.AfficheMessage("** Conversion en XHTML avec Writer2XHTML...",Nat.LOG_VERBEUX);
		w2x.doConversion();*/
		gest.AfficheMessage("** Conversion en XHTML avec Writer2XHTML...",Nat.LOG_VERBEUX);
		//Create a XHTML converter
		ConverterFactory factory = new ConverterFactory();
		Converter converter = factory.createConverter(MIMETypes.XHTML_MATHML);
		//Create a configuration
		Config config = new Config();
		try
		{
			config.read(new FileInputStream("writer2latex/cleanxhtml.xml"));
			//config.setOption("inputencoding","utf-8");
			converter.setConfig(config);
			//Convert the document
			ConverterResult result = converter.convert(new FileInputStream(source),Transcription.fTempXHTML);
			Enumeration docEnum = result.getDocumentEnumeration();

			while (docEnum.hasMoreElements()) 
			{
				OutputFile docOut = (OutputFile) docEnum.nextElement();
			    FileOutputStream fos = new FileOutputStream(docOut.getFileName());
			    docOut.write(fos);
			    fos.flush();
			    fos.close();
			}
		}
		catch(Exception e){System.out.println("ya un pb"); e.printStackTrace();};
		/*Write the files
		Enumeration docEnum = dataOut.getDocumentEnumeration();
		while (docEnum.hasMoreElements())
		{
			OutputFile docOut = (OutputFile) docEnum.nextElement();
		    FileOutputStream fos = new FileOutputStream(docOut.getFileName());
		    docOut.write(fos);
		    fos.flush();
		    fos.close();
		}*/
		//conversion de xhtml vers interne
		ConvertisseurXML convXML = new ConvertisseurXML(Transcription.fTempXHTML, cible);
		retour = convXML.convertir(gest);
		tempsExecution = System.currentTimeMillis() - tempsExecution;
		return retour;
	}
}