/*
 * NAT - An universal Translator
 * Copyright (C) 2005 Bruno Mascret
 * Contact: bmascret@free.fr
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

package nat.convertisseur;


//import writer2latex.util.Misc;
// *** gestionnaires ***


import nat.ConfigNat;
import gestionnaires.GestionnaireErreur;

// *** Autres ***
//import javax.swing.text.BadLocationException;
//import javax.swing.text.StyleConstants;

public abstract class Convertisseur
{
	protected String source;
	protected String cible;
	protected int nbCars;
	protected int nbMots;
	protected int nbPhrases;
	protected long tempsExecution;
	protected String DTD = "xsl/" + ConfigNat.getCurrentConfig().getDTD();
	

	public Convertisseur()
	{
		
	}
	
	public Convertisseur(String src, String c)
	{
		source=src;
		cible=c;
	}
	
	public void setSource(String src)
	{
		source=src;
	}
	public void setDTD(String laDTD)
	{
		DTD=laDTD;
	}
	public void setCible(String c)
	{
		cible=c;
	}
	
	public void setFormat(int f)
	{
	
	}
	
	public long donneTempsExecution()
	{
		return tempsExecution;
	}

	public abstract boolean convertir(GestionnaireErreur gest);
	

	

}
