/*
 Copyright 2004-2008 Paul R. Holser, Jr.  All rights reserved.
 Licensed under the Academic Free License version 3.0
 */

package joptsimple.internal;

/**
 * @since 2.1
 * @author <a href="mailto:pholser@alumni.rice.edu">Paul Holser</a>
 * @version $Id: Strings.java,v 1.1 2008/04/01 21:46:46 pholser Exp $
 */
public final class Strings {
    public static final String EMPTY = "";
    public static final String LINE_SEPARATOR = System.getProperty( "line.separator" );

    /**
     * <p>Do not instantiate -- statics only.</p>
     */
    protected Strings() {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>Gives a string consisting of the given character repeated the given number of
     * times.</p>
     *
     * @param ch the character to repeat
     * @param count how many times to repeat the character
     * @return the resultant string
     */
    public static String repeat( char ch, int count ) {
        StringBuffer buffer = new StringBuffer();

        for ( int i = 0; i < count; ++i )
            buffer.append( ch );

        return buffer.toString();
    }

    /**
     * <p>Tells whether the given string is either <code>null</code> or consists solely
     * of whitespace characters.</p>
     *
     * @param target string to check
     * @return <code>true</code> if the target string is null or empty
     */
    public static boolean isNullOrEmpty( String target ) {
        return target == null || EMPTY.equals( target );
    }
    

    /**
     * <p>Returns a string consisting of a given string prepended and appended with
     * surrounding characters.</p>
     *
     * @param target a string
     * @param begin character to prepend
     * @param end character to append
     * @return the surrounded string
     */
    public static String surround( String target, char begin, char end ) {
        return begin + target + end;
    }

    /**
     * Returns a string consisting of the elements of a given array of strings, each
     * separated by a given separator string.
     *
     * @param pieces the strings to join
     * @param separator the separator
     * @return the joined string
     */
    public static String join( String[] pieces, String separator ) {
        StringBuffer buffer = new StringBuffer();
    
        for ( int i = 0; i < pieces.length; ++i ) {
            buffer.append( pieces[ i ] );
    
            if ( i < pieces.length - 1 )
                buffer.append( separator );
        }
    
        return buffer.toString();
    }
}
