/*
 Copyright 2004-2008 Paul R. Holser, Jr.  All rights reserved.
 Licensed under the Academic Free License version 3.0
 */

package joptsimple;

import java.util.Collections;

/**
 * <p>Thrown when the option parser encounters an unrecognized option.</p>
 *
 * @since 1.0
 * @author <a href="mailto:pholser@alumni.rice.edu">Paul Holser</a>
 * @version $Id: UnrecognizedOptionException.java,v 1.3 2008/04/18 15:12:08 pholser Exp $
 */
class UnrecognizedOptionException extends OptionException {
    private static final long serialVersionUID = -1L;

    UnrecognizedOptionException( String option ) {
        super( Collections.singletonList( option ) );
    }
    
    /**
     * {@inheritDoc}
     */
    public String getMessage() {
        return singleOptionMessage() + " is not a recognized option";
    }
}
