/*
 Copyright 2004-2008 Paul R. Holser, Jr.  All rights reserved.
 Licensed under the Academic Free License version 3.0
 */

package joptsimple;

import java.util.List;

/**
 * <p>Specification of an option that accepts a required argument.</p>
 *
 * @since 1.0
 * @author <a href="mailto:pholser@alumni.rice.edu">Paul Holser</a>
 * @version $Id: RequiredArgumentOptionSpec.java,v 1.4 2008/04/30 19:47:40 pholser Exp $
 */
class RequiredArgumentOptionSpec extends ArgumentAcceptingOptionSpec {
    RequiredArgumentOptionSpec( String option ) {
        super( option, true );
    }

    RequiredArgumentOptionSpec( List options, String description ) {
        super( options, true, description );
    }

    protected void detectOptionArgument( OptionParser parser, ArgumentList arguments,
        OptionSet detectedOptions ) {

        if ( !arguments.hasMore() )
            throw new OptionMissingRequiredArgumentException( options() );

        addArguments( detectedOptions, arguments.next() );
    }

    void accept( OptionSpecVisitor visitor ) {
        visitor.visit( this );
    }
}
