/*
 Copyright 2004-2008 Paul R. Holser, Jr.  All rights reserved.
 Licensed under the Academic Free License version 3.0
 */

package joptsimple;

/**
 * <p>Abstraction of parser state; mostly serves to model how a parser behaves depending
 * on whether end-of-options has been detected.</p>
 *
 * @since 1.0
 * @author <a href="mailto:pholser@alumni.rice.edu">Paul Holser</a>
 * @version $Id: OptionParserState.java,v 1.1 2008/03/15 14:45:40 pholser Exp $
 */
abstract class OptionParserState {
    static OptionParserState noMoreOptions() {
        return new OptionParserState() {
            protected void handleArgument( OptionParser parser, ArgumentList arguments,
                OptionSet detectedOptions ) {
    
                detectedOptions.addNonOptionArgument( arguments.next() );
            }
        };
    }

    static OptionParserState moreOptions( final boolean posixlyCorrect ) {
        return new OptionParserState() {
            protected void handleArgument( OptionParser parser, ArgumentList arguments,
                OptionSet detectedOptions ) {
    
                String candidate = arguments.next();
                if ( ParserRules.isOptionTerminator( candidate ) )
                    parser.noMoreOptions();
                else if ( ParserRules.isLongOptionToken( candidate ) )
                    parser.handleLongOptionToken( candidate, arguments, detectedOptions );
                else if ( ParserRules.isShortOptionToken( candidate ) )
                    parser.handleShortOptionToken( candidate, arguments,
                        detectedOptions );
                else {
                    if ( posixlyCorrect )
                        parser.noMoreOptions();

                    detectedOptions.addNonOptionArgument( candidate );
                }
            }
        };
    }

    protected abstract void handleArgument( OptionParser parser, ArgumentList arguments,
        OptionSet detectedOptions );
}
