/*
 Copyright 2004-2008 Paul R. Holser, Jr.  All rights reserved.
 Licensed under the Academic Free License version 3.0
 */

package joptsimple;

import java.util.List;

/**
 * <p>Thrown when the option parser discovers an option that requires an argument,
 * but that argument is missing.</p>
 *
 * @since 1.0
 * @author <a href="mailto:pholser@alumni.rice.edu">Paul Holser</a>
 * @version $Id: OptionMissingRequiredArgumentException.java,v 1.3 2008/04/18 15:12:08 pholser Exp $
 */
class OptionMissingRequiredArgumentException extends OptionException {
    private static final long serialVersionUID = -1L;

    OptionMissingRequiredArgumentException( List options ) {
        super( options );
    }

    public String getMessage() {
        return "Option " + multipleOptionMessage() + " requires an argument";
    }
}
