/*
 Copyright 2004-2008 Paul R. Holser, Jr.  All rights reserved.
 Licensed under the Academic Free License version 3.0
 */

package joptsimple;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/**
 * <p>Thrown when a problem occurs during option parsing.</p>
 *
 * @since 1.0
 * @author <a href="mailto:pholser@alumni.rice.edu">Paul Holser</a>
 * @version $Id: OptionException.java,v 1.4 2008/04/30 19:47:40 pholser Exp $
 */
public abstract class OptionException extends RuntimeException {
    private final List options;

    protected OptionException( List options ) {
        this.options = Collections.unmodifiableList( options );
    }

    /**
     * <p>Gives the option being considered when the exception was created.</p>
     *
     * @since 2.1
     * @return the option being considered when the exception was created
     */
    public List options() {
        return options;
    }

    protected final String singleOptionMessage() {
        return singleOptionMessage( (String) options.get( 0 ) );
    }

    protected final String singleOptionMessage( String option ) {
        return "'" + option + "'";
    }

    protected final String multipleOptionMessage() {
        StringBuffer buffer = new StringBuffer( "[" );
        for ( Iterator iter = options.iterator(); iter.hasNext(); ) {
            buffer.append( singleOptionMessage( (String) iter.next() ) );
            if ( iter.hasNext() )
                buffer.append( ", " );
        }
        buffer.append( ']' );

        return buffer.toString();
    }

    static IllegalOptionClusterException illegalOptionCluster( String option ) {
        return new IllegalOptionClusterException( option );
    }

    static UnrecognizedOptionException unrecognizedOption( String option ) {
        return new UnrecognizedOptionException( option );
    }
}
