/*
 Copyright 2004-2008 Paul R. Holser, Jr.  All rights reserved.
 Licensed under the Academic Free License version 3.0
 */

package joptsimple;

import java.util.List;

/**
 * <p>Thrown when a problem occurs converting a string argument into another type.</p>
 *
 * @since 2.0
 * @author <a href="mailto:pholser@alumni.rice.edu">Paul Holser</a>
 * @version $Id: OptionArgumentConversionException.java,v 1.4 2008/04/30 19:47:40 pholser Exp $
 */
class OptionArgumentConversionException extends OptionException {
    private static final long serialVersionUID = -1L;

    private final String argument;
    private final Class valueType;

    OptionArgumentConversionException( List options, String argument, Class valueType ) {
        super( options );

        this.argument = argument;
        this.valueType = valueType;
    }

    public String getMessage() {
        return "Cannot convert argument '" + argument + "' of option "
            + multipleOptionMessage() + " to " + valueType;
    }
}
