/*
 Copyright 2004-2008 Paul R. Holser, Jr.  All rights reserved.
 Licensed under the Academic Free License version 3.0
 */

package joptsimple;

import java.util.Collections;
import java.util.List;

/**
 * <p>A specification for an option that does not accept arguments.</p>
 *
 * @since 1.0
 * @author <a href="mailto:pholser@alumni.rice.edu">Paul Holser</a>
 * @version $Id: NoArgumentOptionSpec.java,v 1.3 2008/04/10 19:41:55 pholser Exp $
 */
class NoArgumentOptionSpec extends OptionSpec {
    NoArgumentOptionSpec( String option ) {
        this( Collections.singletonList( option ), "" );
    }

    NoArgumentOptionSpec( List options, String description ) {
        super( options, description );
    }

    void handleOption( OptionParser parser, ArgumentList arguments,
        OptionSet detectedOptions, String detectedArgument ) {

        detectedOptions.addAll( options() );
    }

    boolean acceptsArguments() {
        return false;
    }

    boolean requiresArgument() {
        return false;
    }

    void accept( OptionSpecVisitor visitor ) {
        visitor.visit( this );
    }
}
