/*
 Copyright 2004-2008 Paul R. Holser, Jr.  All rights reserved.
 Licensed under the Academic Free License version 3.0
 */

package joptsimple;

import java.util.Collections;

/**
 * <p>
 * Thrown when asking an {@link OptionSet} for a single argument of an option when many
 * have been specified.
 * </p>
 * 
 * @since 1.0
 * @author <a href="mailto:pholser@alumni.rice.edu">Paul Holser</a>
 * @version $Id: MultipleArgumentsForOptionException.java,v 1.3 2008/04/18 15:12:09 pholser Exp $
 */
class MultipleArgumentsForOptionException extends OptionException {
    private static final long serialVersionUID = -1L;

    MultipleArgumentsForOptionException( String option ) {
        super( Collections.singletonList( option ) );
    }

    public String getMessage() {
        return "Found multiple arguments for option " + singleOptionMessage()
            + ", but you asked for only one";
    }
}
