/*
 Copyright 2004-2008 Paul R. Holser, Jr.  All rights reserved.
 Licensed under the Academic Free License version 3.0
 */

package joptsimple;

import java.util.Collections;

/**
 * <p>Thrown when the option parser is asked to recognize an option with illegal
 * characters in it.</p>
 *
 * @since 1.0
 * @author <a href="mailto:pholser@alumni.rice.edu">Paul Holser</a>
 * @version $Id: IllegalOptionSpecificationException.java,v 1.3 2008/04/18 15:12:09 pholser Exp $
 */
class IllegalOptionSpecificationException extends OptionException {
    private static final long serialVersionUID = -1L;

    IllegalOptionSpecificationException( String option ) {
        super( Collections.singletonList( option ) );
    }

    public String getMessage() {
        return singleOptionMessage() + " is not a legal option character";
    }
}
