/*
 Copyright 2004-2008 Paul R. Holser, Jr.  All rights reserved.
 Licensed under the Academic Free License version 3.0
 */

package joptsimple;

import java.util.Collections;

/**
 * <p>Thrown when the option parser discovers a cluster of short options in which
 * at least one of the short options can accept arguments.</p>
 *
 * @since 1.0
 * @author <a href="mailto:pholser@alumni.rice.edu">Paul Holser</a>
 * @version $Id: IllegalOptionClusterException.java,v 1.3 2008/04/18 15:12:08 pholser Exp $
 */
class IllegalOptionClusterException extends OptionException {
    private static final long serialVersionUID = -1L;

    IllegalOptionClusterException( String option ) {
        super( Collections.singletonList( option ) );
    }
    
    public String getMessage() {
        return "Option cluster containing " + singleOptionMessage() + " is illegal";
    }
}
