/*
 Copyright 2004-2008 Paul R. Holser, Jr.  All rights reserved.
 Licensed under the Academic Free License version 3.0
 */

package joptsimple;

/**
 * <p>Wrapper for an array of command line arguments.</p>
 *
 * @since 1.0
 * @author <a href="mailto:pholser@alumni.rice.edu">Paul Holser</a>
 * @version $Id: ArgumentList.java,v 1.1 2008/03/15 14:45:40 pholser Exp $
 */
class ArgumentList {
    private final String[] arguments;
    private int currentIndex;

    ArgumentList( String[] arguments ) {
        this.arguments = (String[]) arguments.clone();
    }

    boolean hasMore() {
        return currentIndex < arguments.length;
    }

    String next() {
        return arguments[ currentIndex++ ];
    }

    String peek() {
        return arguments[ currentIndex ];
    }

    void treatNextAsLongOption() {
        if ( ParserRules.HYPHEN_CHAR != arguments[ currentIndex ].charAt( 0 ) )
            arguments[ currentIndex ] =
                ParserRules.DOUBLE_HYPHEN + arguments[ currentIndex ];
    }
}
