/*
 Copyright 2004-2008 Paul R. Holser, Jr.  All rights reserved.
 Licensed under the Academic Free License version 3.0
 */

package joptsimple;

import java.util.Collections;

/**
 * <p>Represents the <kbd>"-W"</kbd> form of long option specification.</p>
 *
 * @since 1.0
 * @author <a href="mailto:pholser@alumni.rice.edu">Paul Holser</a>
 * @version $Id: AlternativeLongOptionSpec.java,v 1.2 2008/04/08 03:20:18 pholser Exp $
 */
class AlternativeLongOptionSpec extends ArgumentAcceptingOptionSpec {
    AlternativeLongOptionSpec() {
        super( Collections.singletonList( ParserRules.RESERVED_FOR_EXTENSIONS ), true,
            "Alternative form of long options" );

        describedAs( "opt=value" );
    }

    protected void detectOptionArgument( OptionParser parser, ArgumentList arguments,
        OptionSet detectedOptions ) {

        if ( !arguments.hasMore() )
            throw new OptionMissingRequiredArgumentException( options() );

        arguments.treatNextAsLongOption();
    }

    void accept( OptionSpecVisitor visitor ) {
        visitor.visit( this );
    }
}
