/*
 * NAT - An universal Translator
 * Copyright (C) 2005 Bruno Mascret
 * Contact: bmascret@free.fr
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

package gestionnaires;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import javax.swing.JFrame;

import ui.Aide;
import ui.APropos;
import ui.Configuration;
import ui.FenetrePrinc;

public class GestionnaireOuvrirFenetre implements ActionListener
{
	//constantes
	public static final int OUVRIR_OPTIONS = 1;
	public static final int OUVRIR_AIDE = 2;
	public static final int OUVRIR_APROPOS = 3;
	/* 
	 * attributs
	 */
	private int action;
	private FenetrePrinc fPrinc;
	private JFrame fenetre;
	//private ActionListener al;//lui il va servir pour la mise à jour du combo configurations de la fenêtre principale
	
	//constructeur
	public GestionnaireOuvrirFenetre( int action, FenetrePrinc fp)
	{
	    this.action = action;
	    fPrinc = fp;
	}
	
	//méthodes
	 public void actionPerformed(ActionEvent evt) 
	 {    
		 switch (action)
		 {
		 	case OUVRIR_OPTIONS :
		 		if(!fPrinc.getOptionsOuvertes())
		 		{
			 		fenetre = new Configuration(fPrinc);
		 			fPrinc.setOptionsOuvertes(true);
		 			fenetre.setVisible(true);
		 		}
		 		else
		 		{
		 			fenetre.toFront();
		 		}
		 		break;
		 		
		 	case OUVRIR_AIDE :
				@SuppressWarnings("unused")
				Aide aide = new Aide();
		 		break;
		 		
		 	case OUVRIR_APROPOS:
		 		fenetre = new APropos();
		 		//apropos.pack();
		 		fenetre.setVisible(true);
		 		break;
		 }
	 }

}
