/*
 * NAT - An universal Translator
 * Copyright (C) 2005 Bruno Mascret
 * Contact: bmascret@free.fr
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

package gestionnaires;

import java.awt.event.*;
import javax.swing.JFileChooser;
import java.io.File;
import ui.FenetrePrinc;
import ui.FiltreFichier;

public class GestionnaireOuvrir implements ActionListener
{
	//constantes
	public static final int OUVRIR_SOURCE = 1;
	public static final int OUVRIR_FILTRE = 2;
	public static final int OUVRIR_SORTIE = 3;
	/* 
	 * attributs
	 */
	private JFileChooser selectionneFichier = new JFileChooser();
	private FenetrePrinc fenetre;
	private int action;
	//les filtres
	FiltreFichier ftxt = new FiltreFichier( new String[]{"txt"}, "fichiers texte (*.txt)");
	FiltreFichier fxml = new FiltreFichier( new String[]{"xml","mml", "xhtml"},"les fichiers xml (*.xml, *.mml, *.xhtml)");
	FiltreFichier foo = new FiltreFichier( new String[]{"sxw, odt"}, "fichiers openoffice writer (*.sxw, *.odt)");	
	
	//constructeur
	public GestionnaireOuvrir(FenetrePrinc fenetre, int action)
	{
		this.fenetre = fenetre;
		this.action = action;
		File f = new File(fenetre.getEntree().getText());
		if (!f.exists() || f.getParent()==null)
		{
			f = new File("./documents/");
			selectionneFichier.setCurrentDirectory(f);
		}
		if (action==OUVRIR_SOURCE || action == OUVRIR_SORTIE)
		{
			selectionneFichier.setCurrentDirectory(new File(f.getParent()));
		}
		/*
		else if(action == OUVRIR_SORTIE)
		{
			selectionneFichier.setCurrentDirectory(new File(f.getParent()));
		}
		*/
		else
		{
			selectionneFichier.setCurrentDirectory(new File("./documents/"));
		}
		//ajout des filtres au JFileChooser
		selectionneFichier.addChoosableFileFilter(ftxt);
		selectionneFichier.addChoosableFileFilter(foo);
		selectionneFichier.addChoosableFileFilter(fxml);
		selectionneFichier.setAcceptAllFileFilterUsed(true);
		//selectionneFichier.;
	}
	
	//méthodes
	 public void actionPerformed(ActionEvent evt) 
	 {    
		 selectionneFichier.setApproveButtonText("Choisir ce fichier"); //intitulé du bouton
		 switch (action)
		 {
		 	case OUVRIR_SOURCE :
				selectionneFichier.setDialogTitle("Selection du fichier source");
		 		if (selectionneFichier.showOpenDialog(fenetre) == JFileChooser.APPROVE_OPTION)
		         {    
		 			//si un fichier est selectionné, récupérer le fichier puis son path
					fenetre.setEntree(selectionneFichier.getSelectedFile().getAbsolutePath()); 
		         }
		 		break;
		 	case OUVRIR_FILTRE :
		 		if (selectionneFichier.showOpenDialog(fenetre) == JFileChooser.APPROVE_OPTION)
		         {    
					 fenetre.setFiltre(selectionneFichier.getSelectedFile().getAbsolutePath()); //si un fichier est selectionné, récupérer le fichier puis son path
		         }
		 		break;
		 	case OUVRIR_SORTIE:
				selectionneFichier.setDialogTitle("Selection du fichier de sortie");
		 		if (selectionneFichier.showOpenDialog(fenetre) == JFileChooser.APPROVE_OPTION)
		         {    
		 			//si un fichier est selectionné, récupérer le fichier puis son path
					fenetre.setSortie(selectionneFichier.getSelectedFile().getAbsolutePath()); 
		         }
		 		break;
		 }
		 selectionneFichier.updateUI();
	 }

}
