/*
 * NAT - An universal Translator
 * Copyright (C) 2005 Bruno Mascret
 * Contact: bmascret@free.fr
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

package gestionnaires;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension ;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
//import javax.swing.JOptionPane;

import nat.ConfigNat;

import outils.TextSender;
import outils.FileToolKit;

import java.io.File;

import ui.FiltreFichier;

/**
 * @author djidjo
 *
 */
public class GestionnaireExporter implements ActionListener, PropertyChangeListener

{
	
	/* constantes */
	public static final int EXPORTER_BRF = 1 ;
	
	/* attributs */
	private JFileChooser selectionneFichier = new JFileChooser();
	private JComboBox comboTables ;
	private JLabel lComboTables ;
	private JPanel panelTables ;
	private int action;
	private TextSender texteAExporter ;
	private Component parent;
	//les filtres
	FiltreFichier ftxt = new FiltreFichier( new String[]{"txt"}, "fichiers texte (*.txt)");
	FiltreFichier fbrf = new FiltreFichier( new String[]{"brf"}, "fichiers BRF (*.brf)");
	
	// constructeur
	public GestionnaireExporter (Component parent, TextSender texteAExporter, int action)
	{
		this.texteAExporter=texteAExporter ;
		this.action=action;
		this.parent=parent;
		
		//la table braille courante est par défaut la table braille de conversion
		FileToolKit.copyFile("./xsl/tablesBraille/Brltab.ent", "./xsl/tablesUsed/ConvtabIn.ent");
			
	}
	
	public void actionPerformed(ActionEvent evt) 
	 {    
		 // selectionneFichier.setApproveButtonText("Exporter"); intitulé du bouton inutile pour un showDialog
		 switch (action)
		 {
		 	case EXPORTER_BRF :
		 		
				selectionneFichier.addChoosableFileFilter(ftxt);
				selectionneFichier.addChoosableFileFilter(fbrf);
				
		 		comboTables = new JComboBox();
				lComboTables = new JLabel("Table Braille d'export en BRF");
				//lComboTables.setLabelFor(comboTables);
		 		
				/* Remplissage liste Table braille */
				File repertoire =new File("xsl/tablesEmbosseuse");
			   //System.out.println ( repertoire.getAbsolutePath());
			    File[] listTables = repertoire.listFiles();
			    String table = "";
			    
			    comboTables.addItem("table actuelle (pas de conversion)");
			    for(int i=0;i<listTables.length;i++)
			    {
			    	if (listTables[i].getName().endsWith(".ent") && !listTables[i].getName().equals("Brltab.ent"))
			    	{
			    		table = listTables[i].getName().substring(0,listTables[i].getName().length()-4);
			    		comboTables.addItem(table);
			    	}
			    }
			    comboTables.setEditable(false);
			    comboTables.setSelectedIndex(0); // par défaut, pas de conversion de table
			    comboTables.getAccessibleContext().setAccessibleName("Choix de la table braille d'export");
			    comboTables.getAccessibleContext().setAccessibleDescription("Sélectionner à l'aide des flèches la table braille à utiliser");
			    comboTables.setToolTipText("Sélectionner la table braille d'export");
				
			    panelTables = new JPanel();
			    panelTables.setLayout(new BorderLayout());
			    panelTables.setBorder(BorderFactory.createCompoundBorder(
                        BorderFactory.createTitledBorder(""),
                        BorderFactory.createEmptyBorder(5,5,5,5)));
			    
			    // nécessité d'avoir un second panel pour le resize du dialog
			    JPanel panelTables2 = new JPanel();
			    panelTables2.setLayout(new BorderLayout());
			    //panelTables2.setSize(comboTables.getWidth(), (int)(comboTables.getFont().getSize()*3));
			    panelTables2.add(lComboTables, BorderLayout.CENTER);
			    panelTables2.add(comboTables, BorderLayout.SOUTH);
			    panelTables.add (panelTables2,BorderLayout.SOUTH);
			     
			    selectionneFichier.setDialogTitle("Nom du fichier exporté");
		 		selectionneFichier.setAccessory(panelTables);
			    //comboTables.setMaximumSize(new Dimension (comboTables.getWidth(), comboTables.getFont().getSize()));
		 		comboTables.setMaximumSize(new Dimension (comboTables.getWidth(), 12));
		 		selectionneFichier.addPropertyChangeListener(this);
		 		
		 		if (selectionneFichier.showDialog(parent,"Exporter") == JFileChooser.APPROVE_OPTION)
		         {    
		 			String encodageExport = ConfigNat.getCurrentConfig().getSortieEncoding() ;
		 			String fichierExport = selectionneFichier.getSelectedFile().getPath() ;
		 			
		 			if (selectionneFichier.getFileFilter()!=fbrf)
		 			{
		 				FileToolKit.saveStrToFile (texteAExporter.getText(), fichierExport, encodageExport);
		 			}
		 			else
		 			{
		 				//JOptionPane.showMessageDialog(parent, "L'export en BRF sera bientôt implémenté");
		 				//String s = FileToolKit.LoadFileToStr("./xsl/tablesBraille/Brltab.ent");
		 				
		 				if (comboTables.getSelectedIndex()==0) // pas de conversion
		 				{
		 					FileToolKit.saveStrToFile (texteAExporter.getText(), fichierExport, encodageExport);
		 				}
		 				else
		 				{
		 					String fichierTemp = "./tmp/sourceText.txt" ;
		 					FileToolKit.saveStrToFile (texteAExporter.getText(), fichierTemp, encodageExport);
		 					FileToolKit.convertBrailleFile(fichierTemp, fichierExport, 
		 							ConfigNat.getCurrentConfig().getTableBraille(), 
		 							comboTables.getSelectedItem().toString(), null);
		 				}
		 			}
		         }
		 		break;
		 }
		 //selectionneFichier.updateUI();
	 }

	public void propertyChange(PropertyChangeEvent e)
	{
		String prop = e.getPropertyName();

		if (JFileChooser.FILE_FILTER_CHANGED_PROPERTY.equals(prop))
		{
			if (selectionneFichier.getFileFilter()==fbrf)
			{
				comboTables.setEnabled(true);
				lComboTables.setText("Table Braille d'export en BRF");
				lComboTables.setEnabled(true);
			}
			else
			{
				comboTables.setEnabled(false);
				lComboTables.setText("<html><p color='grey'>Option disponible uniquement</p><p>pour export en BRF</p></html>");
				lComboTables.setEnabled(false);
			}
		}
		
	}

}
