/*
 * NAT - An universal Translator
 * Copyright (C) 2005 Bruno Mascret
 * Contact: bmascret@free.fr
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

package gestionnaires;

import javax.swing.text.JTextComponent;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import nat.Nat;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import java.awt.Rectangle;
import java.io.FileNotFoundException;


public class GestionnaireErreur extends DefaultHandler
{
	private Exception exception;
	private JTextComponent zoneAffichage;
	private boolean debug = false;
	private int niveauLog=1;
	// constantes
	

	//constructeur
	public GestionnaireErreur(Exception e, JTextComponent zAffichage, int niveau)
	{
		exception = e;
		zoneAffichage = zAffichage;
		niveauLog = niveau;
	}

	//méthodes d'accès
	public Exception getException()
	{
		return  exception;
	}
	
	public void setException(Exception e)
	{
		exception = e;
	}
	
	public void setNiveauLog(int niveau)
	{
		niveauLog = niveau;
	}
	public void setModeDebugage(boolean isDebugging)
	{
		debug = isDebugging;
		//niveauLog=4;
	}
	
	//méthodes
	public void AfficheMessage(String message, int niveau)
	{
		if (niveau <= niveauLog)
		    {
			if (zoneAffichage != null){
			    zoneAffichage.setText(zoneAffichage.getText() + message);
			    zoneAffichage.paintImmediately(new Rectangle(0,0,zoneAffichage.getWidth(),zoneAffichage.getHeight()));
			}
			System.out.print(message);
		}
	}
	
	private String MessageParser(SAXParseException e)
	{
		String message = "  " + e.getMessage() + "\n";
        message += "  Ligne " + e.getLineNumber()+", colonne "+e.getColumnNumber()+"\n";
        message += "  Public id : "+e.getPublicId()+"\n";
        message += "  System id : "+e.getSystemId()+"\n";
        return message;
    }
	
	private void AfficheSAXException(SAXParseException e)
	{
		AfficheMessage(MessageParser(e), Nat.LOG_VERBEUX);
        if(e.getException() != null)
        {
        	e.getException().printStackTrace();
        }
    }

	
	public void GestionErreur()
	{
		if (exception.getClass()==FileNotFoundException.class)
        {
			AfficheMessage("not ok\nERREUR: Problème lors du chargement d'un fichier: " + exception.getMessage(),Nat.LOG_SILENCIEUX);
        }
		if (exception.getClass()==TransformerConfigurationException.class) 
        {
			AfficheMessage("not ok\nERREUR: Problème lors du chargement de la configuration du convertisseur: " + exception.getMessage(),Nat.LOG_SILENCIEUX );
        } 
		if (exception.getClass()==TransformerException.class) 
        {
			AfficheMessage("not ok\nERREUR: Erreur du convertisseur: " + exception.getMessage(),Nat.LOG_SILENCIEUX );
         }
		if (exception.getClass()==SAXException.class)
        {
			AfficheMessage("not ok\nERREUR: Erreur du parser SAX: " + exception.getMessage(),Nat.LOG_SILENCIEUX );
        } 
		if (exception.getClass()==SAXParseException.class)
		{
			AfficheMessage("not ok\nERREUR: Problème lors du parsage du document d'entrée avec SAX : " + exception.getMessage(),Nat.LOG_SILENCIEUX );
		}
		if (exception.getClass()==ParserConfigurationException.class)
        {
			AfficheMessage("not ok\nERREUR: Problème de configuration du parser: " + exception.getMessage(),Nat.LOG_SILENCIEUX );
        } 
		if (exception.getClass()==Exception.class)  
        {
			AfficheMessage("not ok\nERREUR: Problème non identifié " + exception.getMessage(),Nat.LOG_SILENCIEUX);
        }
		exception.printStackTrace();
	}
	
	//méthodes redéfinies pour le DefaultHandler
	 public void warning(SAXParseException exception) throws SAXException
	 {
		 if (debug)
		 {
			 AfficheMessage("\n-Avertissement\n",Nat.LOG_VERBEUX);
			 AfficheSAXException(exception);
		 }
     }
	 public void error(SAXParseException exception) throws SAXException
	 {
		 if (debug)
		 {
			 AfficheMessage("\n-Erreur non bloquante\n",Nat.LOG_VERBEUX);
			 AfficheSAXException(exception);
		 }
	 }
	 /*public void fatalError(SAXParseException exception) throws SAXException
	 {
         String message = "*\n** Erreur fatale ***";
         throw exception;
     }*/

}
