<?xml version='1.1' encoding="UTF-8" ?>
<!--
 * NAT - An universal Translator
 * Copyright (C) 2005 Bruno Mascret
 * Contact: bmascret@free.fr
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
-->

<!DOCTYPE xsl:stylesheet SYSTEM "mmlents/windob.dtd">

<xsl:stylesheet version="2.0"
xmlns:xsl='http://www.w3.org/1999/XSL/Transform' 
xmlns:saxon='http://icl.com/saxon'
xmlns:m='http://www.w3.org/1998/Math/MathML'
xmlns:fn='http://www.w3.org/2005/xpath-functions'
xmlns:functx='http://www.functx.com'
xmlns:xs='http://www.w3.org/2001/XMLSchema'
xmlns:lit='espacelit'
xmlns:doc='espaceDoc'>
	
	<xsl:import href="functions/functx-1.0.xsl" /> <!-- functx functions -->
	<xsl:include href="outils.xsl"/>
	<xsl:include href="hyphenation.xsl"/>

	<xsl:output method="text" encoding="UTF-8" indent="no"/>
	<xsl:variable name="l_maj" as="xs:string">ABCDEFGHIJKLMNOPQRSTUVWXYZÀÂÉÈÊËÎÏÔÙÛÜÁÍÓÚÑÌÒÄÖ&Ccedil;&AElig;&OElig;</xsl:variable>
	<xsl:variable name="l_maj_A" as="xs:string">AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA</xsl:variable>
	<xsl:variable name="l_min" as="xs:string">abcdefghijklmnopqrstuvwxyzàâéèêëîïôùûüáíóúñìòäö&cedil;&aelig;&oelig;</xsl:variable>
	<xsl:variable name="l_min_a" as="xs:string">aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa</xsl:variable>
	<xsl:variable name="l_num" as="xs:string">0123456789+-×÷=,.&sup2;&sup3;</xsl:variable>
	<xsl:variable name="l_amb" as="xs:string">ÂÊÎÔÛËÏÜŒWâêîôûëïüœ</xsl:variable>
	<xsl:variable name="l_amb_ahat" as="xs:string">âââââââââââââââââââ</xsl:variable>
	<xsl:variable name="l_alphabet" as="xs:string">abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ</xsl:variable>
	<xsl:variable name="l_chiffres" as="xs:string">1234567890,</xsl:variable>
	<xsl:variable name="l_grec_min" as="xs:string">&alpha;&beta;&gamma;&delta;&epsi;&epsiv;&zeta;&eta;&theta;&thetav;&iota;&kappa;&lambda;&mu;&nu;&xi;&omicron;&pi;&piv;&rho;&rhov;&sigma;&sigmav;&tau;&upsilon;&phi;&phiv;&chi;&psi;&omega;</xsl:variable>
	<xsl:variable name="l_grec_maj" as="xs:string">&Agr;&Bgr;&Gamma;&Delta;&Egr;&Zgr;&EEgr;&Theta;&Igr;&Kgr;&Lambda;&Mgr;&Ngr;&Xi;&Ogr;&Pi;&Rgr;&Sigma;&Tgr;&Upsilon;&Phi;&KHgr;&Chi;&Psi;&Omega;</xsl:variable>
	<!--<xsl:variable name="l_alphanumgrec" select="fn:concat($l_alphabet,$l_chiffres,$l_grec_min,$l_grec_maj)" />-->
	<xsl:variable name="l_alphanumgrec" as="xs:string" select="concat($l_alphabet,$l_chiffres,$l_grec_min,$l_grec_maj)" />
	<!-- Bruno: SUPER IMPORTANT: ne pas placer cette variable en tête de liste des variables, je sais pas pourquoi mais elle fait planter des fois le parsage de la feuille-->
	<xsl:variable name="chaine_vide" as="xs:string" select="''"/>
	<xsl:strip-space elements = "tableau col ligne lit phrase math" />

	<xsl:template match="doc:doc">
		<xsl:apply-templates select="@*|*|text()|processing-instruction()" />
		<xsl:if test="$formFeedEnd = 1">
			<xsl:text>&#12;</xsl:text>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="tableau">
		<xsl:variable name="leTableau">
			<xsl:choose>
				<xsl:when test="$linearise_table">
					<xsl:call-template name="lineariseTableau"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:variable name="colMef" >
						<xsl:apply-templates/>
					</xsl:variable>
					<!-- affichage final -->
					<xsl:variable name="longLigne" as="xs:integer">
						<xsl:value-of select="string-length($colMef) div (count(col[1]/child::ligne) + 1) - count(child::col)"/>
					</xsl:variable>
					<!-- <xsl:value-of select="$sautAGenerer"/> -->
					<xsl:choose>
						<xsl:when test="$coupons = 1 and $longLigne &gt; $longueur">
							<!-- va falloir scinder le tableau -->
							<!-- recherche de la première coupe possible -->
							<xsl:call-template name="scinderTab">
								<xsl:with-param name="tableau" select="string($colMef)"/>
								<xsl:with-param name="nbCol" select="count(child::col)"/>
							</xsl:call-template>
						</xsl:when>
						<xsl:otherwise>
							<xsl:call-template name="mefTab">
								<xsl:with-param name="tableau" select="string($colMef)"/>
								<xsl:with-param name="nbLigne" select="count(col[1]/child::ligne) + 1"/><!-- +1 pour ligne séparateur -->
								<xsl:with-param name="nbCol" select="count(child::col)"/>
							</xsl:call-template>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:value-of select="$sautAGenerer"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- affichage complet -->
		<xsl:value-of select="translate($leTableau,concat($espace,$sautAGenerer),'&pt;&#10;')"/>
	</xsl:template>

	<xsl:template name="lineariseTableau">
		<xsl:value-of select="'tableau à linéariser'"/>
	</xsl:template>
	
	<xsl:template name="scinderTab">
		<xsl:param name="tableau" as="xs:string"/>
		<xsl:param name="nbCol" as="xs:integer" select="-10" />
		<xsl:param name="compte" as="xs:string" select="'CTRL '" />
		<xsl:param name="nbLignes" as="xs:integer" select="0"/>
		<xsl:variable name="tab" select="tokenize($tableau,$coupe)" as="xs:string*"/>
		<!--
		<xsl:value-of select="$tableau"/>
		<!-<xsl:value-of select="concat($sautAGenerer,string-join($tab,'C'))"/>-->
		<xsl:variable name="nl" select="count(col[1]/child::ligne) + 1" as="xs:integer"/>
		<xsl:choose>
			<!--<xsl:when test="string-length($compte) &gt; 80"><xsl:value-of select="$compte" /></xsl:when>-->
			<xsl:when test="string-length($tab[$nl]) + string-length($tab[$nl * 2]) &gt; $longueur + 1">
				<xsl:text>IMPOSSIBLE DE REPRESENTER CE TABLEAU, LA LIGNE EST TROP COURTE</xsl:text>
			</xsl:when>
			<xsl:when test="(string-length(translate($tableau,$coupe,'')) div $nl) &gt; $longueur">
				<xsl:variable name="entete" as="xs:string">
					<xsl:value-of select="string-join($tab[position()&lt;$nl+1],$coupe)"/>
				</xsl:variable>
				<!--<xsl:value-of select="concat($nl,$entete)"/>-->
				<xsl:variable name="pcoup" as="xs:integer">
					<xsl:call-template name="donnePositionCoupure2">
						<xsl:with-param name="tableau" select="$tab"/>
						<xsl:with-param name="nbl" select="$nl"/>
					</xsl:call-template>
				</xsl:variable>
				<!--<xsl:value-of select="$pcoup"/>-->
				<xsl:call-template name="mefTab">
					<xsl:with-param name="tableau" select="string-join($tab[position() &lt; $pcoup * $nl +2],$coupe)"/>
					<xsl:with-param name="nbLigne" select="$nl"/><!-- +1 pour ligne séparateur -->
					<xsl:with-param name="nbCol" select="$pcoup"/>
				</xsl:call-template>
				<!-- affichage reste -->
				<xsl:value-of select="$sautAGenerer"/>
				<xsl:call-template name="scinderTab">
					<xsl:with-param name="tableau" select="concat($entete,$coupe,string-join($tab[position() &gt; $pcoup * $nl],$coupe))"/>
					<xsl:with-param name="nbCol" select="count(col) + 1 - $pcoup"/>
					<!--<xsl:with-param name="compte" select="concat($compte,' NC', string($nbCol), ' CF', $pcoup - 1, ' PC', string($pcoup))" />-->
				</xsl:call-template>
			</xsl:when>
			<!--
			<xsl:when test="(string-length($tableau) div (count(col[1]/child::ligne) + 1) - $nbCol) &gt; $longueur">
				<!-c'est pas fini; sauvegarde des entetes ->
				<xsl:variable name="entete" as="xs:string">
					<xsl:value-of select="concat(substring($tableau,1,string-length(substring-before($tableau,$coupe)) * (count(col[1]/child::ligne) + 1) + count(col[1]/child::ligne)),$coupe)"/>
				</xsl:variable>
				<xsl:variable name="pcoup" as="xs:integer">
					<xsl:call-template name="donnePositionCoupure">
						<xsl:with-param name="tableau" select="$tableau"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:value-of select="$pcoup"/>
				<!- affichage du début->
				<xsl:value-of select="$nbCol - string-length(translate(substring-before(substring-after($tableau,$coupe),$coupe),'&pt25;', ''))"/>
				<xsl:variable name="colFait" as="xs:integer">
					<xsl:value-of select="(string-length(substring($tableau,1,$pcoup * (count(col[1]/child::ligne) + 1) + count(col[1]/child::ligne))) - string-length(translate(substring($tableau,1,$pcoup * (count(col[1]/child::ligne) + 1) + count(col[1]/child::ligne)),$coupe,''))) div (count(col[1]/child::ligne) + 1)"/>
				</xsl:variable>
				<xsl:call-template name="mefTab">
					<xsl:with-param name="tableau" select="substring($tableau,1,$pcoup * (count(col[1]/child::ligne) + 1) + count(col[1]/child::ligne))"/>
					<xsl:with-param name="nbLigne" select="count(col[1]/child::ligne) + 1"/><!- +1 pour ligne séparateur ->
					<xsl:with-param name="nbCol" select="xs:integer(floor($colFait))"/>
				</xsl:call-template>
				<!- affichage reste ->
				<xsl:value-of select="$sautAGenerer"/>
				<xsl:call-template name="scinderTab">
					<xsl:with-param name="tableau" select="concat($entete,substring($tableau,$pcoup * (count(col[1]/child::ligne) + 1) + 1))"/>
					<xsl:with-param name="nbCol" select="xs:integer(floor($nbCol - $colFait + 1))"/>  <!- +1 pour entetes  ->
					<xsl:with-param name="compte" select="concat($compte,' NC', string($nbCol), ' CF', string($colFait), ' PC', string($pcoup))" />
				</xsl:call-template>
			</xsl:when>-->
			<xsl:otherwise>
				<xsl:call-template name="mefTab">
					<xsl:with-param name="tableau" select="$tableau"/>
					<xsl:with-param name="nbLigne" select="$nl"/><!-- +1 pour ligne séparateur -->
					<xsl:with-param name="nbCol" select="$nbCol"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="donnePositionCoupure2">
		<xsl:param name="tableau" as="xs:string*"/>
		<xsl:param name="nbl" as="xs:integer" select="1" />
		<xsl:param name="i" as="xs:integer" select="1"/>
		<xsl:param name="used" select="0" as="xs:integer"/>
		<xsl:variable name="used2" select="$used + string-length($tableau[$i * $nbl])" as="xs:integer"/>
		<!--<xsl:variable name="tmp" select="$used2" as="item()*"/>
		<xsl:value-of select="trace($i, 'The value of i is: ')"/>
		<xsl:value-of select="trace($nbl, 'The value of nbl is: ')"/>
		<xsl:value-of select="trace($tableau[$i * $nbl], 'The value of tab[i*l] is: ')"/>
		<xsl:value-of select="trace($used2, 'The value of $used2 is: ')"/>-->
		<xsl:choose>
			<xsl:when test="$i &gt; 30"><xsl:value-of select="10000"/></xsl:when>
			<xsl:when test="$used2 &gt; $longueur">
				<xsl:value-of select="$i - 1"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="donnePositionCoupure2">
						<xsl:with-param name="tableau" select="$tableau"/>
						<xsl:with-param name="used" select="$used2"/>
						<xsl:with-param name="i" select="$i+1"/>
						<xsl:with-param name="nbl" select="$nbl"/>
					</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="donnePositionCoupure">
		<xsl:param name="tableau" as="xs:string"/>
		<!-- <xsl:param name="nbCol" as="xs:integer" select="-10" /> -->
		<xsl:param name="used" select="0" as="xs:integer"/>
		<xsl:variable name="lg"  select="string-length(substring-before($tableau,$coupe)) * (count(col[1]/child::ligne) + 1) + count(col[1]/child::ligne) +1" as="xs:integer"/>
		<xsl:choose>
			<xsl:when test="(string-length(substring-before($tableau,$coupe)) + $used  + $lg) &gt; $longueur">
				<xsl:value-of select="$used"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="donnePositionCoupure">
						<xsl:with-param name="tableau" select="substring($tableau,$lg + 1)"/>
						<xsl:with-param name="used" select="$used + $lg"/>
					</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	
	<xsl:template name="mefTab">
		<xsl:param name="tableau" as="xs:string"/>
		<xsl:param name="nbLigne" as="xs:integer" select="-10" />
		<xsl:param name="nbCol" as="xs:integer" select="-10"/>
		<xsl:param name="ligne" as="xs:integer" select="0"/>
		<xsl:param name="col" as="xs:integer" select="0" />
		<xsl:param name="used" as="xs:integer" select="0"/>
		<xsl:if test="$nbLigne &gt; $ligne">
			<xsl:choose>
				<xsl:when test="$nbCol &gt; $col">
					<xsl:variable name="res" as="xs:string">
						<xsl:call-template name="donneCellule">
							<xsl:with-param name="tableau" select="$tableau"/>
							<xsl:with-param name="nombre" select="$ligne + ($nbLigne * $col)"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:value-of select="$res"/>
					<xsl:call-template name="mefTab">
						<xsl:with-param name="tableau" select="$tableau"/>
						<xsl:with-param name="nbLigne" select="$nbLigne"/>
						<xsl:with-param name="nbCol" select="$nbCol"/>
						<xsl:with-param name="ligne" select="$ligne"/>
						<xsl:with-param name="col" select="$col + 1"/>
						<xsl:with-param name="used" select="string-length($res)"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<!-- on a traité toutes les colonnes de cette ligne -->
					<xsl:value-of select="$sautAGenerer"/>
					<xsl:call-template name="mefTab">
						<xsl:with-param name="tableau" select="$tableau"/>
						<xsl:with-param name="nbLigne" select="$nbLigne"/>
						<xsl:with-param name="nbCol" select="$nbCol"/>
						<xsl:with-param name="ligne" select="$ligne + 1"/>
						<xsl:with-param name="col" select="0"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="donneCellule">
		<xsl:param name="nombre" as="xs:integer" select="-10"/>
		<xsl:param name="fait" as="xs:integer" select="0"/>
		<xsl:param name="tableau" as="xs:string"/>
		<xsl:choose>
			<xsl:when test="$fait &lt; $nombre">
				<xsl:call-template name="donneCellule">
					<xsl:with-param name="nombre" select="$nombre"/>
					<xsl:with-param name="fait" select="$fait + 1"/>
					<xsl:with-param name="tableau" select="substring-after($tableau,$coupe)"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise><!-- on y est!-->
				<xsl:value-of select="translate(substring-before($tableau, $coupe),'&espace;','&pt;')"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="col">
		<xsl:variable name="colonne">
			<xsl:for-each select="child::ligne">
				<xsl:apply-templates/>
				<xsl:choose>
					<xsl:when test="@b-vert=1">
						<xsl:text>&pt456;</xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>&espace;</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:value-of select="$coupe"/>
			</xsl:for-each>
		</xsl:variable>
		<!--<xsl:value-of select="translate(string($colonne),'&NewLi ne;&#13;&#10;', '')"/>-->
		<!-- CARACTÈRE SI PREMIÈRE COLONNE -->
		<xsl:variable name="finSep" as="xs:string">
			<xsl:choose>
				<xsl:when test="count(preceding-sibling::*)=0"><xsl:value-of select="'&pt2456;'"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="'&pt25;'"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:call-template name="largeurMax">
			<xsl:with-param name="colonne" select="translate($colonne,concat($sautAGenerer,'&#13;&#10;&NewLine;'), '')"/>
			<xsl:with-param name="finSeparateur" tunnel="yes" select="$finSep"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="largeurMax">
		<xsl:param name="colonne" as="xs:string"/>
		<xsl:param name="position" as="xs:integer" select="1"/>
		<xsl:param name="max" as="xs:integer" select="0"/>
		<xsl:param name="finSeparateur" tunnel="yes" as="xs:string"/>
		<!-- détection de la largeur maximale des colonnes -->
		<xsl:choose>
			<xsl:when test="$position &gt; string-length($colonne)">
				<xsl:call-template name="prepareColonne">
					<xsl:with-param name="max" select="$max"/>
					<xsl:with-param name="colonne" select="$colonne"/>
					<xsl:with-param name="hSeparateur" select="1"/>
				</xsl:call-template>
				<!--<xsl:value-of select="concat('fini:',$max)"/>-->
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="long" as="xs:integer">
					<xsl:value-of select="string-length(substring-before(substring($colonne, $position),$coupe))"/>
				</xsl:variable>
				<xsl:choose>
					<xsl:when test="$long &gt; $max">
						<xsl:call-template name="largeurMax">
							<xsl:with-param name="colonne" select="$colonne"/>
							<xsl:with-param name="position" select="$position + $long + 1"/>
							<xsl:with-param name="max" select="$long"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="largeurMax">
							<xsl:with-param name="colonne" select="$colonne"/>
							<xsl:with-param name="position" select="$position + $long + 1"/>
							<xsl:with-param name="max" select="$max"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="prepareColonne">
		<xsl:param name="max" as="xs:integer" select="-10" />
		<xsl:param name="colonne" as="xs:string" />
		<xsl:param name="hSeparateur" as="xs:integer" select="-10" /><!-- = 1 ligne à ajouter -->
		<xsl:param name="finSeparateur" tunnel="yes" as="xs:string"/>
		<!-- largeur max pour chaque élément de la colonne -->
		<xsl:if test="not(string-length($colonne) = 0)">
			<xsl:variable name="col" as="xs:string">
				<xsl:value-of select="substring-before($colonne, $coupe)"/>
			</xsl:variable>
			<xsl:value-of select="substring($col,1,string-length($col)-1)"/>
			<xsl:call-template name="rempli">
				<xsl:with-param name="nb" select="$max - string-length($col)" />
				<xsl:with-param name="motif" select="'&pt;'"/>
			</xsl:call-template>
			<xsl:value-of select="substring($col,string-length($col))"/>
			<!--<xsl:value-of select="concat('&pt456;',$coupe)"/>-->
			<xsl:value-of select="$coupe"/>
			<xsl:if test="$hSeparateur = 1">
				<xsl:call-template name="rempli">
					<xsl:with-param name="nb" select="$max -1"/>
					<xsl:with-param name="motif" select="'&pt25;'"/>
				</xsl:call-template>
				<xsl:value-of select="concat($finSeparateur,$coupe)"/>
			</xsl:if>
			<xsl:call-template name="prepareColonne">
				<xsl:with-param name="max" select="$max"/>
				<xsl:with-param name="colonne" select="substring-after($colonne, $coupe)"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="rempli">
		<xsl:param name="nb" select="-10" as="xs:integer"/>
		<xsl:param name="motif" as="xs:string"/>
		<xsl:if test="$nb &gt; 0">
			<xsl:value-of select="$motif"/>
			<xsl:call-template name="rempli">
				<xsl:with-param name="nb" select="$nb - 1"/>
				<xsl:with-param name="motif" select="$motif"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="phrase">
		<xsl:variable name="exprTmp" as="xs:string*">
			<xsl:apply-templates />
		</xsl:variable>
		<xsl:variable name="expr" as="xs:string">
			<xsl:value-of select="string-join($exprTmp,'')"/>
		</xsl:variable>
		<xsl:variable name="retrait_paragraphe">
			<xsl:value-of select="functx:repeat-string($espace,$par_indent)"/>
		</xsl:variable>
		
		<xsl:variable name="phraseSansEspaceMath">
			<xsl:choose>
				<!-- il y a une table mathématique dans l'expression -->
				<xsl:when test="contains($expr,$debTable)"><!-- and $linearise_table">-->
					<xsl:call-template name="mepTables">
						<xsl:with-param name="expr" select="$expr"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$coupons = 1 and name(..)='doc:doc'">
					<!-- indentation -->
					<xsl:value-of select="$retrait_paragraphe"/>
					<!-- il faut couper; on sauve le résultat de la transcription dans une variable -->
					<xsl:call-template name="coupure"><!---->
						<!-- ajout d'un espace en fin de phrase (il sera supprimé) pour ne pas avoir à tester partout dans coupure si le mot est le dernier de la phrase -->
						<!-- remplacement des $coupeEsth par $coupe en attendant de les traiter -->
						<!--<xsl:with-param name="phrase" select="concat(translate($expr,$coupeEsth,$coupe),' ')"/>-->
						<xsl:with-param name="phrase" select="$expr"/>
						<xsl:with-param name="premier" select="1"/>
						<xsl:with-param name="used" select="$par_indent"/>
						<xsl:with-param name="no_nl" select="true()"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<!-- on applique directement les templates -->
					<xsl:value-of select="translate(string($expr), concat($coupeEsth,$coupe,$debMath,$finMath,$debTable,$finTable), '')"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		
		<!-- si la phrase n'est pas vide (càd avec autre chose que des espaces) on l'affiche -->
		<xsl:if test="not(translate(string($phraseSansEspaceMath),concat($espace,'&pt;'),'')='')">
			<xsl:value-of select="translate(string($phraseSansEspaceMath),concat($espace,$sautAGenerer),'&pt;&#10;')"/>
		</xsl:if>
		<!--<xsl:variable name="modeLigneVide" select="1" as="xs:integer"/>
		<xsl:variable name="min3ligne" select="6" as="xs:integer"/>
		<xsl:variable name="min2ligne" select="4" as="xs:integer"/>
		<xsl:variable name="min1ligne" select="2" as="xs:integer"/>-->
		<!--<xsl:value-of select="trace(concat('A',string($phraseSansEspaceMath),'A'),'Expression:')"/>-->
		
		<xsl:choose>
			<!-- la phrase est vide-->
			<xsl:when test="translate(string($phraseSansEspaceMath),concat($espace,'&pt;'),'')='' and not($modeLigneVide=-1)">
				<xsl:choose>
					<!-- mode 0: suppression de toutes les lignes vides -->
					<xsl:when test="$modeLigneVide=0"/>
					<!-- la phrase et la suivante sont vides: on supprime la ligne-->
					<xsl:when test="string-join(following-sibling::*[1]/child::*,'')=''"/>
					<!-- on est au début du document: on vire -->
					<xsl:when test="position()=1 "/>
					<!-- la phrase est vide mais pas la suivante -->
					<xsl:otherwise>
						<xsl:choose>
							<!-- le minimum pour mettre 3 lignes est atteint -->
							<xsl:when test="string-join(preceding-sibling::*[position() &lt; $min3ligne]/child::*,'')=''">
								<xsl:text>&NewLine;&NewLine;&NewLine;</xsl:text>
							</xsl:when>
							<!-- le minimum pour mettre 2 lignes est atteint -->
							<xsl:when test="string-join(preceding-sibling::*[position() &lt; $min2ligne]/child::*,'')=''">
								<xsl:text>&NewLine;&NewLine;</xsl:text>
							</xsl:when>
							<!-- le minimum pour mettre 1 ligne est atteint -->
							<xsl:when test="string-join(preceding-sibling::*[position() &lt; $min1ligne]/child::*,'')=''">
								<xsl:text>&NewLine;</xsl:text>
							</xsl:when>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>&NewLine;</xsl:text><!--&#13;&#10;</xsl:text>-->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="mepTables">
		<xsl:param name="expr" as="xs:string"/>
		<xsl:param name="used" select="0" as="xs:integer"/>
		<xsl:param name="premier" select="0" as="xs:integer"/>
		<!-- on commence par traiter ce qu'il y a avant la table -->
		<xsl:variable name="carcoup" as="xs:string" select="concat($coupeEsth,$coupe,$debMath,$finMath)"/>
		<xsl:variable name="avantSeq" as="xs:string*">
			<xsl:choose>
				<!-- la coupure est-elle active? -->
				<xsl:when test="$coupons = 1"><!-- oui -->
					<xsl:call-template name="coupure">
						<xsl:with-param name="phrase" select="concat(substring-before($expr,$debTable),$finMath)"/>
						<xsl:with-param name="premier" select="$premier"/>
						<xsl:with-param name="used" select="$used"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="translate(substring-before($expr,$debTable),$carcoup,'')"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- affichage de ce qu'il y a avant avec remplacements des marques pour les espaces et les sauts -->
		<xsl:variable name="avant" as="xs:string" select="string-join($avantSeq,'')"/>
		<xsl:value-of select="translate($avant,concat($espace,$sautAGenerer),'&pt;&#10;')"/>
		<!-- la table -->
		<xsl:variable name="table" as="xs:string">
			<xsl:value-of select="substring-before(substring-after($expr,$debTable),$finTable)"/>
		</xsl:variable>
		<!--<xsl:value-of select="functx:substring-after-last(translate($avant,'&#13;','A'),'A')"/>-->
		<xsl:variable name="lgAvant" as="xs:integer">
			<xsl:value-of select="$used + string-length(functx:substring-after-last($avant,$sautAGenerer))"/>
		</xsl:variable>
		<xsl:variable name="lesLignes" as="xs:string*" select="tokenize(translate($table,$carcoup,''),$sautAGenerer)"/>
		<!-- <xsl:value-of select="concat('{',$lgAvant,':',$used,'}{',$toto,'}')"/>-->
		<!-- hypothèse: si il n'y a pas de saut de lignes, c'est que c'est linéarisé-->
		<xsl:variable name="laTable" as="xs:string*">
			<xsl:choose>
				<!-- la structure 2D ne tient pas sur la fin de la ligne et la coupure est active -->
				<xsl:when test="string-length($lesLignes[1]) + $lgAvant &gt; $longueur and $coupons = 1">
					<xsl:value-of select="$sautAGenerer"/>
					<xsl:for-each select="$lesLignes">
						<xsl:value-of select="translate(.,$carcoup,'')"/>
						<xsl:if test="not(position()=last())">
							<xsl:value-of select="$sautAGenerer"/>
						</xsl:if>
					</xsl:for-each>
				</xsl:when>
				<!-- ça tient ou la coupure n'est pas active -->
				<xsl:otherwise>
					<xsl:for-each select="$lesLignes">
						<xsl:value-of select="translate(.,$carcoup,'')"/>
						<xsl:if test="not(position()=last())">
							<xsl:value-of select="$sautAGenerer"/>
							<xsl:value-of select="functx:repeat-string('&pt;',$lgAvant)"/>
						</xsl:if><!---->
					</xsl:for-each>
				</xsl:otherwise>
			</xsl:choose><!-- -->
		</xsl:variable>
		<!-- affichage de la table -->
		<xsl:value-of select="translate(string-join($laTable,''),concat($espace,$sautAGenerer),'&pt;&#10;')"/>
		<xsl:variable name="apres">
			<xsl:value-of select="concat($debMath,substring-after($expr,$finTable))"/>
		</xsl:variable>
		<!-- <xsl:value-of select="concat('#',$lgAvant,':',string-length(substring-before($laTable,$sautAGenerer)),'#')"/> -->
		<!-- <xsl:variable name="lgAvantUsed" as="xs:integer">
			<xsl:choose>
				<!- est-ce qu'on est allé à la ligne?->
				<xsl:when test="starts-with(string-join($laTable,''),$sautAGenerer)"><xsl:text>0</xsl:text></xsl:when>
				<xsl:otherwise><xsl:value-of select="$lgAvant"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable> -->
		<!--<xsl:value-of select="concat('#',$lgAvant,':',$lesLignes[1],':',$lgAvantUsed)"/>-->
		<xsl:choose>
			<!-- y a-t-il encore une table après?-->
			<xsl:when test="contains($apres,$debTable)">
				<!--<xsl:value-of select="concat($avant,string-join($table,''))"/>-->
				<xsl:call-template name="mepTables">
					<xsl:with-param name="expr" select="$apres"/>
					<xsl:with-param name="used" select="string-length(functx:substring-after-last(string-join($laTable,''),$sautAGenerer))"/><!-- -1 à cause du caractère de saut de ligne qui traine-->
					<xsl:with-param name="premier" select="0"/>
				</xsl:call-template>
			</xsl:when>
			<!-- on traite ce qu'il y a après la table -->
			<xsl:when test="$coupons=1">
				<xsl:call-template name="coupure">
					<xsl:with-param name="phrase" select="$apres"/>
					<xsl:with-param name="premier" select="0"/>
					<xsl:with-param name="no_nl" select="true()"/>
					<xsl:with-param name="used" select="string-length(functx:substring-after-last(string-join($laTable,''),$sautAGenerer))"/>
				</xsl:call-template>
				<!--<xsl:value-of select="concat($avant,string-join($table,''),$apres)"/>-->
			</xsl:when>
			<xsl:otherwise><!-- pas de table ni de coupure dans ce qui suit -->
				<xsl:value-of select="translate($apres,$carcoup,'')"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- ****** FONCTIONS de COUPURE *********** -->
	<xsl:template name="coupure">
		<xsl:param name="phrase" as="xs:string"/>
		<xsl:param name="used" select="0" as="xs:integer"/>
		<xsl:param name="premier" select="0" as="xs:integer"/>
		<xsl:param name="no_nl" select="false()" as="xs:boolean"/>
		<!---->
		<!--<xsl:value-of select="concat('&#13;#',$phrase,'#','&#13;')"/>-->
		<xsl:variable name="carcoup" as="xs:string" select="concat($coupeEsth,$coupe,$debMath,$finMath)"/>
		<xsl:variable name="phraseSansEspDeb" select="functx:substring-after-match($phrase,'^&pt;+')" as="xs:string"/>
		<!--<xsl:value-of select="concat('&#13;$',$phraseSansEspDeb,'$','&#13;')"/>-->

		<xsl:variable name="espaceAjoute" as="xs:boolean"><!-- vrai si la coupure va ajouter un espace après le dernier élément -->
			<xsl:choose>
				<xsl:when test="ends-with($phrase,'&pt;')"><xsl:value-of select="false()"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="true()"/></xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="resultat">
			<xsl:choose>
				<xsl:when test="starts-with($phraseSansEspDeb,$debMath) and string-length(translate($phraseSansEspDeb,concat($carcoup,'&pt;'),'')) &gt;0">
					<xsl:call-template name="coupureMaths">
						<xsl:with-param name="phrase" select="$phraseSansEspDeb"/>
						<xsl:with-param name="used" select="$used"/>
						<xsl:with-param name="no_nl" select="$no_nl"/>
						<xsl:with-param name="premier" select="1"/>
					</xsl:call-template>
				</xsl:when>
				<!-- il y a deb math et fin math mais rien dedans -->
				<xsl:when test="not(string-length(translate($phraseSansEspDeb,concat($carcoup,'&pt;'),'')) &gt;0)"/>
				<xsl:otherwise>
					<xsl:variable name="ajout"><!-- ajoute un espace à la fin de l'expression si il n'y en a pas -->
						<xsl:if test="$espaceAjoute">
							<xsl:text>&pt;</xsl:text>
						</xsl:if>
					</xsl:variable>
					<xsl:call-template name="coupureLit">
						<xsl:with-param name="phrase" select="concat($phraseSansEspDeb,$ajout)"/>
						<xsl:with-param name="used" select="$used"/>
						<xsl:with-param name="premier" select="1"/>
						<xsl:with-param name="no_nl" select="$no_nl"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- suppression du dernier espace si ajouté par la coupure -->
		<xsl:choose>
			<xsl:when test="ends-with($resultat,'&pt;') and $espaceAjoute">
				<xsl:value-of select="substring($resultat,1,string-length($resultat) -1)"/>
			</xsl:when>
			<xsl:otherwise><xsl:value-of select="$resultat"/></xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- coupure littéraire -->
	<xsl:template name="coupureLit">
		<xsl:param name="phrase" as="xs:string"/><!-- la phrase à traiter -->
		<xsl:param name="used" select="0" as="xs:integer"/><!-- nb de caractères déjà utilisés sur la ligne -->
		<xsl:param name="premier" select="0" as="xs:integer"/><!-- TODO c'est quoi?-->
		<xsl:param name="debPhrase" select="0" as="xs:integer"/>
		<xsl:param name="no_nl" select="false()" as="xs:boolean"/><!-- true si passage à la ligne sans écrire qqch interdit-->

		<xsl:variable name="carcoup" as="xs:string*"><!-- les caractères pour couper -->
			<xsl:value-of select="$coupeEsth"/>
			<xsl:value-of select="$coupe"/>
		</xsl:variable>

		<xsl:variable name="leMot" as="xs:string"><!-- le mot avec les car de coupe -->
			<xsl:value-of select="substring-before($phrase, '&pt;')"/>
		</xsl:variable>
		<xsl:variable name="longMot" as="xs:integer"><!-- longueur avant le 1er espace -->
			<xsl:value-of select="string-length(substring-before($phrase, '&pt;'))"/>
		</xsl:variable>
		<xsl:variable name="leMotSansCoup" as="xs:string"><!-- le mot sans les car de coupe -->
			<xsl:value-of select="translate(substring-before($phrase, '&pt;'),string-join($carcoup,''),'')"/>
		</xsl:variable>
		<xsl:variable name="longMotSansCoup" as="xs:integer"><!-- longueur réelle du mot sans les car de coupe -->
			<xsl:value-of select="string-length(translate(substring-before($phrase, '&pt;'),string-join($carcoup,''),''))"/>
		</xsl:variable>
		
		<xsl:choose>
			<!-- c'est fini! -->
			<xsl:when test="$longMotSansCoup = 0"/>
			<!-- il y a juste la place pour mettre le mot -->
			<xsl:when test="$longMotSansCoup = $longueur - $used">
				<xsl:value-of select="$leMotSansCoup"/>
				<!-- il reste des mots?-->
				<xsl:if test="string-length(substring-after($phrase,'&pt;'))&gt;0">
					<xsl:value-of select="$sautAGenerer"/>
					<xsl:call-template name="coupure">
						<xsl:with-param name="phrase" select="substring-after($phrase,'&pt;')"/>
						<xsl:with-param name="premier" select="1"/>
					</xsl:call-template>
				</xsl:if>
			</xsl:when>
			<!-- il n'y a plus de place (s'il ne reste qu'un caractère, c'est comme s'il n'y avait plus de place car il en faut au moins 2 pour 1car+coupe) -->
			<xsl:when test="$used >= ($longueur - 1)">
				<xsl:value-of select="$sautAGenerer"/>
				<xsl:call-template name="coupure">
					<xsl:with-param name="phrase" select="$phrase"/>
					<xsl:with-param name="premier" select="1"/>
				</xsl:call-template>
			</xsl:when>
			<!-- ça tient sans couper -->
			<xsl:when test="$longMotSansCoup &lt; $longueur - $used + 1">
				<xsl:value-of select="$leMotSansCoup"/>
				<xsl:text>&pt;</xsl:text><!-- TODO test pour virer espace en fin de ligne -->
				<xsl:call-template name="coupure">
					<xsl:with-param name="phrase" select="substring-after($phrase, '&pt;')"/>
					<xsl:with-param name="used" select="$used+$longMotSansCoup+1"/>
					<xsl:with-param name="premier" select="1"/>
				</xsl:call-template>
			</xsl:when>
			<!-- il va falloir couper -->
			<xsl:otherwise>
				<xsl:choose>
					<!-- il n'y a pas de caractere de coupe -->
					<xsl:when test="not(functx:contains-any-of($leMot,$carcoup))">
						<!-- appel d'hyphenate -->
						<xsl:variable name="motAvecCoupure" as="xs:string">
							<xsl:choose>
								<xsl:when test="$longueur - $used &gt; 1 and $couplit = 1">
									<xsl:call-template name="hyphenate">
										<xsl:with-param name="mot" select="$leMot"/>
										<xsl:with-param name="longueur" select="$longueur - $used"/>
									</xsl:call-template>
								</xsl:when>
								<!-- -->
								<xsl:otherwise>
									<xsl:text>&pt1;</xsl:text><!-- TODO ça sert à quoi?-->
								</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						<xsl:choose>
							<!-- un ou des car de coupes ont été ajoutés par hyphenate -->
							<xsl:when test="functx:contains-any-of($motAvecCoupure,$carcoup)">
								<xsl:call-template name="coupureLit">
									<xsl:with-param name="phrase" select="concat($motAvecCoupure,'&pt;',substring-after($phrase, '&pt;'))"/>
									<xsl:with-param name="used" select="$used"/>
								</xsl:call-template>
							</xsl:when>
							<!-- pas de coupe, mais mode sagouin possible: OU
							la ligne est de toute façon trop petite pour ce mot => on écrit ce qu'on peut-->
							<xsl:when test="(($sagouin = 1 or $no_nl) and $longueur - $used &gt; 1) or ($longueur &lt; $longMot) ">
								<xsl:value-of select="substring(translate($phrase,string-join($carcoup,''),''), 0,$longueur - $used)"/>
								<xsl:value-of select="concat('&pt36;',$sautAGenerer)"/>
								<xsl:call-template name="coupureLit">
									<xsl:with-param name="phrase" select="substring($phrase, $longueur - $used)"/>
								</xsl:call-template>
							</xsl:when>
							<!-- pas de sagouin, pas de coupe, mais la ligne peut contenir le mot: on va à la ligne -->
							<xsl:otherwise>
								<xsl:value-of select="$sautAGenerer"/>
								<xsl:call-template name="coupureLit">
									<xsl:with-param name="phrase" select="$phrase"/>
									<xsl:with-param name="premier" select="1"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<!-- on peut couper le mot avant la fin de la ligne avec une coupure esthétique-->
					<xsl:when test="string-length(functx:substring-before-match(translate($leMot,$coupe,''),$coupeEsth)) + $used &lt; $longueur ">
						<!-- si le premier caractère de coupure est le bon, on coupe, sinon on écrit ce qu'on peut et on appelle de nouveau le template -->
						<xsl:value-of select="substring-before(translate($phrase,string-join($carcoup,''),''),$coupeEsth)"/>
						<xsl:choose>
							<!-- on peut couper plus loin -->
							<xsl:when test="string-length(substring-before(substring-after(translate($phrase,string-join($carcoup,''),''),$coupeEsth),$coupeEsth)) + $used + string-length(substring-before(translate($phrase,string-join($carcoup,''),''),$coupeEsth)) &lt; $longueur and string-length(substring-before(substring-after(translate($phrase,string-join($carcoup,''),''),$coupeEsth),$coupeEsth)) &gt; 0">
								<xsl:call-template name="coupureLit">
									<xsl:with-param name="phrase" select="substring-after($phrase,$coupe)"/>
									<xsl:with-param name="used" select="$used + string-length(substring-before(translate($phrase,string-join($carcoup,''),''),$coupeEsth))"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<!-- la coupure détectée est la meilleure -->
								<xsl:value-of select="concat('&pt36;',$sautAGenerer)"/>
								<xsl:call-template name="coupure">
									<xsl:with-param name="phrase" select="substring-after($phrase,$coupeEsth)"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<!-- on peut couper le mot avant la fin de la ligne avec une coupure normale-->
					<xsl:when test="string-length(functx:substring-before-match(translate($leMot,$coupeEsth,''),$coupe)) + $used &lt; $longueur ">
						<!-- si le premier caractère de coupure est le bon, on coupe, sinon on écrit ce qu'on peut et on appelle de nouveau le template -->
						<xsl:value-of select="substring-before(translate($leMot,$coupeEsth,''),$coupe)"/>
						<xsl:choose>
							<!-- on peut couper plus loin-->
							<xsl:when test="string-length(substring-before(substring-after(translate($phrase,$coupeEsth,''),$coupe),$coupe)) + $used + string-length(substring-before(translate($phrase,$coupeEsth,''),$coupe)) &lt; $longueur and string-length(substring-before(substring-after(translate($phrase,$coupeEsth,''),$coupe),$coupe)) &gt; 0">
								<xsl:call-template name="coupure">
									<xsl:with-param name="phrase" select="substring-after($phrase,$coupe)"/>
									<xsl:with-param name="used" select="$used + string-length(substring-before(translate($phrase,$coupeEsth,''),$coupe))"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<!-- la coupure détectée est la meilleure -->
								<xsl:value-of select="concat('&pt36;',$sautAGenerer)"/>
								<xsl:call-template name="coupure">
									<xsl:with-param name="phrase" select="substring-after($phrase,$coupe)"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<!-- on ne peut pas couper le mot avant la fin de la ligne -->
					<xsl:otherwise>
						<!-- la première coupure du mot tiendrait-elle sur une ligne? -->
						<xsl:choose>
							<!--oui: on saute une ligne-->
							<xsl:when test="string-length(functx:substring-before-match($phrase,string-join($carcoup,'|'))) &lt; $longueur">
								<xsl:value-of select="$sautAGenerer"/>
								<xsl:call-template name="coupure">
									<xsl:with-param name="phrase" select="$phrase"/>
								</xsl:call-template>
							</xsl:when>
							<!-- non: sagouin!-->
							<xsl:otherwise>
								<xsl:value-of select="substring(translate($phrase,string-join($carcoup,''),''), 0,$longueur - $used)"/>
								<xsl:value-of select="concat('&pt36;',$sautAGenerer)"/>
								<xsl:call-template name="coupureLit">
									<xsl:with-param name="phrase" select="substring($phrase, $longueur - $used)"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
		<!--<xsl:value-of select="concat('zob', $phrase)"/>-->


	<!-- ne pas oublier dans les calculs de longueur que si on coupe, il faudra ajouter un caractère de coupure braille (pt5 pour math pt36 pour littéraire) -->
	<xsl:template name="coupureMaths">
		<xsl:param name="phrase" as="xs:string"/>
		<xsl:param name="used" select="0" as="xs:integer"/>
		<xsl:param name="premier" select="0" as="xs:integer"/>
		<xsl:param name="debPhrase" select="0" as="xs:integer"/>
		<xsl:param name="no_nl" select="false()" as="xs:boolean"/>
		
		<xsl:variable name="carcoup" as="xs:string" select="concat($coupeEsth,$coupe,$debMath,$finMath)"/>
		<xsl:variable name="delimiteursMaths" select="concat($debMath,$finMath)" as="xs:string"/>

		<xsl:variable name="leMot" as="xs:string"><!-- le mot avec les car de coupe -->
			<xsl:value-of select="substring-before($phrase, $finMath)"/>
		</xsl:variable>
		<xsl:variable name="longMot" as="xs:integer"><!-- longueur des maths -->
			<xsl:value-of select="string-length($leMot)"/>
		</xsl:variable>
		<xsl:variable name="leMotSansCoup" as="xs:string"><!-- le mot sans les car de coupe -->
			<xsl:value-of select="translate($leMot,$carcoup,'')"/>
		</xsl:variable>
		<xsl:variable name="longMotSansCoup" as="xs:integer"><!-- longueur réelle du mot sans les car de coupe -->
			<xsl:value-of select="string-length($leMotSansCoup)"/>
		</xsl:variable>
		
		<xsl:choose>
			<!-- c'est fini! -->
			<xsl:when test="$longMotSansCoup = 0">
				<xsl:if test="starts-with(substring-after($phrase,$finMath),'&pt;')">
					<xsl:text>&pt;</xsl:text>
				</xsl:if>
				<xsl:call-template name="coupure">
					<xsl:with-param name="phrase" select="substring-after($phrase,$finMath)"/>
					<xsl:with-param name="premier" select="1"/>
					<xsl:with-param name="used" select="$used"/>
				</xsl:call-template>
			</xsl:when>
			<!-- il n'y a plus de place -->
			<xsl:when test="$used = $longueur">
				<xsl:value-of select="$sautAGenerer"/>
				<xsl:call-template name="coupureMaths">
					<xsl:with-param name="phrase" select="$phrase"/>
					<xsl:with-param name="premier" select="1"/>
				</xsl:call-template>
			</xsl:when>
			<!-- ça tient pile sur le reste de la ligne LES TESTS SONT HARDOS MAIS JE VOIS PAS COMMENT SIMPLIFIER -->
			<xsl:when test="$longMotSansCoup = $longueur - $used">
				<!-- attention faut aller à la ligne si c'est pas suivi d'un espace et que used >0 et que ça tient
				(cas très précis d'une expr math suivie d'une punct ou autre sans espace) -->
				<xsl:variable name="reste" as="xs:string" select="substring-after($phrase,$finMath)" />

				<xsl:choose>
					<xsl:when test="($used > 0) and (string-length(translate(substring($reste,1,1),'&pt;','')) > 0)
					 and ($longMotSansCoup + string-length(functx:substring-before-if-contains($reste,'&pt;'))) &lt;= $longueur">
						<xsl:value-of select="$sautAGenerer"/>
						<xsl:value-of select="$leMotSansCoup"/>
						<xsl:call-template name="coupure">
							<xsl:with-param name="phrase" select="$reste"/>
							<xsl:with-param name="premier" select="1"/>
							<xsl:with-param name="used" select="$longMotSansCoup" />
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$leMotSansCoup"/>
						<!-- <xsl:value-of select="$sautAGenerer"/> -->
						<xsl:call-template name="coupure">
							<xsl:with-param name="phrase" select="substring-after($phrase,$finMath)"/>
							<xsl:with-param name="premier" select="1"/>
							<xsl:with-param name="used" select="$used+$longMotSansCoup" />
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<!-- ça tient sur le reste de la ligne -->
			<xsl:when test="$longMotSansCoup &lt; $longueur - $used">
				<xsl:value-of select="$leMotSansCoup"/>
				<xsl:choose>
					<xsl:when test="starts-with(substring-after($phrase,$finMath),'&pt;')">
						<xsl:text>&pt;</xsl:text>
						<xsl:call-template name="coupure">
							<xsl:with-param name="phrase" select="substring-after($phrase, $finMath)"/>
							<xsl:with-param name="used" select="$used+$longMotSansCoup+1"/>
							<xsl:with-param name="premier" select="1"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise><!-- il faut rappeler la coupure sans +1 à used car pas de &pt;-->
						<xsl:call-template name="coupure">
							<xsl:with-param name="phrase" select="substring-after($phrase, $finMath)"/>
							<xsl:with-param name="used" select="$used+$longMotSansCoup"/>
							<xsl:with-param name="premier" select="1"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<!-- ça tient en passant à la ligne ET (y'a pas de char de coup ou premier passage) -->
			<xsl:when test="($longueur >= $longMotSansCoup) and ($premier=1 or not(functx:contains-any-of($leMot,($coupeEsth,$coupe))))">
				<xsl:if test="not($premier = 1)">
					<xsl:text>&pt5;</xsl:text><!--E-->
				</xsl:if>
				<xsl:value-of select="$sautAGenerer"/>
				<xsl:value-of select="$leMotSansCoup"/>
				<xsl:choose>
					<xsl:when test="not($longueur - $longMotSansCoup= 0)">
						<xsl:if test="starts-with(substring-after($phrase,$finMath),'&pt;')">
							<xsl:text>&pt;</xsl:text>
						</xsl:if>
						<xsl:call-template name="coupure">
							<xsl:with-param name="phrase" select="substring-after($phrase,$finMath)"/>
							<xsl:with-param name="used" select="string-length($leMotSansCoup)+1"/>
							<xsl:with-param name="premier" select="1"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:variable name="reste" select="substring-after($phrase,$finMath)" as="xs:string"/>
						<xsl:if test="string-length(translate($reste,'&pt;',''))&gt;0">
							<xsl:value-of select="$sautAGenerer"/>
							<xsl:call-template name="coupure">
								<xsl:with-param name="phrase" select="substring-after($phrase,$finMath)"/>
								<xsl:with-param name="premier" select="1"/>
							</xsl:call-template>
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<!-- il va falloir couper -->
				<xsl:choose>
					<!-- cas particulier d'une expression mathématique qui ne tient pas sur une ligne sans coupure et qui contient des caractères de coupure esthétique -->
					<xsl:when test="contains($leMot,$coupeEsth)">
						<xsl:variable name="teteExpr" as="xs:string" select="translate(substring-before($leMot, $coupeEsth),$carcoup,'')"/>
						<xsl:variable name="finExpr" as="xs:string" select="translate(substring-after($leMot, $coupeEsth),$delimiteursMaths,'')"/>
						<xsl:variable name="finExprSansCoupPasEsth" as="xs:string" select="translate($finExpr, $coupe, '')"/><!-- fin expr sans les coupe mais avec les coupe esth -->
						<xsl:variable name="finExprSansCoup" as="xs:string" select="translate($finExprSansCoupPasEsth, $coupeEsth, '')"/>
						<xsl:choose>
							<!-- il y a une coupure esthétique possible avant la fin de la ligne -->
							<xsl:when test="$longueur - $used - string-length($teteExpr) &gt; 0">
								<xsl:value-of select="$teteExpr"/><!-- -->
								<xsl:choose>
									<!-- il y a une coupure esthétique possible après celle-ci donc on passe pas à la ligne-->
									<xsl:when test="contains($finExpr,$coupeEsth) and 
										($longueur - $used - string-length($teteExpr) - string-length(substring-before($finExprSansCoupPasEsth,$coupeEsth)) &gt; 0)">
										<xsl:call-template name="coupureMaths">
											<xsl:with-param name="phrase" select="concat($debMath,substring-after($phrase,$coupeEsth))"/>
											<xsl:with-param name="used" select="$used + string-length($teteExpr)"/>
										</xsl:call-template>
									</xsl:when>
									<!-- on est sur la seule coupure esthetique possible, mais est-ce qu'on l'applique?
									oui si la fin de l'expression tient sur la ligne suivante
									OU si la prochaine coupure esthétique tient sur la ligne suivante  (si y'en a pas d'autre, on l'applique aussi car string-lenth=0<longueur) -->
									<xsl:when test="(string-length($finExprSansCoup) &lt;= $longueur) or
												(string-length(substring-before($finExprSansCoupPasEsth,$coupeEsth)) &lt; $longueur) ">
												<!--not((contains(substring(translate($finExpr,$coupe,$coupeEsth),1,$longueur - $used - string-length($teteExpr)),$coupeEsth)
												or string-length(substring($finExprSansCoup,1,$longueur)) = string-length(substring(substring-after($phrase,$coupeEsth), 1, $longueur))))"> -->
										<xsl:text>&pt5;</xsl:text><!--A-->
										<xsl:value-of select="$sautAGenerer"/>
										<xsl:call-template name="coupureMaths">
											<xsl:with-param name="phrase" select="concat($debMath,substring-after($phrase,$coupeEsth))"/>
										</xsl:call-template>
									</xsl:when>
									<xsl:otherwise>
												<!--<xsl:value-of select="concat('{',$debMath,substring-after($phrase,$coupeEsth),'}')"/>-->
										<xsl:call-template name="coupureMaths">
											<xsl:with-param name="phrase" select="concat($debMath,substring-after($phrase,$coupeEsth))"/>
											<xsl:with-param name="used" select="$used+string-length($teteExpr)"/>
										</xsl:call-template>
									</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<!-- pas de coupesth possible sur le reste de la ligne mais coupure esthétique possible en allant à la ligne (seulement si premier=1) -->
							<xsl:when test="($premier = 1) and ($longueur - string-length($teteExpr) &gt; 0)">
								<xsl:value-of select="$sautAGenerer"/>
								<xsl:value-of select="$teteExpr"/>
								<!-- <xsl:value-of select="concat($debMath,substring-after($phrase,$coupeEsth))" /> -->
								<xsl:call-template name="coupureMaths">
									<xsl:with-param name="phrase" select="concat($debMath,substring-after($phrase,$coupeEsth))"/>
									<xsl:with-param name="used" select="string-length($teteExpr)"/>
								</xsl:call-template>
							</xsl:when>
							<!-- remplacement des car de coupe par des coupes esthétiques sur la longueur qui reste-->
							<xsl:when test="contains(substring($leMot,1,$longueur - $used + 2),$coupe)"><!-- +2 pour debmaths + coupure -->
								<xsl:call-template name="coupureMaths">
									<xsl:with-param name="phrase" select="concat(translate(substring($phrase,1,$longueur - $used + 2),$coupe,$coupeEsth),substring($phrase,$longueur - $used + 3))"/>
									<xsl:with-param name="used" select="$used"/>
									<xsl:with-param name="premier" select="$premier"/> <!-- necessaire car rien n'a été transcrit lors de ce passage -->
								</xsl:call-template>
							</xsl:when>
							<xsl:when test="not(functx:contains-any-of(substring($leMot, 1, $longueur + 1),($coupeEsth,$coupe)))">
								<!-- il n'y a pas possibilité de couper l'expression proprement même en passant à la ligne car elle est trop longue -->
								<!-- sagouin! -->
								<xsl:variable name="to_display" as="xs:string" select="substring($leMotSansCoup,1,$longueur - $used - 1)"/>
								<xsl:value-of select="$to_display"/>
								<xsl:text>&pt5;</xsl:text><!--B-->
								<xsl:value-of select="$sautAGenerer"/>
								<xsl:call-template name="coupureMaths">
									<xsl:with-param name="phrase" select="concat($debMath,substring-after($phrase,$to_display))"/>
									<xsl:with-param name="premier" select="1"/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise><!--on passe à la ligne en espérant pouvoir couper-->
								<xsl:if test="not($premier = 1)">
									<xsl:text>&pt5;</xsl:text><!-- C -->
								</xsl:if>
								<xsl:value-of select="$sautAGenerer"/>
								<xsl:call-template name="coupureMaths">
									<xsl:with-param name="phrase" select="$phrase"/>
									<xsl:with-param name="premier" select="1"/>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<!-- Pas de coupure esthétique dans toute l'expression -->
					<!-- on regarde s'il y a une coupure classique, si oui on remplace par coupesth et on relance, sinon sagouin -->
					<xsl:when test="contains($leMot,$coupe)">
								<!-- remplacement des car de coupe par des coupes esthétiques sur la longueur qui reste-->
						<xsl:call-template name="coupureMaths">
							<xsl:with-param name="phrase" select="concat(translate($leMot,$coupe,$coupeEsth),substring-after($phrase,$leMot))"/>
							<xsl:with-param name="used" select="$used"/>
							<xsl:with-param name="premier" select="$premier"/> <!-- necessaire car rien n'a été transcrit lors de ce passage -->
						</xsl:call-template>
					</xsl:when>
					<!-- Pa s de coupure dans le mot et ça tient pas sur la ligne -> Sagouin -->
					<xsl:otherwise>
						<xsl:value-of select="substring(translate($phrase,$carcoup,''), 1,$longueur - $used - 1)"/>
						<xsl:text>&pt5;</xsl:text><!-- D -->
						<xsl:value-of select="$sautAGenerer"/>
						<xsl:call-template name="coupureMaths">
							<xsl:with-param name="phrase" select="concat($debMath,substring($phrase, $longueur - $used +1))"/><!--+1 à cause de debmaths -->
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
		<!--<xsl:value-of select="concat('zob', $phrase)"/>-->
	</xsl:template>

	<xsl:template name="espace">
		<xsl:param name="position" select="1" as="xs:integer" />
		<xsl:choose>
			<!--<xsl:when test="not(following::*[1]=text() or following::*[1]=node())">
			</xsl:when>-->
			<!--<xsl:when test="string(following::*[$position]) ='' or local-name(following::*[$position])='lit'">-->
			<xsl:when test="local-name(following::*[$position])='lit' or following::*[$position][not(string(.))]">
				<xsl:call-template name="espace">
					<xsl:with-param name="position" select="$position + 1"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="following::*[$position]='-' and local-name(following::*[$position+1])='ponctuation'"/>
			<xsl:when test="local-name(following::*[$position])='mot' or local-name(following::*[$position])='math' or following::*[$position]='-'">
				<xsl:if test="not(following::*[$position]/@attr='exp' or following::*[$position]/@attr='ind' or 
					(.='&quot;' and (count(preceding-sibling::ponctuation[.='&quot;']) mod 2)=0))">
					<xsl:text>&pt;</xsl:text>
				</xsl:if>
			</xsl:when>
			<!-- espaces avec les pponctuations -->
			<xsl:when test="local-name(following::*[$position])='ponctuation'">
				<xsl:if test="contains('¡¿([{«“‘&lsquo;',following::*[$position])" >
					<xsl:text>&pt;</xsl:text>
				</xsl:if>
				<!--  cas particulier des guillements non orientés -->
				<xsl:if test="following::*[$position]='&quot;'">
					<xsl:variable name="ouvrant" as="xs:integer">
						<xsl:value-of select="count(preceding-sibling::ponctuation[.='&quot;']) mod 2"/>
					</xsl:variable>
					<!-- Espace si le nombre de guillements précédents est pair (ouverture) -->
					<xsl:if test="$ouvrant = 0">
						<xsl:text>&pt;</xsl:text>
					</xsl:if>
				</xsl:if>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="hyphenate">
		<xsl:param name="mot" as="xs:string" />
		<xsl:param name="i" as="xs:integer" select="1"/><!--select="if($longueur &gt; 12) then $index[12] else $index[$longueur]"/>-->
		<xsl:param name="longueur" as="xs:integer" select="0"/>
		<xsl:variable name="pattern" select="translate($patterns[$i],'C','')"/>
		<!--	<xsl:choose>
				<xsl:when test="ends-with($patterns[$i],'.')">
					<xsl:value-of select="translate($patterns[$i],'.C','$')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="translate($patterns[$i],'C','')"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>-->
		<xsl:variable name="resultat">
			<xsl:analyze-string regex="{$pattern}" select="$mot">
				<xsl:matching-substring>
					<xsl:value-of select="replace($mot,.,translate($patterns[$i],'C^.*$',$coupe))"/>
				</xsl:matching-substring>
				<!--<xsl:non-matching-substring>
					<xsl:value-of select="."/>
				</xsl:non-matching-substring>-->
			</xsl:analyze-string>
		</xsl:variable>
		<!-- on enlève la coupe si elle est en début de mot-->
		<xsl:variable name="resultatOk" as="xs:string">
			<xsl:choose>
				<xsl:when test="starts-with($resultat,$coupe)">
					<xsl:value-of select="substring-after($resultat,$coupe)"/>
				</xsl:when><!--
				<xsl:when test="starts-with($resultat[1],$coupeEsth)">
					<xsl:value-of select="substring-after($resultat[1],$coupeEsth)"/>
				</xsl:when>-->
				<xsl:otherwise>
					<xsl:value-of select="$resultat"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:choose>
			<!-- on peut couper, AVANT la fin de ligne, et pas en première position -->
			<xsl:when test="not($resultatOk = $mot or string-length($resultatOk) = 0 or (string-length(substring-before($resultatOk,$coupe)) &gt; $longueur) or string-length(substring-before($resultatOk,$coupe)) &lt; 2)">
				<xsl:value-of select="$resultatOk"/>
			</xsl:when>
			<xsl:when test="not($patterns[$i] = $patterns[last()])">
				<xsl:call-template name="hyphenate">
					<xsl:with-param name="mot" select="$mot"/>
					<xsl:with-param name="i" select="$i + 1"/>
					<xsl:with-param name="longueur" select="$longueur"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$mot"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
