/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class StatisticoSemanticDistance {
    private Map<String, double[]> vectors = new HashMap<String, double[]>();
    public static final int MANHATTAN_DISTANCE = 0;
    public static final int EUCLIDIAN_DISTANCE = 1;

    public void addTerm(String term, double[] vector) {
        this.vectors.put(term, vector);
    }

    public double getSimilarity(String term0, String term1, int SOME_DISTANCE) {
        double result;
        if (!this.vectors.containsKey(term0)) {
            return term0.equals(term1) ? 1.0 : 0.0;
        }
        if (!this.vectors.containsKey(term1)) {
            return term0.equals(term1) ? 1.0 : 0.0;
        }
        switch (SOME_DISTANCE) {
            case 1: {
                result = this.getEuclidianDistance(this.vectors.get(term0), this.vectors.get(term1));
                break;
            }
            default: {
                result = this.getManhattanDistance(this.vectors.get(term0), this.vectors.get(term1));
            }
        }
        return 1.0 - result / Math.sqrt(2.0);
    }

    public String[] getSimilarTerms(String term, double threshold, int SOME_DISTANCE) {
        ArrayList<String> result = new ArrayList<String>();
        for (String toEvaluate : this.vectors.keySet()) {
            if (!(this.getSimilarity(term, toEvaluate, SOME_DISTANCE) >= threshold)) continue;
            result.add(toEvaluate);
        }
        String[] res = new String[result.size()];
        result.toArray(res);
        return res;
    }

    private double getManhattanDistance(double[] vectorA, double[] vectorB) {
        double qt = 0.0;
        for (int i = 0; i < vectorA.length; ++i) {
            qt += Math.abs(vectorA[i] - vectorB[i]);
        }
        return qt;
    }

    private double getEuclidianDistance(double[] vectorA, double[] vectorB) {
        double qt = 0.0;
        for (int i = 0; i < vectorA.length; ++i) {
            qt += (vectorA[i] - vectorB[i]) * (vectorA[i] - vectorB[i]);
        }
        return Math.sqrt(qt);
    }

    public String[] listTerms() {
        String[] result = new String[this.vectors.keySet().size()];
        this.vectors.keySet().toArray(result);
        return result;
    }
}

