/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class SpectralAnalyzer
implements Process {
    private ArrayList<String[]> wordBlocks = new ArrayList();
    private ArrayList<String> stopwords = new ArrayList();
    private double progress = 1.0;
    private String status = "Done";

    public void addResource(String text, String separators) {
        String[] blocks;
        for (String block : blocks = text.split("[" + separators + "]")) {
            String[] words = block.split("\\s");
            this.wordBlocks.add(words);
        }
    }

    public void addResource(String text, int wordsPerBlock) {
        String[] words = text.split("\\s");
        for (int i = 0; i < words.length; i += wordsPerBlock) {
            ArrayList<String> current = new ArrayList<String>();
            for (int j = i; j + i < words.length && j < wordsPerBlock; ++j) {
                current.add(words[j + i]);
            }
            String[] block = new String[current.size()];
            current.toArray(block);
            this.wordBlocks.add(block);
        }
    }

    public void addStopWord(String stopword) {
        this.stopwords.add(stopword);
    }

    public void setStopWordsList(String[] list) {
        this.stopwords = new ArrayList<String>(Arrays.asList(list));
    }

    public StatisticoSemanticDistance computeDistance(int vectorSize) {
        StatisticoSemanticDistance distance = new StatisticoSemanticDistance();
        this.progress = 0.0;
        this.status = "1. Building occurrence lists";
        HashSet<String> studiedTerms = new HashSet<String>();
        HashMap<String, Integer> occurrencesList0 = new HashMap<String, Integer>();
        for (String[] block : this.wordBlocks) {
            for (String word : block) {
                if (!occurrencesList0.containsKey(word)) {
                    occurrencesList0.put(word, 0);
                }
                occurrencesList0.put(word, (Integer)occurrencesList0.get(word) + 1);
                studiedTerms.add(word);
            }
        }
        HashMap occurrencesList = new HashMap();
        for (String term : occurrencesList0.keySet()) {
            if (!occurrencesList.containsKey(occurrencesList0.get(term))) {
                occurrencesList.put(occurrencesList0.get(term), new ArrayList());
            }
            ((ArrayList)occurrencesList.get(occurrencesList0.get(term))).add(term);
        }
        Object[] OccurrencesAmtList = new Integer[occurrencesList.keySet().size()];
        occurrencesList.keySet().toArray(OccurrencesAmtList);
        Arrays.sort(OccurrencesAmtList);
        ArrayList<String> mostFrequents = new ArrayList<String>();
        for (int i = OccurrencesAmtList.length - 1; i >= 0 && mostFrequents.size() < vectorSize; --i) {
            for (String toAdd : (ArrayList)occurrencesList.get(OccurrencesAmtList[i])) {
                if (!this.stopwords.contains(toAdd)) continue;
                mostFrequents.add(toAdd);
            }
        }
        String[] mostFrequentTerms = new String[Math.min(vectorSize, mostFrequents.size())];
        for (int i = 0; i < mostFrequentTerms.length; ++i) {
            mostFrequentTerms[i] = (String)mostFrequents.get(i);
        }
        this.progress = 0.06;
        this.status = "2. Indexing block terms";
        HashMap frequentTermsOccurrences = new HashMap();
        HashMap infrequentTermsOccurrences = new HashMap();
        HashSet<String> frequents = new HashSet<String>(Arrays.asList(mostFrequentTerms));
        for (int i = 0; i < this.wordBlocks.size(); ++i) {
            this.progress = 0.06 + 0.24 * (double)i / (double)this.wordBlocks.size();
            for (String l : this.wordBlocks.get(i)) {
                if (frequents.contains(l)) {
                    if (!frequentTermsOccurrences.containsKey(l)) {
                        frequentTermsOccurrences.put(l, new HashSet());
                    }
                    ((Set)frequentTermsOccurrences.get(l)).add(i);
                }
                if (!infrequentTermsOccurrences.containsKey(l)) {
                    infrequentTermsOccurrences.put(l, new HashSet());
                }
                ((Set)infrequentTermsOccurrences.get(l)).add(i);
            }
        }
        this.progress = 0.3;
        this.status = "3. Listing co-occurrences";
        HashMap<String, int[]> cooccurrences = new HashMap<String, int[]>();
        ArrayList studiedTerms2 = new ArrayList(studiedTerms);
        for (int i = 0; i < studiedTerms2.size(); ++i) {
            this.progress = 0.3 + 0.5 * (double)i / (double)studiedTerms2.size();
            String toStudy = (String)studiedTerms2.get(i);
            int[] coocs = new int[mostFrequentTerms.length];
            Set occurrences = (Set)infrequentTermsOccurrences.get(toStudy);
            for (int j = 0; j < mostFrequentTerms.length; ++j) {
                HashSet a = new HashSet(occurrences);
                Set b = (Set)frequentTermsOccurrences.get(mostFrequentTerms[j]);
                a.retainAll(b);
                coocs[j] = a.size();
            }
            cooccurrences.put(toStudy, coocs);
        }
        this.progress = 0.8;
        this.status = "4. Normalizing the results";
        ArrayList ls = new ArrayList(cooccurrences.keySet());
        for (int i = 0; i < ls.size(); ++i) {
            this.progress = 0.8 + 0.2 * (double)i / (double)ls.size();
            String t = (String)ls.get(i);
            int[] scores = (int[])cooccurrences.get(t);
            int qt = 0;
            for (int s : scores) {
                qt += s;
            }
            double[] normalizedScores = new double[scores.length];
            if (qt > 0) {
                for (int j = 0; j < normalizedScores.length; ++j) {
                    normalizedScores[j] = 1.0 * (double)scores[j] / (double)qt;
                }
            }
            distance.addTerm(t, normalizedScores);
        }
        this.progress = 1.0;
        this.status = "Done";
        return distance;
    }

    @Override
    public double getProgress() {
        return this.progress;
    }

    @Override
    public String getStatus() {
        return this.status;
    }
}

