/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.states.test;

import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.impl.ANode;
import com.hp.hpl.jena.rdf.arp.impl.AbsXMLContext;
import com.hp.hpl.jena.rdf.arp.impl.AttributeLexer;
import com.hp.hpl.jena.rdf.arp.impl.Names;
import com.hp.hpl.jena.rdf.arp.impl.URIReference;
import com.hp.hpl.jena.rdf.arp.impl.XMLBaselessContext;
import com.hp.hpl.jena.rdf.arp.impl.XMLContext;
import com.hp.hpl.jena.rdf.arp.impl.XMLHandler;
import com.hp.hpl.jena.rdf.arp.states.AbsXMLLiteral;
import com.hp.hpl.jena.rdf.arp.states.DAMLCollection;
import com.hp.hpl.jena.rdf.arp.states.Frame;
import com.hp.hpl.jena.rdf.arp.states.FrameI;
import com.hp.hpl.jena.rdf.arp.states.HasSubjectFrameI;
import com.hp.hpl.jena.rdf.arp.states.InnerXMLLiteral;
import com.hp.hpl.jena.rdf.arp.states.LookingForRDF;
import com.hp.hpl.jena.rdf.arp.states.OuterXMLLiteral;
import com.hp.hpl.jena.rdf.arp.states.RDFCollection;
import com.hp.hpl.jena.rdf.arp.states.WantEmpty;
import com.hp.hpl.jena.rdf.arp.states.WantLiteralValueOrDescription;
import com.hp.hpl.jena.rdf.arp.states.WantPropertyElement;
import com.hp.hpl.jena.rdf.arp.states.WantTopLevelDescription;
import com.hp.hpl.jena.rdf.arp.states.WantTypedLiteral;
import com.hp.hpl.jena.rdf.arp.states.WantsObjectFrameI;
import com.hp.hpl.jena.rdf.arp.states.test.AttrEvent;
import com.hp.hpl.jena.rdf.arp.states.test.ElementEvent;
import com.hp.hpl.jena.rdf.arp.states.test.Event;
import com.hp.hpl.jena.rdf.arp.states.test.EventList;
import com.hp.hpl.jena.rdf.arp.states.test.InternalEvent;
import com.hp.hpl.jena.rdf.arp.states.test.QName;
import com.hp.hpl.jena.rdf.arp.states.test.TestFrame;
import com.hp.hpl.jena.rdf.arp.states.test.TestHandler;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestData
implements ARPErrorNumbers {
    private static final URIReference foo = URIReference.createNoChecks((String)"http://foo/");
    private static final URIReference bar = URIReference.createNoChecks((String)"http://bar/");
    static TestHandler xmlHandler = new TestHandler();
    static String dataFile = "testing/arp/state.txt";
    static AbsXMLContext xmlContext;
    static TestFrame testFrame;
    static char[] white;
    static char[] black;
    private static final AttrEvent xmlSpace;
    static Event[] allEvents;
    static Map<String, Event> short2Event;
    static Map<Class<? extends FrameI>, String> state2Name;
    static Map<Class<? extends FrameI>, String> state2ShortName;
    static Map<String, Class<? extends FrameI>> shortName2State;
    static Map<Class<? extends FrameI>, Object[]> state2Args;
    static AttributeLexer ap;
    int localCount;
    int globalCount;
    private EventList eventList = new EventList();
    String[] characters = new String[]{"<eg:Goo>", "<eg:Goo> </end>", "<eg:Goo> </end> <eg:Goo>", "'abcde'", "'abcde' <eg:Goo>", "'abcde' </end>", "</end>", "pred-object", "object"};
    boolean inCharacterize = false;
    static Class<?>[] tryClasses;
    private Random dice = new Random(23L);
    Set<String> data = new TreeSet<String>(new Comparator<String>(){

        @Override
        public int compare(String arg1, String arg2) {
            StringBuffer b1 = new StringBuffer(arg1).reverse();
            StringBuffer b2 = new StringBuffer(arg2).reverse();
            return b1.toString().compareTo(b2.toString());
        }
    });

    static void add(String sh, String nm, Class<? extends FrameI> f, Object[] args) {
        state2Name.put(f, nm);
        sh = TestData.getSimpleName(f);
        if (shortName2State.get(sh) != null) {
            System.err.println("Duplicate: " + sh);
        }
        state2Args.put(f, args);
        shortName2State.put(sh, f);
        state2ShortName.put(f, sh);
    }

    private static String getSimpleName(Class<? extends FrameI> f) {
        return XMLHandler.getSimpleName(f);
    }

    void characterize(Class<? extends FrameI> f) {
        this.inCharacterize = true;
        int sz = this.eventList.size;
        StringBuffer rslt = new StringBuffer();
        String skip = null;
        this.eventList.test(f);
        rslt.append(this.eventListName(f, null));
        rslt.append(" $ " + this.testInfo(f) + " {");
        if (this.eventList.testResult.getClass() != LookingForRDF.class) {
            for (int i = 0; i < this.characters.length; ++i) {
                if (skip != null && this.characters[i].startsWith(skip)) continue;
                skip = null;
                this.addEvents(this.characters[i]);
                rslt.append(" " + this.characters[i] + " $ ");
                boolean testV = this.eventList.test(f);
                rslt.append(this.testInfo(f) + " ;");
                this.eventList.size = sz;
                if (testV) continue;
                skip = this.characters[i];
            }
        }
        rslt.append(" }");
        this.data.add(rslt.toString());
        this.inCharacterize = false;
    }

    private String eventListName(Class<? extends FrameI> f, Class<? extends FrameI> f2) {
        StringBuffer rslt = new StringBuffer();
        rslt.append(this.stateName(f, f2));
        for (int i = 0; i < this.eventList.size; ++i) {
            rslt.append(' ');
            rslt.append(this.eventList.events[i].oneChar);
        }
        return rslt.toString();
    }

    private String stateName(Class<? extends FrameI> f, Class<? extends FrameI> f2) {
        return f == f2 ? "*" : state2ShortName.get(f);
    }

    private void addEvents(String string) {
        String[] all = string.split(" ");
        for (int i = 0; i < all.length; ++i) {
            this.eventList.add(short2Event.get(all[i]));
        }
    }

    private String testInfo(Class<? extends FrameI> f) {
        return this.eventList.testFailure ? (this.eventList.testException ? "!" : "?") : this.stateName(this.eventList.testResult.getClass(), f) + " " + xmlHandler.info() + " " + testFrame.info();
    }

    static FrameI create(Class<? extends FrameI> cl) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        FrameI frame = null;
        Object[] args = state2Args.get(cl);
        Class[] types = new Class[args.length];
        for (int i = 1; i < args.length; ++i) {
            types[i] = args[i].getClass();
            if (types[i] != XMLContext.class) continue;
            types[i] = AbsXMLContext.class;
        }
        if (cl == InnerXMLLiteral.class) {
            types[2] = Map.class;
        }
        for (int j = 0; j < tryClasses.length; ++j) {
            types[0] = tryClasses[j];
            try {
                frame = cl.getConstructor(types).newInstance(args);
                break;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        return frame;
    }

    void expand(Class<? extends FrameI> f) {
        if (AbsXMLLiteral.class.isAssignableFrom(f)) {
            return;
        }
        if (this.randomPurgeXMLAttrs()) {
            return;
        }
        ++this.localCount;
        ++this.globalCount;
        if (this.localCount % 20000 == 0) {
            this.stats(f);
        }
        if (!this.eventList.test(f)) {
            if (!this.shorterTestFails(f)) {
                this.data.add(this.eventListName(f, null) + " $ " + this.testInfo(f));
            }
            return;
        }
        this.characterize(f);
        if (this.eventList.size >= (AbsXMLLiteral.class.isAssignableFrom(f) ? 3 : (this.eventList.testResult instanceof LookingForRDF ? 2 : 8))) {
            return;
        }
        for (int i = 0; i < allEvents.length; ++i) {
            Event e;
            if (!allEvents[i].isAttribute() || !(e = this.eventList.last()).isElement() && (!e.isAttribute() || e.hashCode() >= allEvents[i].hashCode())) continue;
            this.eventList.add(allEvents[i]);
            this.expand(f);
            this.eventList.pop();
        }
    }

    private boolean randomPurgeXMLAttrs() {
        int weight = 0;
        this.eventList.rewind();
        while (this.eventList.hasNext()) {
            Event e = this.eventList.next();
            if (e == xmlSpace) {
                weight += 2;
                continue;
            }
            if (!e.isAttribute() || !((AttrEvent)e).q.uri.equals(Names.xmlns)) continue;
            ++weight;
        }
        while (weight-- > 0) {
            if (!this.dice.nextBoolean()) continue;
            return true;
        }
        return false;
    }

    private boolean shorterTestFails(Class<? extends FrameI> f) {
        if (this.eventList.size <= 2) {
            return false;
        }
        for (int i = 1; i < this.eventList.size - 1; ++i) {
            EventList copy = this.eventList.copy();
            copy.delete(i);
            if (copy.test(f)) continue;
            return true;
        }
        return false;
    }

    void stats(Class<? extends FrameI> f) {
    }

    void test1() throws IOException {
        Iterator<Class<? extends FrameI>> it = state2Name.keySet().iterator();
        while (it.hasNext()) {
            Class<? extends FrameI> f = it.next();
            this.localCount = 0;
            for (int i = 0; i < allEvents.length; ++i) {
                if (!allEvents[i].isElement()) continue;
                this.eventList.clear();
                this.eventList.add(allEvents[i]);
                this.expand(f);
            }
            this.stats(f);
        }
        FileWriter fw = new FileWriter(dataFile);
        Iterator<String> it2 = this.data.iterator();
        while (it.hasNext()) {
            fw.write(it2.next());
            fw.write(10);
        }
        fw.close();
    }

    public static void main(String[] args) throws IOException {
        long start = System.currentTimeMillis();
        new TestData().test1();
        System.out.println(System.currentTimeMillis() - start + " ms");
    }

    public static String stateLongName(String sh) {
        return state2Name.get(shortName2State.get(sh));
    }

    public static Class<? extends FrameI> toState(String sh) {
        return shortName2State.get(sh);
    }

    static {
        try {
            xmlContext = new XMLBaselessContext((XMLHandler)xmlHandler, 215).withBase((XMLHandler)xmlHandler, "http://example.org/base/");
        }
        catch (SAXParseException e) {
            throw new RuntimeException(e);
        }
        testFrame = new TestFrame(xmlHandler, xmlContext);
        white = new char[]{' ', ' ', ' ', ' ', ' '};
        black = new char[]{'a', 'b', 'c', 'd', 'e'};
        xmlSpace = new AttrEvent(QName.xml("space"));
        allEvents = new Event[]{new ElementEvent(QName.rdf("li")), new ElementEvent(QName.rdf("Description")), new ElementEvent("F", QName.rdf("RDF")), new ElementEvent(QName.eg("Goo")), new AttrEvent(QName.xml("base")), new AttrEvent("g", QName.xml("lang"), "en"), new AttrEvent(QName.eg("foo")), xmlSpace, new AttrEvent("B", QName.rdf("bagID"), "en"), new AttrEvent(QName.rdf("about")), new AttrEvent("h", QName.rdf("aboutEach"), "en"), new AttrEvent("H", QName.rdf("aboutEachPrefix"), "en"), new AttrEvent(QName.rdf("ID")), new AttrEvent(QName.rdf("nodeID")), new AttrEvent(QName.rdf("resource")), new AttrEvent(QName.rdf("type")), new AttrEvent(QName.rdf("datatype")), new AttrEvent("C", QName.rdf("parseType"), "Collection"), new AttrEvent("L", QName.rdf("parseType"), "Literal"), new AttrEvent("R", QName.rdf("parseType"), "Resource"), new InternalEvent("e", "</end>"){

            FrameI apply(FrameI from, Attributes att) throws SAXParseException {
                from.endElement();
                return from.getParent();
            }
        }, new InternalEvent("O", "object"){

            FrameI apply(FrameI from, Attributes att) {
                ((WantsObjectFrameI)from).theObject((ANode)foo);
                return from;
            }
        }, new InternalEvent("W", "white"){

            FrameI apply(FrameI from, Attributes att) throws SAXParseException {
                from.characters(white, 0, 5);
                return from;
            }
        }, new InternalEvent("Q", "'abcde'"){

            FrameI apply(FrameI from, Attributes att) throws SAXParseException {
                from.characters(black, 0, 5);
                return from;
            }
        }, new InternalEvent("P", "pred-object"){

            FrameI apply(FrameI from, Attributes att) {
                ((HasSubjectFrameI)from).aPredAndObj((ANode)foo, (ANode)bar);
                return from;
            }
        }};
        short2Event = new HashMap<String, Event>();
        for (int i = 0; i < allEvents.length; ++i) {
            String key = TestData.allEvents[i].oneChar;
            if (short2Event.get(key) != null) {
                System.err.println("Duplicate event code: " + key);
            }
            short2Event.put(key, allEvents[i]);
        }
        state2Name = new HashMap<Class<? extends FrameI>, String>();
        state2ShortName = new HashMap<Class<? extends FrameI>, String>();
        shortName2State = new HashMap<String, Class<? extends FrameI>>();
        state2Args = new HashMap<Class<? extends FrameI>, Object[]>();
        ap = new AttributeLexer((Frame)testFrame, 0, 0);
        TestData.add("ix", "inner-xml-literal", InnerXMLLiteral.class, new Object[]{testFrame, "foo", TestData.testFrame.namespaces});
        TestData.add("xl", "xml-literal", OuterXMLLiteral.class, new Object[]{testFrame, xmlContext});
        TestData.add("ip", "vanilla-prop-elt", WantLiteralValueOrDescription.class, new Object[]{testFrame, xmlContext});
        TestData.add("tl", "typed-literal", WantTypedLiteral.class, new Object[]{testFrame, "http://ex/dt", xmlContext});
        TestData.add("dl", "daml:collection", DAMLCollection.class, new Object[]{testFrame, xmlContext});
        TestData.add("cl", "collection", RDFCollection.class, new Object[]{testFrame, xmlContext});
        TestData.add("tp", "top-level", WantTopLevelDescription.class, new Object[]{testFrame, ap});
        TestData.add("em", "empty-prop-elt", WantEmpty.class, new Object[]{testFrame, xmlContext});
        TestData.add("de", "inside-Description", WantPropertyElement.class, new Object[]{testFrame, xmlContext});
        TestData.add("RD", "looking-for-RDF", LookingForRDF.class, new Object[]{testFrame, ap});
        tryClasses = new Class[]{FrameI.class, AbsXMLLiteral.class, HasSubjectFrameI.class, WantsObjectFrameI.class};
    }
}

